(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    480414,      10922]*)
(*NotebookOutlinePosition[    483046,      10996]*)
(*  CellTagsIndexPosition[    482895,      10988]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["\<\
Chapter 6
Forced Oscillators of Systems with Finite Degrees of Freedom\
\>", "Title",
  TextAlignment->Left,
  TextJustification->0],

Cell["\<\
In this chapter, we discuss nonlinear systems having finite degrees of \
freedom. The discussion is limited to weakly nonlinear systems, and \
approximate solutions are obtained by using the method of multiple scales. In \
the case of strongly nonlinear systems, perturbation methods can be used in \
cases for which a basic exact nonlinear solution exists. For the other cases, \
recourse is often made to numerical methods and / or geometrical methods to \
obtain a qualitative description of the behavior of the system, including its \
stability.\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "In contrast with a single-degree-of-freedom system, which has only a \
single linear natural frequency and a single mode of oscillation, an ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  "-degree-of-freedom system has ",
  StyleBox["n",
    FontSlant->"Italic"],
  " linear natural frequencies and ",
  StyleBox["n",
    FontSlant->"Italic"],
  " corresponding modes. Let us denote these frequencies by ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\_1, \[Omega]\_2, \[Ellipsis], 
      \[Omega]\_n\)]],
  " and assume that all of them are real and different from zero. An \
important case occurs whenever two or more of these frequencies are \
commensurate or nearly commensurate. Examples of near-commensurability are"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[Cell[BoxData[
    \({\[Omega]\_2 \[TildeTilde] 2  \[Omega]\_1, 
      \[Omega]\_3 \[TildeTilde] \[Omega]\_2 \[PlusMinus] \[Omega]\_1, 
      \[Omega]\_2 \[TildeTilde] 3  \[Omega]\_1, 
      \[Omega]\_3 \[TildeTilde] 2  \[Omega]\_2 \[PlusMinus] \[Omega]\_1, 
      \[Omega]\_4 \[TildeTilde] 
        \(\[Omega]\_3 \[PlusMinus] \[Omega]\_2\) \[PlusMinus] \[Omega]\_1}
      \)], "Input"]], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Depending on the order of the nonlinearity in the system, these \
commensurate relationships of frequencies can cause the corresponding modes \
to be strongly coupled, and an ",
  StyleBox["internal ",
    FontColor->RGBColor[0, 0, 1]],
  "or",
  StyleBox[" autoparametric resonance",
    FontColor->RGBColor[0, 0, 1]],
  " is said to exist. For example, if the system has quadratic \
nonlinearities, then to first order an internal resonance may exist if ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\_m \[TildeTilde] 2  \[Omega]\_k\)]],
  " or ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Omega]\_q \[TildeTilde] \[Omega]\_p \[PlusMinus] \[Omega]\_m\)]],
  ". For a system with cubic nonlinearities, to first order an internal \
resonance may exist if ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\_m \[TildeTilde] 3  \[Omega]\_k\)]],
  " or ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Omega]\_q \[TildeTilde] 
        \(\[Omega]\_p \[PlusMinus] \[Omega]\_m\) \[PlusMinus] 
          \[Omega]\_k\)]],
  " or ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\_m \[TildeTilde] \[Omega]\_k\)]],
  " or ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Omega]\_q \[TildeTilde] 
        2  \[Omega]\_p \[PlusMinus] \[Omega]\_m\)]],
  ". When an internal resonance exists in a free undamped system, energy \
imparted initially to one of the modes involved in the internal resonance \
will be continuously exchanged among the modes involved in that internal \
resonance. If damping is present in the system, then the energy will decay \
with time as it is being continuously exchanged."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
In a conservative nongyroscopic system, if the linear motion is oscillatory, \
then the nonlinear motion is bounded. For a conservative gyroscopic \
multidegree-of-freedom system, the nonlinear motion may be unbounded and \
hence unstable if an internal resonance exists.\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "If an external harmonic excitation of frequency \[CapitalOmega] acts on a \
multidegree-of-freedom system, then in addition to all of the primary and \
secondary resonances (",
  Cell[BoxData[
      \(TraditionalForm\`p\ \[CapitalOmega] \[TildeTilde] q\ \[Omega]\_m\)]],
  ", with ",
  StyleBox["p",
    FontSlant->"Italic"],
  " and ",
  StyleBox["q",
    FontSlant->"Italic"],
  " being integers) of a single-degree-of-freedom system, there might exist \
other ",
  StyleBox["resonance combinations",
    FontColor->RGBColor[0, 0, 1]],
  " of the frequencies in the form"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[Cell[BoxData[
    \(p\ \[CapitalOmega] == 
      a\_1\ \[Omega]\_1 + a\_2\ \[Omega]\_2 + \[CenterEllipsis] + 
        a\_N\ \[Omega]\_N\)], "Input"]], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " and the ",
  Cell[BoxData[
      \(TraditionalForm\`a\_n\)]],
  " are positive or negative integers such that"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[Cell[BoxData[
    \(| p | \(+\[Sum]\_\(n = 1\)\%N\) | a\_n | \( == M\)\)], "Input"]], "Text",\

  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`M\)]],
  " is the order of the nonlinearity plus one and ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  " is the number of degrees of freedom. The type of combination resonance \
which might exist in a system depends on the order of its nonlinearity. For a \
system having quadratic nonlinearities, to first order the combination \
resonances that might exist involve two frequencies in addition to \
\[CapitalOmega];  that is, ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[CapitalOmega] \[TildeTilde] \[Omega]\_m + \[Omega]\_k\)]],
  " or ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[CapitalOmega] \[TildeTilde] \[Omega]\_m - \[Omega]\_k\)]],
  ". The first of these is called a ",
  StyleBox["summed combination resonance",
    FontColor->RGBColor[0, 0, 1]],
  " or a ",
  StyleBox["combination resonance of the additive type",
    FontColor->RGBColor[0, 0, 1]],
  ", whereas the second is called a ",
  StyleBox["difference combination resonance",
    FontColor->RGBColor[0, 0, 1]],
  " or a",
  StyleBox[" combination resonance of the difference type",
    FontColor->RGBColor[0, 0, 1]],
  ". These types of combination resonances were predicted theoretically by \
Malkin (1956) and found experimentally by Yamamoto (1957, 1960). For a system \
having cubic nonlinearities, to first order the combination resonances that \
might exist involve either two or three of the natural frequencies in \
addition to \[CapitalOmega]; that is,"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[Cell[BoxData[
    \({\[CapitalOmega] \[TildeTilde] 
        \(\[Omega]\_p \[PlusMinus] \[Omega]\_m\) \[PlusMinus] \[Omega]\_k, 
      \[CapitalOmega] \[TildeTilde] 2  \[Omega]\_p \[PlusMinus] \[Omega]\_m, 
      \[CapitalOmega] \[TildeTilde] \[Omega]\_p \[PlusMinus] 2  \[Omega]\_m, 
      2  \[CapitalOmega] \[TildeTilde] \[Omega]\_m \[PlusMinus] \[Omega]\_k}
      \)], "Input"]], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell["Preliminaries", "Section",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(Off[General::spell1]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(Needs["\<Utilities`Notation`\>"]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
To use the method of multiple scales, we introduce different time scales, \
symbolize them as\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{"Symbolize", "[", 
        TagBox[\(T\_0\),
          NotationBoxTag,
          Editable->True], "]"}], ";", 
      RowBox[{"Symbolize", "[", 
        TagBox[\(T\_1\),
          NotationBoxTag,
          Editable->True], "]"}], ";", 
      RowBox[{"Symbolize", "[", 
        TagBox[\(T\_2\),
          NotationBoxTag,
          Editable->True], "]"}], ";"}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["and form a list of them as follows:", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(timeScales = {T\_0, T\_1, T\_2}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "In terms of the time scales ",
  Cell[BoxData[
      \(TraditionalForm\`T\_n\)]],
  ", the time derivatives become"
}], "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(\ \(dt[1]\)[expr_] := 
      Sum[\[Epsilon]\^i\ D[expr, timeScales[\([i + 1]\)]], {i, 0, maxOrder}]; 
    \n\ \(dt[2]\)[expr_] := 
      \((\(dt[1]\)[\(dt[1]\)[expr]] // Expand)\) /. 
        \[Epsilon]\^\(i_ /; i > maxOrder\) -> 0; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "In the course of the analysis, we need the complex conjugates of ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " and \[CapitalGamma]. We define them using the following rule:"
}], "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(conjugateRule = {A -> A\&_, A\&_ -> A, 
        \[CapitalGamma] -> \[CapitalGamma]\&_, 
        \[CapitalGamma]\&_ -> \[CapitalGamma], 
        Complex[0, n_] -> Complex[0, \(-n\)]}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
To represent some of the expressions in a more concise way, we introduce the \
following display rule:\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(displayRule = {
        \(\(Derivative[a__]\)[u_\_\(i_, j_\)]\)[__] :> 
          SequenceForm[
            Times\ @@\ MapIndexed[D\_\(#2[\([1]\)] - 1\)\%#1\ &, {a}], 
            u\_\(i, j\)], 
        \(\(Derivative[a__]\)[A_\_i_]\)[__] :> 
          SequenceForm[Times\ @@\ MapIndexed[D\_\(#2[\([1]\)]\)\%#1\ &, {a}], 
            A\_i], u_\_\(i_, j_\)[__] :> u\_\(i, j\), A_\_i_[__] :> A\_i}; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell["6.1 Externally Excited Linearly Uncoupled Systems", "Section",
  CellMargins->{{Inherited, 17.4375}, {Inherited, Inherited}},
  Evaluatable->False,
  TextAlignment->Left,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],

Cell[CellGroupData[{

Cell["System of Equations", "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
We consider the response of the following two-degree-of-freedom system with \
quadratic and cubic geometric nonlinearities to an external (additive) \
excitation:\
\>", "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(eq61a = {\n
        \(u\_1\^\[DoublePrime]\)[t] + \[Omega]\_1\%2\ u\_1[t] + 
            2  \[Mu]\&^\_1\ \(u\_1\^\[Prime]\)[t] + 
            D[V[u\_1[t], u\_2[t]], u\_1[t]] == 
          F\_1\ Cos[\[CapitalOmega]\ t + \[Tau]\_1], \n
        \(u\_2\^\[DoublePrime]\)[t] + \[Omega]\_2\%2\ u\_2[t] + 
            2  \[Mu]\&^\_2\ \(u\_2\^\[Prime]\)[t] + 
            D[V[u\_1[t], u\_2[t]], u\_2[t]] == 
          F\_2\ Cos[\[CapitalOmega]\ t + \[Tau]\_2]}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{\(\[Omega]\_1\%2\ u\_1[t]\), "+", 
            RowBox[{"2", " ", \(\[Mu]\&^\_1\), " ", 
              RowBox[{
                SubsuperscriptBox["u", "1", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}], "+", 
            RowBox[{
              SubsuperscriptBox["u", "1", "\[DoublePrime]",
                MultilineFunction->None], "[", "t", "]"}], "+", 
            RowBox[{
              SuperscriptBox["V", 
                TagBox[\((1, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(u\_1[t], u\_2[t]\), "]"}]}], 
          "==", \(Cos[t\ \[CapitalOmega] + \[Tau]\_1]\ F\_1\)}], ",", 
        RowBox[{
          RowBox[{\(\[Omega]\_2\%2\ u\_2[t]\), "+", 
            RowBox[{"2", " ", \(\[Mu]\&^\_2\), " ", 
              RowBox[{
                SubsuperscriptBox["u", "2", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}], "+", 
            RowBox[{
              SubsuperscriptBox["u", "2", "\[DoublePrime]",
                MultilineFunction->None], "[", "t", "]"}], "+", 
            RowBox[{
              SuperscriptBox["V", 
                TagBox[\((0, 1)\),
                  Derivative],
                MultilineFunction->None], "[", \(u\_1[t], u\_2[t]\), "]"}]}], 
          "==", \(Cos[t\ \[CapitalOmega] + \[Tau]\_2]\ F\_2\)}]}], "}"}]], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "where the potential function ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " possesses cubic and quartic nonlinearities. The most general such \
potential function can be expressed as follows:"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(basicModes = {u\_1[t], u\_2[t]}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(cubicTerms = 
      \(Nest[Outer[Times, basicModes, #]&, basicModes, 2] // Flatten\) // 
        Union\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u\_1[t]\^3, u\_1[t]\^2\ u\_2[t], u\_1[t]\ u\_2[t]\^2, u\_2[t]\^3}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(quarticTerms = 
      \(Outer[Times, basicModes, cubicTerms] // Flatten\) // Union\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u\_1[t]\^4, u\_1[t]\^3\ u\_2[t], u\_1[t]\^2\ u\_2[t]\^2, 
      u\_1[t]\ u\_2[t]\^3, u\_2[t]\^4}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(potential = 
      V -> \((Evaluate[
              Sum[\[Delta]\_i\ cubicTerms[\([i]\)], {i, 
                      Length[cubicTerms]}] + 
                  Sum[\[Alpha]\_i\ quarticTerms[\([i]\)], {i, 
                      Length[quarticTerms]}] /. 
                Thread[basicModes -> {#1, #2}]]\ &)\)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(V \[Rule] 
      \((#1\^4\ \[Alpha]\_1 + #1\^3\ #2\ \[Alpha]\_2 + #1\^2\ #2\^2\ 
              \[Alpha]\_3 + #1\ #2\^3\ \[Alpha]\_4 + #2\^4\ 
              \[Alpha]\_5 + #1\^3\ \[Delta]\_1 + #1\^2\ #2\ \[Delta]\_2 + #1
              \ #2\^2\ \[Delta]\_3 + #2\^3\ \[Delta]\_4&)\)\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
Approximate solutions of such a system can be obtained using a number of \
techniques, including the method of normal forms, the method of multiple \
scales, the Krylov-Bogoliubov-Mitropolsky technique, and the method of \
averaging. With these methods, one determines a set of ordinary-differential \
equations (modulation equations) that govern the time evolution of the \
amplitudes and phases of the modes participating in the response. If these \
equations are time-dependent, one usually transforms them into a set of \
autonomous equations. In this chapter, we describe how the method of multiple \
scales can be used to determine uniform expansions of this system, including \
the modulation equations.\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
Secondary resonances of nonlinear systems include subharmonic, superharmonic, \
and combination resonances. One or more of these resonances might be \
activated in the presence or absence of internal resonances. When a \
combination resonance is activated in the presence of an internal resonance, \
fractional harmonics might be excited.\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "For a consistent expansion, we first transform ",
  StyleBox["eq61a",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into a system of four first-order equations. To this end, we introduce \
the two states ",
  Cell[BoxData[
      \(TraditionalForm\`v\_1[t]\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`v\_2[t]\)]],
  " defined by"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(vel = {\(u\_1\^\[Prime]\)[t] -> v\_1[t], 
        \(u\_2\^\[Prime]\)[t] -> v\_2[t]}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting the velocity and acceleration terms, using ",
  StyleBox["vel",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["potential",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", into ",
  StyleBox["eq61a",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and combining the result with ",
  StyleBox["vel",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we transform ",
  StyleBox["eq61a ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "into the following set of four first-order equations:"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(eq61b = 
      \({vel /. Rule -> Equal, 
            \(\(eq61a /. D[vel, t]\) /. vel\) /. potential} // Transpose\) // 
        Flatten\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SubsuperscriptBox["u", "1", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "==", \(v\_1[t]\)}], 
        ",", 
        RowBox[{
          RowBox[{
          \(\[Omega]\_1\%2\ u\_1[t]\), "+", \(3\ \[Delta]\_1\ u\_1[t]\^2\), 
            "+", \(4\ \[Alpha]\_1\ u\_1[t]\^3\), "+", 
            \(2\ \[Delta]\_2\ u\_1[t]\ u\_2[t]\), "+", 
            \(3\ \[Alpha]\_2\ u\_1[t]\^2\ u\_2[t]\), "+", 
            \(\[Delta]\_3\ u\_2[t]\^2\), "+", 
            \(2\ \[Alpha]\_3\ u\_1[t]\ u\_2[t]\^2\), "+", 
            \(\[Alpha]\_4\ u\_2[t]\^3\), "+", \(2\ \[Mu]\&^\_1\ v\_1[t]\), 
            "+", 
            RowBox[{
              SubsuperscriptBox["v", "1", "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}]}], "==", 
          \(Cos[t\ \[CapitalOmega] + \[Tau]\_1]\ F\_1\)}], ",", 
        RowBox[{
          RowBox[{
            SubsuperscriptBox["u", "2", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "==", \(v\_2[t]\)}], 
        ",", 
        RowBox[{
          RowBox[{
          \(\[Delta]\_2\ u\_1[t]\^2\), "+", \(\[Alpha]\_2\ u\_1[t]\^3\), "+", 
            \(\[Omega]\_2\%2\ u\_2[t]\), "+", 
            \(2\ \[Delta]\_3\ u\_1[t]\ u\_2[t]\), "+", 
            \(2\ \[Alpha]\_3\ u\_1[t]\^2\ u\_2[t]\), "+", 
            \(3\ \[Delta]\_4\ u\_2[t]\^2\), "+", 
            \(3\ \[Alpha]\_4\ u\_1[t]\ u\_2[t]\^2\), "+", 
            \(4\ \[Alpha]\_5\ u\_2[t]\^3\), "+", \(2\ \[Mu]\&^\_2\ v\_2[t]\), 
            "+", 
            RowBox[{
              SubsuperscriptBox["v", "2", "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}]}], "==", 
          \(Cos[t\ \[CapitalOmega] + \[Tau]\_2]\ F\_2\)}]}], "}"}]], "Output",\

  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "We seek a uniform second-order expansion of the solution of ",
  StyleBox["eq61b",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in the form"
}], "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(solRule = {
        u\_i_ -> 
          \((Sum[\[Epsilon]\^j\ u\_\(i, j\)[#1, #2, #3], {j, 3}]\ &)\), 
        v\_i_ -> 
          \((Sum[\[Epsilon]\^j\ v\_\(i, j\)[#1, #2, #3], {j, 3}]\ &)\)}; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["and set", "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(maxOrder = 2; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "The damping and forcing terms in ",
  StyleBox["eq61b",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " need to be scaled so that they balance the influence of the nonlinearity. \
The scaling of the forcing depends on the type of resonance. Next, we treat \
different resonance cases in the following sections."
}], "Text",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "6.1.1 ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega] \[TildeTilde] \[Omega]\_2\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\_2 \[TildeTilde] 2  \[Omega]\_1\)]]
}], "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
In this case, we have a combination of a primary resonance of the second \
mode, a subharmonic resonance of order one-half of the first mode, and a \
two-to-one internal resonance. In order to bring the effects of damping, \
forcing, and nonlinearity at the same order, we let\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(scaling = {\[Mu]\&^\_n_ -> \[Epsilon]\ \[Mu]\_n, 
        F\_1 -> \[Epsilon]\ f\_1, F\_2 -> \[Epsilon]\^2\ f\_2}; \)\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "To describe quantitatively the nearness of the resonances, we introduce \
the two detunings ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\_2\)]],
  " defined by"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(ResonanceCond = {
        \[Omega]\_2 == 2  \[Omega]\_1 + \[Epsilon]\ \[Sigma]\_1, 
        \[CapitalOmega] == \[Omega]\_2 + \[Epsilon]\ \[Sigma]\_2}; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["Then, we define the following lists:", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(omgList = {\[Omega]\_1, \[Omega]\_2}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(omgRule = 
      \(\(Solve[ResonanceCond, {\[CapitalOmega], #} // Flatten]\)[\([1]\)]\ &
            \)\ /@\ omgList // Reverse\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{\[CapitalOmega] \[Rule] 
          \[Epsilon]\ \[Sigma]\_1 + \[Epsilon]\ \[Sigma]\_2 + 2\ \[Omega]\_1, 
        \[Omega]\_2 \[Rule] \[Epsilon]\ \[Sigma]\_1 + 2\ \[Omega]\_1}, {
        \[CapitalOmega] \[Rule] \[Epsilon]\ \[Sigma]\_2 + \[Omega]\_2, 
        \[Omega]\_1 \[Rule] 
          1\/2\ \((\(-\[Epsilon]\)\ \[Sigma]\_1 + \[Omega]\_2)\)}}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Using the time scales ",
  Cell[BoxData[
      \(TraditionalForm\`T\_0\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`T\_1\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`T\_2\)]],
  ", we express the time derivative as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(multiScales = {u\_i_[t] -> u\_i\ @@\ timeScales, 
        v\_i_[t] -> v\_i\ @@\ timeScales, 
        \(\(Derivative[1]\)[u_]\)[t] -> \(dt[1]\)[u\ @@\ timeScales], 
        t -> T\_0}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting the ",
  StyleBox["scaling",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", ",
  StyleBox["multiScales",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", and ",
  StyleBox["solRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["eq61b",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", expanding the result for small \[Epsilon], and discarding terms of order \
higher than ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon]\^3\)]],
  ", we obtain"
}], "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(eq611a = 
      \((\(\(\(eq61b /. scaling\) /. multiScales\) /. solRule // TrigToExp
              \) // ExpandAll)\) /. \[Epsilon]\^\(n_ /; n > 3\) -> 0; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[
"Equating coefficients of like powers of \[Epsilon], we obtain"], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(eqEps = 
      \(Rest[Thread[CoefficientList[Subtract\ @@\ #, \[Epsilon]] == 0]]\ &
            \)\ /@\ eq611a // Transpose; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
To place the linear operator on one side and the nonhomogeneous terms on the \
other side, we define\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(eqOrder[i_] := 
      \((\(\(#[\([1]\)]\ &\)\ /@\ eqEps[\([1]\)] /. f\_s_ -> 0\) /. 
              u_\_\(k_, 1\) -> u\_\(k, i\))\) == 
          \((\(\(#[\([1]\)]\ &\)\ /@\ eqEps[\([1]\)] /. f\_s_ -> 0\) /. 
                u_\_\(k_, 1\) -> u\_\(k, i\))\) - 
            \((\(#[\([1]\)]\ &\)\ /@\ eqEps[\([i]\)])\) // Thread\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Using the ",
  StyleBox["eqOrder[i]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["displayRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we rewrite ",
  StyleBox["eqEps",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in a concise way as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[{
    \(eqOrder[1] /. displayRule\), 
    \(eqOrder[2] /. displayRule\), 
    \(eqOrder[3] /. displayRule\)}], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]u\_\(1, 1\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ u, 1, 1]],
              Editable->False], "-", \(v\_\(1, 1\)\)}], "==", "0"}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(1, 1\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ v, 1, 1]],
              Editable->False], "+", \(\[Omega]\_1\%2\ u\_\(1, 1\)\)}], "==", 
          \(1\/2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1\)\ f\_1 + 
            1\/2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1\)\ f\_1\)}], 
        ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]u\_\(2, 1\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ u, 2, 1]],
              Editable->False], "-", \(v\_\(2, 1\)\)}], "==", "0"}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(2, 1\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ v, 2, 1]],
              Editable->False], "+", \(\[Omega]\_2\%2\ u\_\(2, 1\)\)}], "==", 
          "0"}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]u\_\(1, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ u, 1, 2]],
              Editable->False], "-", \(v\_\(1, 2\)\)}], "==", 
          RowBox[{"-", 
            RowBox[{"(", 
              InterpretationBox[\(D\_1\[InvisibleSpace]u\_\(1, 1\)\),
                SequenceForm[ 
                  Subscript[ D, 1], 
                  Subscript[ u, 1, 1]],
                Editable->False], ")"}]}]}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(1, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ v, 1, 2]],
              Editable->False], "+", \(\[Omega]\_1\%2\ u\_\(1, 2\)\)}], 
          "==", 
          RowBox[{
            RowBox[{"-", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]v\_\(1, 1\)\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ v, 1, 1]],
                  Editable->False], ")"}]}], "-", 
            \(3\ \[Delta]\_1\ u\_\(1, 1\)\%2\), "-", 
            \(2\ \[Delta]\_2\ u\_\(1, 1\)\ u\_\(2, 1\)\), "-", 
            \(\[Delta]\_3\ u\_\(2, 1\)\%2\), "-", 
            \(2\ \[Mu]\_1\ v\_\(1, 1\)\)}]}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]u\_\(2, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ u, 2, 2]],
              Editable->False], "-", \(v\_\(2, 2\)\)}], "==", 
          RowBox[{"-", 
            RowBox[{"(", 
              InterpretationBox[\(D\_1\[InvisibleSpace]u\_\(2, 1\)\),
                SequenceForm[ 
                  Subscript[ D, 1], 
                  Subscript[ u, 2, 1]],
                Editable->False], ")"}]}]}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(2, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ v, 2, 2]],
              Editable->False], "+", \(\[Omega]\_2\%2\ u\_\(2, 2\)\)}], 
          "==", 
          RowBox[{
            RowBox[{"-", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]v\_\(2, 1\)\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ v, 2, 1]],
                  Editable->False], ")"}]}], "+", 
            \(1\/2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2\)\ 
              f\_2\), "+", 
            \(1\/2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2\)\ f\_2\), 
            "-", \(\[Delta]\_2\ u\_\(1, 1\)\%2\), "-", 
            \(2\ \[Delta]\_3\ u\_\(1, 1\)\ u\_\(2, 1\)\), "-", 
            \(3\ \[Delta]\_4\ u\_\(2, 1\)\%2\), "-", 
            \(2\ \[Mu]\_2\ v\_\(2, 1\)\)}]}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]u\_\(1, 3\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ u, 1, 3]],
              Editable->False], "-", \(v\_\(1, 3\)\)}], "==", 
          RowBox[{
            RowBox[{"-", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]u\_\(1, 2\)\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ u, 1, 2]],
                  Editable->False], ")"}]}], "-", 
            InterpretationBox[\(D\_2\[InvisibleSpace]u\_\(1, 1\)\),
              SequenceForm[ 
                Subscript[ D, 2], 
                Subscript[ u, 1, 1]],
              Editable->False]}]}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(1, 3\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ v, 1, 3]],
              Editable->False], "+", \(\[Omega]\_1\%2\ u\_\(1, 3\)\)}], 
          "==", 
          RowBox[{
            RowBox[{"-", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]v\_\(1, 2\)\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ v, 1, 2]],
                  Editable->False], ")"}]}], "-", 
            InterpretationBox[\(D\_2\[InvisibleSpace]v\_\(1, 1\)\),
              SequenceForm[ 
                Subscript[ D, 2], 
                Subscript[ v, 1, 1]],
              Editable->False], "-", \(4\ \[Alpha]\_1\ u\_\(1, 1\)\%3\), "-", 
            \(6\ \[Delta]\_1\ u\_\(1, 1\)\ u\_\(1, 2\)\), "-", 
            \(3\ \[Alpha]\_2\ u\_\(1, 1\)\%2\ u\_\(2, 1\)\), "-", 
            \(2\ \[Delta]\_2\ u\_\(1, 2\)\ u\_\(2, 1\)\), "-", 
            \(2\ \[Alpha]\_3\ u\_\(1, 1\)\ u\_\(2, 1\)\%2\), "-", 
            \(\[Alpha]\_4\ u\_\(2, 1\)\%3\), "-", 
            \(2\ \[Delta]\_2\ u\_\(1, 1\)\ u\_\(2, 2\)\), "-", 
            \(2\ \[Delta]\_3\ u\_\(2, 1\)\ u\_\(2, 2\)\), "-", 
            \(2\ \[Mu]\_1\ v\_\(1, 2\)\)}]}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]u\_\(2, 3\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ u, 2, 3]],
              Editable->False], "-", \(v\_\(2, 3\)\)}], "==", 
          RowBox[{
            RowBox[{"-", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]u\_\(2, 2\)\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ u, 2, 2]],
                  Editable->False], ")"}]}], "-", 
            InterpretationBox[\(D\_2\[InvisibleSpace]u\_\(2, 1\)\),
              SequenceForm[ 
                Subscript[ D, 2], 
                Subscript[ u, 2, 1]],
              Editable->False]}]}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(2, 3\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ v, 2, 3]],
              Editable->False], "+", \(\[Omega]\_2\%2\ u\_\(2, 3\)\)}], 
          "==", 
          RowBox[{
            RowBox[{"-", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]v\_\(2, 2\)\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ v, 2, 2]],
                  Editable->False], ")"}]}], "-", 
            InterpretationBox[\(D\_2\[InvisibleSpace]v\_\(2, 1\)\),
              SequenceForm[ 
                Subscript[ D, 2], 
                Subscript[ v, 2, 1]],
              Editable->False], "-", \(\[Alpha]\_2\ u\_\(1, 1\)\%3\), "-", 
            \(2\ \[Delta]\_2\ u\_\(1, 1\)\ u\_\(1, 2\)\), "-", 
            \(2\ \[Alpha]\_3\ u\_\(1, 1\)\%2\ u\_\(2, 1\)\), "-", 
            \(2\ \[Delta]\_3\ u\_\(1, 2\)\ u\_\(2, 1\)\), "-", 
            \(3\ \[Alpha]\_4\ u\_\(1, 1\)\ u\_\(2, 1\)\%2\), "-", 
            \(4\ \[Alpha]\_5\ u\_\(2, 1\)\%3\), "-", 
            \(2\ \[Delta]\_3\ u\_\(1, 1\)\ u\_\(2, 2\)\), "-", 
            \(6\ \[Delta]\_4\ u\_\(2, 1\)\ u\_\(2, 2\)\), "-", 
            \(2\ \[Mu]\_2\ v\_\(2, 2\)\)}]}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell["First-Order Problem: Linear System", "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "The first-order problem, ",
  StyleBox["eqOrder[1]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", consists of two sets of uncoupled linear nonhomogeneous differential \
equations. Hence, the general solution of each set can be obtained by using \
the principle of superposition as the sum of any particular solution and the \
solution of the homogeneous equations. To determine the general solution of \
the homogeneous sets, we rewrite the homogeneous part of ",
  StyleBox["eqOrder[1]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(linearSys = \(#[\([1]\)]\ &\)\ /@\ eqOrder[1]; \n
    linearSys /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          InterpretationBox[\(D\_0\[InvisibleSpace]u\_\(1, 1\)\),
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ u, 1, 1]],
            Editable->False], "-", \(v\_\(1, 1\)\)}], ",", 
        RowBox[{
          InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(1, 1\)\),
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ v, 1, 1]],
            Editable->False], "+", \(\[Omega]\_1\%2\ u\_\(1, 1\)\)}], ",", 
        RowBox[{
          InterpretationBox[\(D\_0\[InvisibleSpace]u\_\(2, 1\)\),
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ u, 2, 1]],
            Editable->False], "-", \(v\_\(2, 1\)\)}], ",", 
        RowBox[{
          InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(2, 1\)\),
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ v, 2, 1]],
            Editable->False], "+", \(\[Omega]\_2\%2\ u\_\(2, 1\)\)}]}], 
      "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Next, we seek a solution of the ",
  StyleBox["linearSys",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in the form ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\(i, 1\) = P\ E\^\(I\ \[Omega]\_i\ T\_0\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`v\_\(i, 1\) = Q\ E\^\(I\ \[Omega]\_i\ T\_0\)\)]],
  " and obtain"
}], "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(expr1 = 
      \(linearSys /. {u\_\(i_, 1\) -> \((P\ E\^\(I\ \[Omega]\_i\ #1\)\ &)\), 
              v\_\(i_, 1\) -> \((Q\ E\^\(I\ \[Omega]\_i\ #1\)\ &)\)}\) /. 
          Exp[a_] -> 1 // Partition[#, 2]\ &\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{\(-Q\) + I\ P\ \[Omega]\_1, I\ Q\ \[Omega]\_1 + P\ \[Omega]\_1\%2}, {
        \(-Q\) + I\ P\ \[Omega]\_2, I\ Q\ \[Omega]\_2 + P\ \[Omega]\_2\%2}}
      \)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "The coefficient matrices of ",
  StyleBox["expr1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " are"
}], "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(coefMat = \(Outer[D, #, {P, Q}]\ &\)\ /@\ expr1\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{{I\ \[Omega]\_1, \(-1\)}, {\[Omega]\_1\%2, I\ \[Omega]\_1}}, {{
          I\ \[Omega]\_2, \(-1\)}, {\[Omega]\_2\%2, I\ \[Omega]\_2}}}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["and their adjoints are defined by", "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(hermitian[mat_?MatrixQ] := mat /. conjugateRule // Transpose\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Hence, the right and left eigenvectors of ",
  StyleBox["coefMat",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " are"
}], "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(rightVec = 
      \(#/#[\([1]\)]\ &\)\ /@\ 
        \((\(\(NullSpace[#]\)[\([1]\)]\ &\)\ /@\ coefMat)\)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{1, I\ \[Omega]\_1}, {1, I\ \[Omega]\_2}}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(leftVec = \(\(NullSpace[hermitian[#]]\)[\([1]\)]\ &\)\ /@\ coefMat\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{\(-I\)\ \[Omega]\_1, 1}, {\(-I\)\ \[Omega]\_2, 1}}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["whose complex conjugates are", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(ccleftVec = leftVec /. conjugateRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{I\ \[Omega]\_1, 1}, {I\ \[Omega]\_2, 1}}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "To determine particular solutions of the partial-differential equations ",
  StyleBox["eqOrder[1] ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "using the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function ",
  StyleBox["DSolve",
    FontWeight->"Bold"],
  ", we first transform them into a set of ordinary-differential equations \
as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(order1Eq = eqOrder[1] /. u_\_\(i_, 1\) -> \((u\_\(i, 1\)[#1]\ &)\)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{\(-v\_\(1, 1\)[T\_0]\), "+", 
            RowBox[{
              SubsuperscriptBox["u", \(1, 1\), "\[Prime]",
                MultilineFunction->None], "[", \(T\_0\), "]"}]}], "==", 
          "0"}], ",", 
        RowBox[{
          RowBox[{\(\[Omega]\_1\%2\ u\_\(1, 1\)[T\_0]\), "+", 
            RowBox[{
              SubsuperscriptBox["v", \(1, 1\), "\[Prime]",
                MultilineFunction->None], "[", \(T\_0\), "]"}]}], "==", 
          \(1\/2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1\)\ f\_1 + 
            1\/2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1\)\ f\_1\)}], 
        ",", 
        RowBox[{
          RowBox[{\(-v\_\(2, 1\)[T\_0]\), "+", 
            RowBox[{
              SubsuperscriptBox["u", \(2, 1\), "\[Prime]",
                MultilineFunction->None], "[", \(T\_0\), "]"}]}], "==", 
          "0"}], ",", 
        RowBox[{
          RowBox[{\(\[Omega]\_2\%2\ u\_\(2, 1\)[T\_0]\), "+", 
            RowBox[{
              SubsuperscriptBox["v", \(2, 1\), "\[Prime]",
                MultilineFunction->None], "[", \(T\_0\), "]"}]}], "==", 
          "0"}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Then, the particular solutions of ",
  StyleBox["order1Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " are"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1p = 
      \(DSolve[order1Eq, {u\_\(1, 1\)[T\_0], v\_\(1, 1\)[T\_0], 
                u\_\(2, 1\)[T\_0], v\_\(2, 1\)[T\_0]}, T\_0]\)[\([1]\)] /. 
          C[_] -> 0 // Simplify\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u\_\(1, 1\)[T\_0] \[Rule] 
        \(-\(\(E\^\(\(-I\)\ \((T\_0\ \[CapitalOmega] + \[Tau]\_1)\)\)\ 
                \((1 + E\^\(2\ I\ \((T\_0\ \[CapitalOmega] + \[Tau]\_1)\)\))
                  \)\ f\_1\)\/\(2\ 
                \((\[CapitalOmega]\^2 - \[Omega]\_1\%2)\)\)\)\), 
      v\_\(1, 1\)[T\_0] \[Rule] 
        \(-\(\(I\ E\^\(\(-I\)\ \((T\_0\ \[CapitalOmega] + \[Tau]\_1)\)\)\ 
                \((\(-1\) + 
                    E\^\(2\ I\ \((T\_0\ \[CapitalOmega] + \[Tau]\_1)\)\))\)\ 
                \[CapitalOmega]\ f\_1\)\/\(2\ 
                \((\[CapitalOmega]\^2 - \[Omega]\_1\%2)\)\)\)\), 
      u\_\(2, 1\)[T\_0] \[Rule] 0, v\_\(2, 1\)[T\_0] \[Rule] 0}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["To simplify some of the expressions, we let", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(fRule = {
        f\_i_ -> 
          2\ \[CapitalLambda]\_i\ \((\[Omega]\_i\%2 - \[CapitalOmega]\^2)\)}; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "and express ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\(i, 1\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`v\_\(i, 1\)\)]],
  " in pure function form as"
}], "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1u = 
      Table[u\_\(i, 1\) -> 
          Function[{T\_0, T\_1, T\_2}, 
            A\_i[T\_1, T\_2]\ Exp[I\ \[Omega]\_i\ T\_0] + 
                A\&_\_i[T\_1, T\_2]\ Exp[\(-I\)\ \[Omega]\_i\ T\_0] + 
                \((\(\(u\_\(i, 1\)[T\_0] /. sol1p\) /. fRule // Simplify\) // 
                    Expand)\) // Evaluate], {i, 2}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u\_\(1, 1\) \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1\)\ 
              \[CapitalLambda]\_1 + 
            E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1\)\ 
              \[CapitalLambda]\_1 + 
            E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1[T\_1, T\_2] + 
            E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ A\&_\_1[T\_1, T\_2]], 
      u\_\(2, 1\) \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2[T\_1, T\_2] + 
            E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ A\&_\_2[T\_1, T\_2]]}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1v = 
      Table[v\_\(i, 1\) -> 
          Function[{T\_0, T\_1, T\_2}, 
            D[u\_\(i, 1\)\ @@\ timeScales, T\_0] /. sol1u // Evaluate], {i, 
          2}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({v\_\(1, 1\) \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          \(-I\)\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1\)\ 
              \[CapitalOmega]\ \[CapitalLambda]\_1 + 
            I\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1\)\ 
              \[CapitalOmega]\ \[CapitalLambda]\_1 + 
            I\ E\^\(I\ T\_0\ \[Omega]\_1\)\ \[Omega]\_1\ A\_1[T\_1, T\_2] - 
            I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ \[Omega]\_1\ 
              A\&_\_1[T\_1, T\_2]], 
      v\_\(2, 1\) \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          I\ E\^\(I\ T\_0\ \[Omega]\_2\)\ \[Omega]\_2\ A\_2[T\_1, T\_2] - 
            I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ \[Omega]\_2\ 
              A\&_\_2[T\_1, T\_2]]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Then, we combine them using the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function ",
  StyleBox["Join",
    FontWeight->"Bold"],
  " as"
}], "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(sol1 = Join[sol1u, sol1v]; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell["Second-Order Problem", "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting the first-order solution ",
  StyleBox["sol1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into the second-order problem, ",
  StyleBox["eqOrder[2]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(order2Eq = eqOrder[2] /. sol1 // ExpandAll; \n
    order2Eq /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]u\_\(1, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ u, 1, 2]],
              Editable->False], "-", \(v\_\(1, 2\)\)}], "==", 
          RowBox[{
            RowBox[{\(-E\^\(I\ T\_0\ \[Omega]\_1\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 1]],
                  Editable->False], ")"}]}], "-", 
            RowBox[{\(E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 1]],
                  Editable->False], ")"}]}]}]}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(1, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ v, 1, 2]],
              Editable->False], "+", \(\[Omega]\_1\%2\ u\_\(1, 2\)\)}], 
          "==", 
          RowBox[{
          \(\(-3\)\ E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ A\_1\%2\ \[Delta]\_1\), 
            "-", \(2\ E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
              A\_1\ A\_2\ \[Delta]\_2\), "-", 
            \(E\^\(2\ I\ T\_0\ \[Omega]\_2\)\ A\_2\%2\ \[Delta]\_3\), "-", 
            \(6\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
                  I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Delta]\_1\ 
              \[CapitalLambda]\_1\), "-", 
            \(6\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                  I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Delta]\_1\ 
              \[CapitalLambda]\_1\), "-", 
            \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
                  I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Delta]\_2\ 
              \[CapitalLambda]\_1\), "-", 
            \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                  I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Delta]\_2\ 
              \[CapitalLambda]\_1\), "-", 
            \(6\ \[Delta]\_1\ \[CapitalLambda]\_1\%2\), "-", 
            \(3\ E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega] - 2\ I\ \[Tau]\_1\)\ 
              \[Delta]\_1\ \[CapitalLambda]\_1\%2\), "-", 
            \(3\ E\^\(2\ I\ T\_0\ \[CapitalOmega] + 2\ I\ \[Tau]\_1\)\ 
              \[Delta]\_1\ \[CapitalLambda]\_1\%2\), "+", 
            \(2\ I\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1\)\ 
              \[CapitalOmega]\ \[CapitalLambda]\_1\ \[Mu]\_1\), "-", 
            \(2\ I\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1\)\ 
              \[CapitalOmega]\ \[CapitalLambda]\_1\ \[Mu]\_1\), "-", 
            RowBox[{"I", " ", \(E\^\(I\ T\_0\ \[Omega]\_1\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 1]],
                  Editable->False], ")"}], " ", \(\[Omega]\_1\)}], "+", 
            RowBox[{"I", " ", \(E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 1]],
                  Editable->False], ")"}], " ", \(\[Omega]\_1\)}], "-", 
            \(2\ I\ E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Mu]\_1\ 
              \[Omega]\_1\), "-", \(6\ A\_1\ \[Delta]\_1\ A\&_\_1\), "-", 
            \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
              A\_2\ \[Delta]\_2\ A\&_\_1\), "-", 
            \(6\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                  I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ \[CapitalLambda]\_1\ 
              A\&_\_1\), "-", 
            \(6\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
                  I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ \[CapitalLambda]\_1\ 
              A\&_\_1\), "+", 
            \(2\ I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ \[Mu]\_1\ \[Omega]\_1\ 
              A\&_\_1\), "-", 
            \(3\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ 
              A\&_\_1\%2\), "-", 
            \(2\ E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ A\_1\ 
              \[Delta]\_2\ A\&_\_2\), "-", \(2\ A\_2\ \[Delta]\_3\ A\&_\_2\), 
            "-", \(2\ 
              E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                  I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
              A\&_\_2\), "-", 
            \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
                  I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
              A\&_\_2\), "-", 
            \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
              \[Delta]\_2\ A\&_\_1\ A\&_\_2\), "-", 
            \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ 
              A\&_\_2\%2\)}]}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]u\_\(2, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ u, 2, 2]],
              Editable->False], "-", \(v\_\(2, 2\)\)}], "==", 
          RowBox[{
            RowBox[{\(-E\^\(I\ T\_0\ \[Omega]\_2\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 2]],
                  Editable->False], ")"}]}], "-", 
            RowBox[{\(E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 2]],
                  Editable->False], ")"}]}]}]}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(2, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ v, 2, 2]],
              Editable->False], "+", \(\[Omega]\_2\%2\ u\_\(2, 2\)\)}], 
          "==", 
          RowBox[{
          \(1\/2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2\)\ 
              f\_2\), "+", 
            \(1\/2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2\)\ f\_2\), 
            "-", \(E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ A\_1\%2\ \[Delta]\_2\), 
            "-", \(2\ E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
              A\_1\ A\_2\ \[Delta]\_3\), "-", 
            \(3\ E\^\(2\ I\ T\_0\ \[Omega]\_2\)\ A\_2\%2\ \[Delta]\_4\), "-", 
            \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
                  I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Delta]\_2\ 
              \[CapitalLambda]\_1\), "-", 
            \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                  I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Delta]\_2\ 
              \[CapitalLambda]\_1\), "-", 
            \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
                  I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Delta]\_3\ 
              \[CapitalLambda]\_1\), "-", 
            \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                  I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Delta]\_3\ 
              \[CapitalLambda]\_1\), "-", 
            \(2\ \[Delta]\_2\ \[CapitalLambda]\_1\%2\), "-", 
            \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega] - 2\ I\ \[Tau]\_1\)\ 
              \[Delta]\_2\ \[CapitalLambda]\_1\%2\), "-", 
            \(E\^\(2\ I\ T\_0\ \[CapitalOmega] + 2\ I\ \[Tau]\_1\)\ 
              \[Delta]\_2\ \[CapitalLambda]\_1\%2\), "-", 
            RowBox[{"I", " ", \(E\^\(I\ T\_0\ \[Omega]\_2\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 2]],
                  Editable->False], ")"}], " ", \(\[Omega]\_2\)}], "+", 
            RowBox[{"I", " ", \(E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 2]],
                  Editable->False], ")"}], " ", \(\[Omega]\_2\)}], "-", 
            \(2\ I\ E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Mu]\_2\ 
              \[Omega]\_2\), "-", \(2\ A\_1\ \[Delta]\_2\ A\&_\_1\), "-", 
            \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
              A\_2\ \[Delta]\_3\ A\&_\_1\), "-", 
            \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                  I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
              A\&_\_1\), "-", 
            \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
                  I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
              A\&_\_1\), "-", 
            \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ A\&_\_1\%2\), 
            "-", \(2\ E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
              A\_1\ \[Delta]\_3\ A\&_\_2\), "-", 
            \(6\ A\_2\ \[Delta]\_4\ A\&_\_2\), "-", 
            \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                  I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
              A\&_\_2\), "-", 
            \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
                  I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
              A\&_\_2\), "+", 
            \(2\ I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ \[Mu]\_2\ \[Omega]\_2\ 
              A\&_\_2\), "-", 
            \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
              \[Delta]\_3\ A\&_\_1\ A\&_\_2\), "-", 
            \(3\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_4\ 
              A\&_\_2\%2\)}]}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Any particular solution of ",
  StyleBox["order2Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " contains secular terms and small-divisor terms, making the expansion \
nonuniform. For a uniform expansion, we choose ",
  Cell[BoxData[
      \(TraditionalForm\`\(D\_1\) A\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\(D\_1\) A\_2\)]],
  " to eliminate these terms. To accomplish this, we first convert the \
small-divisor terms into secular terms using the rule"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(expRule1[i_] := 
      Exp[a_] :> 
        Exp[Expand[a /. omgRule[\([i]\)]] /. \[Epsilon]\ T\_0 -> T\_1]\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "To eliminate the terms that produce secular terms (i.e., determine the \
solvability conditions) from ",
  StyleBox["order2Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we collect the terms proportional to ",
  Cell[BoxData[
      \(TraditionalForm\`E\^\(I\ \[Omega]\_1\ T\_0\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`E\^\(I\ \[Omega]\_2\ T\_0\)\)]],
  " and obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(ST11 = 
      \(Coefficient[order2Eq[\([#, 2]\)] /. expRule1[1], 
            Exp[I\ \[Omega]\_1\ T\_0]]\ &\)\ /@\ {1, 2}; \n
    ST11 /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"-", 
          RowBox[{"(", 
            InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
              SequenceForm[ 
                Subscript[ D, 1], 
                Subscript[ A, 1]],
              Editable->False], ")"}]}], ",", 
        RowBox[{
          RowBox[{\(-I\), " ", 
            RowBox[{"(", 
              InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                SequenceForm[ 
                  Subscript[ D, 1], 
                  Subscript[ A, 1]],
                Editable->False], ")"}], " ", \(\[Omega]\_1\)}], "-", 
          \(2\ I\ A\_1\ \[Mu]\_1\ \[Omega]\_1\), "-", 
          \(2\ E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_2\ \[Delta]\_2\ A\&_\_1\), 
          "-", \(6\ 
            E\^\(I\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2 + 
                I\ \[Tau]\_1\)\ \[Delta]\_1\ \[CapitalLambda]\_1\ 
            A\&_\_1\)}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ST12 = 
      \(Coefficient[order2Eq[\([#, 2]\)] /. expRule1[2], 
            Exp[I\ \[Omega]\_2\ T\_0]]\ &\)\ /@\ {3, 4}; \n
    ST12 /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"-", 
          RowBox[{"(", 
            InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
              SequenceForm[ 
                Subscript[ D, 1], 
                Subscript[ A, 2]],
              Editable->False], ")"}]}], ",", 
        RowBox[{
        \(1\/2\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ f\_2\), "-", 
          \(E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\%2\ \[Delta]\_2\), "-", 
          RowBox[{"I", " ", 
            RowBox[{"(", 
              InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
                SequenceForm[ 
                  Subscript[ D, 1], 
                  Subscript[ A, 2]],
                Editable->False], ")"}], " ", \(\[Omega]\_2\)}], "-", 
          \(2\ I\ A\_2\ \[Mu]\_2\ \[Omega]\_2\)}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Then, the solvability conditions, conditions for the elimination of the \
terms that produce secular terms, demand that ",
  StyleBox["ST11",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["ST12",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " be orthogonal to every solution of the corresponding adjoint problem, \
namely, the components of ",
  StyleBox["ccleftVec",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ". The result is"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(SCond1 = {ccleftVec[\([1]\)] . ST11 == 0, 
        ccleftVec[\([2]\)] . ST12 == 0}; \nSCond1 /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{\(-2\), " ", "I", " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 1]],
                  Editable->False], ")"}], " ", \(\[Omega]\_1\)}], "-", 
            \(2\ I\ A\_1\ \[Mu]\_1\ \[Omega]\_1\), "-", 
            \(2\ E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_2\ \[Delta]\_2\ A\&_\_1\), 
            "-", \(6\ 
              E\^\(I\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2 + 
                  I\ \[Tau]\_1\)\ \[Delta]\_1\ \[CapitalLambda]\_1\ 
              A\&_\_1\)}], "==", "0"}], ",", 
        RowBox[{
          RowBox[{
          \(1\/2\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ f\_2\), "-", 
            \(E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\%2\ \[Delta]\_2\), "-", 
            RowBox[{"2", " ", "I", " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 2]],
                  Editable->False], ")"}], " ", \(\[Omega]\_2\)}], "-", 
            \(2\ I\ A\_2\ \[Mu]\_2\ \[Omega]\_2\)}], "==", "0"}]}], "}"}]], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Solving ",
  StyleBox["SCond1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " for ",
  Cell[BoxData[
      \(TraditionalForm\`\(D\_1\) A\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\(D\_1\) A\_2\)]],
  " yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"SCond1Rule1", "=", 
        RowBox[{
          RowBox[{
            RowBox[{"Solve", "[", 
              RowBox[{"SCond1", ",", 
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{
                      SubsuperscriptBox["A", "1", 
                        TagBox[\((1, 0)\),
                          Derivative],
                        MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}], 
                    ",", 
                    RowBox[{
                      SubsuperscriptBox["A", "2", 
                        TagBox[\((1, 0)\),
                          Derivative],
                        MultilineFunction->None], "[", \(T\_1, T\_2\), 
                      "]"}]}], "}"}]}], "]"}], "[", \([1]\), "]"}], "//", 
          "ExpandAll"}]}], ";", "\n", \(SCond1Rule1 /. displayRule\)}]], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
            SequenceForm[ 
              Subscript[ D, 1], 
              Subscript[ A, 1]],
            Editable->False], "\[Rule]", 
          \(\(-A\_1\)\ \[Mu]\_1 + 
            \(I\ E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_2\ \[Delta]\_2\ 
                A\&_\_1\)\/\[Omega]\_1 + 
            \(3\ I\ E
                  \^\(I\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2 + 
                    I\ \[Tau]\_1\)\ \[Delta]\_1\ \[CapitalLambda]\_1\ 
                A\&_\_1\)\/\[Omega]\_1\)}], ",", 
        RowBox[{
          InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
            SequenceForm[ 
              Subscript[ D, 1], 
              Subscript[ A, 2]],
            Editable->False], "\[Rule]", 
          \(\(-A\_2\)\ \[Mu]\_2 - 
            \(I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ f\_2\)\/\(4\ 
                \[Omega]\_2\) + 
            \(I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\%2\ \[Delta]\_2\)\/\(2
                \ \[Omega]\_2\)\)}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "With these conditions, ",
  StyleBox["order2Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " are solvable. However, their solutions are not unique. To render them \
unique, we demand that they be orthogonal to solutions of the corresponding \
adjoint problems; that is, we damand that ",
  Cell[BoxData[
      \(TraditionalForm\`{u\_\(1, 2\ \), v\_\(1, 2\)}\)]],
  " be orthogonal to ",
  StyleBox["ccleftVec[[1]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`{u\_\(2, 2\ \), v\_\(2, 2\)}\)]],
  " be orthogonal to ",
  StyleBox["ccleftVec[[2]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Next, we use the solvability conditions to eliminate ",
  Cell[BoxData[
      \(TraditionalForm\`D\_1\ A\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`D\_1\ A\_2\)]],
  " from ",
  StyleBox["order2Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ". To simplify the resulting equations using ",
  StyleBox["Mathematica, ",
    FontSlant->"Italic"],
  "we replace the scale ",
  Cell[BoxData[
      \(TraditionalForm\`T\_1\)]],
  " in ",
  StyleBox["SCond1Rule1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " with ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon]\ T\_0\)]],
  ". To this end, we express the detuning parameters ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\_i\)]],
  " in terms of the ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\_i\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega]\)]],
  " as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sigRule = 
      \(Solve[ResonanceCond, {\[Sigma]\_1, \[Sigma]\_2}]\)[\([1]\)]\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[Sigma]\_1 \[Rule] 
        \(-\(\(2\ \[Omega]\_1 - \[Omega]\_2\)\/\[Epsilon]\)\), 
      \[Sigma]\_2 \[Rule] 
        \(-\(\(\(-\[CapitalOmega]\) + \[Omega]\_2\)\/\[Epsilon]\)\)}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "and replace ",
  Cell[BoxData[
      \(TraditionalForm\`T\_1\)]],
  " with ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon]\ T\_0\)]],
  " using the rule"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(expRule2 = 
      Exp[a_] :> Exp[\(a /. T\_1 -> \[Epsilon]\ T\_0\) /. sigRule // Expand]; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Using the ",
  StyleBox["expRule2",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we rewrite ",
  StyleBox["SCond1Rule1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(SCond1Rule2 = SCond1Rule1 /. expRule2; \nSCond1Rule2 /. displayRule\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
            SequenceForm[ 
              Subscript[ D, 1], 
              Subscript[ A, 1]],
            Editable->False], "\[Rule]", 
          \(\(-A\_1\)\ \[Mu]\_1 + 
            \(I\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                A\_2\ \[Delta]\_2\ A\&_\_1\)\/\[Omega]\_1 + 
            \(3\ I\ E
                  \^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
                    2\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ 
                \[CapitalLambda]\_1\ A\&_\_1\)\/\[Omega]\_1\)}], ",", 
        RowBox[{
          InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
            SequenceForm[ 
              Subscript[ D, 1], 
              Subscript[ A, 2]],
            Editable->False], "\[Rule]", 
          \(\(-A\_2\)\ \[Mu]\_2 - 
            \(I\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2 - 
                    I\ T\_0\ \[Omega]\_2\)\ f\_2\)\/\(4\ \[Omega]\_2\) + 
            \(I\ E\^\(2\ I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                A\_1\%2\ \[Delta]\_2\)\/\(2\ \[Omega]\_2\)\)}]}], "}"}]], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["whose complex conjugate is", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(ccSCond1Rule2 = SCond1Rule2 /. conjugateRule; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting this form for the solvability conditions into ",
  StyleBox["order2Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(order2Eqm = \(order2Eq /. SCond1Rule2\) /. ccSCond1Rule2 // ExpandAll; 
    \norder2Eqm /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]u\_\(1, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ u, 1, 2]],
              Editable->False], "-", \(v\_\(1, 2\)\)}], "==", 
          \(E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Mu]\_1 + 
            \(3\ I\ E
                  \^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
                    I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Delta]\_1\ 
                \[CapitalLambda]\_1\)\/\[Omega]\_1 + 
            E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ \[Mu]\_1\ A\&_\_1 - 
            \(I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                A\_2\ \[Delta]\_2\ A\&_\_1\)\/\[Omega]\_1 - 
            \(3\ I\ E
                  \^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
                    I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ \[CapitalLambda]\_1\ 
                A\&_\_1\)\/\[Omega]\_1 + 
            \(I\ E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ A\_1\ 
                \[Delta]\_2\ A\&_\_2\)\/\[Omega]\_1\)}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(1, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ v, 1, 2]],
              Editable->False], "+", \(\[Omega]\_1\%2\ u\_\(1, 2\)\)}], "==", 
          \(\(-3\)\ E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ A\_1\%2\ \[Delta]\_1 - 
            2\ E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ A\_1\ 
              A\_2\ \[Delta]\_2 - 
            E\^\(2\ I\ T\_0\ \[Omega]\_2\)\ A\_2\%2\ \[Delta]\_3 - 
            3\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
                  I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Delta]\_1\ 
              \[CapitalLambda]\_1 - 
            6\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                  I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Delta]\_1\ 
              \[CapitalLambda]\_1 - 
            2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
                  I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Delta]\_2\ 
              \[CapitalLambda]\_1 - 
            2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                  I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Delta]\_2\ 
              \[CapitalLambda]\_1 - 6\ \[Delta]\_1\ \[CapitalLambda]\_1\%2 - 
            3\ E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega] - 2\ I\ \[Tau]\_1\)\ 
              \[Delta]\_1\ \[CapitalLambda]\_1\%2 - 
            3\ E\^\(2\ I\ T\_0\ \[CapitalOmega] + 2\ I\ \[Tau]\_1\)\ 
              \[Delta]\_1\ \[CapitalLambda]\_1\%2 + 
            2\ I\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1\)\ 
              \[CapitalOmega]\ \[CapitalLambda]\_1\ \[Mu]\_1 - 
            2\ I\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1\)\ 
              \[CapitalOmega]\ \[CapitalLambda]\_1\ \[Mu]\_1 - 
            I\ E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Mu]\_1\ \[Omega]\_1 - 
            6\ A\_1\ \[Delta]\_1\ A\&_\_1 - 
            E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ A\_2\ 
              \[Delta]\_2\ A\&_\_1 - 
            6\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                  I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ \[CapitalLambda]\_1\ 
              A\&_\_1 - 
            3\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
                  I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ \[CapitalLambda]\_1\ 
              A\&_\_1 + 
            I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ \[Mu]\_1\ \[Omega]\_1\ 
              A\&_\_1 - 
            3\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ A\&_\_1\%2 - 
            E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ A\_1\ 
              \[Delta]\_2\ A\&_\_2 - 2\ A\_2\ \[Delta]\_3\ A\&_\_2 - 
            2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                  I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
              A\&_\_2 - 
            2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
                  I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
              A\&_\_2 - 
            2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
              \[Delta]\_2\ A\&_\_1\ A\&_\_2 - 
            E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ A\&_\_2\%2\)}], 
        ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]u\_\(2, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ u, 2, 2]],
              Editable->False], "-", \(v\_\(2, 2\)\)}], "==", 
          \(E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Mu]\_2 - 
            \(I\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2\)\ 
                f\_2\)\/\(4\ \[Omega]\_2\) + 
            \(I\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2\)\ f\_2\)\/\(4\ 
                \[Omega]\_2\) - 
            \(I\ E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ A\_1\%2\ \[Delta]\_2\)\/\(2\ 
                \[Omega]\_2\) + 
            \(I\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ 
                A\&_\_1\%2\)\/\(2\ \[Omega]\_2\) + 
            E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ \[Mu]\_2\ A\&_\_2\)}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(2, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ v, 2, 2]],
              Editable->False], "+", \(\[Omega]\_2\%2\ u\_\(2, 2\)\)}], "==", 
          \(1\/4\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2\)\ f\_2 + 
            1\/4\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2\)\ f\_2 - 
            1\/2\ E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ A\_1\%2\ \[Delta]\_2 - 
            2\ E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ A\_1\ 
              A\_2\ \[Delta]\_3 - 
            3\ E\^\(2\ I\ T\_0\ \[Omega]\_2\)\ A\_2\%2\ \[Delta]\_4 - 
            2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
                  I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Delta]\_2\ 
              \[CapitalLambda]\_1 - 
            2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                  I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Delta]\_2\ 
              \[CapitalLambda]\_1 - 
            2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
                  I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Delta]\_3\ 
              \[CapitalLambda]\_1 - 
            2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                  I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Delta]\_3\ 
              \[CapitalLambda]\_1 - 2\ \[Delta]\_2\ \[CapitalLambda]\_1\%2 - 
            E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega] - 2\ I\ \[Tau]\_1\)\ 
              \[Delta]\_2\ \[CapitalLambda]\_1\%2 - 
            E\^\(2\ I\ T\_0\ \[CapitalOmega] + 2\ I\ \[Tau]\_1\)\ 
              \[Delta]\_2\ \[CapitalLambda]\_1\%2 - 
            I\ E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Mu]\_2\ \[Omega]\_2 - 
            2\ A\_1\ \[Delta]\_2\ A\&_\_1 - 
            2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ A\_2\ 
              \[Delta]\_3\ A\&_\_1 - 
            2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                  I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
              A\&_\_1 - 
            2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
                  I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
              A\&_\_1 - 
            1\/2\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ 
              A\&_\_1\%2 - 
            2\ E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ A\_1\ 
              \[Delta]\_3\ A\&_\_2 - 6\ A\_2\ \[Delta]\_4\ A\&_\_2 - 
            2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                  I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
              A\&_\_2 - 
            2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
                  I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
              A\&_\_2 + 
            I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ \[Mu]\_2\ \[Omega]\_2\ 
              A\&_\_2 - 
            2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
              \[Delta]\_3\ A\&_\_1\ A\&_\_2 - 
            3\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_4\ 
              A\&_\_2\%2\)}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Next, we use the method of undetermined coefficients to determine the \
particular solutions of ",
  StyleBox["order2Eqm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ". To accomplish this, we first identify the form of the nonhomogeneous \
terms. To this end, we let"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(basicH = 
      Table[{A\_i[T\_1, T\_2]\ E\^\(I\ \[Omega]\_i\ T\_0\), 
            A\&_\_i[T\_1, T\_2]\ E\^\(\(-I\)\ \[Omega]\_i\ T\_0\)}, {i, 
            2}] // Flatten\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1[T\_1, T\_2], 
      E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ A\&_\_1[T\_1, T\_2], 
      E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2[T\_1, T\_2], 
      E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ A\&_\_2[T\_1, T\_2]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(collectForm = 
      Join[basicH, {
          \[CapitalLambda]\_1\ 
            E\^\(I\ \[CapitalOmega]\ T\_0 + I\ \[Tau]\_1\), 
          \[CapitalLambda]\_1\ 
            E\^\(\(-I\)\ \[CapitalOmega]\ T\_0 - I\ \[Tau]\_1\)}]\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1[T\_1, T\_2], 
      E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ A\&_\_1[T\_1, T\_2], 
      E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2[T\_1, T\_2], 
      E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ A\&_\_2[T\_1, T\_2], 
      E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1\)\ \[CapitalLambda]\_1, 
      E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1\)\ 
        \[CapitalLambda]\_1}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Then, the possible form of the nonhomogeneous terms in ",
  StyleBox["order2Eqm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " is"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(possibleTerms = 
      Join[collectForm, {E\^\(I\ \[CapitalOmega]\ T\_0 + I\ \[Tau]\_2\), 
          E\^\(\(-I\)\ \[CapitalOmega]\ T\_0 - I\ \[Tau]\_2\)}, 
        \(Outer[Times, collectForm, collectForm] // Flatten\) // Union]\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1[T\_1, T\_2], 
      E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ A\&_\_1[T\_1, T\_2], 
      E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2[T\_1, T\_2], 
      E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ A\&_\_2[T\_1, T\_2], 
      E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1\)\ \[CapitalLambda]\_1, 
      E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1\)\ 
        \[CapitalLambda]\_1, E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2\), 
      E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2\), 
      \[CapitalLambda]\_1\%2, 
      E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega] - 2\ I\ \[Tau]\_1\)\ 
        \[CapitalLambda]\_1\%2, 
      E\^\(2\ I\ T\_0\ \[CapitalOmega] + 2\ I\ \[Tau]\_1\)\ 
        \[CapitalLambda]\_1\%2, 
      E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
            I\ T\_0\ \[Omega]\_1\)\ \[CapitalLambda]\_1\ A\_1[T\_1, T\_2], 
      E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + I\ T\_0\ \[Omega]\_1\)\ 
        \[CapitalLambda]\_1\ A\_1[T\_1, T\_2], 
      E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ A\_1[T\_1, T\_2]\^2, 
      E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
            I\ T\_0\ \[Omega]\_2\)\ \[CapitalLambda]\_1\ A\_2[T\_1, T\_2], 
      E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
        \[CapitalLambda]\_1\ A\_2[T\_1, T\_2], 
      E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ A\_1[T\_1, T\_2]\ 
        A\_2[T\_1, T\_2], 
      E\^\(2\ I\ T\_0\ \[Omega]\_2\)\ A\_2[T\_1, T\_2]\^2, 
      E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
            I\ T\_0\ \[Omega]\_1\)\ \[CapitalLambda]\_1\ A\&_\_1[T\_1, T\_2], 
      E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - I\ T\_0\ \[Omega]\_1\)\ 
        \[CapitalLambda]\_1\ A\&_\_1[T\_1, T\_2], 
      A\_1[T\_1, T\_2]\ A\&_\_1[T\_1, T\_2], 
      E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
        A\_2[T\_1, T\_2]\ A\&_\_1[T\_1, T\_2], 
      E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ A\&_\_1[T\_1, T\_2]\^2, 
      E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
            I\ T\_0\ \[Omega]\_2\)\ \[CapitalLambda]\_1\ A\&_\_2[T\_1, T\_2], 
      E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
        \[CapitalLambda]\_1\ A\&_\_2[T\_1, T\_2], 
      E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ A\_1[T\_1, T\_2]\ 
        A\&_\_2[T\_1, T\_2], A\_2[T\_1, T\_2]\ A\&_\_2[T\_1, T\_2], 
      E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
        A\&_\_1[T\_1, T\_2]\ A\&_\_2[T\_1, T\_2], 
      E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_2\)\ A\&_\_2[T\_1, T\_2]\^2}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Using the method of undetermined coefficients, we assume that the ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\(i, 2\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`v\_\(i, 2\)\)]],
  " are linear combinations of these possible terms, substitute the result \
into the governing equations, ",
  StyleBox["order2Eqm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", equate the coefficients of each of the possible terms on both sides of \
each equation, and obtain a system of nonhomogeneous algebraic equations \
governing the unknown coefficients. Associated with each possible term is a \
pair of two algebraic equations. The solutions of all pairs, except those \
associated with resonance terms, are unique. The solutions of the pairs \
corresponding to the possible resonance terms are rendered unique by \
requiring them to be orthogonal to the components of ",
  StyleBox["ccleftVec",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ". The possible resonance terms are proportional to ",
  Cell[BoxData[
      \(TraditionalForm\`E\^\(I\ \(\[Omega]\_1\) T\_0\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\(E\^\(I\ \(\[Omega]\_2\) T\_0\), \)\)]],
  " and their complex conjugates; that is,"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(ResonantTerms[i_] := 
      \(\((\(# /. {a_ /; a =!= 0 -> 1}\ &\)\ /@\ 
                \((\(E\^\(\(-I\)\ \[Omega]\_i\ T\_0\)\ possibleTerms /. 
                      expRule1[i]\) /. Exp[_\ T\_0 + _. ] -> 0)\))\)\ 
            possibleTerms // Union\) // Rest\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(RT = Array[ResonantTerms, 2]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1[T\_1, T\_2], 
        E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
              I\ T\_0\ \[Omega]\_1\)\ \[CapitalLambda]\_1\ 
          A\&_\_1[T\_1, T\_2], 
        E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
          A\_2[T\_1, T\_2]\ A\&_\_1[T\_1, T\_2]}, {
        E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2\), 
        E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1\)\ \[CapitalLambda]\_1, 
        E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ A\_1[T\_1, T\_2]\^2, 
        E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2[T\_1, T\_2]}}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Hence, the coefficients of ",
  StyleBox["RT",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in the nonhomogeneous terms in ",
  StyleBox["order2Eqm[[1]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " are"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(r1Rule = 
      MapIndexed[
          r\_\(1, #2[\([1]\)]\) -> Coefficient[order2Eqm[\([1, 2]\)], #1]\ &, 
          RT[\([1]\)]] /. Exp[_\ T\_0 + _. ] -> 0\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({r\_\(1, 1\) \[Rule] \[Mu]\_1, 
      r\_\(1, 2\) \[Rule] \(-\(\(3\ I\ \[Delta]\_1\)\/\[Omega]\_1\)\), 
      r\_\(1, 3\) \[Rule] \(-\(\(I\ \[Delta]\_2\)\/\[Omega]\_1\)\)}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "and the coefficients of ",
  StyleBox["RT",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in the nonhomogeneous terms in ",
  StyleBox["order2Eqm[[2]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " are"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(r2Rule = 
      MapIndexed[
          r\_\(2, #2[\([1]\)]\) -> Coefficient[order2Eqm[\([2, 2]\)], #1]\ &, 
          RT[\([1]\)]] /. Exp[_\ T\_0 + _. ] -> 0\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({r\_\(2, 1\) \[Rule] \(-I\)\ \[Mu]\_1\ \[Omega]\_1, 
      r\_\(2, 2\) \[Rule] \(-3\)\ \[Delta]\_1, 
      r\_\(2, 3\) \[Rule] \(-\[Delta]\_2\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["It follows from", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Table[ccleftVec[\([1]\)] . {r\_\(1, i\), r\_\(2, i\)}, {i, 3}] /. 
        r1Rule\) /. r2Rule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({0, 0, 0}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "that the parts ",
  StyleBox["r1Rule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["r2Rule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  StyleBox[" ",
    FontColor->RGBColor[1, 0, 1]],
  "are orthogonal to the solution of the adjoint, the first component of ",
  StyleBox["ccleftVec",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", as they should."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Similarly, the coefficients of ",
  StyleBox["RT",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in the nonhomogeneous terms in ",
  StyleBox["order2Eqm[[3]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " are"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(r3Rule = 
      MapIndexed[
        r\_\(3, #2[\([1]\)]\) -> Coefficient[order2Eqm[\([3, 2]\)], #1]\ &, 
        RT[\([2]\)]]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({r\_\(3, 1\) \[Rule] \(I\ f\_2\)\/\(4\ \[Omega]\_2\), 
      r\_\(3, 2\) \[Rule] 0, 
      r\_\(3, 3\) \[Rule] \(-\(\(I\ \[Delta]\_2\)\/\(2\ \[Omega]\_2\)\)\), 
      r\_\(3, 4\) \[Rule] \[Mu]\_2}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "and the coefficients of ",
  StyleBox["RT",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in the nonhomogeneous terms in ",
  StyleBox["order2Eqm[[4]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " are"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(r4Rule = 
      MapIndexed[
          r\_\(4, #2[\([1]\)]\) -> Coefficient[order2Eqm[\([4, 2]\)], #1]\ &, 
          RT[\([2]\)]] /. Exp[_\ T\_0 + _. ] -> 0\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({r\_\(4, 1\) \[Rule] f\_2\/4, r\_\(4, 2\) \[Rule] 0, 
      r\_\(4, 3\) \[Rule] \(-\(\[Delta]\_2\/2\)\), 
      r\_\(4, 4\) \[Rule] \(-I\)\ \[Mu]\_2\ \[Omega]\_2}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["Again, it follows from", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Table[ccleftVec[\([2]\)] . {r\_\(3, i\), r\_\(4, i\)}, {i, 4}] /. 
        r3Rule\) /. r4Rule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({0, 0, 0, 0}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "that the vector ",
  Cell[BoxData[
      \(TraditionalForm\`{r\_\(3, \ i\ \), r\_\(4, \ i\)}\)]],
  " is orthogonal to the solution of the adjoint, the second component of ",
  StyleBox["ccleftVec",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", as it should."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "The complement of the resonance terms ",
  StyleBox["RT",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in ",
  StyleBox["possibleTerms",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " yields the nonresonance terms; that is,"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(NRT = 
      \(Complement[possibleTerms, Join[#, # /. conjugateRule]]\ &\)\ /@\ RT
        \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2\), 
        E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2\), 
        E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1\)\ 
          \[CapitalLambda]\_1, 
        E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1\)\ \[CapitalLambda]\_1, 
        \[CapitalLambda]\_1\%2, 
        E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega] - 2\ I\ \[Tau]\_1\)\ 
          \[CapitalLambda]\_1\%2, 
        E\^\(2\ I\ T\_0\ \[CapitalOmega] + 2\ I\ \[Tau]\_1\)\ 
          \[CapitalLambda]\_1\%2, 
        E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
              I\ T\_0\ \[Omega]\_1\)\ \[CapitalLambda]\_1\ A\_1[T\_1, T\_2], 
        E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ A\_1[T\_1, T\_2]\^2, 
        E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2[T\_1, T\_2], 
        E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
              I\ T\_0\ \[Omega]\_2\)\ \[CapitalLambda]\_1\ A\_2[T\_1, T\_2], 
        E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
              I\ T\_0\ \[Omega]\_2\)\ \[CapitalLambda]\_1\ A\_2[T\_1, T\_2], 
        E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ A\_1[T\_1, T\_2]\ 
          A\_2[T\_1, T\_2], 
        E\^\(2\ I\ T\_0\ \[Omega]\_2\)\ A\_2[T\_1, T\_2]\^2, 
        E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
              I\ T\_0\ \[Omega]\_1\)\ \[CapitalLambda]\_1\ 
          A\&_\_1[T\_1, T\_2], A\_1[T\_1, T\_2]\ A\&_\_1[T\_1, T\_2], 
        E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ A\&_\_1[T\_1, T\_2]\^2, 
        E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ A\&_\_2[T\_1, T\_2], 
        E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
              I\ T\_0\ \[Omega]\_2\)\ \[CapitalLambda]\_1\ 
          A\&_\_2[T\_1, T\_2], 
        E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
              I\ T\_0\ \[Omega]\_2\)\ \[CapitalLambda]\_1\ 
          A\&_\_2[T\_1, T\_2], A\_2[T\_1, T\_2]\ A\&_\_2[T\_1, T\_2], 
        E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
          A\&_\_1[T\_1, T\_2]\ A\&_\_2[T\_1, T\_2], 
        E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_2\)\ A\&_\_2[T\_1, T\_2]\^2}, {
        \[CapitalLambda]\_1\%2, 
        E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega] - 2\ I\ \[Tau]\_1\)\ 
          \[CapitalLambda]\_1\%2, 
        E\^\(2\ I\ T\_0\ \[CapitalOmega] + 2\ I\ \[Tau]\_1\)\ 
          \[CapitalLambda]\_1\%2, 
        E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1[T\_1, T\_2], 
        E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
              I\ T\_0\ \[Omega]\_1\)\ \[CapitalLambda]\_1\ A\_1[T\_1, T\_2], 
        E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
              I\ T\_0\ \[Omega]\_1\)\ \[CapitalLambda]\_1\ A\_1[T\_1, T\_2], 
        E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
              I\ T\_0\ \[Omega]\_2\)\ \[CapitalLambda]\_1\ A\_2[T\_1, T\_2], 
        E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
              I\ T\_0\ \[Omega]\_2\)\ \[CapitalLambda]\_1\ A\_2[T\_1, T\_2], 
        E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ A\_1[T\_1, T\_2]\ 
          A\_2[T\_1, T\_2], 
        E\^\(2\ I\ T\_0\ \[Omega]\_2\)\ A\_2[T\_1, T\_2]\^2, 
        E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ A\&_\_1[T\_1, T\_2], 
        E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
              I\ T\_0\ \[Omega]\_1\)\ \[CapitalLambda]\_1\ 
          A\&_\_1[T\_1, T\_2], 
        E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
              I\ T\_0\ \[Omega]\_1\)\ \[CapitalLambda]\_1\ 
          A\&_\_1[T\_1, T\_2], A\_1[T\_1, T\_2]\ A\&_\_1[T\_1, T\_2], 
        E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
          A\_2[T\_1, T\_2]\ A\&_\_1[T\_1, T\_2], 
        E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
              I\ T\_0\ \[Omega]\_2\)\ \[CapitalLambda]\_1\ 
          A\&_\_2[T\_1, T\_2], 
        E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
              I\ T\_0\ \[Omega]\_2\)\ \[CapitalLambda]\_1\ 
          A\&_\_2[T\_1, T\_2], 
        E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ A\_1[T\_1, T\_2]\ 
          A\&_\_2[T\_1, T\_2], A\_2[T\_1, T\_2]\ A\&_\_2[T\_1, T\_2], 
        E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
          A\&_\_1[T\_1, T\_2]\ A\&_\_2[T\_1, T\_2], 
        E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_2\)\ A\&_\_2[T\_1, T\_2]\^2}}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
To implement the method of undetermined coefficients, we associate with each \
possible resonance term an unknown coefficient using the rules\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(RTsymbolList1 = 
      Table[\[CapitalGamma]\_\(1, j\), {j, Length[RT[\([1]\)]]}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[CapitalGamma]\_\(1, 1\), \[CapitalGamma]\_\(1, 2\), 
      \[CapitalGamma]\_\(1, 3\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RTsymbolList2 = 
      Table[\[CapitalGamma]\_\(3, j\), {j, Length[RT[\([2]\)]]}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[CapitalGamma]\_\(3, 1\), \[CapitalGamma]\_\(3, 2\), 
      \[CapitalGamma]\_\(3, 3\), \[CapitalGamma]\_\(3, 4\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
And, we associate with each possible nonresonance term two unknown \
coefficients using the rules\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(NRTsymbolList1[i_] = 
      Table[\[CapitalLambda]\_\(i, j\), {j, Length[NRT[\([1]\)]]}]\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[CapitalLambda]\_\(i, 1\), \[CapitalLambda]\_\(i, 2\), 
      \[CapitalLambda]\_\(i, 3\), \[CapitalLambda]\_\(i, 4\), 
      \[CapitalLambda]\_\(i, 5\), \[CapitalLambda]\_\(i, 6\), 
      \[CapitalLambda]\_\(i, 7\), \[CapitalLambda]\_\(i, 8\), 
      \[CapitalLambda]\_\(i, 9\), \[CapitalLambda]\_\(i, 10\), 
      \[CapitalLambda]\_\(i, 11\), \[CapitalLambda]\_\(i, 12\), 
      \[CapitalLambda]\_\(i, 13\), \[CapitalLambda]\_\(i, 14\), 
      \[CapitalLambda]\_\(i, 15\), \[CapitalLambda]\_\(i, 16\), 
      \[CapitalLambda]\_\(i, 17\), \[CapitalLambda]\_\(i, 18\), 
      \[CapitalLambda]\_\(i, 19\), \[CapitalLambda]\_\(i, 20\), 
      \[CapitalLambda]\_\(i, 21\), \[CapitalLambda]\_\(i, 22\), 
      \[CapitalLambda]\_\(i, 23\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NRTsymbolList2[i_] = 
      Table[\[CapitalLambda]\_\(i + 2, j\), {j, Length[NRT[\([2]\)]]}]\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[CapitalLambda]\_\(2 + i, 1\), \[CapitalLambda]\_\(2 + i, 2\), 
      \[CapitalLambda]\_\(2 + i, 3\), \[CapitalLambda]\_\(2 + i, 4\), 
      \[CapitalLambda]\_\(2 + i, 5\), \[CapitalLambda]\_\(2 + i, 6\), 
      \[CapitalLambda]\_\(2 + i, 7\), \[CapitalLambda]\_\(2 + i, 8\), 
      \[CapitalLambda]\_\(2 + i, 9\), \[CapitalLambda]\_\(2 + i, 10\), 
      \[CapitalLambda]\_\(2 + i, 11\), \[CapitalLambda]\_\(2 + i, 12\), 
      \[CapitalLambda]\_\(2 + i, 13\), \[CapitalLambda]\_\(2 + i, 14\), 
      \[CapitalLambda]\_\(2 + i, 15\), \[CapitalLambda]\_\(2 + i, 16\), 
      \[CapitalLambda]\_\(2 + i, 17\), \[CapitalLambda]\_\(2 + i, 18\), 
      \[CapitalLambda]\_\(2 + i, 19\), \[CapitalLambda]\_\(2 + i, 20\), 
      \[CapitalLambda]\_\(2 + i, 21\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Accounting for the orthogonality conditions, ",
  Cell[BoxData[
      \(TraditionalForm\`{u\_\(1, 2\ \), v\_\(1, 2\)}\)]],
  " must be orthogonal to ",
  StyleBox["ccleftVec[[1]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  StyleBox[" ",
    FontColor->RGBColor[1, 0, 1]],
  "and ",
  Cell[BoxData[
      \(TraditionalForm\`{u\_\(2, 2\ \), v\_\(2, 2\)}\)]],
  " must be orthogonal to ",
  StyleBox["ccleftVec[[2]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", for the resonance terms, ",
  StyleBox["RT",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we express ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\(i, 2\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`v\_\(i, 2\)\)]],
  " in the following function form:"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \({ratio1, ratio2} = Table[\(-ccleftVec[\([i, 1]\)]\), {i, 2}]\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\(-I\)\ \[Omega]\_1, \(-I\)\ \[Omega]\_2}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[BoxData[
    \(\(sol2Form = {
        u\_\(1, 2\) -> 
          Function[{T\_0, T\_1, T\_2}, 
            RTsymbolList1 . RT[\([1]\)] + 
                \((RTsymbolList1 . RT[\([1]\)] /. conjugateRule)\) + 
                NRTsymbolList1[1] . NRT[\([1]\)] // Evaluate], 
        v\_\(1, 2\) -> 
          Function[{T\_0, T\_1, T\_2}, 
            ratio1*RTsymbolList1 . RT[\([1]\)] + 
                \((ratio1*RTsymbolList1 . RT[\([1]\)] /. conjugateRule)\) + 
                NRTsymbolList1[2] . NRT[\([1]\)] // Evaluate], 
        u\_\(2, 2\) -> 
          Function[{T\_0, T\_1, T\_2}, 
            RTsymbolList2 . RT[\([2]\)] + 
                \((RTsymbolList2 . RT[\([2]\)] /. conjugateRule)\) + 
                NRTsymbolList2[1] . NRT[\([2]\)] // Evaluate], 
        v\_\(2, 2\) -> 
          Function[{T\_0, T\_1, T\_2}, 
            ratio2*RTsymbolList2 . RT[\([2]\)] + 
                \((ratio2*RTsymbolList2 . RT[\([2]\)] /. conjugateRule)\) + 
                NRTsymbolList2[2] . NRT[\([2]\)] // Evaluate]}; \)\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting ",
  StyleBox["sol2Form",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["order2Eqm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and collecting the coefficients of like ",
  StyleBox["NRT",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain two sets of algebraic equations as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(eq611b = 
      \((\(Coefficient[Subtract\ @@\ # /. sol2Form, NRT[\([1]\)]] /. 
                    Exp[_\ T\_0 + _. ] -> 0\ &\)\ /@\ 
                order2Eqm[\([{1, 2}]\)] // Flatten)\) == 0 // Thread\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\(-I\)\ \[CapitalOmega]\ \[CapitalLambda]\_\(1, 1\) - 
          \[CapitalLambda]\_\(2, 1\) == 0, 
      I\ \[CapitalOmega]\ \[CapitalLambda]\_\(1, 2\) - 
          \[CapitalLambda]\_\(2, 2\) == 0, 
      \(-I\)\ \[CapitalOmega]\ \[CapitalLambda]\_\(1, 3\) - 
          \[CapitalLambda]\_\(2, 3\) == 0, 
      I\ \[CapitalOmega]\ \[CapitalLambda]\_\(1, 4\) - 
          \[CapitalLambda]\_\(2, 4\) == 0, 
      \(-\[CapitalLambda]\_\(2, 5\)\) == 0, 
      \(-2\)\ I\ \[CapitalOmega]\ \[CapitalLambda]\_\(1, 6\) - 
          \[CapitalLambda]\_\(2, 6\) == 0, 
      2\ I\ \[CapitalOmega]\ \[CapitalLambda]\_\(1, 7\) - 
          \[CapitalLambda]\_\(2, 7\) == 0, 
      I\ \[CapitalOmega]\ \[CapitalLambda]\_\(1, 8\) + 
          I\ \[Omega]\_1\ \[CapitalLambda]\_\(1, 8\) - 
          \[CapitalLambda]\_\(2, 8\) == 0, 
      2\ I\ \[Omega]\_1\ \[CapitalLambda]\_\(1, 9\) - 
          \[CapitalLambda]\_\(2, 9\) == 0, 
      I\ \[Omega]\_2\ \[CapitalLambda]\_\(1, 10\) - 
          \[CapitalLambda]\_\(2, 10\) == 0, 
      \(-I\)\ \[CapitalOmega]\ \[CapitalLambda]\_\(1, 11\) + 
          I\ \[Omega]\_2\ \[CapitalLambda]\_\(1, 11\) - 
          \[CapitalLambda]\_\(2, 11\) == 0, 
      I\ \[CapitalOmega]\ \[CapitalLambda]\_\(1, 12\) + 
          I\ \[Omega]\_2\ \[CapitalLambda]\_\(1, 12\) - 
          \[CapitalLambda]\_\(2, 12\) == 0, 
      I\ \[Omega]\_1\ \[CapitalLambda]\_\(1, 13\) + 
          I\ \[Omega]\_2\ \[CapitalLambda]\_\(1, 13\) - 
          \[CapitalLambda]\_\(2, 13\) == 0, 
      2\ I\ \[Omega]\_2\ \[CapitalLambda]\_\(1, 14\) - 
          \[CapitalLambda]\_\(2, 14\) == 0, 
      \(-I\)\ \[CapitalOmega]\ \[CapitalLambda]\_\(1, 15\) - 
          I\ \[Omega]\_1\ \[CapitalLambda]\_\(1, 15\) - 
          \[CapitalLambda]\_\(2, 15\) == 0, 
      \(-\[CapitalLambda]\_\(2, 16\)\) == 0, 
      \(-2\)\ I\ \[Omega]\_1\ \[CapitalLambda]\_\(1, 17\) - 
          \[CapitalLambda]\_\(2, 17\) == 0, 
      \(-I\)\ \[Omega]\_2\ \[CapitalLambda]\_\(1, 18\) - 
          \[CapitalLambda]\_\(2, 18\) == 0, 
      \(-I\)\ \[CapitalOmega]\ \[CapitalLambda]\_\(1, 19\) - 
          I\ \[Omega]\_2\ \[CapitalLambda]\_\(1, 19\) - 
          \[CapitalLambda]\_\(2, 19\) == 0, 
      I\ \[CapitalOmega]\ \[CapitalLambda]\_\(1, 20\) - 
          I\ \[Omega]\_2\ \[CapitalLambda]\_\(1, 20\) - 
          \[CapitalLambda]\_\(2, 20\) == 0, 
      \(-\[CapitalLambda]\_\(2, 21\)\) == 0, 
      \(-I\)\ \[Omega]\_1\ \[CapitalLambda]\_\(1, 22\) - 
          I\ \[Omega]\_2\ \[CapitalLambda]\_\(1, 22\) - 
          \[CapitalLambda]\_\(2, 22\) == 0, 
      \(-2\)\ I\ \[Omega]\_2\ \[CapitalLambda]\_\(1, 23\) - 
          \[CapitalLambda]\_\(2, 23\) == 0, 
      \[Omega]\_1\%2\ \[CapitalLambda]\_\(1, 1\) - 
          I\ \[CapitalOmega]\ \[CapitalLambda]\_\(2, 1\) == 0, 
      \[Omega]\_1\%2\ \[CapitalLambda]\_\(1, 2\) + 
          I\ \[CapitalOmega]\ \[CapitalLambda]\_\(2, 2\) == 0, 
      \(-2\)\ I\ \[CapitalOmega]\ \[Mu]\_1 + 
          \[Omega]\_1\%2\ \[CapitalLambda]\_\(1, 3\) - 
          I\ \[CapitalOmega]\ \[CapitalLambda]\_\(2, 3\) == 0, 
      2\ I\ \[CapitalOmega]\ \[Mu]\_1 + 
          \[Omega]\_1\%2\ \[CapitalLambda]\_\(1, 4\) + 
          I\ \[CapitalOmega]\ \[CapitalLambda]\_\(2, 4\) == 0, 
      6\ \[Delta]\_1 + \[Omega]\_1\%2\ \[CapitalLambda]\_\(1, 5\) == 0, 
      3\ \[Delta]\_1 + \[Omega]\_1\%2\ \[CapitalLambda]\_\(1, 6\) - 
          2\ I\ \[CapitalOmega]\ \[CapitalLambda]\_\(2, 6\) == 0, 
      3\ \[Delta]\_1 + \[Omega]\_1\%2\ \[CapitalLambda]\_\(1, 7\) + 
          2\ I\ \[CapitalOmega]\ \[CapitalLambda]\_\(2, 7\) == 0, 
      6\ \[Delta]\_1 + \[Omega]\_1\%2\ \[CapitalLambda]\_\(1, 8\) + 
          I\ \[CapitalOmega]\ \[CapitalLambda]\_\(2, 8\) + 
          I\ \[Omega]\_1\ \[CapitalLambda]\_\(2, 8\) == 0, 
      3\ \[Delta]\_1 + \[Omega]\_1\%2\ \[CapitalLambda]\_\(1, 9\) + 
          2\ I\ \[Omega]\_1\ \[CapitalLambda]\_\(2, 9\) == 0, 
      \[Omega]\_1\%2\ \[CapitalLambda]\_\(1, 10\) + 
          I\ \[Omega]\_2\ \[CapitalLambda]\_\(2, 10\) == 0, 
      2\ \[Delta]\_2 + \[Omega]\_1\%2\ \[CapitalLambda]\_\(1, 11\) - 
          I\ \[CapitalOmega]\ \[CapitalLambda]\_\(2, 11\) + 
          I\ \[Omega]\_2\ \[CapitalLambda]\_\(2, 11\) == 0, 
      2\ \[Delta]\_2 + \[Omega]\_1\%2\ \[CapitalLambda]\_\(1, 12\) + 
          I\ \[CapitalOmega]\ \[CapitalLambda]\_\(2, 12\) + 
          I\ \[Omega]\_2\ \[CapitalLambda]\_\(2, 12\) == 0, 
      2\ \[Delta]\_2 + \[Omega]\_1\%2\ \[CapitalLambda]\_\(1, 13\) + 
          I\ \[Omega]\_1\ \[CapitalLambda]\_\(2, 13\) + 
          I\ \[Omega]\_2\ \[CapitalLambda]\_\(2, 13\) == 0, 
      \[Delta]\_3 + \[Omega]\_1\%2\ \[CapitalLambda]\_\(1, 14\) + 
          2\ I\ \[Omega]\_2\ \[CapitalLambda]\_\(2, 14\) == 0, 
      6\ \[Delta]\_1 + \[Omega]\_1\%2\ \[CapitalLambda]\_\(1, 15\) - 
          I\ \[CapitalOmega]\ \[CapitalLambda]\_\(2, 15\) - 
          I\ \[Omega]\_1\ \[CapitalLambda]\_\(2, 15\) == 0, 
      6\ \[Delta]\_1 + \[Omega]\_1\%2\ \[CapitalLambda]\_\(1, 16\) == 0, 
      3\ \[Delta]\_1 + \[Omega]\_1\%2\ \[CapitalLambda]\_\(1, 17\) - 
          2\ I\ \[Omega]\_1\ \[CapitalLambda]\_\(2, 17\) == 0, 
      \[Omega]\_1\%2\ \[CapitalLambda]\_\(1, 18\) - 
          I\ \[Omega]\_2\ \[CapitalLambda]\_\(2, 18\) == 0, 
      2\ \[Delta]\_2 + \[Omega]\_1\%2\ \[CapitalLambda]\_\(1, 19\) - 
          I\ \[CapitalOmega]\ \[CapitalLambda]\_\(2, 19\) - 
          I\ \[Omega]\_2\ \[CapitalLambda]\_\(2, 19\) == 0, 
      2\ \[Delta]\_2 + \[Omega]\_1\%2\ \[CapitalLambda]\_\(1, 20\) + 
          I\ \[CapitalOmega]\ \[CapitalLambda]\_\(2, 20\) - 
          I\ \[Omega]\_2\ \[CapitalLambda]\_\(2, 20\) == 0, 
      2\ \[Delta]\_3 + \[Omega]\_1\%2\ \[CapitalLambda]\_\(1, 21\) == 0, 
      2\ \[Delta]\_2 + \[Omega]\_1\%2\ \[CapitalLambda]\_\(1, 22\) - 
          I\ \[Omega]\_1\ \[CapitalLambda]\_\(2, 22\) - 
          I\ \[Omega]\_2\ \[CapitalLambda]\_\(2, 22\) == 0, 
      \[Delta]\_3 + \[Omega]\_1\%2\ \[CapitalLambda]\_\(1, 23\) - 
          2\ I\ \[Omega]\_2\ \[CapitalLambda]\_\(2, 23\) == 0}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(eq611c = 
      \((\(Coefficient[Subtract\ @@\ # /. sol2Form, NRT[\([2]\)]] /. 
                    Exp[_\ T\_0 + _. ] -> 0\ &\)\ /@\ 
                order2Eqm[\([{3, 4}]\)] // Flatten)\) == 0 // Thread\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\(-\[CapitalLambda]\_\(4, 1\)\) == 0, 
      \(-2\)\ I\ \[CapitalOmega]\ \[CapitalLambda]\_\(3, 2\) - 
          \[CapitalLambda]\_\(4, 2\) == 0, 
      2\ I\ \[CapitalOmega]\ \[CapitalLambda]\_\(3, 3\) - 
          \[CapitalLambda]\_\(4, 3\) == 0, 
      I\ \[Omega]\_1\ \[CapitalLambda]\_\(3, 4\) - 
          \[CapitalLambda]\_\(4, 4\) == 0, 
      \(-I\)\ \[CapitalOmega]\ \[CapitalLambda]\_\(3, 5\) + 
          I\ \[Omega]\_1\ \[CapitalLambda]\_\(3, 5\) - 
          \[CapitalLambda]\_\(4, 5\) == 0, 
      I\ \[CapitalOmega]\ \[CapitalLambda]\_\(3, 6\) + 
          I\ \[Omega]\_1\ \[CapitalLambda]\_\(3, 6\) - 
          \[CapitalLambda]\_\(4, 6\) == 0, 
      \(-I\)\ \[CapitalOmega]\ \[CapitalLambda]\_\(3, 7\) + 
          I\ \[Omega]\_2\ \[CapitalLambda]\_\(3, 7\) - 
          \[CapitalLambda]\_\(4, 7\) == 0, 
      I\ \[CapitalOmega]\ \[CapitalLambda]\_\(3, 8\) + 
          I\ \[Omega]\_2\ \[CapitalLambda]\_\(3, 8\) - 
          \[CapitalLambda]\_\(4, 8\) == 0, 
      I\ \[Omega]\_1\ \[CapitalLambda]\_\(3, 9\) + 
          I\ \[Omega]\_2\ \[CapitalLambda]\_\(3, 9\) - 
          \[CapitalLambda]\_\(4, 9\) == 0, 
      2\ I\ \[Omega]\_2\ \[CapitalLambda]\_\(3, 10\) - 
          \[CapitalLambda]\_\(4, 10\) == 0, 
      \(-I\)\ \[Omega]\_1\ \[CapitalLambda]\_\(3, 11\) - 
          \[CapitalLambda]\_\(4, 11\) == 0, 
      \(-I\)\ \[CapitalOmega]\ \[CapitalLambda]\_\(3, 12\) - 
          I\ \[Omega]\_1\ \[CapitalLambda]\_\(3, 12\) - 
          \[CapitalLambda]\_\(4, 12\) == 0, 
      I\ \[CapitalOmega]\ \[CapitalLambda]\_\(3, 13\) - 
          I\ \[Omega]\_1\ \[CapitalLambda]\_\(3, 13\) - 
          \[CapitalLambda]\_\(4, 13\) == 0, 
      \(-\[CapitalLambda]\_\(4, 14\)\) == 0, 
      \(-I\)\ \[Omega]\_1\ \[CapitalLambda]\_\(3, 15\) + 
          I\ \[Omega]\_2\ \[CapitalLambda]\_\(3, 15\) - 
          \[CapitalLambda]\_\(4, 15\) == 0, 
      \(-I\)\ \[CapitalOmega]\ \[CapitalLambda]\_\(3, 16\) - 
          I\ \[Omega]\_2\ \[CapitalLambda]\_\(3, 16\) - 
          \[CapitalLambda]\_\(4, 16\) == 0, 
      I\ \[CapitalOmega]\ \[CapitalLambda]\_\(3, 17\) - 
          I\ \[Omega]\_2\ \[CapitalLambda]\_\(3, 17\) - 
          \[CapitalLambda]\_\(4, 17\) == 0, 
      I\ \[Omega]\_1\ \[CapitalLambda]\_\(3, 18\) - 
          I\ \[Omega]\_2\ \[CapitalLambda]\_\(3, 18\) - 
          \[CapitalLambda]\_\(4, 18\) == 0, 
      \(-\[CapitalLambda]\_\(4, 19\)\) == 0, 
      \(-I\)\ \[Omega]\_1\ \[CapitalLambda]\_\(3, 20\) - 
          I\ \[Omega]\_2\ \[CapitalLambda]\_\(3, 20\) - 
          \[CapitalLambda]\_\(4, 20\) == 0, 
      \(-2\)\ I\ \[Omega]\_2\ \[CapitalLambda]\_\(3, 21\) - 
          \[CapitalLambda]\_\(4, 21\) == 0, 
      2\ \[Delta]\_2 + \[Omega]\_2\%2\ \[CapitalLambda]\_\(3, 1\) == 0, 
      \[Delta]\_2 + \[Omega]\_2\%2\ \[CapitalLambda]\_\(3, 2\) - 
          2\ I\ \[CapitalOmega]\ \[CapitalLambda]\_\(4, 2\) == 0, 
      \[Delta]\_2 + \[Omega]\_2\%2\ \[CapitalLambda]\_\(3, 3\) + 
          2\ I\ \[CapitalOmega]\ \[CapitalLambda]\_\(4, 3\) == 0, 
      \[Omega]\_2\%2\ \[CapitalLambda]\_\(3, 4\) + 
          I\ \[Omega]\_1\ \[CapitalLambda]\_\(4, 4\) == 0, 
      2\ \[Delta]\_2 + \[Omega]\_2\%2\ \[CapitalLambda]\_\(3, 5\) - 
          I\ \[CapitalOmega]\ \[CapitalLambda]\_\(4, 5\) + 
          I\ \[Omega]\_1\ \[CapitalLambda]\_\(4, 5\) == 0, 
      2\ \[Delta]\_2 + \[Omega]\_2\%2\ \[CapitalLambda]\_\(3, 6\) + 
          I\ \[CapitalOmega]\ \[CapitalLambda]\_\(4, 6\) + 
          I\ \[Omega]\_1\ \[CapitalLambda]\_\(4, 6\) == 0, 
      2\ \[Delta]\_3 + \[Omega]\_2\%2\ \[CapitalLambda]\_\(3, 7\) - 
          I\ \[CapitalOmega]\ \[CapitalLambda]\_\(4, 7\) + 
          I\ \[Omega]\_2\ \[CapitalLambda]\_\(4, 7\) == 0, 
      2\ \[Delta]\_3 + \[Omega]\_2\%2\ \[CapitalLambda]\_\(3, 8\) + 
          I\ \[CapitalOmega]\ \[CapitalLambda]\_\(4, 8\) + 
          I\ \[Omega]\_2\ \[CapitalLambda]\_\(4, 8\) == 0, 
      2\ \[Delta]\_3 + \[Omega]\_2\%2\ \[CapitalLambda]\_\(3, 9\) + 
          I\ \[Omega]\_1\ \[CapitalLambda]\_\(4, 9\) + 
          I\ \[Omega]\_2\ \[CapitalLambda]\_\(4, 9\) == 0, 
      3\ \[Delta]\_4 + \[Omega]\_2\%2\ \[CapitalLambda]\_\(3, 10\) + 
          2\ I\ \[Omega]\_2\ \[CapitalLambda]\_\(4, 10\) == 0, 
      \[Omega]\_2\%2\ \[CapitalLambda]\_\(3, 11\) - 
          I\ \[Omega]\_1\ \[CapitalLambda]\_\(4, 11\) == 0, 
      2\ \[Delta]\_2 + \[Omega]\_2\%2\ \[CapitalLambda]\_\(3, 12\) - 
          I\ \[CapitalOmega]\ \[CapitalLambda]\_\(4, 12\) - 
          I\ \[Omega]\_1\ \[CapitalLambda]\_\(4, 12\) == 0, 
      2\ \[Delta]\_2 + \[Omega]\_2\%2\ \[CapitalLambda]\_\(3, 13\) + 
          I\ \[CapitalOmega]\ \[CapitalLambda]\_\(4, 13\) - 
          I\ \[Omega]\_1\ \[CapitalLambda]\_\(4, 13\) == 0, 
      2\ \[Delta]\_2 + \[Omega]\_2\%2\ \[CapitalLambda]\_\(3, 14\) == 0, 
      2\ \[Delta]\_3 + \[Omega]\_2\%2\ \[CapitalLambda]\_\(3, 15\) - 
          I\ \[Omega]\_1\ \[CapitalLambda]\_\(4, 15\) + 
          I\ \[Omega]\_2\ \[CapitalLambda]\_\(4, 15\) == 0, 
      2\ \[Delta]\_3 + \[Omega]\_2\%2\ \[CapitalLambda]\_\(3, 16\) - 
          I\ \[CapitalOmega]\ \[CapitalLambda]\_\(4, 16\) - 
          I\ \[Omega]\_2\ \[CapitalLambda]\_\(4, 16\) == 0, 
      2\ \[Delta]\_3 + \[Omega]\_2\%2\ \[CapitalLambda]\_\(3, 17\) + 
          I\ \[CapitalOmega]\ \[CapitalLambda]\_\(4, 17\) - 
          I\ \[Omega]\_2\ \[CapitalLambda]\_\(4, 17\) == 0, 
      2\ \[Delta]\_3 + \[Omega]\_2\%2\ \[CapitalLambda]\_\(3, 18\) + 
          I\ \[Omega]\_1\ \[CapitalLambda]\_\(4, 18\) - 
          I\ \[Omega]\_2\ \[CapitalLambda]\_\(4, 18\) == 0, 
      6\ \[Delta]\_4 + \[Omega]\_2\%2\ \[CapitalLambda]\_\(3, 19\) == 0, 
      2\ \[Delta]\_3 + \[Omega]\_2\%2\ \[CapitalLambda]\_\(3, 20\) - 
          I\ \[Omega]\_1\ \[CapitalLambda]\_\(4, 20\) - 
          I\ \[Omega]\_2\ \[CapitalLambda]\_\(4, 20\) == 0, 
      3\ \[Delta]\_4 + \[Omega]\_2\%2\ \[CapitalLambda]\_\(3, 21\) - 
          2\ I\ \[Omega]\_2\ \[CapitalLambda]\_\(4, 21\) == 0}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Solving ",
  StyleBox["eq611b",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " for the ",
  StyleBox["NRTsymbolList1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(coef11 = 
      \(Solve[eq611b, Array[NRTsymbolList1, 2] // Flatten]\)[\([1]\)]\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[CapitalLambda]\_\(2, 5\) \[Rule] 0, 
      \[CapitalLambda]\_\(2, 16\) \[Rule] 0, 
      \[CapitalLambda]\_\(2, 21\) \[Rule] 0, 
      \[CapitalLambda]\_\(1, 5\) \[Rule] 
        \(-\(\(6\ \[Delta]\_1\)\/\[Omega]\_1\%2\)\), 
      \[CapitalLambda]\_\(1, 16\) \[Rule] 
        \(-\(\(6\ \[Delta]\_1\)\/\[Omega]\_1\%2\)\), 
      \[CapitalLambda]\_\(1, 21\) \[Rule] 
        \(-\(\(2\ \[Delta]\_3\)\/\[Omega]\_1\%2\)\), 
      \[CapitalLambda]\_\(2, 1\) \[Rule] 0, 
      \[CapitalLambda]\_\(2, 2\) \[Rule] 0, 
      \[CapitalLambda]\_\(2, 3\) \[Rule] 
        \(-\(\(2\ \[CapitalOmega]\^2\ \[Mu]\_1\)\/\(\[CapitalOmega]\^2 - 
                \[Omega]\_1\%2\)\)\), 
      \[CapitalLambda]\_\(2, 4\) \[Rule] 
        \(-\(\(2\ \[CapitalOmega]\^2\ \[Mu]\_1\)\/\(\[CapitalOmega]\^2 - 
                \[Omega]\_1\%2\)\)\), 
      \[CapitalLambda]\_\(2, 6\) \[Rule] 
        \(-\(\(6\ I\ \[CapitalOmega]\ 
                \[Delta]\_1\)\/\(4\ \[CapitalOmega]\^2 - 
                \[Omega]\_1\%2\)\)\), 
      \[CapitalLambda]\_\(2, 7\) \[Rule] 
        \(6\ I\ \[CapitalOmega]\ \[Delta]\_1\)\/\(4\ \[CapitalOmega]\^2 - 
            \[Omega]\_1\%2\), 
      \[CapitalLambda]\_\(2, 9\) \[Rule] \(2\ I\ \[Delta]\_1\)\/\[Omega]\_1, 
      \[CapitalLambda]\_\(2, 10\) \[Rule] 0, 
      \[CapitalLambda]\_\(2, 14\) \[Rule] 
        \(-\(\(2\ I\ \[Delta]\_3\ \[Omega]\_2\)\/\(\[Omega]\_1\%2 - 
                4\ \[Omega]\_2\%2\)\)\), 
      \[CapitalLambda]\_\(2, 17\) \[Rule] 
        \(-\(\(2\ I\ \[Delta]\_1\)\/\[Omega]\_1\)\), 
      \[CapitalLambda]\_\(2, 18\) \[Rule] 0, 
      \[CapitalLambda]\_\(2, 23\) \[Rule] 
        \(2\ I\ \[Delta]\_3\ \[Omega]\_2\)\/\(\[Omega]\_1\%2 - 
            4\ \[Omega]\_2\%2\), \[CapitalLambda]\_\(1, 1\) \[Rule] 0, 
      \[CapitalLambda]\_\(1, 2\) \[Rule] 0, 
      \[CapitalLambda]\_\(1, 3\) \[Rule] 
        \(-\(\(2\ I\ \[CapitalOmega]\ \[Mu]\_1\)\/\(\[CapitalOmega]\^2 - 
                \[Omega]\_1\%2\)\)\), 
      \[CapitalLambda]\_\(1, 4\) \[Rule] 
        \(2\ I\ \[CapitalOmega]\ \[Mu]\_1\)\/\(\[CapitalOmega]\^2 - 
            \[Omega]\_1\%2\), 
      \[CapitalLambda]\_\(1, 6\) \[Rule] 
        \(3\ \[Delta]\_1\)\/\(4\ \[CapitalOmega]\^2 - \[Omega]\_1\%2\), 
      \[CapitalLambda]\_\(1, 7\) \[Rule] 
        \(3\ \[Delta]\_1\)\/\(4\ \[CapitalOmega]\^2 - \[Omega]\_1\%2\), 
      \[CapitalLambda]\_\(1, 9\) \[Rule] \[Delta]\_1\/\[Omega]\_1\%2, 
      \[CapitalLambda]\_\(1, 10\) \[Rule] 0, 
      \[CapitalLambda]\_\(1, 14\) \[Rule] 
        \(-\(\[Delta]\_3\/\(\[Omega]\_1\%2 - 4\ \[Omega]\_2\%2\)\)\), 
      \[CapitalLambda]\_\(1, 17\) \[Rule] \[Delta]\_1\/\[Omega]\_1\%2, 
      \[CapitalLambda]\_\(1, 18\) \[Rule] 0, 
      \[CapitalLambda]\_\(1, 23\) \[Rule] 
        \(-\(\[Delta]\_3\/\(\[Omega]\_1\%2 - 4\ \[Omega]\_2\%2\)\)\), 
      \[CapitalLambda]\_\(2, 8\) \[Rule] 
        \(6\ I\ \[Delta]\_1\ 
            \((\[CapitalOmega] + \[Omega]\_1)\)\)\/\(\[CapitalOmega]\ 
            \((\[CapitalOmega] + 2\ \[Omega]\_1)\)\), 
      \[CapitalLambda]\_\(2, 11\) \[Rule] 
        \(-\(\(2\ I\ \[Delta]\_2\ 
                \((\[CapitalOmega] - \[Omega]\_2)\)\)\/\(\[CapitalOmega]\^2 - 
                \[Omega]\_1\%2 - 2\ \[CapitalOmega]\ \[Omega]\_2 + 
                \[Omega]\_2\%2\)\)\), 
      \[CapitalLambda]\_\(2, 12\) \[Rule] 
        \(2\ I\ \[Delta]\_2\ 
            \((\[CapitalOmega] + \[Omega]\_2)\)\)\/\(\[CapitalOmega]\^2 - 
            \[Omega]\_1\%2 + 2\ \[CapitalOmega]\ \[Omega]\_2 + 
            \[Omega]\_2\%2\), 
      \[CapitalLambda]\_\(2, 13\) \[Rule] 
        \(2\ I\ \[Delta]\_2\ 
            \((\[Omega]\_1 + \[Omega]\_2)\)\)\/\(\[Omega]\_2\ 
            \((2\ \[Omega]\_1 + \[Omega]\_2)\)\), 
      \[CapitalLambda]\_\(2, 15\) \[Rule] 
        \(-\(\(6\ I\ \[Delta]\_1\ 
                \((\[CapitalOmega] + \[Omega]\_1)\)\)\/\(\[CapitalOmega]\ 
                \((\[CapitalOmega] + 2\ \[Omega]\_1)\)\)\)\), 
      \[CapitalLambda]\_\(2, 19\) \[Rule] 
        \(-\(\(2\ I\ \[Delta]\_2\ 
                \((\[CapitalOmega] + \[Omega]\_2)\)\)\/\(\[CapitalOmega]\^2 - 
                \[Omega]\_1\%2 + 2\ \[CapitalOmega]\ \[Omega]\_2 + 
                \[Omega]\_2\%2\)\)\), 
      \[CapitalLambda]\_\(2, 20\) \[Rule] 
        \(2\ I\ \[Delta]\_2\ 
            \((\[CapitalOmega] - \[Omega]\_2)\)\)\/\(\[CapitalOmega]\^2 - 
            \[Omega]\_1\%2 - 2\ \[CapitalOmega]\ \[Omega]\_2 + 
            \[Omega]\_2\%2\), 
      \[CapitalLambda]\_\(2, 22\) \[Rule] 
        \(-\(\(2\ I\ \[Delta]\_2\ 
                \((\[Omega]\_1 + \[Omega]\_2)\)\)\/\(\[Omega]\_2\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\)\), 
      \[CapitalLambda]\_\(1, 8\) \[Rule] 
        \(6\ \[Delta]\_1\)\/\(\[CapitalOmega]\ 
            \((\[CapitalOmega] + 2\ \[Omega]\_1)\)\), 
      \[CapitalLambda]\_\(1, 11\) \[Rule] 
        \(-\(\(2\ \[Delta]\_2\)\/\(\(-\[CapitalOmega]\^2\) + \[Omega]\_1\%2 + 
                2\ \[CapitalOmega]\ \[Omega]\_2 - \[Omega]\_2\%2\)\)\), 
      \[CapitalLambda]\_\(1, 12\) \[Rule] 
        \(-\(\(2\ \[Delta]\_2\)\/\(\(-\[CapitalOmega]\^2\) + \[Omega]\_1\%2 - 
                2\ \[CapitalOmega]\ \[Omega]\_2 - \[Omega]\_2\%2\)\)\), 
      \[CapitalLambda]\_\(1, 13\) \[Rule] 
        \(2\ \[Delta]\_2\)\/\(\[Omega]\_2\ 
            \((2\ \[Omega]\_1 + \[Omega]\_2)\)\), 
      \[CapitalLambda]\_\(1, 15\) \[Rule] 
        \(6\ \[Delta]\_1\)\/\(\[CapitalOmega]\ 
            \((\[CapitalOmega] + 2\ \[Omega]\_1)\)\), 
      \[CapitalLambda]\_\(1, 19\) \[Rule] 
        \(-\(\(2\ \[Delta]\_2\)\/\(\(-\[CapitalOmega]\^2\) + \[Omega]\_1\%2 - 
                2\ \[CapitalOmega]\ \[Omega]\_2 - \[Omega]\_2\%2\)\)\), 
      \[CapitalLambda]\_\(1, 20\) \[Rule] 
        \(-\(\(2\ \[Delta]\_2\)\/\(\(-\[CapitalOmega]\^2\) + \[Omega]\_1\%2 + 
                2\ \[CapitalOmega]\ \[Omega]\_2 - \[Omega]\_2\%2\)\)\), 
      \[CapitalLambda]\_\(1, 22\) \[Rule] 
        \(2\ \[Delta]\_2\)\/\(\[Omega]\_2\ 
            \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Solving ",
  StyleBox["eq611c",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " for the ",
  StyleBox["NRTsymbolList2",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(coef12 = 
      \(Solve[eq611c, Array[NRTsymbolList2, 2] // Flatten]\)[\([1]\)]\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[CapitalLambda]\_\(4, 1\) \[Rule] 0, 
      \[CapitalLambda]\_\(4, 14\) \[Rule] 0, 
      \[CapitalLambda]\_\(4, 19\) \[Rule] 0, 
      \[CapitalLambda]\_\(3, 1\) \[Rule] 
        \(-\(\(2\ \[Delta]\_2\)\/\[Omega]\_2\%2\)\), 
      \[CapitalLambda]\_\(3, 14\) \[Rule] 
        \(-\(\(2\ \[Delta]\_2\)\/\[Omega]\_2\%2\)\), 
      \[CapitalLambda]\_\(3, 19\) \[Rule] 
        \(-\(\(6\ \[Delta]\_4\)\/\[Omega]\_2\%2\)\), 
      \[CapitalLambda]\_\(4, 2\) \[Rule] 
        \(-\(\(2\ I\ \[CapitalOmega]\ 
                \[Delta]\_2\)\/\(4\ \[CapitalOmega]\^2 - 
                \[Omega]\_2\%2\)\)\), 
      \[CapitalLambda]\_\(4, 3\) \[Rule] 
        \(2\ I\ \[CapitalOmega]\ \[Delta]\_2\)\/\(4\ \[CapitalOmega]\^2 - 
            \[Omega]\_2\%2\), \[CapitalLambda]\_\(4, 4\) \[Rule] 0, 
      \[CapitalLambda]\_\(4, 10\) \[Rule] \(2\ I\ \[Delta]\_4\)\/\[Omega]\_2, 
      \[CapitalLambda]\_\(4, 11\) \[Rule] 0, 
      \[CapitalLambda]\_\(4, 21\) \[Rule] 
        \(-\(\(2\ I\ \[Delta]\_4\)\/\[Omega]\_2\)\), 
      \[CapitalLambda]\_\(3, 2\) \[Rule] 
        \[Delta]\_2\/\(4\ \[CapitalOmega]\^2 - \[Omega]\_2\%2\), 
      \[CapitalLambda]\_\(3, 3\) \[Rule] 
        \[Delta]\_2\/\(4\ \[CapitalOmega]\^2 - \[Omega]\_2\%2\), 
      \[CapitalLambda]\_\(3, 4\) \[Rule] 0, 
      \[CapitalLambda]\_\(3, 10\) \[Rule] \[Delta]\_4\/\[Omega]\_2\%2, 
      \[CapitalLambda]\_\(3, 11\) \[Rule] 0, 
      \[CapitalLambda]\_\(3, 21\) \[Rule] \[Delta]\_4\/\[Omega]\_2\%2, 
      \[CapitalLambda]\_\(4, 5\) \[Rule] 
        \(-\(\(2\ I\ \[Delta]\_2\ 
                \((\[CapitalOmega] - \[Omega]\_1)\)\)\/\(\[CapitalOmega]\^2 - 
                2\ \[CapitalOmega]\ \[Omega]\_1 + \[Omega]\_1\%2 - 
                \[Omega]\_2\%2\)\)\), 
      \[CapitalLambda]\_\(4, 6\) \[Rule] 
        \(2\ I\ \[Delta]\_2\ 
            \((\[CapitalOmega] + \[Omega]\_1)\)\)\/\(\[CapitalOmega]\^2 + 
            2\ \[CapitalOmega]\ \[Omega]\_1 + \[Omega]\_1\%2 - 
            \[Omega]\_2\%2\), 
      \[CapitalLambda]\_\(4, 7\) \[Rule] 
        \(-\(\(2\ I\ \[Delta]\_3\ 
                \((\[CapitalOmega] - \[Omega]\_2)\)\)\/\(\[CapitalOmega]\ 
                \((\[CapitalOmega] - 2\ \[Omega]\_2)\)\)\)\), 
      \[CapitalLambda]\_\(4, 8\) \[Rule] 
        \(2\ I\ \[Delta]\_3\ 
            \((\[CapitalOmega] + \[Omega]\_2)\)\)\/\(\[CapitalOmega]\ 
            \((\[CapitalOmega] + 2\ \[Omega]\_2)\)\), 
      \[CapitalLambda]\_\(4, 9\) \[Rule] 
        \(2\ I\ \[Delta]\_3\ 
            \((\[Omega]\_1 + \[Omega]\_2)\)\)\/\(\[Omega]\_1\ 
            \((\[Omega]\_1 + 2\ \[Omega]\_2)\)\), 
      \[CapitalLambda]\_\(4, 12\) \[Rule] 
        \(-\(\(2\ I\ \[Delta]\_2\ 
                \((\[CapitalOmega] + \[Omega]\_1)\)\)\/\(\[CapitalOmega]\^2 + 
                2\ \[CapitalOmega]\ \[Omega]\_1 + \[Omega]\_1\%2 - 
                \[Omega]\_2\%2\)\)\), 
      \[CapitalLambda]\_\(4, 13\) \[Rule] 
        \(2\ I\ \[Delta]\_2\ 
            \((\[CapitalOmega] - \[Omega]\_1)\)\)\/\(\[CapitalOmega]\^2 - 
            2\ \[CapitalOmega]\ \[Omega]\_1 + \[Omega]\_1\%2 - 
            \[Omega]\_2\%2\), 
      \[CapitalLambda]\_\(4, 15\) \[Rule] 
        \(-\(\(2\ I\ \[Delta]\_3\ 
                \((\[Omega]\_1 - \[Omega]\_2)\)\)\/\(\[Omega]\_1\ 
                \((\[Omega]\_1 - 2\ \[Omega]\_2)\)\)\)\), 
      \[CapitalLambda]\_\(4, 16\) \[Rule] 
        \(-\(\(2\ I\ \[Delta]\_3\ 
                \((\[CapitalOmega] + \[Omega]\_2)\)\)\/\(\[CapitalOmega]\ 
                \((\[CapitalOmega] + 2\ \[Omega]\_2)\)\)\)\), 
      \[CapitalLambda]\_\(4, 17\) \[Rule] 
        \(2\ I\ \[Delta]\_3\ 
            \((\[CapitalOmega] - \[Omega]\_2)\)\)\/\(\[CapitalOmega]\ 
            \((\[CapitalOmega] - 2\ \[Omega]\_2)\)\), 
      \[CapitalLambda]\_\(4, 18\) \[Rule] 
        \(2\ I\ \[Delta]\_3\ 
            \((\[Omega]\_1 - \[Omega]\_2)\)\)\/\(\[Omega]\_1\ 
            \((\[Omega]\_1 - 2\ \[Omega]\_2)\)\), 
      \[CapitalLambda]\_\(4, 20\) \[Rule] 
        \(-\(\(2\ I\ \[Delta]\_3\ 
                \((\[Omega]\_1 + \[Omega]\_2)\)\)\/\(\[Omega]\_1\ 
                \((\[Omega]\_1 + 2\ \[Omega]\_2)\)\)\)\), 
      \[CapitalLambda]\_\(3, 5\) \[Rule] 
        \(2\ \[Delta]\_2\)\/\(\[CapitalOmega]\^2 - 
            2\ \[CapitalOmega]\ \[Omega]\_1 + \[Omega]\_1\%2 - 
            \[Omega]\_2\%2\), 
      \[CapitalLambda]\_\(3, 6\) \[Rule] 
        \(2\ \[Delta]\_2\)\/\(\[CapitalOmega]\^2 + 
            2\ \[CapitalOmega]\ \[Omega]\_1 + \[Omega]\_1\%2 - 
            \[Omega]\_2\%2\), 
      \[CapitalLambda]\_\(3, 7\) \[Rule] 
        \(2\ \[Delta]\_3\)\/\(\[CapitalOmega]\ 
            \((\[CapitalOmega] - 2\ \[Omega]\_2)\)\), 
      \[CapitalLambda]\_\(3, 8\) \[Rule] 
        \(2\ \[Delta]\_3\)\/\(\[CapitalOmega]\ 
            \((\[CapitalOmega] + 2\ \[Omega]\_2)\)\), 
      \[CapitalLambda]\_\(3, 9\) \[Rule] 
        \(2\ \[Delta]\_3\)\/\(\[Omega]\_1\ 
            \((\[Omega]\_1 + 2\ \[Omega]\_2)\)\), 
      \[CapitalLambda]\_\(3, 12\) \[Rule] 
        \(2\ \[Delta]\_2\)\/\(\[CapitalOmega]\^2 + 
            2\ \[CapitalOmega]\ \[Omega]\_1 + \[Omega]\_1\%2 - 
            \[Omega]\_2\%2\), 
      \[CapitalLambda]\_\(3, 13\) \[Rule] 
        \(2\ \[Delta]\_2\)\/\(\[CapitalOmega]\^2 - 
            2\ \[CapitalOmega]\ \[Omega]\_1 + \[Omega]\_1\%2 - 
            \[Omega]\_2\%2\), 
      \[CapitalLambda]\_\(3, 15\) \[Rule] 
        \(2\ \[Delta]\_3\)\/\(\[Omega]\_1\ 
            \((\[Omega]\_1 - 2\ \[Omega]\_2)\)\), 
      \[CapitalLambda]\_\(3, 16\) \[Rule] 
        \(2\ \[Delta]\_3\)\/\(\[CapitalOmega]\ 
            \((\[CapitalOmega] + 2\ \[Omega]\_2)\)\), 
      \[CapitalLambda]\_\(3, 17\) \[Rule] 
        \(2\ \[Delta]\_3\)\/\(\[CapitalOmega]\ 
            \((\[CapitalOmega] - 2\ \[Omega]\_2)\)\), 
      \[CapitalLambda]\_\(3, 18\) \[Rule] 
        \(2\ \[Delta]\_3\)\/\(\[Omega]\_1\ 
            \((\[Omega]\_1 - 2\ \[Omega]\_2)\)\), 
      \[CapitalLambda]\_\(3, 20\) \[Rule] 
        \(2\ \[Delta]\_3\)\/\(\[Omega]\_1\ 
            \((\[Omega]\_1 + 2\ \[Omega]\_2)\)\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Substituting ",
  StyleBox["sol2Form",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["order2Eqm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and collecting the coefficients of like ",
  StyleBox["RT",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain two sets of algebraic equations as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(eq1 = 
      MapIndexed[
          Coefficient[order2Eqm[\([1, 1]\)] /. sol2Form, #1] == 
              r\_\(1, #2[\([1]\)]\)\ &, RT[\([1]\)]] /. 
        Exp[_\ T\_0 + _. ] -> 0\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({2\ I\ \[Omega]\_1\ \[CapitalGamma]\_\(1, 1\) == r\_\(1, 1\), 
      I\ \[CapitalOmega]\ \[CapitalGamma]\_\(1, 2\) == r\_\(1, 2\), 
      I\ \[Omega]\_2\ \[CapitalGamma]\_\(1, 3\) == r\_\(1, 3\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(eq2 = 
      MapIndexed[
          Coefficient[order2Eqm[\([3, 1]\)] /. sol2Form, #1] == 
              r\_\(3, #2[\([1]\)]\)\ &, RT[\([2]\)]] /. 
        Exp[_\ T\_0 + _. ] -> 0\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({I\ \[CapitalOmega]\ \[CapitalGamma]\_\(3, 1\) + 
          I\ \[Omega]\_2\ \[CapitalGamma]\_\(3, 1\) == r\_\(3, 1\), 
      I\ \[CapitalOmega]\ \[CapitalGamma]\_\(3, 2\) + 
          I\ \[Omega]\_2\ \[CapitalGamma]\_\(3, 2\) == r\_\(3, 2\), 
      2\ I\ \[Omega]\_1\ \[CapitalGamma]\_\(3, 3\) + 
          I\ \[Omega]\_2\ \[CapitalGamma]\_\(3, 3\) == r\_\(3, 3\), 
      2\ I\ \[Omega]\_2\ \[CapitalGamma]\_\(3, 4\) == r\_\(3, 4\)}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Solving ",
  StyleBox["eq1 ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "and ",
  StyleBox["eq2",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " for the ",
  StyleBox["RTsymbolList1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  StyleBox[" ",
    FontColor->RGBColor[1, 0, 1]],
  "and ",
  StyleBox["RTsymbolList2",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(coef21 = \(Solve[eq1, RTsymbolList1]\)[\([1]\)] /. r1Rule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[CapitalGamma]\_\(1, 1\) \[Rule] 
        \(-\(\(I\ \[Mu]\_1\)\/\(2\ \[Omega]\_1\)\)\), 
      \[CapitalGamma]\_\(1, 2\) \[Rule] 
        \(-\(\(3\ \[Delta]\_1\)\/\(\[CapitalOmega]\ \[Omega]\_1\)\)\), 
      \[CapitalGamma]\_\(1, 3\) \[Rule] 
        \(-\(\[Delta]\_2\/\(\[Omega]\_1\ \[Omega]\_2\)\)\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(coef22 = \(Solve[eq2, RTsymbolList2]\)[\([1]\)] /. r3Rule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[CapitalGamma]\_\(3, 4\) \[Rule] 
        \(-\(\(I\ \[Mu]\_2\)\/\(2\ \[Omega]\_2\)\)\), 
      \[CapitalGamma]\_\(3, 1\) \[Rule] 
        f\_2\/\(4\ \[Omega]\_2\ \((\[CapitalOmega] + \[Omega]\_2)\)\), 
      \[CapitalGamma]\_\(3, 2\) \[Rule] 0, 
      \[CapitalGamma]\_\(3, 3\) \[Rule] 
        \(-\(\[Delta]\_2\/\(2\ \[Omega]\_2\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\)\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Combining these coefficients using the function ",
  StyleBox["Join",
    FontWeight->"Bold"],
  " yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(coeffs = 
      Join[coef11, coef12, coef21, coef22, coef21 /. conjugateRule, 
          coef22 /. conjugateRule] /. 
        \((omgRule[\([1]\)] /. \[Epsilon] -> 0)\); \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
Then, we express the solution of the second-order equations in pure function \
form as\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2 = 
      sol2Form /. 
        Function[{T\_0, T\_1, T\_2}, a_] :> 
          Function[{T\_0, T\_1, T\_2} // Evaluate, 
            \(a /. coeffs // Expand\) // Evaluate]; \nsol2 /. displayRule\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u\_\(1, 2\) \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          \(-\(\(6\ \[Delta]\_1\ \[CapitalLambda]\_1\%2\)\/\[Omega]\_1\%2
                    \)\) + \(E
                  \^\(\(-2\)\ I\ T\_0\ \[CapitalOmega] - 2\ I\ \[Tau]\_1\)\ 
                \[Delta]\_1\ \[CapitalLambda]\_1\%2\)\/\(5\ 
                \[Omega]\_1\%2\) + 
            \(E\^\(2\ I\ T\_0\ \[CapitalOmega] + 2\ I\ \[Tau]\_1\)\ 
                \[Delta]\_1\ \[CapitalLambda]\_1\%2\)\/\(5\ 
                \[Omega]\_1\%2\) - 
            \(4\ I\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1\)\ 
                \[CapitalLambda]\_1\ \[Mu]\_1\)\/\(3\ \[Omega]\_1\) + 
            \(4\ I\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1\)\ 
                \[CapitalLambda]\_1\ \[Mu]\_1\)\/\(3\ \[Omega]\_1\) - 
            \(3\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
                    I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ \[CapitalLambda]\_1\ 
                A\_1\)\/\(2\ \[Omega]\_1\%2\) + 
            \(3\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                    I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ \[CapitalLambda]\_1\ 
                A\_1\)\/\(4\ \[Omega]\_1\%2\) - 
            \(I\ E\^\(I\ T\_0\ \[Omega]\_1\)\ \[Mu]\_1\ A\_1\)\/\(2\ 
                \[Omega]\_1\) + 
            \(E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ 
                A\_1\%2\)\/\[Omega]\_1\%2 - 
            \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
                    I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
                A\_2\)\/\[Omega]\_1\%2 + 
            \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                    I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
                A\_2\)\/\(15\ \[Omega]\_1\%2\) + 
            \(E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\_2\ A\_1\ A\_2\)\/\(4\ \[Omega]\_1\%2\) + 
            \(E\^\(2\ I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ A\_2\%2\)\/\(15\ 
                \[Omega]\_1\%2\) + 
            \(3\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                    I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ \[CapitalLambda]\_1\ 
                A\&_\_1\)\/\(4\ \[Omega]\_1\%2\) - 
            \(3\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
                    I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ \[CapitalLambda]\_1\ 
                A\&_\_1\)\/\(2\ \[Omega]\_1\%2\) + 
            \(I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ \[Mu]\_1\ A\&_\_1\)\/\(2\ 
                \[Omega]\_1\) - 
            \(6\ \[Delta]\_1\ A\_1\ A\&_\_1\)\/\[Omega]\_1\%2 - 
            \(E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\_2\ A\_2\ A\&_\_1\)\/\(2\ \[Omega]\_1\%2\) + 
            \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ 
                A\&_\_1\%2\)\/\[Omega]\_1\%2 + 
            \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                    I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
                A\&_\_2\)\/\(15\ \[Omega]\_1\%2\) - 
            \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
                    I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
                A\&_\_2\)\/\[Omega]\_1\%2 - 
            \(E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\_2\ A\_1\ A\&_\_2\)\/\(2\ \[Omega]\_1\%2\) - 
            \(2\ \[Delta]\_3\ A\_2\ A\&_\_2\)\/\[Omega]\_1\%2 + 
            \(E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\_2\ A\&_\_1\ A\&_\_2\)\/\(4\ \[Omega]\_1\%2\) + 
            \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ 
                A\&_\_2\%2\)\/\(15\ \[Omega]\_1\%2\)], 
      v\_\(1, 2\) \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          \(-\(8\/3\)\)\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1\)\ 
              \[CapitalLambda]\_1\ \[Mu]\_1 - 
            8\/3\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1\)\ 
              \[CapitalLambda]\_1\ \[Mu]\_1 - 
            \(4\ I\ E
                  \^\(\(-2\)\ I\ T\_0\ \[CapitalOmega] - 2\ I\ \[Tau]\_1\)\ 
                \[Delta]\_1\ \[CapitalLambda]\_1\%2\)\/\(5\ \[Omega]\_1\) + 
            \(4\ I\ E\^\(2\ I\ T\_0\ \[CapitalOmega] + 2\ I\ \[Tau]\_1\)\ 
                \[Delta]\_1\ \[CapitalLambda]\_1\%2\)\/\(5\ \[Omega]\_1\) - 
            1\/2\ E\^\(I\ T\_0\ \[Omega]\_1\)\ \[Mu]\_1\ A\_1 - 
            \(3\ I\ E
                  \^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
                    I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ \[CapitalLambda]\_1\ 
                A\_1\)\/\(2\ \[Omega]\_1\) + 
            \(9\ I\ E
                  \^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                    I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ \[CapitalLambda]\_1\ 
                A\_1\)\/\(4\ \[Omega]\_1\) + 
            \(2\ I\ E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ 
                A\_1\%2\)\/\[Omega]\_1 + 
            \(8\ I\ E
                  \^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                    I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
                A\_2\)\/\(15\ \[Omega]\_1\) + 
            \(3\ I\ E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\_2\ A\_1\ A\_2\)\/\(4\ \[Omega]\_1\) + 
            \(4\ I\ E\^\(2\ I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ 
                A\_2\%2\)\/\(15\ \[Omega]\_1\) - 
            1\/2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ \[Mu]\_1\ A\&_\_1 - 
            \(9\ I\ E
                  \^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                    I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ \[CapitalLambda]\_1\ 
                A\&_\_1\)\/\(4\ \[Omega]\_1\) + 
            \(3\ I\ E
                  \^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
                    I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ \[CapitalLambda]\_1\ 
                A\&_\_1\)\/\(2\ \[Omega]\_1\) + 
            \(I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\_2\ A\_2\ A\&_\_1\)\/\(2\ \[Omega]\_1\) - 
            \(2\ I\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ 
                A\&_\_1\%2\)\/\[Omega]\_1 - 
            \(8\ I\ E
                  \^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                    I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
                A\&_\_2\)\/\(15\ \[Omega]\_1\) - 
            \(I\ E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\_2\ A\_1\ A\&_\_2\)\/\(2\ \[Omega]\_1\) - 
            \(3\ I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\_2\ A\&_\_1\ A\&_\_2\)\/\(4\ \[Omega]\_1\) - 
            \(4\ I\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ 
                A\&_\_2\%2\)\/\(15\ \[Omega]\_1\)], 
      u\_\(2, 2\) \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2\)\ f\_2\)\/\(32
                \ \[Omega]\_1\%2\) + 
            \(E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2\)\ f\_2\)\/\(32\ 
                \[Omega]\_1\%2\) - 
            \(\[Delta]\_2\ \[CapitalLambda]\_1\%2\)\/\(2\ \[Omega]\_1\%2\) + 
            \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega] - 2\ I\ \[Tau]\_1\)\ 
                \[Delta]\_2\ \[CapitalLambda]\_1\%2\)\/\(12\ 
                \[Omega]\_1\%2\) + 
            \(E\^\(2\ I\ T\_0\ \[CapitalOmega] + 2\ I\ \[Tau]\_1\)\ 
                \[Delta]\_2\ \[CapitalLambda]\_1\%2\)\/\(12\ 
                \[Omega]\_1\%2\) - 
            \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
                    I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
                A\_1\)\/\(3\ \[Omega]\_1\%2\) + 
            \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                    I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
                A\_1\)\/\(5\ \[Omega]\_1\%2\) - 
            \(E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ A\_1\%2\)\/\(16\ 
                \[Omega]\_1\%2\) - 
            \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
                    I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
                A\_2\)\/\(2\ \[Omega]\_1\%2\) + 
            \(E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                    I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
                A\_2\)\/\(6\ \[Omega]\_1\%2\) - 
            \(I\ E\^\(I\ T\_0\ \[Omega]\_2\)\ \[Mu]\_2\ A\_2\)\/\(4\ 
                \[Omega]\_1\) + 
            \(2\ E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\_3\ A\_1\ A\_2\)\/\(5\ \[Omega]\_1\%2\) + 
            \(E\^\(2\ I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_4\ A\_2\%2\)\/\(4\ 
                \[Omega]\_1\%2\) + 
            \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                    I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
                A\&_\_1\)\/\(5\ \[Omega]\_1\%2\) - 
            \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
                    I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
                A\&_\_1\)\/\(3\ \[Omega]\_1\%2\) - 
            \(\[Delta]\_2\ A\_1\ A\&_\_1\)\/\(2\ \[Omega]\_1\%2\) - 
            \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\_3\ A\_2\ A\&_\_1\)\/\(3\ \[Omega]\_1\%2\) - 
            \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ 
                A\&_\_1\%2\)\/\(16\ \[Omega]\_1\%2\) + 
            \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                    I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
                A\&_\_2\)\/\(6\ \[Omega]\_1\%2\) - 
            \(E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
                    I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
                A\&_\_2\)\/\(2\ \[Omega]\_1\%2\) + 
            \(I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ \[Mu]\_2\ A\&_\_2\)\/\(4\ 
                \[Omega]\_1\) - 
            \(2\ E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\_3\ A\_1\ A\&_\_2\)\/\(3\ \[Omega]\_1\%2\) - 
            \(3\ \[Delta]\_4\ A\_2\ A\&_\_2\)\/\(2\ \[Omega]\_1\%2\) + 
            \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\_3\ A\&_\_1\ A\&_\_2\)\/\(5\ \[Omega]\_1\%2\) + 
            \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_4\ 
                A\&_\_2\%2\)\/\(4\ \[Omega]\_1\%2\)], 
      v\_\(2, 2\) \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          \(-\(\(I\ E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega] - 
                        2\ I\ \[Tau]\_1\)\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\%2\)\/\(3\ \[Omega]\_1\)\)\) + 
            \(I\ E\^\(2\ I\ T\_0\ \[CapitalOmega] + 2\ I\ \[Tau]\_1\)\ 
                \[Delta]\_2\ \[CapitalLambda]\_1\%2\)\/\(3\ \[Omega]\_1\) + 
            \(I\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2\)\ f\_2\ 
                \[Omega]\_2\)\/\(32\ \[Omega]\_1\%2\) - 
            \(I\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2\)\ f\_2\ 
                \[Omega]\_2\)\/\(32\ \[Omega]\_1\%2\) + 
            \(2\ I\ E
                  \^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
                    I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
                A\_1\)\/\(3\ \[Omega]\_1\) + 
            \(6\ I\ E
                  \^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                    I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
                A\_1\)\/\(5\ \[Omega]\_1\) + 
            \(I\ E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ \[Omega]\_2\ 
                A\_1\%2\)\/\(16\ \[Omega]\_1\%2\) + 
            \(2\ I\ E
                  \^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                    I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
                A\_2\)\/\(3\ \[Omega]\_1\) - 
            \(E\^\(I\ T\_0\ \[Omega]\_2\)\ \[Mu]\_2\ \[Omega]\_2\ A\_2\)\/\(4
                \ \[Omega]\_1\) + 
            \(6\ I\ E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\_3\ A\_1\ A\_2\)\/\(5\ \[Omega]\_1\) + 
            \(I\ E\^\(2\ I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_4\ 
                A\_2\%2\)\/\[Omega]\_1 - 
            \(6\ I\ E
                  \^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                    I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
                A\&_\_1\)\/\(5\ \[Omega]\_1\) - 
            \(2\ I\ E
                  \^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
                    I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
                A\&_\_1\)\/\(3\ \[Omega]\_1\) - 
            \(2\ I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\_3\ A\_2\ A\&_\_1\)\/\(3\ \[Omega]\_1\) - 
            \(I\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ 
                \[Omega]\_2\ A\&_\_1\%2\)\/\(16\ \[Omega]\_1\%2\) - 
            \(2\ I\ E
                  \^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                    I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
                A\&_\_2\)\/\(3\ \[Omega]\_1\) - 
            \(E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ \[Mu]\_2\ \[Omega]\_2\ 
                A\&_\_2\)\/\(4\ \[Omega]\_1\) + 
            \(2\ I\ E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\_3\ A\_1\ A\&_\_2\)\/\(3\ \[Omega]\_1\) - 
            \(6\ I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\_3\ A\&_\_1\ A\&_\_2\)\/\(5\ \[Omega]\_1\) - 
            \(I\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_4\ 
                A\&_\_2\%2\)\/\[Omega]\_1]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Third-Order Problem", "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting the first- and second-order solutions into the third-order \
problem, ",
  StyleBox["eqOrder[3]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(order3Eq = \(eqOrder[3] /. sol1\) /. sol2 // ExpandAll; \)\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting the ",
  StyleBox["expRule1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into the right-hand sides of ",
  StyleBox["order3Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and collecting the terms that could produce secular terms, the terms \
proportional to ",
  Cell[BoxData[
      \(TraditionalForm\`E\^\(I\ \(\[Omega]\_1\) T\_0\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`E\^\(I\ \(\[Omega]\_2\) T\_0\)\)]],
  ", we have"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(ST21 = 
      \(Coefficient[order3Eq[\([#, 2]\)] /. expRule1[1], 
            Exp[I\ \[Omega]\_1\ T\_0]]\ &\)\ /@\ {1, 2}; \n
    ST21 /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{"-", 
            RowBox[{"(", 
              InterpretationBox[\(D\_2\[InvisibleSpace]A\_1\),
                SequenceForm[ 
                  Subscript[ D, 2], 
                  Subscript[ A, 1]],
                Editable->False], ")"}]}], "+", 
          FractionBox[
            RowBox[{\(E\^\(I\ T\_1\ \[Sigma]\_1\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 1]],
                  Editable->False], ")"}], " ", \(A\_2\), " ", 
              \(\[Delta]\_2\)}], \(2\ \[Omega]\_1\%2\)], "+", 
          FractionBox[
            RowBox[{
            "3", " ", 
              \(E\^\(I\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2 + 
                    I\ \[Tau]\_1\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 1]],
                  Editable->False], ")"}], " ", \(\[Delta]\_1\), " ", 
              \(\[CapitalLambda]\_1\)}], \(2\ \[Omega]\_1\%2\)], "+", 
          FractionBox[
            RowBox[{"I", " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 1]],
                  Editable->False], ")"}], " ", \(\[Mu]\_1\)}], 
            \(2\ \[Omega]\_1\)], "+", 
          FractionBox[
            RowBox[{\(E\^\(I\ T\_1\ \[Sigma]\_1\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 2]],
                  Editable->False], ")"}], " ", \(\[Delta]\_2\), " ", 
              \(A\&_\_1\)}], \(2\ \[Omega]\_1\%2\)]}], ",", 
        RowBox[{
        \(\(-6\)\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ A\_1\ 
            A\_2\ \[Alpha]\_2\ \[CapitalLambda]\_1\), "-", 
          \(24\ A\_1\ \[Alpha]\_1\ \[CapitalLambda]\_1\%2\), "+", 
          RowBox[{\(1\/2\), " ", 
            RowBox[{"(", 
              InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                SequenceForm[ 
                  Subscript[ D, 1], 
                  Subscript[ A, 1]],
                Editable->False], ")"}], " ", \(\[Mu]\_1\)}], "+", 
          \(A\_1\ \[Mu]\_1\%2\), "+", 
          \(\(27\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ A\_1\ 
                A\_2\ \[Delta]\_1\ \[Delta]\_2\ \[CapitalLambda]\_1\)\/\(2\ 
                \[Omega]\_1\%2\)\), "+", 
          \(\(23\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ A\_1\ 
                A\_2\ \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\)\/\(15\ 
                \[Omega]\_1\%2\)\), "+", 
          \(\(81\ A\_1\ \[Delta]\_1\%2\ \[CapitalLambda]\_1\%2\)\/\(2\ 
                \[Omega]\_1\%2\)\), "+", 
          \(\(23\ A\_1\ \[Delta]\_2\%2\ \[CapitalLambda]\_1\%2\)\/\(15\ 
                \[Omega]\_1\%2\)\), "-", 
          FractionBox[
            RowBox[{"I", " ", \(E\^\(I\ T\_1\ \[Sigma]\_1\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 1]],
                  Editable->False], ")"}], " ", \(A\_2\), " ", 
              \(\[Delta]\_2\)}], \(2\ \[Omega]\_1\)], "-", 
          FractionBox[
            RowBox[{
            "3", " ", "I", " ", 
              \(E\^\(I\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2 + 
                    I\ \[Tau]\_1\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 1]],
                  Editable->False], ")"}], " ", \(\[Delta]\_1\), " ", 
              \(\[CapitalLambda]\_1\)}], \(2\ \[Omega]\_1\)], "-", 
          RowBox[{"I", " ", 
            RowBox[{"(", 
              InterpretationBox[\(D\_2\[InvisibleSpace]A\_1\),
                SequenceForm[ 
                  Subscript[ D, 2], 
                  Subscript[ A, 1]],
                Editable->False], ")"}], " ", \(\[Omega]\_1\)}], "-", 
          \(12\ A\_1\%2\ \[Alpha]\_1\ A\&_\_1\), "+", 
          \(\(30\ A\_1\%2\ \[Delta]\_1\%2\ A\&_\_1\)\/\[Omega]\_1\%2\), "-", 
          \(\(E\^\(I\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2 + 
                    I\ \[Tau]\_2\)\ f\_2\ \[Delta]\_2\ A\&_\_1\)\/\(16\ 
                \[Omega]\_1\%2\)\), "+", 
          \(\(9\ A\_1\%2\ \[Delta]\_2\%2\ A\&_\_1\)\/\(8\ \[Omega]\_1\%2\)\), 
          "-", 
          FractionBox[
            RowBox[{"I", " ", \(E\^\(I\ T\_1\ \[Sigma]\_1\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 2]],
                  Editable->False], ")"}], " ", \(\[Delta]\_2\), " ", 
              \(A\&_\_1\)}], \(2\ \[Omega]\_1\)], "-", 
          \(\(2\ I\ E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_2\ \[Delta]\_2\ \[Mu]\_1\ 
                A\&_\_1\)\/\[Omega]\_1\), "-", 
          \(\(14\ I\ 
                E\^\(I\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2 + 
                    I\ \[Tau]\_1\)\ \[Delta]\_1\ \[CapitalLambda]\_1\ 
                \[Mu]\_1\ A\&_\_1\)\/\[Omega]\_1\), "+", 
          \(\(I\ E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_2\ \[Delta]\_2\ \[Mu]\_2\ 
                A\&_\_1\)\/\(2\ \[Omega]\_1\)\), "-", 
          \(4\ A\_1\ A\_2\ \[Alpha]\_3\ A\&_\_2\), "-", 
          \(6\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ \[Alpha]\_2\ 
            \[CapitalLambda]\_1\ A\&_\_2\), "+", 
          \(\(A\_1\ A\_2\ \[Delta]\_2\%2\ A\&_\_2\)\/\(2\ \[Omega]\_1\%2\)\), 
          "+", 
          \(\(12\ A\_1\ A\_2\ \[Delta]\_1\ \[Delta]\_3\ A\&_\_2\)\/\[Omega]\_1
                \%2\), "+", 
          \(\(8\ A\_1\ A\_2\ \[Delta]\_3\%2\ A\&_\_2\)\/\(15\ 
                \[Omega]\_1\%2\)\), "+", 
          \(\(3\ A\_1\ A\_2\ \[Delta]\_2\ \[Delta]\_4\ A\&_\_2\)\/\[Omega]\_1
                \%2\), "+", 
          \(\(27\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                \[Delta]\_1\ \[Delta]\_2\ \[CapitalLambda]\_1\ A\&_\_2\)\/\(2
                \ \[Omega]\_1\%2\)\), "+", 
          \(\(23\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\ A\&_\_2\)\/\(15
                \ \[Omega]\_1\%2\)\)}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ST22 = 
      \(Coefficient[order3Eq[\([#, 2]\)] /. expRule1[2], 
            Exp[I\ \[Omega]\_2\ T\_0]]\ &\)\ /@\ {3, 4}; \n
    ST22 /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{"-", 
            RowBox[{"(", 
              InterpretationBox[\(D\_2\[InvisibleSpace]A\_2\),
                SequenceForm[ 
                  Subscript[ D, 2], 
                  Subscript[ A, 2]],
                Editable->False], ")"}]}], "+", 
          FractionBox[
            RowBox[{\(E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 1]],
                  Editable->False], ")"}], " ", \(A\_1\), " ", 
              \(\[Delta]\_2\)}], \(8\ \[Omega]\_1\%2\)], "+", 
          FractionBox[
            RowBox[{"I", " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 2]],
                  Editable->False], ")"}], " ", \(\[Mu]\_2\)}], 
            \(4\ \[Omega]\_1\)]}], ",", 
        RowBox[{
        \(\(-3\)\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ A\_2\%2\ 
            \[Alpha]\_4\ \[CapitalLambda]\_1\), "-", 
          \(4\ A\_2\ \[Alpha]\_3\ \[CapitalLambda]\_1\%2\), "-", 
          \(3\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ \[Alpha]\_2\ 
            \[CapitalLambda]\_1\%3\), "+", 
          \(\(58\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ A\_2\%2\ 
                \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\)\/\(15\ 
                \[Omega]\_1\%2\)\), "+", 
          \(\(5\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ A\_2\%2\ 
                \[Delta]\_3\ \[Delta]\_4\ \[CapitalLambda]\_1\)\/\(2\ 
                \[Omega]\_1\%2\)\), "+", 
          \(\(56\ A\_2\ \[Delta]\_2\%2\ \[CapitalLambda]\_1\%2\)\/\(15\ 
                \[Omega]\_1\%2\)\), "+", 
          \(\(12\ A\_2\ \[Delta]\_1\ \[Delta]\_3\ 
                \[CapitalLambda]\_1\%2\)\/\[Omega]\_1\%2\), "+", 
          \(\(2\ A\_2\ \[Delta]\_3\%2\ \[CapitalLambda]\_1\%2\)\/\(3\ 
                \[Omega]\_1\%2\)\), "+", 
          \(\(3\ A\_2\ \[Delta]\_2\ \[Delta]\_4\ 
                \[CapitalLambda]\_1\%2\)\/\[Omega]\_1\%2\), "+", 
          \(\(58\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ \[Delta]\_1\ 
                \[Delta]\_2\ \[CapitalLambda]\_1\%3\)\/\(5\ 
                \[Omega]\_1\%2\)\), "+", 
          \(\(5\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ \[Delta]\_2\ 
                \[Delta]\_3\ \[CapitalLambda]\_1\%3\)\/\(6\ 
                \[Omega]\_1\%2\)\), "+", 
          \(\(I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\%2\ \[Delta]\_2\ 
                \[Mu]\_1\)\/\[Omega]\_1\), "-", 
          RowBox[{"I", " ", 
            RowBox[{"(", 
              InterpretationBox[\(D\_2\[InvisibleSpace]A\_2\),
                SequenceForm[ 
                  Subscript[ D, 2], 
                  Subscript[ A, 2]],
                Editable->False], ")"}], " ", \(\[Omega]\_2\)}], "-", 
          FractionBox[
            RowBox[{"I", " ", \(E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 1]],
                  Editable->False], ")"}], " ", \(A\_1\), " ", 
              \(\[Delta]\_2\), " ", \(\[Omega]\_2\)}], 
            \(8\ \[Omega]\_1\%2\)], "+", 
          \(\(I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ f\_2\ \[Mu]\_2\ 
                \[Omega]\_2\)\/\(16\ \[Omega]\_1\%2\)\), "-", 
          \(\(I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\%2\ \[Delta]\_2\ 
                \[Mu]\_2\ \[Omega]\_2\)\/\(8\ \[Omega]\_1\%2\)\), "+", 
          FractionBox[
            RowBox[{
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 2]],
                  Editable->False], ")"}], " ", \(\[Mu]\_2\), " ", 
              \(\[Omega]\_2\)}], \(4\ \[Omega]\_1\)], "+", 
          \(\(A\_2\ \[Mu]\_2\%2\ \[Omega]\_2\)\/\(2\ \[Omega]\_1\)\), "-", 
          \(4\ A\_1\ A\_2\ \[Alpha]\_3\ A\&_\_1\), "-", 
          \(6\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ \[Alpha]\_2\ 
            \[CapitalLambda]\_1\ A\&_\_1\), "+", 
          \(\(A\_1\ A\_2\ \[Delta]\_2\%2\ A\&_\_1\)\/\(2\ \[Omega]\_1\%2\)\), 
          "+", \(\(12\ A\_1\ A\_2\ \[Delta]\_1\ \[Delta]\_3\ 
                A\&_\_1\)\/\[Omega]\_1\%2\), "+", 
          \(\(8\ A\_1\ A\_2\ \[Delta]\_3\%2\ A\&_\_1\)\/\(15\ 
                \[Omega]\_1\%2\)\), "+", 
          \(\(3\ A\_1\ A\_2\ \[Delta]\_2\ \[Delta]\_4\ A\&_\_1\)\/\[Omega]\_1
                \%2\), "+", 
          \(\(27\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                \[Delta]\_1\ \[Delta]\_2\ \[CapitalLambda]\_1\ A\&_\_1\)\/\(2
                \ \[Omega]\_1\%2\)\), "+", 
          \(\(23\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\ A\&_\_1\)\/\(15
                \ \[Omega]\_1\%2\)\), "-", 
          \(12\ A\_2\%2\ \[Alpha]\_5\ A\&_\_2\), "-", 
          \(6\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_2\ \[Alpha]\_4\ 
            \[CapitalLambda]\_1\ A\&_\_2\), "-", 
          \(2\ E\^\(2\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ \[Tau]\_1\)\ \[Alpha]\_3\ 
            \[CapitalLambda]\_1\%2\ A\&_\_2\), "+", 
          \(\(58\ A\_2\%2\ \[Delta]\_3\%2\ A\&_\_2\)\/\(15\ 
                \[Omega]\_1\%2\)\), "+", 
          \(\(15\ A\_2\%2\ \[Delta]\_4\%2\ A\&_\_2\)\/\(2\ 
                \[Omega]\_1\%2\)\), "+", 
          \(\(116\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_2\ 
                \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\ A\&_\_2\)\/\(15
                \ \[Omega]\_1\%2\)\), "+", 
          \(\(5\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_2\ 
                \[Delta]\_3\ \[Delta]\_4\ \[CapitalLambda]\_1\ 
                A\&_\_2\)\/\[Omega]\_1\%2\), "+", 
          \(\(4\ E\^\(2\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ \[Tau]\_1\)\ 
                \[Delta]\_2\%2\ \[CapitalLambda]\_1\%2\ A\&_\_2\)\/\[Omega]\_1
                \%2\), "-", 
          \(\(2\ E\^\(2\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ \[Tau]\_1\)\ 
                \[Delta]\_1\ \[Delta]\_3\ \[CapitalLambda]\_1\%2\ 
                A\&_\_2\)\/\(5\ \[Omega]\_1\%2\)\), "+", 
          \(\(E\^\(2\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ \[Tau]\_1\)\ 
                \[Delta]\_3\%2\ \[CapitalLambda]\_1\%2\ A\&_\_2\)\/\[Omega]\_1
                \%2\), "-", 
          \(\(E\^\(2\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ \[Tau]\_1\)\ \[Delta]\_2\ 
                \[Delta]\_4\ \[CapitalLambda]\_1\%2\ A\&_\_2\)\/\(2\ 
                \[Omega]\_1\%2\)\)}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Then, the solvability conditions demand that ",
  StyleBox["ST21",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["ST22",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " be orthogonal to solutions of their corresponding adjoints, the \
components of ",
  StyleBox["ccleftVec",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ". The result is"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(SCond2 = {ccleftVec[\([1]\)] . ST21 == 0, 
          ccleftVec[\([2]\)] . ST22 == 0} // ExpandAll; \n
    SCond2 /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
          \(\(-6\)\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ A\_1\ 
              A\_2\ \[Alpha]\_2\ \[CapitalLambda]\_1\), "-", 
            \(24\ A\_1\ \[Alpha]\_1\ \[CapitalLambda]\_1\%2\), "+", 
            \(A\_1\ \[Mu]\_1\%2\), "+", 
            \(\(27\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ A\_1\ 
                  A\_2\ \[Delta]\_1\ \[Delta]\_2\ \[CapitalLambda]\_1\)\/\(2\ 
                  \[Omega]\_1\%2\)\), "+", 
            \(\(23\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ A\_1\ 
                  A\_2\ \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\)\/\(15
                  \ \[Omega]\_1\%2\)\), "+", 
            \(\(81\ A\_1\ \[Delta]\_1\%2\ \[CapitalLambda]\_1\%2\)\/\(2\ 
                  \[Omega]\_1\%2\)\), "+", 
            \(\(23\ A\_1\ \[Delta]\_2\%2\ \[CapitalLambda]\_1\%2\)\/\(15\ 
                  \[Omega]\_1\%2\)\), "-", 
            RowBox[{"2", " ", "I", " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_2\[InvisibleSpace]A\_1\),
                  SequenceForm[ 
                    Subscript[ D, 2], 
                    Subscript[ A, 1]],
                  Editable->False], ")"}], " ", \(\[Omega]\_1\)}], "-", 
            \(12\ A\_1\%2\ \[Alpha]\_1\ A\&_\_1\), "+", 
            \(\(30\ A\_1\%2\ \[Delta]\_1\%2\ A\&_\_1\)\/\[Omega]\_1\%2\), 
            "-", \(\(E
                    \^\(I\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2 + 
                      I\ \[Tau]\_2\)\ f\_2\ \[Delta]\_2\ A\&_\_1\)\/\(16\ 
                  \[Omega]\_1\%2\)\), "+", 
            \(\(9\ A\_1\%2\ \[Delta]\_2\%2\ A\&_\_1\)\/\(8\ 
                  \[Omega]\_1\%2\)\), "-", 
            \(\(2\ I\ E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_2\ \[Delta]\_2\ 
                  \[Mu]\_1\ A\&_\_1\)\/\[Omega]\_1\), "-", 
            \(\(14\ I\ 
                  E\^\(I\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2 + 
                      I\ \[Tau]\_1\)\ \[Delta]\_1\ \[CapitalLambda]\_1\ 
                  \[Mu]\_1\ A\&_\_1\)\/\[Omega]\_1\), "+", 
            \(\(I\ E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_2\ \[Delta]\_2\ \[Mu]\_2\ 
                  A\&_\_1\)\/\(2\ \[Omega]\_1\)\), "-", 
            \(4\ A\_1\ A\_2\ \[Alpha]\_3\ A\&_\_2\), "-", 
            \(6\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
              \[Alpha]\_2\ \[CapitalLambda]\_1\ A\&_\_2\), "+", 
            \(\(A\_1\ A\_2\ \[Delta]\_2\%2\ A\&_\_2\)\/\(2\ 
                  \[Omega]\_1\%2\)\), "+", 
            \(\(12\ A\_1\ A\_2\ \[Delta]\_1\ \[Delta]\_3\ 
                  A\&_\_2\)\/\[Omega]\_1\%2\), "+", 
            \(\(8\ A\_1\ A\_2\ \[Delta]\_3\%2\ A\&_\_2\)\/\(15\ 
                  \[Omega]\_1\%2\)\), "+", 
            \(\(3\ A\_1\ A\_2\ \[Delta]\_2\ \[Delta]\_4\ 
                  A\&_\_2\)\/\[Omega]\_1\%2\), "+", 
            \(\(27\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                  \[Delta]\_1\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
                  A\&_\_2\)\/\(2\ \[Omega]\_1\%2\)\), "+", 
            \(\(23\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                  \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
                  A\&_\_2\)\/\(15\ \[Omega]\_1\%2\)\)}], "==", "0"}], ",", 
        RowBox[{
          RowBox[{
          \(\(-3\)\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ A\_2\%2\ 
              \[Alpha]\_4\ \[CapitalLambda]\_1\), "-", 
            \(4\ A\_2\ \[Alpha]\_3\ \[CapitalLambda]\_1\%2\), "-", 
            \(3\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ \[Alpha]\_2\ 
              \[CapitalLambda]\_1\%3\), "+", 
            \(\(58\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ A\_2\%2\ 
                  \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\)\/\(15\ 
                  \[Omega]\_1\%2\)\), "+", 
            \(\(5\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ A\_2\%2\ 
                  \[Delta]\_3\ \[Delta]\_4\ \[CapitalLambda]\_1\)\/\(2\ 
                  \[Omega]\_1\%2\)\), "+", 
            \(\(56\ A\_2\ \[Delta]\_2\%2\ \[CapitalLambda]\_1\%2\)\/\(15\ 
                  \[Omega]\_1\%2\)\), "+", 
            \(\(12\ A\_2\ \[Delta]\_1\ \[Delta]\_3\ 
                  \[CapitalLambda]\_1\%2\)\/\[Omega]\_1\%2\), "+", 
            \(\(2\ A\_2\ \[Delta]\_3\%2\ \[CapitalLambda]\_1\%2\)\/\(3\ 
                  \[Omega]\_1\%2\)\), "+", 
            \(\(3\ A\_2\ \[Delta]\_2\ \[Delta]\_4\ 
                  \[CapitalLambda]\_1\%2\)\/\[Omega]\_1\%2\), "+", 
            \(\(58\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ \[Delta]\_1\ 
                  \[Delta]\_2\ \[CapitalLambda]\_1\%3\)\/\(5\ 
                  \[Omega]\_1\%2\)\), "+", 
            \(\(5\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ \[Delta]\_2\ 
                  \[Delta]\_3\ \[CapitalLambda]\_1\%3\)\/\(6\ 
                  \[Omega]\_1\%2\)\), "+", 
            \(\(I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\%2\ \[Delta]\_2\ 
                  \[Mu]\_1\)\/\[Omega]\_1\), "-", 
            RowBox[{"2", " ", "I", " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_2\[InvisibleSpace]A\_2\),
                  SequenceForm[ 
                    Subscript[ D, 2], 
                    Subscript[ A, 2]],
                  Editable->False], ")"}], " ", \(\[Omega]\_2\)}], "+", 
            \(\(I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ f\_2\ 
                  \[Mu]\_2\ \[Omega]\_2\)\/\(16\ \[Omega]\_1\%2\)\), "-", 
            \(\(I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\%2\ \[Delta]\_2\ 
                  \[Mu]\_2\ \[Omega]\_2\)\/\(8\ \[Omega]\_1\%2\)\), "+", 
            \(\(A\_2\ \[Mu]\_2\%2\ \[Omega]\_2\)\/\(2\ \[Omega]\_1\)\), "-", 
            \(4\ A\_1\ A\_2\ \[Alpha]\_3\ A\&_\_1\), "-", 
            \(6\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
              \[Alpha]\_2\ \[CapitalLambda]\_1\ A\&_\_1\), "+", 
            \(\(A\_1\ A\_2\ \[Delta]\_2\%2\ A\&_\_1\)\/\(2\ 
                  \[Omega]\_1\%2\)\), "+", 
            \(\(12\ A\_1\ A\_2\ \[Delta]\_1\ \[Delta]\_3\ 
                  A\&_\_1\)\/\[Omega]\_1\%2\), "+", 
            \(\(8\ A\_1\ A\_2\ \[Delta]\_3\%2\ A\&_\_1\)\/\(15\ 
                  \[Omega]\_1\%2\)\), "+", 
            \(\(3\ A\_1\ A\_2\ \[Delta]\_2\ \[Delta]\_4\ 
                  A\&_\_1\)\/\[Omega]\_1\%2\), "+", 
            \(\(27\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                  \[Delta]\_1\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
                  A\&_\_1\)\/\(2\ \[Omega]\_1\%2\)\), "+", 
            \(\(23\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                  \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
                  A\&_\_1\)\/\(15\ \[Omega]\_1\%2\)\), "-", 
            \(12\ A\_2\%2\ \[Alpha]\_5\ A\&_\_2\), "-", 
            \(6\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_2\ 
              \[Alpha]\_4\ \[CapitalLambda]\_1\ A\&_\_2\), "-", 
            \(2\ E\^\(2\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ \[Tau]\_1\)\ 
              \[Alpha]\_3\ \[CapitalLambda]\_1\%2\ A\&_\_2\), "+", 
            \(\(58\ A\_2\%2\ \[Delta]\_3\%2\ A\&_\_2\)\/\(15\ 
                  \[Omega]\_1\%2\)\), "+", 
            \(\(15\ A\_2\%2\ \[Delta]\_4\%2\ A\&_\_2\)\/\(2\ 
                  \[Omega]\_1\%2\)\), "+", 
            \(\(116\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_2\ 
                  \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
                  A\&_\_2\)\/\(15\ \[Omega]\_1\%2\)\), "+", 
            \(\(5\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_2\ 
                  \[Delta]\_3\ \[Delta]\_4\ \[CapitalLambda]\_1\ 
                  A\&_\_2\)\/\[Omega]\_1\%2\), "+", 
            \(\(4\ E\^\(2\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ \[Tau]\_1\)\ 
                  \[Delta]\_2\%2\ \[CapitalLambda]\_1\%2\ 
                  A\&_\_2\)\/\[Omega]\_1\%2\), "-", 
            \(\(2\ E\^\(2\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ \[Tau]\_1\)\ 
                  \[Delta]\_1\ \[Delta]\_3\ \[CapitalLambda]\_1\%2\ 
                  A\&_\_2\)\/\(5\ \[Omega]\_1\%2\)\), "+", 
            \(\(E\^\(2\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ \[Tau]\_1\)\ 
                  \[Delta]\_3\%2\ \[CapitalLambda]\_1\%2\ 
                  A\&_\_2\)\/\[Omega]\_1\%2\), "-", 
            \(\(E\^\(2\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ \[Tau]\_1\)\ 
                  \[Delta]\_2\ \[Delta]\_4\ \[CapitalLambda]\_1\%2\ 
                  A\&_\_2\)\/\(2\ \[Omega]\_1\%2\)\)}], "==", "0"}]}], 
      "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Solving ",
  StyleBox["SCond2",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " for ",
  Cell[BoxData[
      \(TraditionalForm\`\(D\_2\) A\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\(D\_2\) A\_2\)]],
  ", we have"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"SCond2Rule1", "=", 
        RowBox[{
          RowBox[{
            RowBox[{"Solve", "[", 
              RowBox[{"SCond2", ",", 
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{
                      SubsuperscriptBox["A", "1", 
                        TagBox[\((0, 1)\),
                          Derivative],
                        MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}], 
                    ",", 
                    RowBox[{
                      SubsuperscriptBox["A", "2", 
                        TagBox[\((0, 1)\),
                          Derivative],
                        MultilineFunction->None], "[", \(T\_1, T\_2\), 
                      "]"}]}], "}"}]}], "]"}], "[", \([1]\), "]"}], "//", 
          "ExpandAll"}]}], ";", "\n", \(SCond2Rule1 /. displayRule\)}]], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          InterpretationBox[\(D\_2\[InvisibleSpace]A\_1\),
            SequenceForm[ 
              Subscript[ D, 2], 
              Subscript[ A, 1]],
            Editable->False], "\[Rule]", 
          \(\(-\(\(27\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ 
                    A\_1\ A\_2\ \[Delta]\_1\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\)\/\(4\ \[Omega]\_1\%3\)\)\) - 
            \(23\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ A\_1\ 
                A\_2\ \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\)\/\(30\ 
                \[Omega]\_1\%3\) - 
            \(81\ I\ A\_1\ \[Delta]\_1\%2\ \[CapitalLambda]\_1\%2\)\/\(4\ 
                \[Omega]\_1\%3\) - 
            \(23\ I\ A\_1\ \[Delta]\_2\%2\ \[CapitalLambda]\_1\%2\)\/\(30\ 
                \[Omega]\_1\%3\) + 
            \(3\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ A\_1\ 
                A\_2\ \[Alpha]\_2\ \[CapitalLambda]\_1\)\/\[Omega]\_1 + 
            \(12\ I\ A\_1\ \[Alpha]\_1\ 
                \[CapitalLambda]\_1\%2\)\/\[Omega]\_1 - 
            \(I\ A\_1\ \[Mu]\_1\%2\)\/\(2\ \[Omega]\_1\) - 
            \(15\ I\ A\_1\%2\ \[Delta]\_1\%2\ A\&_\_1\)\/\[Omega]\_1\%3 + 
            \(I\ E\^\(I\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2 + 
                    I\ \[Tau]\_2\)\ f\_2\ \[Delta]\_2\ A\&_\_1\)\/\(32\ 
                \[Omega]\_1\%3\) - 
            \(9\ I\ A\_1\%2\ \[Delta]\_2\%2\ A\&_\_1\)\/\(16\ 
                \[Omega]\_1\%3\) - 
            \(E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_2\ \[Delta]\_2\ \[Mu]\_1\ 
                A\&_\_1\)\/\[Omega]\_1\%2 - 
            \(7\ E\^\(I\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2 + 
                    I\ \[Tau]\_1\)\ \[Delta]\_1\ \[CapitalLambda]\_1\ 
                \[Mu]\_1\ A\&_\_1\)\/\[Omega]\_1\%2 + 
            \(E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_2\ \[Delta]\_2\ \[Mu]\_2\ 
                A\&_\_1\)\/\(4\ \[Omega]\_1\%2\) + 
            \(6\ I\ A\_1\%2\ \[Alpha]\_1\ A\&_\_1\)\/\[Omega]\_1 - 
            \(I\ A\_1\ A\_2\ \[Delta]\_2\%2\ A\&_\_2\)\/\(4\ 
                \[Omega]\_1\%3\) - 
            \(6\ I\ A\_1\ A\_2\ \[Delta]\_1\ \[Delta]\_3\ 
                A\&_\_2\)\/\[Omega]\_1\%3 - 
            \(4\ I\ A\_1\ A\_2\ \[Delta]\_3\%2\ A\&_\_2\)\/\(15\ 
                \[Omega]\_1\%3\) - 
            \(3\ I\ A\_1\ A\_2\ \[Delta]\_2\ \[Delta]\_4\ A\&_\_2\)\/\(2\ 
                \[Omega]\_1\%3\) - 
            \(27\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                \[Delta]\_1\ \[Delta]\_2\ \[CapitalLambda]\_1\ A\&_\_2\)\/\(4
                \ \[Omega]\_1\%3\) - 
            \(23\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\ A\&_\_2\)\/\(30
                \ \[Omega]\_1\%3\) + 
            \(2\ I\ A\_1\ A\_2\ \[Alpha]\_3\ A\&_\_2\)\/\[Omega]\_1 + 
            \(3\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                \[Alpha]\_2\ \[CapitalLambda]\_1\ A\&_\_2\)\/\[Omega]\_1\)}], 
        ",", 
        RowBox[{
          InterpretationBox[\(D\_2\[InvisibleSpace]A\_2\),
            SequenceForm[ 
              Subscript[ D, 2], 
              Subscript[ A, 2]],
            Editable->False], "\[Rule]", 
          \(\(E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ f\_2\ 
                \[Mu]\_2\)\/\(32\ \[Omega]\_1\%2\) - 
            \(E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\%2\ \[Delta]\_2\ 
                \[Mu]\_2\)\/\(16\ \[Omega]\_1\%2\) - 
            \(I\ A\_2\ \[Mu]\_2\%2\)\/\(4\ \[Omega]\_1\) + 
            \(3\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ A\_2\%2\ 
                \[Alpha]\_4\ \[CapitalLambda]\_1\)\/\(2\ \[Omega]\_2\) + 
            \(2\ I\ A\_2\ \[Alpha]\_3\ 
                \[CapitalLambda]\_1\%2\)\/\[Omega]\_2 + 
            \(3\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ \[Alpha]\_2\ 
                \[CapitalLambda]\_1\%3\)\/\(2\ \[Omega]\_2\) - 
            \(29\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ 
                A\_2\%2\ \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\)\/\(15
                \ \[Omega]\_1\%2\ \[Omega]\_2\) - 
            \(5\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ A\_2\%2\ 
                \[Delta]\_3\ \[Delta]\_4\ \[CapitalLambda]\_1\)\/\(4\ 
                \[Omega]\_1\%2\ \[Omega]\_2\) - 
            \(28\ I\ A\_2\ \[Delta]\_2\%2\ \[CapitalLambda]\_1\%2\)\/\(15\ 
                \[Omega]\_1\%2\ \[Omega]\_2\) - 
            \(6\ I\ A\_2\ \[Delta]\_1\ \[Delta]\_3\ 
                \[CapitalLambda]\_1\%2\)\/\(\[Omega]\_1\%2\ \[Omega]\_2\) - 
            \(I\ A\_2\ \[Delta]\_3\%2\ \[CapitalLambda]\_1\%2\)\/\(3\ 
                \[Omega]\_1\%2\ \[Omega]\_2\) - 
            \(3\ I\ A\_2\ \[Delta]\_2\ \[Delta]\_4\ 
                \[CapitalLambda]\_1\%2\)\/\(2\ \[Omega]\_1\%2\ 
                \[Omega]\_2\) - 
            \(29\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ \[Delta]\_1\ 
                \[Delta]\_2\ \[CapitalLambda]\_1\%3\)\/\(5\ \[Omega]\_1\%2\ 
                \[Omega]\_2\) - 
            \(5\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ \[Delta]\_2\ 
                \[Delta]\_3\ \[CapitalLambda]\_1\%3\)\/\(12\ \[Omega]\_1\%2\ 
                \[Omega]\_2\) + 
            \(E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\%2\ \[Delta]\_2\ 
                \[Mu]\_1\)\/\(2\ \[Omega]\_1\ \[Omega]\_2\) + 
            \(2\ I\ A\_1\ A\_2\ \[Alpha]\_3\ A\&_\_1\)\/\[Omega]\_2 + 
            \(3\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                \[Alpha]\_2\ \[CapitalLambda]\_1\ A\&_\_1\)\/\[Omega]\_2 - 
            \(I\ A\_1\ A\_2\ \[Delta]\_2\%2\ A\&_\_1\)\/\(4\ \[Omega]\_1\%2\ 
                \[Omega]\_2\) - 
            \(6\ I\ A\_1\ A\_2\ \[Delta]\_1\ \[Delta]\_3\ 
                A\&_\_1\)\/\(\[Omega]\_1\%2\ \[Omega]\_2\) - 
            \(4\ I\ A\_1\ A\_2\ \[Delta]\_3\%2\ A\&_\_1\)\/\(15\ 
                \[Omega]\_1\%2\ \[Omega]\_2\) - 
            \(3\ I\ A\_1\ A\_2\ \[Delta]\_2\ \[Delta]\_4\ A\&_\_1\)\/\(2\ 
                \[Omega]\_1\%2\ \[Omega]\_2\) - 
            \(27\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                \[Delta]\_1\ \[Delta]\_2\ \[CapitalLambda]\_1\ A\&_\_1\)\/\(4
                \ \[Omega]\_1\%2\ \[Omega]\_2\) - 
            \(23\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\ A\&_\_1\)\/\(30
                \ \[Omega]\_1\%2\ \[Omega]\_2\) + 
            \(6\ I\ A\_2\%2\ \[Alpha]\_5\ A\&_\_2\)\/\[Omega]\_2 + 
            \(3\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_2\ 
                \[Alpha]\_4\ \[CapitalLambda]\_1\ A\&_\_2\)\/\[Omega]\_2 + 
            \(I\ E\^\(2\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ \[Tau]\_1\)\ 
                \[Alpha]\_3\ \[CapitalLambda]\_1\%2\ A\&_\_2\)\/\[Omega]\_2 - 
            \(29\ I\ A\_2\%2\ \[Delta]\_3\%2\ A\&_\_2\)\/\(15\ 
                \[Omega]\_1\%2\ \[Omega]\_2\) - 
            \(15\ I\ A\_2\%2\ \[Delta]\_4\%2\ A\&_\_2\)\/\(4\ \[Omega]\_1\%2\ 
                \[Omega]\_2\) - 
            \(58\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_2\ 
                \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\ A\&_\_2\)\/\(15
                \ \[Omega]\_1\%2\ \[Omega]\_2\) - 
            \(5\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_2\ 
                \[Delta]\_3\ \[Delta]\_4\ \[CapitalLambda]\_1\ A\&_\_2\)\/\(2
                \ \[Omega]\_1\%2\ \[Omega]\_2\) - 
            \(2\ I\ E\^\(2\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ \[Tau]\_1\)\ 
                \[Delta]\_2\%2\ \[CapitalLambda]\_1\%2\ 
                A\&_\_2\)\/\(\[Omega]\_1\%2\ \[Omega]\_2\) + 
            \(I\ E\^\(2\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ \[Tau]\_1\)\ 
                \[Delta]\_1\ \[Delta]\_3\ \[CapitalLambda]\_1\%2\ 
                A\&_\_2\)\/\(5\ \[Omega]\_1\%2\ \[Omega]\_2\) - 
            \(I\ E\^\(2\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ \[Tau]\_1\)\ 
                \[Delta]\_3\%2\ \[CapitalLambda]\_1\%2\ A\&_\_2\)\/\(2\ 
                \[Omega]\_1\%2\ \[Omega]\_2\) + 
            \(I\ E\^\(2\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ \[Tau]\_1\)\ 
                \[Delta]\_2\ \[Delta]\_4\ \[CapitalLambda]\_1\%2\ 
                A\&_\_2\)\/\(4\ \[Omega]\_1\%2\ \[Omega]\_2\)\)}]}], "}"}]], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Reconstitution", "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Using the method of reconstitution, ",
  Cell[BoxData[
      \(TraditionalForm
      \`A\_k\^\[Prime] = 
        \[Epsilon]\ \(D\_1\) A\_k + \[Epsilon]\^2\ \(D\_2\) A\_k + \ 
          \[CenterEllipsis]\)]],
  ", we combine the partial-differential equations ",
  StyleBox["SCond1Rule1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["SCond2Rule1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into the following two ordinary-differential equations governing the \
modulation of the complex-valued functions ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(A\_k\) : \)\)]]
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(moduEq = 
      Table[2\ I\ \[Omega]\_k\ A\_k\^\[Prime], {k, 2}] == 
          \((\(Table[
                    2\ I\ \[Omega]\_k\ \(dt[1]\)[\ A\_k[T\_1, T\_2]], {k, 
                      2}] /. SCond1Rule1\) /. SCond2Rule1 // 
              Collect[#, \[Epsilon]]\ &)\) // Thread; \n
    moduEq /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{"2", " ", "I", " ", \(\[Omega]\_1\), " ", 
            SubsuperscriptBox["A", "1", "\[Prime]",
              MultilineFunction->None]}], "==", 
          \(2\ I\ \[Epsilon]\ \[Omega]\_1\ 
              \((\(-A\_1\)\ \[Mu]\_1 + 
                  \(I\ E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_2\ \[Delta]\_2\ 
                      A\&_\_1\)\/\[Omega]\_1 + 
                  \(3\ I\ E
                        \^\(I\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2 + 
                          I\ \[Tau]\_1\)\ \[Delta]\_1\ \[CapitalLambda]\_1\ 
                      A\&_\_1\)\/\[Omega]\_1)\) + 
            2\ I\ \[Epsilon]\^2\ \[Omega]\_1\ 
              \((\(-\(\(27\ I\ 
                          E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ 
                          A\_1\ A\_2\ \[Delta]\_1\ \[Delta]\_2\ 
                          \[CapitalLambda]\_1\)\/\(4\ \[Omega]\_1\%3\)\)\) - 
                  \(23\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ 
                      A\_1\ A\_2\ \[Delta]\_2\ \[Delta]\_3\ 
                      \[CapitalLambda]\_1\)\/\(30\ \[Omega]\_1\%3\) - 
                  \(81\ I\ A\_1\ \[Delta]\_1\%2\ \[CapitalLambda]\_1\%2\)\/\(4
                      \ \[Omega]\_1\%3\) - 
                  \(23\ I\ A\_1\ \[Delta]\_2\%2\ 
                      \[CapitalLambda]\_1\%2\)\/\(30\ \[Omega]\_1\%3\) + 
                  \(3\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ 
                      A\_1\ A\_2\ \[Alpha]\_2\ 
                      \[CapitalLambda]\_1\)\/\[Omega]\_1 + 
                  \(12\ I\ A\_1\ \[Alpha]\_1\ 
                      \[CapitalLambda]\_1\%2\)\/\[Omega]\_1 - 
                  \(I\ A\_1\ \[Mu]\_1\%2\)\/\(2\ \[Omega]\_1\) - 
                  \(15\ I\ A\_1\%2\ \[Delta]\_1\%2\ A\&_\_1\)\/\[Omega]\_1
                      \%3 + \(I\ 
                      E\^\(I\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2 + 
                          I\ \[Tau]\_2\)\ f\_2\ \[Delta]\_2\ A\&_\_1\)\/\(32\ 
                      \[Omega]\_1\%3\) - 
                  \(9\ I\ A\_1\%2\ \[Delta]\_2\%2\ A\&_\_1\)\/\(16\ 
                      \[Omega]\_1\%3\) - 
                  \(E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_2\ \[Delta]\_2\ \[Mu]\_1\ 
                      A\&_\_1\)\/\[Omega]\_1\%2 - 
                  \(7\ E\^\(I\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2 + 
                          I\ \[Tau]\_1\)\ \[Delta]\_1\ \[CapitalLambda]\_1\ 
                      \[Mu]\_1\ A\&_\_1\)\/\[Omega]\_1\%2 + 
                  \(E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_2\ \[Delta]\_2\ \[Mu]\_2\ 
                      A\&_\_1\)\/\(4\ \[Omega]\_1\%2\) + 
                  \(6\ I\ A\_1\%2\ \[Alpha]\_1\ A\&_\_1\)\/\[Omega]\_1 - 
                  \(I\ A\_1\ A\_2\ \[Delta]\_2\%2\ A\&_\_2\)\/\(4\ 
                      \[Omega]\_1\%3\) - 
                  \(6\ I\ A\_1\ A\_2\ \[Delta]\_1\ \[Delta]\_3\ 
                      A\&_\_2\)\/\[Omega]\_1\%3 - 
                  \(4\ I\ A\_1\ A\_2\ \[Delta]\_3\%2\ A\&_\_2\)\/\(15\ 
                      \[Omega]\_1\%3\) - 
                  \(3\ I\ A\_1\ A\_2\ \[Delta]\_2\ \[Delta]\_4\ A\&_\_2\)\/\(2
                      \ \[Omega]\_1\%3\) - 
                  \(27\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                      \[Delta]\_1\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
                      A\&_\_2\)\/\(4\ \[Omega]\_1\%3\) - 
                  \(23\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                      \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
                      A\&_\_2\)\/\(30\ \[Omega]\_1\%3\) + 
                  \(2\ I\ A\_1\ A\_2\ \[Alpha]\_3\ A\&_\_2\)\/\[Omega]\_1 + 
                  \(3\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                      \[Alpha]\_2\ \[CapitalLambda]\_1\ 
                      A\&_\_2\)\/\[Omega]\_1)\)\)}], ",", 
        RowBox[{
          RowBox[{"2", " ", "I", " ", \(\[Omega]\_2\), " ", 
            SubsuperscriptBox["A", "2", "\[Prime]",
              MultilineFunction->None]}], "==", 
          \(2\ I\ \[Epsilon]\ 
              \((\(-A\_2\)\ \[Mu]\_2 - 
                  \(I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ f\_2\)\/\(4
                      \ \[Omega]\_2\) + 
                  \(I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\%2\ 
                      \[Delta]\_2\)\/\(2\ \[Omega]\_2\))\)\ \[Omega]\_2 + 
            2\ I\ \[Epsilon]\^2\ \[Omega]\_2\ 
              \((\(E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ f\_2\ 
                      \[Mu]\_2\)\/\(32\ \[Omega]\_1\%2\) - 
                  \(E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\%2\ \[Delta]\_2\ 
                      \[Mu]\_2\)\/\(16\ \[Omega]\_1\%2\) - 
                  \(I\ A\_2\ \[Mu]\_2\%2\)\/\(4\ \[Omega]\_1\) + 
                  \(3\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ 
                      A\_2\%2\ \[Alpha]\_4\ \[CapitalLambda]\_1\)\/\(2\ 
                      \[Omega]\_2\) + 
                  \(2\ I\ A\_2\ \[Alpha]\_3\ 
                      \[CapitalLambda]\_1\%2\)\/\[Omega]\_2 + 
                  \(3\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ 
                      \[Alpha]\_2\ \[CapitalLambda]\_1\%3\)\/\(2\ 
                      \[Omega]\_2\) - 
                  \(29\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ 
                      A\_2\%2\ \[Delta]\_2\ \[Delta]\_3\ 
                      \[CapitalLambda]\_1\)\/\(15\ \[Omega]\_1\%2\ 
                      \[Omega]\_2\) - 
                  \(5\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ 
                      A\_2\%2\ \[Delta]\_3\ \[Delta]\_4\ 
                      \[CapitalLambda]\_1\)\/\(4\ \[Omega]\_1\%2\ 
                      \[Omega]\_2\) - 
                  \(28\ I\ A\_2\ \[Delta]\_2\%2\ 
                      \[CapitalLambda]\_1\%2\)\/\(15\ \[Omega]\_1\%2\ 
                      \[Omega]\_2\) - 
                  \(6\ I\ A\_2\ \[Delta]\_1\ \[Delta]\_3\ 
                      \[CapitalLambda]\_1\%2\)\/\(\[Omega]\_1\%2\ 
                      \[Omega]\_2\) - 
                  \(I\ A\_2\ \[Delta]\_3\%2\ \[CapitalLambda]\_1\%2\)\/\(3\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(3\ I\ A\_2\ \[Delta]\_2\ \[Delta]\_4\ 
                      \[CapitalLambda]\_1\%2\)\/\(2\ \[Omega]\_1\%2\ 
                      \[Omega]\_2\) - 
                  \(29\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ 
                      \[Delta]\_1\ \[Delta]\_2\ \[CapitalLambda]\_1\%3\)\/\(5
                      \ \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(5\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ 
                      \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\%3\)\/\(12
                      \ \[Omega]\_1\%2\ \[Omega]\_2\) + 
                  \(E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\%2\ \[Delta]\_2\ 
                      \[Mu]\_1\)\/\(2\ \[Omega]\_1\ \[Omega]\_2\) + 
                  \(2\ I\ A\_1\ A\_2\ \[Alpha]\_3\ A\&_\_1\)\/\[Omega]\_2 + 
                  \(3\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                      \[Alpha]\_2\ \[CapitalLambda]\_1\ 
                      A\&_\_1\)\/\[Omega]\_2 - 
                  \(I\ A\_1\ A\_2\ \[Delta]\_2\%2\ A\&_\_1\)\/\(4\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(6\ I\ A\_1\ A\_2\ \[Delta]\_1\ \[Delta]\_3\ 
                      A\&_\_1\)\/\(\[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(4\ I\ A\_1\ A\_2\ \[Delta]\_3\%2\ A\&_\_1\)\/\(15\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(3\ I\ A\_1\ A\_2\ \[Delta]\_2\ \[Delta]\_4\ A\&_\_1\)\/\(2
                      \ \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(27\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                      \[Delta]\_1\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
                      A\&_\_1\)\/\(4\ \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(23\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                      \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
                      A\&_\_1\)\/\(30\ \[Omega]\_1\%2\ \[Omega]\_2\) + 
                  \(6\ I\ A\_2\%2\ \[Alpha]\_5\ A\&_\_2\)\/\[Omega]\_2 + 
                  \(3\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_2\ 
                      \[Alpha]\_4\ \[CapitalLambda]\_1\ 
                      A\&_\_2\)\/\[Omega]\_2 + 
                  \(I\ E\^\(2\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ \[Tau]\_1\)\ 
                      \[Alpha]\_3\ \[CapitalLambda]\_1\%2\ 
                      A\&_\_2\)\/\[Omega]\_2 - 
                  \(29\ I\ A\_2\%2\ \[Delta]\_3\%2\ A\&_\_2\)\/\(15\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(15\ I\ A\_2\%2\ \[Delta]\_4\%2\ A\&_\_2\)\/\(4\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(58\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_2\ 
                      \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
                      A\&_\_2\)\/\(15\ \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(5\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_2\ 
                      \[Delta]\_3\ \[Delta]\_4\ \[CapitalLambda]\_1\ 
                      A\&_\_2\)\/\(2\ \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(2\ I\ E\^\(2\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ \[Tau]\_1\)\ 
                      \[Delta]\_2\%2\ \[CapitalLambda]\_1\%2\ 
                      A\&_\_2\)\/\(\[Omega]\_1\%2\ \[Omega]\_2\) + 
                  \(I\ E\^\(2\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ \[Tau]\_1\)\ 
                      \[Delta]\_1\ \[Delta]\_3\ \[CapitalLambda]\_1\%2\ 
                      A\&_\_2\)\/\(5\ \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(I\ E\^\(2\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ \[Tau]\_1\)\ 
                      \[Delta]\_3\%2\ \[CapitalLambda]\_1\%2\ A\&_\_2\)\/\(2\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) + 
                  \(I\ E\^\(2\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ \[Tau]\_1\)\ 
                      \[Delta]\_2\ \[Delta]\_4\ \[CapitalLambda]\_1\%2\ 
                      A\&_\_2\)\/\(4\ \[Omega]\_1\%2\ \[Omega]\_2\))\)\)}]}], 
      "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "6.1.2 The function ",
  StyleBox["MMS",
    FontColor->RGBColor[1, 0, 1]]
}], "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "According to the procedures described in the previous section, we can \
build a function named ",
  StyleBox["MMS",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " (",
  StyleBox["M",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  "ethod of ",
  StyleBox["M",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  "ultiple ",
  StyleBox["S",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  "cales) specifically for ",
  StyleBox["eq61b",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ". A more general function (a Package) can be created by considering as \
arguments the governing equations, symbols for dependent variables, \
independent variable, excitation amplitudes and frequencies, and all other \
related quantities which allow the program to identify their respective \
meanings. We will use ",
  StyleBox["MMS",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " to solve for different resonance cases in the following sections."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
    \(MMS[scaling_List, ResonanceCond : {__Equal}]\), ":=", "\n", "   ", 
      RowBox[{"Module", "[", 
        RowBox[{\({}\), ",", "\n", "\t\t", 
          RowBox[{
          \(omgList = {\[Omega]\_1, \[Omega]\_2}\), ";", "\n", "     ", 
            \(omgRule = 
              \(\(Solve[ResonanceCond, {\[CapitalOmega], #} // Flatten]\)[
                      \([1]\)]\ &\)\ /@\ omgList // Reverse\), ";", "\n", 
            "     ", 
            \(multiScales = {u\_i_[t] -> u\_i\ @@\ timeScales, 
                v\_i_[t] -> v\_i\ @@\ timeScales, 
                \(\(Derivative[1]\)[u_]\)[t] -> \(dt[1]\)[u\ @@\ timeScales], 
                t -> T\_0}\), ";", "\n", "\t\t", 
            \(eqa = \((
                  \(\(\(eq61b /. scaling\) /. multiScales\) /. solRule // 
                      TrigToExp\) // ExpandAll)\) /. 
                \[Epsilon]\^\(n_ /; n > 3\) -> 0\), ";", "\n", "\t\t", 
            \(eqEps = 
              \(Rest[Thread[
                        CoefficientList[Subtract\ @@\ #, \[Epsilon]] == 0]]\ &
                    \)\ /@\ eqa // Transpose\), ";", "\n", "\t\t", 
            \(eqOrder[i_] := 
              \((\(\(#[\([1]\)]\ &\)\ /@\ eqEps[\([1]\)] /. f\_s_ -> 0\) /. 
                      u_\_\(k_, 1\) -> u\_\(k, i\))\) == 
                  \((\(\(#[\([1]\)]\ &\)\ /@\ eqEps[\([1]\)] /. 
                          f\_s_ -> 0\) /. u_\_\(k_, 1\) -> u\_\(k, i\))\) - 
                    \((\(#[\([1]\)]\ &\)\ /@\ eqEps[\([i]\)])\) // Thread\), 
            ";", "\n", "\t", "\n", "\t\t", 
            StyleBox[\( (*\ First - Order\ Problem\ *) \),
              FontColor->RGBColor[0, 0, 1]], "\t\t", "\n", "\t\t", 
            \(linearSys = \(#[\([1]\)]\ &\)\ /@\ eqOrder[1]\), ";", "\n", 
            "\t\t", \(expr1 = 
              \(linearSys /. {
                      u\_\(i_, 1\) -> \((P\ E\^\(I\ \[Omega]\_i\ #1\)\ &)\), 
                      v\_\(i_, 1\) -> \((Q\ E\^\(I\ \[Omega]\_i\ #1\)\ &)\)}
                      \) /. Exp[a_] -> 1 // Partition[#, 2]\ &\), ";", "\n", 
            "\t\t", \(coefMat = \(Outer[D, #, {P, Q}]\ &\)\ /@\ expr1\), ";", 
            "\n", "\t\t", 
            \(hermitian[mat_?MatrixQ] := mat /. conjugateRule // Transpose\), 
            ";", "\n", "\t\t", 
            \(rightVec = 
              \(#/#[\([1]\)]\ &\)\ /@\ 
                \((\(\(NullSpace[#]\)[\([1]\)]\ &\)\ /@\ coefMat)\)\), ";", 
            "\n", "\t\t", 
            \(leftVec = 
              \(\(NullSpace[hermitian[#]]\)[\([1]\)]\ &\)\ /@\ coefMat\), 
            ";", "\n", "\t\t", \(ccleftVec = leftVec /. conjugateRule\), ";", 
            "\n", "\t\t", 
            \(order1Eq = 
              eqOrder[1] /. u_\_\(i_, 1\) -> \((u\_\(i, 1\)[#1]\ &)\)\), ";", 
            "\n", "\t\t", 
            \(sol1p = 
              \(DSolve[
                      order1Eq, {u\_\(1, 1\)[T\_0], v\_\(1, 1\)[T\_0], 
                        u\_\(2, 1\)[T\_0], v\_\(2, 1\)[T\_0]}, T\_0]\)[
                    \([1]\)] /. C[_] -> 0 // Simplify\), ";", "\n", "\t\t", 
            \(fRule = {
                f\_i_ -> 
                  2\ \[CapitalLambda]\_i\ 
                    \((\[Omega]\_i\%2 - \[CapitalOmega]\^2)\)}\), ";", "\n", 
            "\t\t", \(sol1u = 
              Table[u\_\(i, 1\) -> 
                  Function[{T\_0, T\_1, T\_2}, 
                    A\_i[T\_1, T\_2]\ Exp[I\ \[Omega]\_i\ T\_0] + 
                        A\&_\_i[T\_1, T\_2]\ Exp[\(-I\)\ \[Omega]\_i\ T\_0] + 
                        \((\(\(u\_\(i, 1\)[T\_0] /. sol1p\) /. fRule // 
                              Simplify\) // Expand)\) // Evaluate], {i, 2}]
                \), ";", "\n", "\t\t", 
            \(sol1v = 
              Table[v\_\(i, 1\) -> 
                  Function[{T\_0, T\_1, T\_2}, 
                    D[u\_\(i, 1\)\ @@\ timeScales, T\_0] /. sol1u // 
                      Evaluate], {i, 2}]\), ";", "\n", "\t\t", 
            \(sol1 = Join[sol1u, sol1v]\), ";", "\n", "\t\t\t\t", "\n", 
            "\t\t", 
            StyleBox[\( (*\ Second - Order\ Problem\ *) \),
              FontColor->RGBColor[0, 0, 1]], "\n", "\t\t", 
            \(order2Eq = eqOrder[2] /. sol1 // ExpandAll\), ";", "\n", 
            "\t\t", \(expRule1[i_] := 
              Exp[a_] :> 
                Exp[Expand[a /. omgRule[\([i]\)]] /. 
                    \[Epsilon]\^n_. \ T\_0 :> timeScales[\([n + 1]\)]]\), 
            ";", "\n", "\t\t", 
            \(ST11 = 
              \(Coefficient[order2Eq[\([#, 2]\)] /. expRule1[1], 
                    Exp[I\ \[Omega]\_1\ T\_0]]\ &\)\ /@\ {1, 2}\), ";", "\n", 
            "\t\t", \(ST12 = 
              \(Coefficient[order2Eq[\([#, 2]\)] /. expRule1[2], 
                    Exp[I\ \[Omega]\_2\ T\_0]]\ &\)\ /@\ {3, 4}\), ";", "\n", 
            "\t\t", \(SCond1 = {ccleftVec[\([1]\)] . ST11 == 0, 
                ccleftVec[\([2]\)] . ST12 == 0}\), ";", "\n", "\t\t", 
            RowBox[{"SCond1Rule1", "=", 
              RowBox[{
                RowBox[{
                  RowBox[{"Solve", "[", 
                    RowBox[{"SCond1", ",", 
                      RowBox[{"{", 
                        RowBox[{
                          RowBox[{
                            SubsuperscriptBox["A", "1", 
                              TagBox[\((1, 0)\),
                                Derivative],
                              MultilineFunction->None], "[", \(T\_1, T\_2\), 
                            "]"}], ",", 
                          RowBox[{
                            SubsuperscriptBox["A", "2", 
                              TagBox[\((1, 0)\),
                                Derivative],
                              MultilineFunction->None], "[", \(T\_1, T\_2\), 
                            "]"}]}], "}"}]}], "]"}], "[", \([1]\), "]"}], 
                "//", "ExpandAll"}]}], ";", "\n", "\t\t", 
            \(sigRule = 
              \(Solve[ResonanceCond, {\[Sigma]\_1, \[Sigma]\_2}]\)[\([1]\)]
                \), ";", "\n", "\t\t", 
            \(expRule2 = 
              Exp[a_] :> 
                Exp[\(a /. {T\_1 -> \[Epsilon]\ T\_0, 
                          T\_2 -> \[Epsilon]\^2\ T\_0}\) /. sigRule // Expand]
                  \), ";", "\n", "\t\t", 
            \(SCond1Rule2 = SCond1Rule1 /. expRule2\), ";", "\n", "\t\t", 
            \(ccSCond1Rule2 = SCond1Rule2 /. conjugateRule\), ";", "\n", 
            "\t\t", \(order2Eqm = 
              \(order2Eq /. SCond1Rule2\) /. ccSCond1Rule2 // ExpandAll\), 
            ";", "\n", "\t\t", 
            \(If[Union[\(#[\([2]\)]\ &\)\ /@\ order2Eqm] === {0}, \n\t\t\ \ \ 
              sol2 = {u\_\(1, 2\) -> \((0\ &)\), v\_\(1, 2\) -> \((0\ &)\), 
                  u\_\(2, 2\) -> \((0\ &)\), v\_\(2, 2\) -> \((0\ &)\)}, \t\n
              \ \ \ \t\t
              basicH = 
                Table[{A\_i[T\_1, T\_2]\ E\^\(I\ \[Omega]\_i\ T\_0\), 
                      A\&_\_i[T\_1, T\_2]\ 
                        E\^\(\(-I\)\ \[Omega]\_i\ T\_0\)}, {i, 2}] // 
                  Flatten; \n\t\ \ \ \t
              collectForm = 
                Join[basicH, 
                  If[list1 = 
                      List\ @@\ 
                          \(Plus\ @@\ 
                            \((\(#[\([2]\)]\ &\)\ /@\ eqOrder[1])\)\) /. 
                        c_\ f\_i_\ E\^a_ -> \[CapitalLambda]\_i\ E\^a; 
                    Head[list1] === List, list1, {}]]; \n\ \ \ \t\t
              possibleTerms = 
                Join[collectForm, 
                  If[list1 = 
                      List\ @@\ 
                          \(Plus\ @@\ 
                            \((\(#[\([2]\)]\ &\)\ /@\ eqOrder[2] /. 
                                u_\_\(i_, j_\) -> \((0\ &)\))\)\) /. 
                        c_\ f\_i_\ E\^a_ -> E\^a; Head[list1] === List, 
                    list1, {}], 
                  \(Outer[Times, collectForm, collectForm] // Flatten\) // 
                    Union]; \n\ \ \ \t\t
              ResonantTerms[i_] := 
                \(\((\(# /. {a_ /; a =!= 0 -> 1}\ &\)\ /@\ 
                          \((\(E\^\(\(-I\)\ \[Omega]\_i\ T\_0\)\ 
                                  possibleTerms /. expRule1[i]\) /. 
                              Exp[_\ T\_0 + _. ] -> 0)\))\)\ possibleTerms // 
                    Union\) // Rest; \n\t\ \ \ \t
              RT = Array[ResonantTerms, 2]; \n\ \ \ \t\t
              r1Rule = 
                MapIndexed[
                    r\_\(1, #2[\([1]\)]\) -> 
                        Coefficient[order2Eqm[\([1, 2]\)], #1]\ &, 
                    RT[\([1]\)]] /. Exp[_\ T\_0 + _. ] -> 0; \n
              \t\t (*\ r2Rule = 
                  MapIndexed[
                      r\_\(2, #2[\([1]\)]\) -> 
                          Coefficient[order2Eqm[\([2, 2]\)], #1]\ &, 
                      RT[\([1]\)]] /. Exp[_\ T\_0 + _. ] -> 0; \ *) \n
              \ \ \ \t\t
              r3Rule = 
                MapIndexed[
                    r\_\(3, #2[\([1]\)]\) -> 
                        Coefficient[order2Eqm[\([3, 2]\)], #1]\ &, 
                    RT[\([2]\)]] /. Exp[_\ T\_0 + _. ] -> 0; \n
              \t\t (*\ r4Rule = 
                  MapIndexed[
                      r\_\(4, #2[\([1]\)]\) -> 
                          Coefficient[order2Eqm[\([4, 2]\)], #1]\ &, 
                      RT[\([2]\)]] /. Exp[_\ T\_0 + _. ] -> 0; \ *) \n
              \ \ \ \t\t
              NRT = \(Complement[possibleTerms, Join[#, # /. conjugateRule]]
                      \ &\)\ /@\ RT; \n\ \ \ \t\t
              RTsymbolList1 = 
                Table[\[CapitalGamma]\_\(1, j\), {j, Length[RT[\([1]\)]]}]; \n
              \ \ \ \t\t
              RTsymbolList2 = 
                Table[\[CapitalGamma]\_\(3, j\), {j, Length[RT[\([2]\)]]}]; \n
              \ \ \ \t\t
              NRTsymbolList1[i_] = 
                Table[\[CapitalLambda]\_\(i, j\), {j, Length[NRT[\([1]\)]]}]; 
              \n\ \ \ \t\t
              NRTsymbolList2[i_] = 
                Table[\[CapitalLambda]\_\(i + 2, j\), {j, 
                    Length[NRT[\([2]\)]]}]; \n
              \ \ \ \t\t{ratio1, ratio2} = 
                Table[\(-ccleftVec[\([i, 1]\)]\), {i, 2}]; \n\ \ \ \t\t
              sol2Form = {
                  u\_\(1, 2\) -> 
                    Function[{T\_0, T\_1, T\_2}, 
                      RTsymbolList1 . RT[\([1]\)] + 
                          \((RTsymbolList1 . RT[\([1]\)] /. conjugateRule)
                            \) + NRTsymbolList1[1] . NRT[\([1]\)] // 
                        Evaluate], 
                  v\_\(1, 2\) -> 
                    Function[{T\_0, T\_1, T\_2}, 
                      ratio1*RTsymbolList1 . RT[\([1]\)] + 
                          \((ratio1*RTsymbolList1 . RT[\([1]\)] /. 
                              conjugateRule)\) + 
                          NRTsymbolList1[2] . NRT[\([1]\)] // Evaluate], 
                  u\_\(2, 2\) -> 
                    Function[{T\_0, T\_1, T\_2}, 
                      RTsymbolList2 . RT[\([2]\)] + 
                          \((RTsymbolList2 . RT[\([2]\)] /. conjugateRule)
                            \) + NRTsymbolList2[1] . NRT[\([2]\)] // 
                        Evaluate], 
                  v\_\(2, 2\) -> 
                    Function[{T\_0, T\_1, T\_2}, 
                      ratio2*RTsymbolList2 . RT[\([2]\)] + 
                          \((ratio2*RTsymbolList2 . RT[\([2]\)] /. 
                              conjugateRule)\) + 
                          NRTsymbolList2[2] . NRT[\([2]\)] // Evaluate]}; \n
              \ \ \ \t\t
              eqb = \((
                      \(Coefficient[Subtract\ @@\ # /. sol2Form, 
                                NRT[\([1]\)]] /. Exp[_\ T\_0 + _. ] -> 0\ &
                            \)\ /@\ order2Eqm[\([{1, 2}]\)] // Flatten)\) == 
                    0 // Thread; \n\ \ \ \t\t
              eqc = \((
                      \(Coefficient[Subtract\ @@\ # /. sol2Form, 
                                NRT[\([2]\)]] /. Exp[_\ T\_0 + _. ] -> 0\ &
                            \)\ /@\ order2Eqm[\([{3, 4}]\)] // Flatten)\) == 
                    0 // Thread; \n\ \ \ \t\t
              coef11 = 
                \(Solve[eqb, Array[NRTsymbolList1, 2] // Flatten]\)[\([1]\)]; 
              \n\ \ \ \t\t
              coef12 = 
                \(Solve[eqc, Array[NRTsymbolList2, 2] // Flatten]\)[\([1]\)]; 
              \n\ \ \ \t\t
              eqd = MapIndexed[
                    Coefficient[order2Eqm[\([1, 1]\)] /. sol2Form, #1] == 
                        r\_\(1, #2[\([1]\)]\)\ &, RT[\([1]\)]] /. 
                  Exp[_\ T\_0 + _. ] -> 0; \n\ \ \ \t\t
              eqe = MapIndexed[
                    Coefficient[order2Eqm[\([3, 1]\)] /. sol2Form, #1] == 
                        r\_\(3, #2[\([1]\)]\)\ &, RT[\([2]\)]] /. 
                  Exp[_\ T\_0 + _. ] -> 0; \n\ \ \ \t\t
              coef21 = \(Solve[eqd, RTsymbolList1]\)[\([1]\)] /. r1Rule; \n
              \ \ \ \t\t
              coef22 = \(Solve[eqe, RTsymbolList2]\)[\([1]\)] /. r3Rule; \n
              \ \ \ \t\t
              coeffs = 
                Join[coef11, coef12, coef21, coef22, coef21 /. conjugateRule, 
                    coef22 /. conjugateRule] /. 
                  \((omgRule[\([1]\)] /. \[Epsilon] -> 0)\); \n\ \ \ \t\t
              sol2 = sol2Form /. 
                  Function[{T\_0, T\_1, T\_2}, a_] :> 
                    Function[{T\_0, T\_1, T\_2} // Evaluate, 
                      \(a /. coeffs // Expand\) // Evaluate]\n\t\ \ ]\), ";", 
            "\n", "\t\t", "\n", "\t\t", 
            StyleBox[\( (*\ Third - Order\ Problem\ *) \),
              FontColor->RGBColor[0, 0, 1]], "\n", "\t\t", 
            \(order3Eq = \(eqOrder[3] /. sol1\) /. sol2 // ExpandAll\), ";", 
            "\n", "\t\t", 
            \(ST21 = 
              \(Coefficient[order3Eq[\([#, 2]\)] /. expRule1[1], 
                    Exp[I\ \[Omega]\_1\ T\_0]]\ &\)\ /@\ {1, 2}\), ";", "\n", 
            "\t\t", 
            \(ST22 = 
              \(Coefficient[order3Eq[\([#, 2]\)] /. expRule1[2], 
                    Exp[I\ \[Omega]\_2\ T\_0]]\ &\)\ /@\ {3, 4}\), ";", "\n", 
            "\t\t", \(SCond2 = {ccleftVec[\([1]\)] . ST21 == 0, 
                  ccleftVec[\([2]\)] . ST22 == 0} // ExpandAll\), ";", "\n", 
            "\t\t", 
            RowBox[{"SCond2Rule1", "=", 
              RowBox[{
                RowBox[{
                  RowBox[{"Solve", "[", 
                    RowBox[{"SCond2", ",", 
                      RowBox[{"{", 
                        RowBox[{
                          RowBox[{
                            SubsuperscriptBox["A", "1", 
                              TagBox[\((0, 1)\),
                                Derivative],
                              MultilineFunction->None], "[", \(T\_1, T\_2\), 
                            "]"}], ",", 
                          RowBox[{
                            SubsuperscriptBox["A", "2", 
                              TagBox[\((0, 1)\),
                                Derivative],
                              MultilineFunction->None], "[", \(T\_1, T\_2\), 
                            "]"}]}], "}"}]}], "]"}], "[", \([1]\), "]"}], 
                "//", "ExpandAll"}]}], ";", "\n", "\t\t", "\n", "\t\t", 
            StyleBox[\( (*\ Reconstitution\ *) \),
              FontColor->RGBColor[0, 0, 1]], "\n", "\t\t", 
            \(moduEq = 
              Table[2\ I\ \[Omega]\_k\ A\_k\^\[Prime], {k, 2}] == 
                  \((\(Table[
                            2\ I\ \[Omega]\_k\ 
                              \(dt[1]\)[\ A\_k[T\_1, T\_2]], {k, 2}] /. 
                          SCond1Rule1\) /. SCond2Rule1 // 
                      Collect[#, \[Epsilon]]\ &)\) // Thread\), ";", "\n", 
            "\t\t", 
            RowBox[{"Print", "[", "\"\<\!\(\*
StyleBox[\\(The\\),\nFontColor->RGBColor[0, 0, 1]]\) \!\(\*
StyleBox[\\(second\\),\nFontColor->RGBColor[0, 0, 1]]\)\!\(\*
StyleBox[\\(-\\),\nFontColor->RGBColor[0, 0, 1]]\)\!\(\*
StyleBox[\\(order\\),\nFontColor->RGBColor[0, 0, 1]]\) \!\(\*
StyleBox[\\(approximate\\),\nFontColor->RGBColor[0, 0, 1]]\) \!\(\*
StyleBox[\\(solution\\),\nFontColor->RGBColor[0, 0, 1]]\)\!\(\*
StyleBox[\\(:\\),\nFontColor->RGBColor[0, 0, 1]]\)\>\"", "]"}], ";", "\n", 
            "\t\t", \(Print[
              Table[u\_i[t] == 
                  \((\(\(\(\(u\_i\ @@\ timeScales /. solRule\) /. 
                            \[Epsilon]\^3 -> 0\) /. sol1\) /. sol2\) /. 
                      displayRule)\), {i, 2}]]\), ";", "\n", "\t\t", 
            RowBox[{"If", "[", 
              RowBox[{
              \(Or\ @@\ 
                  Table[\((F\_i/f\_i /. scaling)\) === \[Epsilon], {i, 2}]\), 
                ",", "\n", "\t\t\t", 
                RowBox[{
                  RowBox[{"Print", "[", "\"\<\!\(\*
StyleBox[\\(where\\),\nFontColor->RGBColor[0, 0, 1]]\)\>\"", "]"}], ";", 
                  "\n", "\t\t\t", 
                  \(Print[
                    \*"\"\<\!\(\[CapitalLambda]\_i\)==\!\(f\_i\/\(2 \((\
\[Omega]\_i\%2 - \[CapitalOmega]\^2)\)\)\)\>\""]\)}]}], "\n", "\t\t", "]"}], 
            ";", " ", "\n", "\t\t", 
            RowBox[{"Print", "[", "\"\<\\n\!\(\*
StyleBox[\\(The\\),\nFontColor->RGBColor[0, 0, 1]]\) \!\(\*
StyleBox[\\(modulation\\),\nFontColor->RGBColor[0, 0, 1]]\) \!\(\*
StyleBox[\\(equations\\),\nFontColor->RGBColor[0, 0, 1]]\)\!\(\*
StyleBox[\\(:\\),\nFontColor->RGBColor[0, 0, 1]]\)\>\"", "]"}], ";", "\n", 
            "\t\t", \(Print[moduEq /. displayRule]\)}]}], "\n", "]"}]}]], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["As an example, we check the case in Section 6.1.1:", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(scaling1 = {\[Mu]\&^\_n_ -> \[Epsilon]\ \[Mu]\_n, 
        F\_1 -> \[Epsilon]\ f\_1, F\_2 -> \[Epsilon]\^2\ f\_2}; \)\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(ResonanceCond1 = {
        \[Omega]\_2 == 2  \[Omega]\_1 + \[Epsilon]\ \[Sigma]\_1, 
        \[CapitalOmega] == \[Omega]\_2 + \[Epsilon]\ \[Sigma]\_2}; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(MMS[scaling1, ResonanceCond1] // Timing\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\!\\(\\* StyleBox[\\(The\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(second\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* \
StyleBox[\\(-\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* StyleBox[\\(order\
\\), FontColor->RGBColor[0, 0, 1]]\\) \\!\\(\\* StyleBox[\\(approximate\\), \
FontColor->RGBColor[0, 0, 1]]\\) \\!\\(\\* StyleBox[\\(solution\\), \
FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* StyleBox[\\(:\\), \
FontColor->RGBColor[0, 0, 1]]\\)\"\>"], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u\_1[t] == 
        \[Epsilon]\ 
            \((E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1 + 
                E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1\)\ 
                  \[CapitalLambda]\_1 + 
                E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1\)\ 
                  \[CapitalLambda]\_1 + 
                E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ A\&_\_1)\) + 
          \[Epsilon]\^2\ 
            \((\(E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ A\_1\%2\ 
                    \[Delta]\_1\)\/\[Omega]\_1\%2 + 
                \(E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ A\_1\ 
                    A\_2\ \[Delta]\_2\)\/\(4\ \[Omega]\_1\%2\) + 
                \(E\^\(2\ I\ T\_0\ \[Omega]\_2\)\ A\_2\%2\ \[Delta]\_3\)\/\(15
                    \ \[Omega]\_1\%2\) - 
                \(3\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
                        I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Delta]\_1\ 
                    \[CapitalLambda]\_1\)\/\(2\ \[Omega]\_1\%2\) + 
                \(3\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                        I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Delta]\_1\ 
                    \[CapitalLambda]\_1\)\/\(4\ \[Omega]\_1\%2\) - 
                \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
                        I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\)\/\[Omega]\_1\%2 + 
                \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                        I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\)\/\(15\ \[Omega]\_1\%2\) - 
                \(6\ \[Delta]\_1\ \[CapitalLambda]\_1\%2\)\/\[Omega]\_1\%2 + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega] - 2\ I\ \[Tau]\_1\)\ 
                    \[Delta]\_1\ \[CapitalLambda]\_1\%2\)\/\(5\ 
                    \[Omega]\_1\%2\) + 
                \(E\^\(2\ I\ T\_0\ \[CapitalOmega] + 2\ I\ \[Tau]\_1\)\ 
                    \[Delta]\_1\ \[CapitalLambda]\_1\%2\)\/\(5\ 
                    \[Omega]\_1\%2\) - 
                \(I\ E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Mu]\_1\)\/\(2\ 
                    \[Omega]\_1\) - 
                \(4\ I\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1\)\ 
                    \[CapitalLambda]\_1\ \[Mu]\_1\)\/\(3\ \[Omega]\_1\) + 
                \(4\ I\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1\)\ 
                    \[CapitalLambda]\_1\ \[Mu]\_1\)\/\(3\ \[Omega]\_1\) - 
                \(6\ A\_1\ \[Delta]\_1\ A\&_\_1\)\/\[Omega]\_1\%2 - 
                \(E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                    A\_2\ \[Delta]\_2\ A\&_\_1\)\/\(2\ \[Omega]\_1\%2\) + 
                \(3\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                        I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ 
                    \[CapitalLambda]\_1\ A\&_\_1\)\/\(4\ \[Omega]\_1\%2\) - 
                \(3\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
                        I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ 
                    \[CapitalLambda]\_1\ A\&_\_1\)\/\(2\ \[Omega]\_1\%2\) + 
                \(I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ \[Mu]\_1\ 
                    A\&_\_1\)\/\(2\ \[Omega]\_1\) + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ 
                    A\&_\_1\%2\)\/\[Omega]\_1\%2 - 
                \(E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ A\_1\ 
                    \[Delta]\_2\ A\&_\_2\)\/\(2\ \[Omega]\_1\%2\) - 
                \(2\ A\_2\ \[Delta]\_3\ A\&_\_2\)\/\[Omega]\_1\%2 + 
                \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                        I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\ A\&_\_2\)\/\(15\ \[Omega]\_1\%2\) - 
                \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
                        I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\ A\&_\_2\)\/\[Omega]\_1\%2 + 
                \(E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                    \[Delta]\_2\ A\&_\_1\ A\&_\_2\)\/\(4\ \[Omega]\_1\%2\) + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ 
                    A\&_\_2\%2\)\/\(15\ \[Omega]\_1\%2\))\), 
      u\_2[t] == 
        \[Epsilon]\ 
            \((E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2 + 
                E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ A\&_\_2)\) + 
          \[Epsilon]\^2\ 
            \((\(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2\)\ 
                    f\_2\)\/\(32\ \[Omega]\_1\%2\) + 
                \(E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2\)\ f\_2\)\/\(32
                    \ \[Omega]\_1\%2\) - 
                \(E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ A\_1\%2\ \[Delta]\_2\)\/\(16
                    \ \[Omega]\_1\%2\) + 
                \(2\ E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                    A\_1\ A\_2\ \[Delta]\_3\)\/\(5\ \[Omega]\_1\%2\) + 
                \(E\^\(2\ I\ T\_0\ \[Omega]\_2\)\ A\_2\%2\ \[Delta]\_4\)\/\(4
                    \ \[Omega]\_1\%2\) - 
                \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
                        I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\)\/\(3\ \[Omega]\_1\%2\) + 
                \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                        I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\)\/\(5\ \[Omega]\_1\%2\) - 
                \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
                        I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Delta]\_3\ 
                    \[CapitalLambda]\_1\)\/\(2\ \[Omega]\_1\%2\) + 
                \(E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                        I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Delta]\_3\ 
                    \[CapitalLambda]\_1\)\/\(6\ \[Omega]\_1\%2\) - 
                \(\[Delta]\_2\ \[CapitalLambda]\_1\%2\)\/\(2\ 
                    \[Omega]\_1\%2\) + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega] - 2\ I\ \[Tau]\_1\)\ 
                    \[Delta]\_2\ \[CapitalLambda]\_1\%2\)\/\(12\ 
                    \[Omega]\_1\%2\) + 
                \(E\^\(2\ I\ T\_0\ \[CapitalOmega] + 2\ I\ \[Tau]\_1\)\ 
                    \[Delta]\_2\ \[CapitalLambda]\_1\%2\)\/\(12\ 
                    \[Omega]\_1\%2\) - 
                \(I\ E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Mu]\_2\)\/\(4\ 
                    \[Omega]\_1\) - 
                \(A\_1\ \[Delta]\_2\ A\&_\_1\)\/\(2\ \[Omega]\_1\%2\) - 
                \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                    A\_2\ \[Delta]\_3\ A\&_\_1\)\/\(3\ \[Omega]\_1\%2\) + 
                \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                        I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\ A\&_\_1\)\/\(5\ \[Omega]\_1\%2\) - 
                \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
                        I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\ A\&_\_1\)\/\(3\ \[Omega]\_1\%2\) - 
                \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ 
                    A\&_\_1\%2\)\/\(16\ \[Omega]\_1\%2\) - 
                \(2\ E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                    A\_1\ \[Delta]\_3\ A\&_\_2\)\/\(3\ \[Omega]\_1\%2\) - 
                \(3\ A\_2\ \[Delta]\_4\ A\&_\_2\)\/\(2\ \[Omega]\_1\%2\) + 
                \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                        I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ 
                    \[CapitalLambda]\_1\ A\&_\_2\)\/\(6\ \[Omega]\_1\%2\) - 
                \(E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
                        I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ 
                    \[CapitalLambda]\_1\ A\&_\_2\)\/\(2\ \[Omega]\_1\%2\) + 
                \(I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ \[Mu]\_2\ 
                    A\&_\_2\)\/\(4\ \[Omega]\_1\) + 
                \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                    \[Delta]\_3\ A\&_\_1\ A\&_\_2\)\/\(5\ \[Omega]\_1\%2\) + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_4\ 
                    A\&_\_2\%2\)\/\(4\ \[Omega]\_1\%2\))\)}\)], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\!\\(\\* StyleBox[\\(where\\), FontColor->RGBColor[0, 0, 1]]\\)\"\>"],
   "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \("\!\(\[CapitalLambda]\_i\)==\!\(f\_i\/\(2 \((\[Omega]\_i\%2 - \
\[CapitalOmega]\^2)\)\)\)"\)], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\n\\!\\(\\* StyleBox[\\(The\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(modulation\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(equations\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* \
StyleBox[\\(:\\), FontColor->RGBColor[0, 0, 1]]\\)\"\>"], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{"2", " ", "I", " ", \(\[Omega]\_1\), " ", 
            SubsuperscriptBox["A", "1", "\[Prime]",
              MultilineFunction->None]}], "==", 
          \(2\ I\ \[Epsilon]\ \[Omega]\_1\ 
              \((\(-A\_1\)\ \[Mu]\_1 + 
                  \(I\ E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_2\ \[Delta]\_2\ 
                      A\&_\_1\)\/\[Omega]\_1 + 
                  \(3\ I\ E
                        \^\(I\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2 + 
                          I\ \[Tau]\_1\)\ \[Delta]\_1\ \[CapitalLambda]\_1\ 
                      A\&_\_1\)\/\[Omega]\_1)\) + 
            2\ I\ \[Epsilon]\^2\ \[Omega]\_1\ 
              \((\(-\(\(27\ I\ 
                          E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ 
                          A\_1\ A\_2\ \[Delta]\_1\ \[Delta]\_2\ 
                          \[CapitalLambda]\_1\)\/\(4\ \[Omega]\_1\%3\)\)\) - 
                  \(23\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ 
                      A\_1\ A\_2\ \[Delta]\_2\ \[Delta]\_3\ 
                      \[CapitalLambda]\_1\)\/\(30\ \[Omega]\_1\%3\) - 
                  \(81\ I\ A\_1\ \[Delta]\_1\%2\ \[CapitalLambda]\_1\%2\)\/\(4
                      \ \[Omega]\_1\%3\) - 
                  \(23\ I\ A\_1\ \[Delta]\_2\%2\ 
                      \[CapitalLambda]\_1\%2\)\/\(30\ \[Omega]\_1\%3\) + 
                  \(3\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ 
                      A\_1\ A\_2\ \[Alpha]\_2\ 
                      \[CapitalLambda]\_1\)\/\[Omega]\_1 + 
                  \(12\ I\ A\_1\ \[Alpha]\_1\ 
                      \[CapitalLambda]\_1\%2\)\/\[Omega]\_1 - 
                  \(I\ A\_1\ \[Mu]\_1\%2\)\/\(2\ \[Omega]\_1\) - 
                  \(15\ I\ A\_1\%2\ \[Delta]\_1\%2\ A\&_\_1\)\/\[Omega]\_1
                      \%3 + \(I\ 
                      E\^\(I\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2 + 
                          I\ \[Tau]\_2\)\ f\_2\ \[Delta]\_2\ A\&_\_1\)\/\(32\ 
                      \[Omega]\_1\%3\) - 
                  \(9\ I\ A\_1\%2\ \[Delta]\_2\%2\ A\&_\_1\)\/\(16\ 
                      \[Omega]\_1\%3\) - 
                  \(E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_2\ \[Delta]\_2\ \[Mu]\_1\ 
                      A\&_\_1\)\/\[Omega]\_1\%2 - 
                  \(7\ E\^\(I\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2 + 
                          I\ \[Tau]\_1\)\ \[Delta]\_1\ \[CapitalLambda]\_1\ 
                      \[Mu]\_1\ A\&_\_1\)\/\[Omega]\_1\%2 + 
                  \(E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_2\ \[Delta]\_2\ \[Mu]\_2\ 
                      A\&_\_1\)\/\(4\ \[Omega]\_1\%2\) + 
                  \(6\ I\ A\_1\%2\ \[Alpha]\_1\ A\&_\_1\)\/\[Omega]\_1 - 
                  \(I\ A\_1\ A\_2\ \[Delta]\_2\%2\ A\&_\_2\)\/\(4\ 
                      \[Omega]\_1\%3\) - 
                  \(6\ I\ A\_1\ A\_2\ \[Delta]\_1\ \[Delta]\_3\ 
                      A\&_\_2\)\/\[Omega]\_1\%3 - 
                  \(4\ I\ A\_1\ A\_2\ \[Delta]\_3\%2\ A\&_\_2\)\/\(15\ 
                      \[Omega]\_1\%3\) - 
                  \(3\ I\ A\_1\ A\_2\ \[Delta]\_2\ \[Delta]\_4\ A\&_\_2\)\/\(2
                      \ \[Omega]\_1\%3\) - 
                  \(27\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                      \[Delta]\_1\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
                      A\&_\_2\)\/\(4\ \[Omega]\_1\%3\) - 
                  \(23\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                      \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
                      A\&_\_2\)\/\(30\ \[Omega]\_1\%3\) + 
                  \(2\ I\ A\_1\ A\_2\ \[Alpha]\_3\ A\&_\_2\)\/\[Omega]\_1 + 
                  \(3\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                      \[Alpha]\_2\ \[CapitalLambda]\_1\ 
                      A\&_\_2\)\/\[Omega]\_1)\)\)}], ",", 
        RowBox[{
          RowBox[{"2", " ", "I", " ", \(\[Omega]\_2\), " ", 
            SubsuperscriptBox["A", "2", "\[Prime]",
              MultilineFunction->None]}], "==", 
          \(2\ I\ \[Epsilon]\ 
              \((\(-A\_2\)\ \[Mu]\_2 - 
                  \(I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ f\_2\)\/\(4
                      \ \[Omega]\_2\) + 
                  \(I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\%2\ 
                      \[Delta]\_2\)\/\(2\ \[Omega]\_2\))\)\ \[Omega]\_2 + 
            2\ I\ \[Epsilon]\^2\ \[Omega]\_2\ 
              \((\(E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ f\_2\ 
                      \[Mu]\_2\)\/\(32\ \[Omega]\_1\%2\) - 
                  \(E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\%2\ \[Delta]\_2\ 
                      \[Mu]\_2\)\/\(16\ \[Omega]\_1\%2\) - 
                  \(I\ A\_2\ \[Mu]\_2\%2\)\/\(4\ \[Omega]\_1\) + 
                  \(3\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ 
                      A\_2\%2\ \[Alpha]\_4\ \[CapitalLambda]\_1\)\/\(2\ 
                      \[Omega]\_2\) + 
                  \(2\ I\ A\_2\ \[Alpha]\_3\ 
                      \[CapitalLambda]\_1\%2\)\/\[Omega]\_2 + 
                  \(3\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ 
                      \[Alpha]\_2\ \[CapitalLambda]\_1\%3\)\/\(2\ 
                      \[Omega]\_2\) - 
                  \(29\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ 
                      A\_2\%2\ \[Delta]\_2\ \[Delta]\_3\ 
                      \[CapitalLambda]\_1\)\/\(15\ \[Omega]\_1\%2\ 
                      \[Omega]\_2\) - 
                  \(5\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ 
                      A\_2\%2\ \[Delta]\_3\ \[Delta]\_4\ 
                      \[CapitalLambda]\_1\)\/\(4\ \[Omega]\_1\%2\ 
                      \[Omega]\_2\) - 
                  \(28\ I\ A\_2\ \[Delta]\_2\%2\ 
                      \[CapitalLambda]\_1\%2\)\/\(15\ \[Omega]\_1\%2\ 
                      \[Omega]\_2\) - 
                  \(6\ I\ A\_2\ \[Delta]\_1\ \[Delta]\_3\ 
                      \[CapitalLambda]\_1\%2\)\/\(\[Omega]\_1\%2\ 
                      \[Omega]\_2\) - 
                  \(I\ A\_2\ \[Delta]\_3\%2\ \[CapitalLambda]\_1\%2\)\/\(3\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(3\ I\ A\_2\ \[Delta]\_2\ \[Delta]\_4\ 
                      \[CapitalLambda]\_1\%2\)\/\(2\ \[Omega]\_1\%2\ 
                      \[Omega]\_2\) - 
                  \(29\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ 
                      \[Delta]\_1\ \[Delta]\_2\ \[CapitalLambda]\_1\%3\)\/\(5
                      \ \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(5\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ 
                      \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\%3\)\/\(12
                      \ \[Omega]\_1\%2\ \[Omega]\_2\) + 
                  \(E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\%2\ \[Delta]\_2\ 
                      \[Mu]\_1\)\/\(2\ \[Omega]\_1\ \[Omega]\_2\) + 
                  \(2\ I\ A\_1\ A\_2\ \[Alpha]\_3\ A\&_\_1\)\/\[Omega]\_2 + 
                  \(3\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                      \[Alpha]\_2\ \[CapitalLambda]\_1\ 
                      A\&_\_1\)\/\[Omega]\_2 - 
                  \(I\ A\_1\ A\_2\ \[Delta]\_2\%2\ A\&_\_1\)\/\(4\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(6\ I\ A\_1\ A\_2\ \[Delta]\_1\ \[Delta]\_3\ 
                      A\&_\_1\)\/\(\[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(4\ I\ A\_1\ A\_2\ \[Delta]\_3\%2\ A\&_\_1\)\/\(15\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(3\ I\ A\_1\ A\_2\ \[Delta]\_2\ \[Delta]\_4\ A\&_\_1\)\/\(2
                      \ \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(27\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                      \[Delta]\_1\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
                      A\&_\_1\)\/\(4\ \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(23\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                      \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
                      A\&_\_1\)\/\(30\ \[Omega]\_1\%2\ \[Omega]\_2\) + 
                  \(6\ I\ A\_2\%2\ \[Alpha]\_5\ A\&_\_2\)\/\[Omega]\_2 + 
                  \(3\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_2\ 
                      \[Alpha]\_4\ \[CapitalLambda]\_1\ 
                      A\&_\_2\)\/\[Omega]\_2 + 
                  \(I\ E\^\(2\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ \[Tau]\_1\)\ 
                      \[Alpha]\_3\ \[CapitalLambda]\_1\%2\ 
                      A\&_\_2\)\/\[Omega]\_2 - 
                  \(29\ I\ A\_2\%2\ \[Delta]\_3\%2\ A\&_\_2\)\/\(15\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(15\ I\ A\_2\%2\ \[Delta]\_4\%2\ A\&_\_2\)\/\(4\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(58\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_2\ 
                      \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
                      A\&_\_2\)\/\(15\ \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(5\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_2\ 
                      \[Delta]\_3\ \[Delta]\_4\ \[CapitalLambda]\_1\ 
                      A\&_\_2\)\/\(2\ \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(2\ I\ E\^\(2\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ \[Tau]\_1\)\ 
                      \[Delta]\_2\%2\ \[CapitalLambda]\_1\%2\ 
                      A\&_\_2\)\/\(\[Omega]\_1\%2\ \[Omega]\_2\) + 
                  \(I\ E\^\(2\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ \[Tau]\_1\)\ 
                      \[Delta]\_1\ \[Delta]\_3\ \[CapitalLambda]\_1\%2\ 
                      A\&_\_2\)\/\(5\ \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(I\ E\^\(2\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ \[Tau]\_1\)\ 
                      \[Delta]\_3\%2\ \[CapitalLambda]\_1\%2\ A\&_\_2\)\/\(2\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) + 
                  \(I\ E\^\(2\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ \[Tau]\_1\)\ 
                      \[Delta]\_2\ \[Delta]\_4\ \[CapitalLambda]\_1\%2\ 
                      A\&_\_2\)\/\(4\ \[Omega]\_1\%2\ \[Omega]\_2\))\)\)}]}], 
      "}"}]], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({82.9800000000000181`\ Second, Null}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "6.1.3 ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega] \[TildeTilde] \[Omega]\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\_2 \[TildeTilde] 2  \[Omega]\_1\)]]
}], "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
In this case, we have a combination of a primary resonance of the first mode, \
a superharmonic resonance of the second mode, and a two-to-one internal \
resonance. In order to bring the effects of damping, forcing, and \
nonlinearity at the same order, we let\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(scaling3 = {\[Mu]\&^\_n_ -> \[Epsilon]\ \[Mu]\_n, 
        F\_1 -> \[Epsilon]\^2\ f\_1, F\_2 -> \[Epsilon]\ f\_2}; \)\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "To describe quantitatively the nearness of the resonances, we introduce \
the detuning parameters ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\_2\)]],
  " defined according to"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(ResonanceCond3 = {
        \[Omega]\_2 == 2  \[Omega]\_1 + \[Epsilon]\ \[Sigma]\_1, 
        \[CapitalOmega] == \[Omega]\_1 + \[Epsilon]\ \[Sigma]\_2}; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Using ",
  StyleBox["MMS",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain the second-order approximate solution and the two equations \
governing the modulation of the complex-valued functions ",
  Cell[BoxData[
      \(TraditionalForm\`A\_k\)]],
  ":"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(MMS[scaling3, ResonanceCond3] // Timing\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\!\\(\\* StyleBox[\\(The\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(second\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* \
StyleBox[\\(-\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* StyleBox[\\(order\
\\), FontColor->RGBColor[0, 0, 1]]\\) \\!\\(\\* StyleBox[\\(approximate\\), \
FontColor->RGBColor[0, 0, 1]]\\) \\!\\(\\* StyleBox[\\(solution\\), \
FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* StyleBox[\\(:\\), \
FontColor->RGBColor[0, 0, 1]]\\)\"\>"], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u\_1[t] == 
        \[Epsilon]\ 
            \((E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1 + 
                E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ A\&_\_1)\) + 
          \[Epsilon]\^2\ 
            \((\(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1\)\ 
                    f\_1\)\/\(8\ \[Omega]\_1\%2\) + 
                \(E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1\)\ f\_1\)\/\(8
                    \ \[Omega]\_1\%2\) + 
                \(E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ A\_1\%2\ 
                    \[Delta]\_1\)\/\[Omega]\_1\%2 + 
                \(E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ A\_1\ 
                    A\_2\ \[Delta]\_2\)\/\(4\ \[Omega]\_1\%2\) + 
                \(E\^\(2\ I\ T\_0\ \[Omega]\_2\)\ A\_2\%2\ \[Delta]\_3\)\/\(15
                    \ \[Omega]\_1\%2\) - 
                \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2 + 
                        I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Delta]\_2\ 
                    \[CapitalLambda]\_2\)\/\[Omega]\_1\%2 + 
                \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2 + 
                        I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Delta]\_2\ 
                    \[CapitalLambda]\_2\)\/\(3\ \[Omega]\_1\%2\) - 
                \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2 + 
                        I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\)\/\(2\ \[Omega]\_1\%2\) + 
                \(E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2 + 
                        I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\)\/\(4\ \[Omega]\_1\%2\) - 
                \(2\ \[Delta]\_3\ \[CapitalLambda]\_2\%2\)\/\[Omega]\_1\%2 + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega] - 2\ I\ \[Tau]\_2\)\ 
                    \[Delta]\_3\ \[CapitalLambda]\_2\%2\)\/\(3\ 
                    \[Omega]\_1\%2\) + 
                \(E\^\(2\ I\ T\_0\ \[CapitalOmega] + 2\ I\ \[Tau]\_2\)\ 
                    \[Delta]\_3\ \[CapitalLambda]\_2\%2\)\/\(3\ 
                    \[Omega]\_1\%2\) - 
                \(I\ E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Mu]\_1\)\/\(2\ 
                    \[Omega]\_1\) - 
                \(6\ A\_1\ \[Delta]\_1\ A\&_\_1\)\/\[Omega]\_1\%2 - 
                \(E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                    A\_2\ \[Delta]\_2\ A\&_\_1\)\/\(2\ \[Omega]\_1\%2\) + 
                \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2 - 
                        I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ 
                    \[CapitalLambda]\_2\ A\&_\_1\)\/\(3\ \[Omega]\_1\%2\) - 
                \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2 - 
                        I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ 
                    \[CapitalLambda]\_2\ A\&_\_1\)\/\[Omega]\_1\%2 + 
                \(I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ \[Mu]\_1\ 
                    A\&_\_1\)\/\(2\ \[Omega]\_1\) + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ 
                    A\&_\_1\%2\)\/\[Omega]\_1\%2 - 
                \(E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ A\_1\ 
                    \[Delta]\_2\ A\&_\_2\)\/\(2\ \[Omega]\_1\%2\) - 
                \(2\ A\_2\ \[Delta]\_3\ A\&_\_2\)\/\[Omega]\_1\%2 + 
                \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2 - 
                        I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\ A\&_\_2\)\/\(4\ \[Omega]\_1\%2\) - 
                \(E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2 - 
                        I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\ A\&_\_2\)\/\(2\ \[Omega]\_1\%2\) + 
                \(E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                    \[Delta]\_2\ A\&_\_1\ A\&_\_2\)\/\(4\ \[Omega]\_1\%2\) + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ 
                    A\&_\_2\%2\)\/\(15\ \[Omega]\_1\%2\))\), 
      u\_2[t] == 
        \[Epsilon]\ 
            \((E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2 + 
                E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2\)\ 
                  \[CapitalLambda]\_2 + 
                E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2\)\ 
                  \[CapitalLambda]\_2 + 
                E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ A\&_\_2)\) + 
          \[Epsilon]\^2\ 
            \((\(-\(\(E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ A\_1\%2\ 
                        \[Delta]\_2\)\/\(16\ \[Omega]\_1\%2\)\)\) + 
                \(2\ E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                    A\_1\ A\_2\ \[Delta]\_3\)\/\(5\ \[Omega]\_1\%2\) + 
                \(E\^\(2\ I\ T\_0\ \[Omega]\_2\)\ A\_2\%2\ \[Delta]\_4\)\/\(4
                    \ \[Omega]\_1\%2\) - 
                \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2 + 
                        I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\)\/\(2\ \[Omega]\_1\%2\) - 
                \(E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2 + 
                        I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\)\/\(8\ \[Omega]\_1\%2\) - 
                \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2 + 
                        I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Delta]\_4\ 
                    \[CapitalLambda]\_2\)\/\[Omega]\_1\%2 + 
                \(6\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2 + 
                        I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Delta]\_4\ 
                    \[CapitalLambda]\_2\)\/\(5\ \[Omega]\_1\%2\) - 
                \(3\ \[Delta]\_4\ \[CapitalLambda]\_2\%2\)\/\(2\ 
                    \[Omega]\_1\%2\) - 
                \(3\ E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega] - 
                        2\ I\ \[Tau]\_2\)\ \[Delta]\_4\ 
                    \[CapitalLambda]\_2\%2\)\/\(16\ \[Omega]\_1\%2\) - 
                \(3\ E\^\(2\ I\ T\_0\ \[CapitalOmega] + 2\ I\ \[Tau]\_2\)\ 
                    \[Delta]\_4\ \[CapitalLambda]\_2\%2\)\/\(16\ 
                    \[Omega]\_1\%2\) - 
                \(I\ E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Mu]\_2\)\/\(4\ 
                    \[Omega]\_1\) + 
                \(2\ I\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2\)\ 
                    \[CapitalLambda]\_2\ \[Mu]\_2\)\/\(3\ \[Omega]\_1\) - 
                \(2\ I\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2\)\ 
                    \[CapitalLambda]\_2\ \[Mu]\_2\)\/\(3\ \[Omega]\_1\) - 
                \(A\_1\ \[Delta]\_2\ A\&_\_1\)\/\(2\ \[Omega]\_1\%2\) - 
                \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                    A\_2\ \[Delta]\_3\ A\&_\_1\)\/\(3\ \[Omega]\_1\%2\) - 
                \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2 - 
                        I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\ A\&_\_1\)\/\(8\ \[Omega]\_1\%2\) - 
                \(E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2 - 
                        I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\ A\&_\_1\)\/\(2\ \[Omega]\_1\%2\) - 
                \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ 
                    A\&_\_1\%2\)\/\(16\ \[Omega]\_1\%2\) - 
                \(2\ E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                    A\_1\ \[Delta]\_3\ A\&_\_2\)\/\(3\ \[Omega]\_1\%2\) - 
                \(3\ A\_2\ \[Delta]\_4\ A\&_\_2\)\/\(2\ \[Omega]\_1\%2\) + 
                \(6\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2 - 
                        I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_4\ 
                    \[CapitalLambda]\_2\ A\&_\_2\)\/\(5\ \[Omega]\_1\%2\) - 
                \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2 - 
                        I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_4\ 
                    \[CapitalLambda]\_2\ A\&_\_2\)\/\[Omega]\_1\%2 + 
                \(I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ \[Mu]\_2\ 
                    A\&_\_2\)\/\(4\ \[Omega]\_1\) + 
                \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                    \[Delta]\_3\ A\&_\_1\ A\&_\_2\)\/\(5\ \[Omega]\_1\%2\) + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_4\ 
                    A\&_\_2\%2\)\/\(4\ \[Omega]\_1\%2\))\)}\)], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\!\\(\\* StyleBox[\\(where\\), FontColor->RGBColor[0, 0, 1]]\\)\"\>"],
   "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \("\!\(\[CapitalLambda]\_i\)==\!\(f\_i\/\(2 \((\[Omega]\_i\%2 - \
\[CapitalOmega]\^2)\)\)\)"\)], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\n\\!\\(\\* StyleBox[\\(The\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(modulation\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(equations\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* \
StyleBox[\\(:\\), FontColor->RGBColor[0, 0, 1]]\\)\"\>"], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{"2", " ", "I", " ", \(\[Omega]\_1\), " ", 
            SubsuperscriptBox["A", "1", "\[Prime]",
              MultilineFunction->None]}], "==", 
          \(2\ I\ \[Epsilon]\ \[Omega]\_1\ 
              \((\(-A\_1\)\ \[Mu]\_1 - 
                  \(I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ f\_1\)\/\(4
                      \ \[Omega]\_1\) + 
                  \(I\ E\^\(I\ T\_1\ \[Sigma]\_1 - I\ T\_1\ \[Sigma]\_2 - 
                          I\ \[Tau]\_2\)\ A\_2\ \[Delta]\_3\ 
                      \[CapitalLambda]\_2\)\/\[Omega]\_1 + 
                  \(I\ E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_2\ \[Delta]\_2\ 
                      A\&_\_1\)\/\[Omega]\_1)\) + 
            2\ I\ \[Epsilon]\^2\ \[Omega]\_1\ 
              \((\(I\ E\^\(I\ T\_1\ \[Sigma]\_1 - I\ T\_1\ \[Sigma]\_2 - 
                          I\ \[Tau]\_1\)\ A\_2\ f\_1\ \[Delta]\_2\)\/\(8\ 
                      \[Omega]\_1\%3\) - 
                  \(5\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_2\)\ 
                      A\_1\%2\ \[Delta]\_1\ \[Delta]\_2\ 
                      \[CapitalLambda]\_2\)\/\[Omega]\_1\%3 - 
                  \(9\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_2\)\ 
                      A\_1\%2\ \[Delta]\_2\ \[Delta]\_3\ 
                      \[CapitalLambda]\_2\)\/\(16\ \[Omega]\_1\%3\) - 
                  \(4\ I\ A\_1\ \[Delta]\_2\%2\ \[CapitalLambda]\_2\%2\)\/\(3
                      \ \[Omega]\_1\%3\) - 
                  \(6\ I\ A\_1\ \[Delta]\_1\ \[Delta]\_3\ 
                      \[CapitalLambda]\_2\%2\)\/\[Omega]\_1\%3 - 
                  \(5\ I\ A\_1\ \[Delta]\_3\%2\ \[CapitalLambda]\_2\%2\)\/\(8
                      \ \[Omega]\_1\%3\) - 
                  \(3\ I\ A\_1\ \[Delta]\_2\ \[Delta]\_4\ 
                      \[CapitalLambda]\_2\%2\)\/\(2\ \[Omega]\_1\%3\) - 
                  \(5\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ 
                      \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_2\%3\)\/\(3
                      \ \[Omega]\_1\%3\) - 
                  \(27\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ 
                      \[Delta]\_3\ \[Delta]\_4\ \[CapitalLambda]\_2\%3\)\/\(16
                      \ \[Omega]\_1\%3\) + 
                  \(E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ f\_1\ 
                      \[Mu]\_1\)\/\(8\ \[Omega]\_1\%2\) - 
                  \(E\^\(I\ T\_1\ \[Sigma]\_1 - I\ T\_1\ \[Sigma]\_2 - 
                          I\ \[Tau]\_2\)\ A\_2\ \[Delta]\_3\ 
                      \[CapitalLambda]\_2\ \[Mu]\_1\)\/\(2\ 
                      \[Omega]\_1\%2\) - 
                  \(5\ E\^\(I\ T\_1\ \[Sigma]\_1 - I\ T\_1\ \[Sigma]\_2 - 
                          I\ \[Tau]\_2\)\ A\_2\ \[Delta]\_3\ 
                      \[CapitalLambda]\_2\ \[Mu]\_2\)\/\(12\ 
                      \[Omega]\_1\%2\) + 
                  \(3\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_2\)\ 
                      A\_1\%2\ \[Alpha]\_2\ \[CapitalLambda]\_2\)\/\(2\ 
                      \[Omega]\_1\) + 
                  \(2\ I\ A\_1\ \[Alpha]\_3\ 
                      \[CapitalLambda]\_2\%2\)\/\[Omega]\_1 + 
                  \(3\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ 
                      \[Alpha]\_4\ \[CapitalLambda]\_2\%3\)\/\(2\ 
                      \[Omega]\_1\) - 
                  \(I\ A\_1\ \[Mu]\_1\%2\)\/\(2\ \[Omega]\_1\) - 
                  \(15\ I\ A\_1\%2\ \[Delta]\_1\%2\ A\&_\_1\)\/\[Omega]\_1
                      \%3 - \(9\ I\ A\_1\%2\ \[Delta]\_2\%2\ A\&_\_1\)\/\(16\ 
                      \[Omega]\_1\%3\) - 
                  \(10\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ A\_1\ 
                      \[Delta]\_1\ \[Delta]\_2\ \[CapitalLambda]\_2\ 
                      A\&_\_1\)\/\[Omega]\_1\%3 - 
                  \(9\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ A\_1\ 
                      \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_2\ 
                      A\&_\_1\)\/\(8\ \[Omega]\_1\%3\) - 
                  \(2\ I\ E\^\(2\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ \[Tau]\_2\)\ 
                      \[Delta]\_2\%2\ \[CapitalLambda]\_2\%2\ 
                      A\&_\_1\)\/\[Omega]\_1\%3 + 
                  \(I\ E\^\(2\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ \[Tau]\_2\)\ 
                      \[Delta]\_1\ \[Delta]\_3\ \[CapitalLambda]\_2\%2\ 
                      A\&_\_1\)\/\[Omega]\_1\%3 - 
                  \(I\ E\^\(2\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ \[Tau]\_2\)\ 
                      \[Delta]\_3\%2\ \[CapitalLambda]\_2\%2\ A\&_\_1\)\/\(2\ 
                      \[Omega]\_1\%3\) - 
                  \(3\ I\ E\^\(2\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ \[Tau]\_2\)\ 
                      \[Delta]\_2\ \[Delta]\_4\ \[CapitalLambda]\_2\%2\ 
                      A\&_\_1\)\/\(16\ \[Omega]\_1\%3\) - 
                  \(E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_2\ \[Delta]\_2\ \[Mu]\_1\ 
                      A\&_\_1\)\/\[Omega]\_1\%2 + 
                  \(E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_2\ \[Delta]\_2\ \[Mu]\_2\ 
                      A\&_\_1\)\/\(4\ \[Omega]\_1\%2\) + 
                  \(6\ I\ A\_1\%2\ \[Alpha]\_1\ A\&_\_1\)\/\[Omega]\_1 + 
                  \(3\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ A\_1\ 
                      \[Alpha]\_2\ \[CapitalLambda]\_2\ 
                      A\&_\_1\)\/\[Omega]\_1 + 
                  \(I\ E\^\(2\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ \[Tau]\_2\)\ 
                      \[Alpha]\_3\ \[CapitalLambda]\_2\%2\ 
                      A\&_\_1\)\/\[Omega]\_1 - 
                  \(I\ A\_1\ A\_2\ \[Delta]\_2\%2\ A\&_\_2\)\/\(4\ 
                      \[Omega]\_1\%3\) - 
                  \(6\ I\ A\_1\ A\_2\ \[Delta]\_1\ \[Delta]\_3\ 
                      A\&_\_2\)\/\[Omega]\_1\%3 - 
                  \(4\ I\ A\_1\ A\_2\ \[Delta]\_3\%2\ A\&_\_2\)\/\(15\ 
                      \[Omega]\_1\%3\) - 
                  \(3\ I\ A\_1\ A\_2\ \[Delta]\_2\ \[Delta]\_4\ A\&_\_2\)\/\(2
                      \ \[Omega]\_1\%3\) - 
                  \(9\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ A\_2\ 
                      \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_2\ 
                      A\&_\_2\)\/\(4\ \[Omega]\_1\%3\) - 
                  \(23\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ A\_2\ 
                      \[Delta]\_3\ \[Delta]\_4\ \[CapitalLambda]\_2\ 
                      A\&_\_2\)\/\(10\ \[Omega]\_1\%3\) + 
                  \(2\ I\ A\_1\ A\_2\ \[Alpha]\_3\ A\&_\_2\)\/\[Omega]\_1 + 
                  \(3\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ A\_2\ 
                      \[Alpha]\_4\ \[CapitalLambda]\_2\ 
                      A\&_\_2\)\/\[Omega]\_1)\)\)}], ",", 
        RowBox[{
          RowBox[{"2", " ", "I", " ", \(\[Omega]\_2\), " ", 
            SubsuperscriptBox["A", "2", "\[Prime]",
              MultilineFunction->None]}], "==", 
          \(2\ I\ \[Epsilon]\ 
              \((\(-A\_2\)\ \[Mu]\_2 + 
                  \(I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\%2\ 
                      \[Delta]\_2\)\/\(2\ \[Omega]\_2\) + 
                  \(I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1 + 
                          I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ A\_1\ 
                      \[Delta]\_3\ \[CapitalLambda]\_2\)\/\[Omega]\_2 + 
                  \(3\ I\ E
                        \^\(\(-I\)\ T\_1\ \[Sigma]\_1 + 
                          2\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ \[Tau]\_2\)\ 
                      \[Delta]\_4\ \[CapitalLambda]\_2\%2\)\/\(2\ 
                      \[Omega]\_2\))\)\ \[Omega]\_2 + 
            2\ I\ \[Epsilon]\^2\ \[Omega]\_2\ 
              \((\(-\(\(E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\%2\ 
                          \[Delta]\_2\ \[Mu]\_2\)\/\(16\ 
                          \[Omega]\_1\%2\)\)\) - 
                  \(E\^\(\(-I\)\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2 + 
                          I\ \[Tau]\_2\)\ A\_1\ \[Delta]\_3\ 
                      \[CapitalLambda]\_2\ \[Mu]\_2\)\/\(8\ 
                      \[Omega]\_1\%2\) - 
                  \(3\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1 + 
                          2\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ \[Tau]\_2\)\ 
                      \[Delta]\_4\ \[CapitalLambda]\_2\%2\ \[Mu]\_2\)\/\(16\ 
                      \[Omega]\_1\%2\) - 
                  \(I\ A\_2\ \[Mu]\_2\%2\)\/\(4\ \[Omega]\_1\) + 
                  \(3\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_2\)\ 
                      A\_1\ A\_2\ \[Alpha]\_4\ 
                      \[CapitalLambda]\_2\)\/\[Omega]\_2 + 
                  \(12\ I\ A\_2\ \[Alpha]\_5\ 
                      \[CapitalLambda]\_2\%2\)\/\[Omega]\_2 + 
                  \(I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1 + 
                          I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ f\_1\ 
                      \[Delta]\_2\)\/\(8\ \[Omega]\_1\%2\ \[Omega]\_2\) + 
                  \(I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1 + 
                          2\ I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1 + 
                          I\ \[Tau]\_2\)\ f\_1\ \[Delta]\_3\ 
                      \[CapitalLambda]\_2\)\/\(8\ \[Omega]\_1\%2\ 
                      \[Omega]\_2\) - 
                  \(9\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_2\)\ 
                      A\_1\ A\_2\ \[Delta]\_2\ \[Delta]\_3\ 
                      \[CapitalLambda]\_2\)\/\(4\ \[Omega]\_1\%2\ 
                      \[Omega]\_2\) - 
                  \(23\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 - I\ \[Tau]\_2\)\ 
                      A\_1\ A\_2\ \[Delta]\_3\ \[Delta]\_4\ 
                      \[CapitalLambda]\_2\)\/\(10\ \[Omega]\_1\%2\ 
                      \[Omega]\_2\) - 
                  \(9\ I\ A\_2\ \[Delta]\_3\%2\ \[CapitalLambda]\_2\%2\)\/\(4
                      \ \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(69\ I\ A\_2\ \[Delta]\_4\%2\ 
                      \[CapitalLambda]\_2\%2\)\/\(10\ \[Omega]\_1\%2\ 
                      \[Omega]\_2\) + 
                  \(E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\%2\ \[Delta]\_2\ 
                      \[Mu]\_1\)\/\(2\ \[Omega]\_1\ \[Omega]\_2\) + 
                  \(E\^\(\(-I\)\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2 + 
                          I\ \[Tau]\_2\)\ A\_1\ \[Delta]\_3\ 
                      \[CapitalLambda]\_2\ \[Mu]\_1\)\/\(2\ \[Omega]\_1\ 
                      \[Omega]\_2\) + 
                  \(2\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1 + 
                          I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ A\_1\ 
                      \[Delta]\_3\ \[CapitalLambda]\_2\ \[Mu]\_2\)\/\(3\ 
                      \[Omega]\_1\ \[Omega]\_2\) + 
                  \(2\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1 + 
                          2\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ \[Tau]\_2\)\ 
                      \[Delta]\_4\ \[CapitalLambda]\_2\%2\ 
                      \[Mu]\_2\)\/\(\[Omega]\_1\ \[Omega]\_2\) + 
                  \(2\ I\ A\_1\ A\_2\ \[Alpha]\_3\ A\&_\_1\)\/\[Omega]\_2 + 
                  \(3\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ A\_2\ 
                      \[Alpha]\_4\ \[CapitalLambda]\_2\ 
                      A\&_\_1\)\/\[Omega]\_2 - 
                  \(I\ A\_1\ A\_2\ \[Delta]\_2\%2\ A\&_\_1\)\/\(4\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(6\ I\ A\_1\ A\_2\ \[Delta]\_1\ \[Delta]\_3\ 
                      A\&_\_1\)\/\(\[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(4\ I\ A\_1\ A\_2\ \[Delta]\_3\%2\ A\&_\_1\)\/\(15\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(3\ I\ A\_1\ A\_2\ \[Delta]\_2\ \[Delta]\_4\ A\&_\_1\)\/\(2
                      \ \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(9\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ A\_2\ 
                      \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_2\ 
                      A\&_\_1\)\/\(4\ \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(23\ I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ A\_2\ 
                      \[Delta]\_3\ \[Delta]\_4\ \[CapitalLambda]\_2\ 
                      A\&_\_1\)\/\(10\ \[Omega]\_1\%2\ \[Omega]\_2\) + 
                  \(6\ I\ A\_2\%2\ \[Alpha]\_5\ A\&_\_2\)\/\[Omega]\_2 - 
                  \(29\ I\ A\_2\%2\ \[Delta]\_3\%2\ A\&_\_2\)\/\(15\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(15\ I\ A\_2\%2\ \[Delta]\_4\%2\ A\&_\_2\)\/\(4\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\))\)\)}]}], "}"}]], "Print",\

  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({60.3600000000000047`\ Second, Null}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "6.1.4 ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[CapitalOmega] \[TildeTilde] \[Omega]\_1 + \[Omega]\_2\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\_2 \[TildeTilde] 2  \[Omega]\_1\)]]
}], "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
In this case, we have a combination resonance and a two-to-one internal \
resonance. We let\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(scaling4 = {\[Mu]\&^\_n_ -> \[Epsilon]\ \[Mu]\_n, 
        F\_1 -> \[Epsilon]\ f\_1, F\_2 -> \[Epsilon]\ f\_2}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(ResonanceCond4 = {
        \[Omega]\_2 == 2  \[Omega]\_1 + \[Epsilon]\ \[Sigma]\_1, 
        \[CapitalOmega] == 
          \[Omega]\_1 + \[Omega]\_2 + \[Epsilon]\ \[Sigma]\_2}; \)\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Using ",
  StyleBox["MMS",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain the second-order approximate solution and the two equations \
governing the modulation of the complex-valued functions ",
  Cell[BoxData[
      \(TraditionalForm\`A\_k\)]],
  ":"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(MMS[scaling4, ResonanceCond4] // Timing\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\!\\(\\* StyleBox[\\(The\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(second\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* \
StyleBox[\\(-\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* StyleBox[\\(order\
\\), FontColor->RGBColor[0, 0, 1]]\\) \\!\\(\\* StyleBox[\\(approximate\\), \
FontColor->RGBColor[0, 0, 1]]\\) \\!\\(\\* StyleBox[\\(solution\\), \
FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* StyleBox[\\(:\\), \
FontColor->RGBColor[0, 0, 1]]\\)\"\>"], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u\_1[t] == 
        \[Epsilon]\ 
            \((E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1 + 
                E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1\)\ 
                  \[CapitalLambda]\_1 + 
                E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1\)\ 
                  \[CapitalLambda]\_1 + 
                E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ A\&_\_1)\) + 
          \[Epsilon]\^2\ 
            \((\(E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ A\_1\%2\ 
                    \[Delta]\_1\)\/\[Omega]\_1\%2 + 
                \(E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                    A\_1\%2\ \[Delta]\_2\)\/\(4\ \[Omega]\_1\%2\) + 
                \(E\^\(2\ I\ T\_0\ \[Omega]\_2\)\ A\_1\%2\ \[Delta]\_3\)\/\(15
                    \ \[Omega]\_1\%2\) + 
                \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
                        I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Delta]\_1\ 
                    \[CapitalLambda]\_1\)\/\[Omega]\_1\%2 + 
                \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                        I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Delta]\_1\ 
                    \[CapitalLambda]\_1\)\/\(5\ \[Omega]\_1\%2\) - 
                \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
                        I\ T\_0\ \[Omega]\_2\)\ A\_1\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\)\/\(2\ \[Omega]\_1\%2\) + 
                \(E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                        I\ T\_0\ \[Omega]\_2\)\ A\_1\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\)\/\(12\ \[Omega]\_1\%2\) - 
                \(6\ \[Delta]\_1\ \[CapitalLambda]\_1\%2\)\/\[Omega]\_1\%2 + 
                \(3\ E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega] - 
                        2\ I\ \[Tau]\_1\)\ \[Delta]\_1\ 
                    \[CapitalLambda]\_1\%2\)\/\(35\ \[Omega]\_1\%2\) + 
                \(3\ E\^\(2\ I\ T\_0\ \[CapitalOmega] + 2\ I\ \[Tau]\_1\)\ 
                    \[Delta]\_1\ \[CapitalLambda]\_1\%2\)\/\(35\ 
                    \[Omega]\_1\%2\) + 
                \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2 + 
                        I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Delta]\_2\ 
                    \[CapitalLambda]\_2\)\/\(3\ \[Omega]\_1\%2\) + 
                \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2 + 
                        I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Delta]\_2\ 
                    \[CapitalLambda]\_2\)\/\(15\ \[Omega]\_1\%2\) - 
                \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2 + 
                        I\ T\_0\ \[Omega]\_2\)\ A\_1\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\)\/\(2\ \[Omega]\_1\%2\) + 
                \(E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2 + 
                        I\ T\_0\ \[Omega]\_2\)\ A\_1\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\)\/\(12\ \[Omega]\_1\%2\) + 
                \(2\ E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                        I\ \[Tau]\_2\)\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
                    \[CapitalLambda]\_2\)\/\(35\ \[Omega]\_1\%2\) - 
                \(2\ E\^\(I\ \[Tau]\_1 - I\ \[Tau]\_2\)\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\ \[CapitalLambda]\_2\)\/\[Omega]\_1
                    \%2 - \(2\ E\^\(\(-I\)\ \[Tau]\_1 + I\ \[Tau]\_2\)\ 
                    \[Delta]\_2\ \[CapitalLambda]\_1\ 
                    \[CapitalLambda]\_2\)\/\[Omega]\_1\%2 + 
                \(2\ E\^\(2\ I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                        I\ \[Tau]\_2\)\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
                    \[CapitalLambda]\_2\)\/\(35\ \[Omega]\_1\%2\) - 
                \(2\ \[Delta]\_3\ \[CapitalLambda]\_2\%2\)\/\[Omega]\_1\%2 + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega] - 2\ I\ \[Tau]\_2\)\ 
                    \[Delta]\_3\ \[CapitalLambda]\_2\%2\)\/\(35\ 
                    \[Omega]\_1\%2\) + 
                \(E\^\(2\ I\ T\_0\ \[CapitalOmega] + 2\ I\ \[Tau]\_2\)\ 
                    \[Delta]\_3\ \[CapitalLambda]\_2\%2\)\/\(35\ 
                    \[Omega]\_1\%2\) - 
                \(I\ E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Mu]\_1\)\/\(2\ 
                    \[Omega]\_1\) - 
                \(3\ I\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1\)\ 
                    \[CapitalLambda]\_1\ \[Mu]\_1\)\/\(4\ \[Omega]\_1\) + 
                \(3\ I\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1\)\ 
                    \[CapitalLambda]\_1\ \[Mu]\_1\)\/\(4\ \[Omega]\_1\) - 
                \(6\ A\_1\ \[Delta]\_1\ A\&_\_1\)\/\[Omega]\_1\%2 - 
                \(E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ A\_1\ 
                    \[Delta]\_2\ A\&_\_1\)\/\(2\ \[Omega]\_1\%2\) - 
                \(E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                    A\_1\ \[Delta]\_2\ A\&_\_1\)\/\(2\ \[Omega]\_1\%2\) - 
                \(2\ A\_1\ \[Delta]\_3\ A\&_\_1\)\/\[Omega]\_1\%2 + 
                \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                        I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ 
                    \[CapitalLambda]\_1\ A\&_\_1\)\/\(5\ \[Omega]\_1\%2\) + 
                \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
                        I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ 
                    \[CapitalLambda]\_1\ A\&_\_1\)\/\[Omega]\_1\%2 + 
                \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                        I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\ A\&_\_1\)\/\(12\ \[Omega]\_1\%2\) - 
                \(E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
                        I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\ A\&_\_1\)\/\(2\ \[Omega]\_1\%2\) + 
                \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2 - 
                        I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ 
                    \[CapitalLambda]\_2\ A\&_\_1\)\/\(15\ \[Omega]\_1\%2\) + 
                \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2 - 
                        I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ 
                    \[CapitalLambda]\_2\ A\&_\_1\)\/\(3\ \[Omega]\_1\%2\) + 
                \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2 - 
                        I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\ A\&_\_1\)\/\(12\ \[Omega]\_1\%2\) - 
                \(E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2 - 
                        I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\ A\&_\_1\)\/\(2\ \[Omega]\_1\%2\) + 
                \(I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ \[Mu]\_1\ 
                    A\&_\_1\)\/\(2\ \[Omega]\_1\) + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ 
                    A\&_\_1\%2\)\/\[Omega]\_1\%2 + 
                \(E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                    \[Delta]\_2\ A\&_\_1\%2\)\/\(4\ \[Omega]\_1\%2\) + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ 
                    A\&_\_1\%2\)\/\(15\ \[Omega]\_1\%2\))\), 
      u\_2[t] == 
        \[Epsilon]\ 
            \((E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2 + 
                E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2\)\ 
                  \[CapitalLambda]\_2 + 
                E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2\)\ 
                  \[CapitalLambda]\_2 + 
                E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ A\&_\_2)\) + 
          \[Epsilon]\^2\ 
            \((\(-\(\(E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ A\_2\%2\ 
                        \[Delta]\_2\)\/\(16\ \[Omega]\_1\%2\)\)\) + 
                \(2\ E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                    A\_2\%2\ \[Delta]\_3\)\/\(5\ \[Omega]\_1\%2\) + 
                \(E\^\(2\ I\ T\_0\ \[Omega]\_2\)\ A\_2\%2\ \[Delta]\_4\)\/\(4
                    \ \[Omega]\_1\%2\) - 
                \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
                        I\ T\_0\ \[Omega]\_1\)\ A\_2\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\)\/\(8\ \[Omega]\_1\%2\) + 
                \(E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                        I\ T\_0\ \[Omega]\_1\)\ A\_2\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\)\/\(6\ \[Omega]\_1\%2\) - 
                \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
                        I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Delta]\_3\ 
                    \[CapitalLambda]\_1\)\/\(3\ \[Omega]\_1\%2\) + 
                \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                        I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Delta]\_3\ 
                    \[CapitalLambda]\_1\)\/\(21\ \[Omega]\_1\%2\) - 
                \(\[Delta]\_2\ \[CapitalLambda]\_1\%2\)\/\(2\ 
                    \[Omega]\_1\%2\) + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega] - 2\ I\ \[Tau]\_1\)\ 
                    \[Delta]\_2\ \[CapitalLambda]\_1\%2\)\/\(32\ 
                    \[Omega]\_1\%2\) + 
                \(E\^\(2\ I\ T\_0\ \[CapitalOmega] + 2\ I\ \[Tau]\_1\)\ 
                    \[Delta]\_2\ \[CapitalLambda]\_1\%2\)\/\(32\ 
                    \[Omega]\_1\%2\) - 
                \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2 + 
                        I\ T\_0\ \[Omega]\_1\)\ A\_2\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\)\/\(8\ \[Omega]\_1\%2\) + 
                \(E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2 + 
                        I\ T\_0\ \[Omega]\_1\)\ A\_2\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\)\/\(6\ \[Omega]\_1\%2\) - 
                \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2 + 
                        I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Delta]\_4\ 
                    \[CapitalLambda]\_2\)\/\[Omega]\_1\%2 + 
                \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2 + 
                        I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Delta]\_4\ 
                    \[CapitalLambda]\_2\)\/\(7\ \[Omega]\_1\%2\) + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                        I\ \[Tau]\_2\)\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
                    \[CapitalLambda]\_2\)\/\(16\ \[Omega]\_1\%2\) - 
                \(E\^\(I\ \[Tau]\_1 - I\ \[Tau]\_2\)\ \[Delta]\_3\ 
                    \[CapitalLambda]\_1\ \[CapitalLambda]\_2\)\/\(2\ 
                    \[Omega]\_1\%2\) - 
                \(E\^\(\(-I\)\ \[Tau]\_1 + I\ \[Tau]\_2\)\ \[Delta]\_3\ 
                    \[CapitalLambda]\_1\ \[CapitalLambda]\_2\)\/\(2\ 
                    \[Omega]\_1\%2\) + 
                \(E\^\(2\ I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                        I\ \[Tau]\_2\)\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
                    \[CapitalLambda]\_2\)\/\(16\ \[Omega]\_1\%2\) - 
                \(3\ \[Delta]\_4\ \[CapitalLambda]\_2\%2\)\/\(2\ 
                    \[Omega]\_1\%2\) + 
                \(3\ E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega] - 
                        2\ I\ \[Tau]\_2\)\ \[Delta]\_4\ 
                    \[CapitalLambda]\_2\%2\)\/\(32\ \[Omega]\_1\%2\) + 
                \(3\ E\^\(2\ I\ T\_0\ \[CapitalOmega] + 2\ I\ \[Tau]\_2\)\ 
                    \[Delta]\_4\ \[CapitalLambda]\_2\%2\)\/\(32\ 
                    \[Omega]\_1\%2\) - 
                \(I\ E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Mu]\_2\)\/\(4\ 
                    \[Omega]\_1\) - 
                \(6\ I\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2\)\ 
                    \[CapitalLambda]\_2\ \[Mu]\_2\)\/\(5\ \[Omega]\_1\) + 
                \(6\ I\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2\)\ 
                    \[CapitalLambda]\_2\ \[Mu]\_2\)\/\(5\ \[Omega]\_1\) - 
                \(A\_2\ \[Delta]\_2\ A\&_\_2\)\/\(2\ \[Omega]\_1\%2\) - 
                \(2\ E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                    A\_2\ \[Delta]\_3\ A\&_\_2\)\/\(3\ \[Omega]\_1\%2\) - 
                \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                    A\_2\ \[Delta]\_3\ A\&_\_2\)\/\(3\ \[Omega]\_1\%2\) - 
                \(3\ A\_2\ \[Delta]\_4\ A\&_\_2\)\/\(2\ \[Omega]\_1\%2\) + 
                \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                        I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\ A\&_\_2\)\/\(6\ \[Omega]\_1\%2\) - 
                \(E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
                        I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\ A\&_\_2\)\/\(8\ \[Omega]\_1\%2\) + 
                \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                        I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ 
                    \[CapitalLambda]\_1\ A\&_\_2\)\/\(21\ \[Omega]\_1\%2\) - 
                \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
                        I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ 
                    \[CapitalLambda]\_1\ A\&_\_2\)\/\(3\ \[Omega]\_1\%2\) + 
                \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2 - 
                        I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\ A\&_\_2\)\/\(6\ \[Omega]\_1\%2\) - 
                \(E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2 - 
                        I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\ A\&_\_2\)\/\(8\ \[Omega]\_1\%2\) + 
                \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2 - 
                        I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_4\ 
                    \[CapitalLambda]\_2\ A\&_\_2\)\/\(7\ \[Omega]\_1\%2\) - 
                \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2 - 
                        I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_4\ 
                    \[CapitalLambda]\_2\ A\&_\_2\)\/\[Omega]\_1\%2 + 
                \(I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ \[Mu]\_2\ 
                    A\&_\_2\)\/\(4\ \[Omega]\_1\) - 
                \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ 
                    A\&_\_2\%2\)\/\(16\ \[Omega]\_1\%2\) + 
                \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                    \[Delta]\_3\ A\&_\_2\%2\)\/\(5\ \[Omega]\_1\%2\) + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_4\ 
                    A\&_\_2\%2\)\/\(4\ \[Omega]\_1\%2\))\)}\)], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\!\\(\\* StyleBox[\\(where\\), FontColor->RGBColor[0, 0, 1]]\\)\"\>"],
   "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \("\!\(\[CapitalLambda]\_i\)==\!\(f\_i\/\(2 \((\[Omega]\_i\%2 - \
\[CapitalOmega]\^2)\)\)\)"\)], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\n\\!\\(\\* StyleBox[\\(The\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(modulation\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(equations\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* \
StyleBox[\\(:\\), FontColor->RGBColor[0, 0, 1]]\\)\"\>"], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{"2", " ", "I", " ", \(\[Omega]\_1\), " ", 
            SubsuperscriptBox["A", "1", "\[Prime]",
              MultilineFunction->None]}], "==", 
          \(2\ I\ \[Epsilon]\^2\ \[Omega]\_1\ 
              \((\(-\(\(I\ 
                          E\^\(I\ T\_1\ \[Sigma]\_1 - I\ T\_1\ \[Sigma]\_2 - 
                              I\ \[Tau]\_1\)\ A\_2\%2\ \[Delta]\_2\%2\ 
                          \[CapitalLambda]\_1\)\/\(2\ \[Omega]\_1\%3\)\)\) + 
                  \(I\ E\^\(I\ T\_1\ \[Sigma]\_1 - I\ T\_1\ \[Sigma]\_2 - 
                          I\ \[Tau]\_1\)\ A\_2\%2\ \[Delta]\_1\ \[Delta]\_3\ 
                      \[CapitalLambda]\_1\)\/\(5\ \[Omega]\_1\%3\) - 
                  \(2\ I\ E
                        \^\(I\ T\_1\ \[Sigma]\_1 - I\ T\_1\ \[Sigma]\_2 - 
                          I\ \[Tau]\_1\)\ A\_2\%2\ \[Delta]\_3\%2\ 
                      \[CapitalLambda]\_1\)\/\(3\ \[Omega]\_1\%3\) + 
                  \(I\ E\^\(I\ T\_1\ \[Sigma]\_1 - I\ T\_1\ \[Sigma]\_2 - 
                          I\ \[Tau]\_1\)\ A\_2\%2\ \[Delta]\_2\ \[Delta]\_4\ 
                      \[CapitalLambda]\_1\)\/\(4\ \[Omega]\_1\%3\) - 
                  \(54\ I\ A\_1\ \[Delta]\_1\%2\ \[CapitalLambda]\_1\%2\)\/\(5
                      \ \[Omega]\_1\%3\) - 
                  \(11\ I\ A\_1\ \[Delta]\_2\%2\ 
                      \[CapitalLambda]\_1\%2\)\/\(24\ \[Omega]\_1\%3\) - 
                  \(13\ I\ 
                      E\^\(I\ T\_1\ \[Sigma]\_1 - I\ T\_1\ \[Sigma]\_2 - 
                          I\ \[Tau]\_2\)\ A\_2\%2\ \[Delta]\_2\ \[Delta]\_3\ 
                      \[CapitalLambda]\_2\)\/\(30\ \[Omega]\_1\%3\) - 
                  \(7\ I\ E
                        \^\(I\ T\_1\ \[Sigma]\_1 - I\ T\_1\ \[Sigma]\_2 - 
                          I\ \[Tau]\_2\)\ A\_2\%2\ \[Delta]\_3\ \[Delta]\_4\ 
                      \[CapitalLambda]\_2\)\/\(4\ \[Omega]\_1\%3\) - 
                  \(18\ I\ E\^\(I\ \[Tau]\_1 - I\ \[Tau]\_2\)\ A\_1\ 
                      \[Delta]\_1\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
                      \[CapitalLambda]\_2\)\/\(5\ \[Omega]\_1\%3\) - 
                  \(18\ I\ E\^\(\(-I\)\ \[Tau]\_1 + I\ \[Tau]\_2\)\ A\_1\ 
                      \[Delta]\_1\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
                      \[CapitalLambda]\_2\)\/\(5\ \[Omega]\_1\%3\) - 
                  \(11\ I\ E\^\(I\ \[Tau]\_1 - I\ \[Tau]\_2\)\ A\_1\ 
                      \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
                      \[CapitalLambda]\_2\)\/\(24\ \[Omega]\_1\%3\) - 
                  \(11\ I\ E\^\(\(-I\)\ \[Tau]\_1 + I\ \[Tau]\_2\)\ A\_1\ 
                      \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
                      \[CapitalLambda]\_2\)\/\(24\ \[Omega]\_1\%3\) + 
                  \(4\ I\ A\_1\ \[Delta]\_2\%2\ \[CapitalLambda]\_2\%2\)\/\(5
                      \ \[Omega]\_1\%3\) - 
                  \(6\ I\ A\_1\ \[Delta]\_1\ \[Delta]\_3\ 
                      \[CapitalLambda]\_2\%2\)\/\[Omega]\_1\%3 + 
                  \(I\ A\_1\ \[Delta]\_3\%2\ \[CapitalLambda]\_2\%2\)\/\(24\ 
                      \[Omega]\_1\%3\) - 
                  \(3\ I\ A\_1\ \[Delta]\_2\ \[Delta]\_4\ 
                      \[CapitalLambda]\_2\%2\)\/\(2\ \[Omega]\_1\%3\) + 
                  \(I\ E\^\(I\ T\_1\ \[Sigma]\_1 - I\ T\_1\ \[Sigma]\_2 - 
                          I\ \[Tau]\_1\)\ A\_2\%2\ \[Alpha]\_3\ 
                      \[CapitalLambda]\_1\)\/\[Omega]\_1 + 
                  \(12\ I\ A\_1\ \[Alpha]\_1\ 
                      \[CapitalLambda]\_1\%2\)\/\[Omega]\_1 + 
                  \(3\ I\ E
                        \^\(I\ T\_1\ \[Sigma]\_1 - I\ T\_1\ \[Sigma]\_2 - 
                          I\ \[Tau]\_2\)\ A\_2\%2\ \[Alpha]\_4\ 
                      \[CapitalLambda]\_2\)\/\(2\ \[Omega]\_1\) + 
                  \(3\ I\ E\^\(I\ \[Tau]\_1 - I\ \[Tau]\_2\)\ A\_1\ 
                      \[Alpha]\_2\ \[CapitalLambda]\_1\ 
                      \[CapitalLambda]\_2\)\/\[Omega]\_1 + 
                  \(3\ I\ E\^\(\(-I\)\ \[Tau]\_1 + I\ \[Tau]\_2\)\ A\_1\ 
                      \[Alpha]\_2\ \[CapitalLambda]\_1\ 
                      \[CapitalLambda]\_2\)\/\[Omega]\_1 + 
                  \(2\ I\ A\_1\ \[Alpha]\_3\ 
                      \[CapitalLambda]\_2\%2\)\/\[Omega]\_1 - 
                  \(I\ A\_1\ \[Mu]\_1\%2\)\/\(2\ \[Omega]\_1\) - 
                  \(15\ I\ A\_1\%2\ \[Delta]\_1\%2\ A\&_\_1\)\/\[Omega]\_1
                      \%3 - \(9\ I\ A\_1\%2\ \[Delta]\_2\%2\ A\&_\_1\)\/\(16\ 
                      \[Omega]\_1\%3\) - 
                  \(E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_2\ \[Delta]\_2\ \[Mu]\_1\ 
                      A\&_\_1\)\/\[Omega]\_1\%2 + 
                  \(E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_2\ \[Delta]\_2\ \[Mu]\_2\ 
                      A\&_\_1\)\/\(4\ \[Omega]\_1\%2\) + 
                  \(6\ I\ A\_1\%2\ \[Alpha]\_1\ A\&_\_1\)\/\[Omega]\_1 + 
                  \(9\ I\ E
                        \^\(I\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2 + 
                          I\ \[Tau]\_1\)\ \[Delta]\_1\%2\ 
                      \[CapitalLambda]\_1\ A\&_\_1\%2\)\/\[Omega]\_1\%3 - 
                  \(3\ I\ E
                        \^\(I\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2 + 
                          I\ \[Tau]\_1\)\ \[Delta]\_2\%2\ 
                      \[CapitalLambda]\_1\ A\&_\_1\%2\)\/\(16\ 
                      \[Omega]\_1\%3\) + 
                  \(3\ I\ E
                        \^\(I\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2 + 
                          I\ \[Tau]\_2\)\ \[Delta]\_1\ \[Delta]\_2\ 
                      \[CapitalLambda]\_2\ A\&_\_1\%2\)\/\[Omega]\_1\%3 - 
                  \(3\ I\ 
                      E\^\(I\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2 + 
                          I\ \[Tau]\_2\)\ \[Delta]\_2\ \[Delta]\_3\ 
                      \[CapitalLambda]\_2\ A\&_\_1\%2\)\/\(16\ 
                      \[Omega]\_1\%3\) + 
                  \(6\ I\ E
                        \^\(I\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2 + 
                          I\ \[Tau]\_1\)\ \[Alpha]\_1\ \[CapitalLambda]\_1\ 
                      A\&_\_1\%2\)\/\[Omega]\_1 + 
                  \(3\ I\ E
                        \^\(I\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2 + 
                          I\ \[Tau]\_2\)\ \[Alpha]\_2\ \[CapitalLambda]\_2\ 
                      A\&_\_1\%2\)\/\(2\ \[Omega]\_1\) - 
                  \(I\ A\_1\ A\_2\ \[Delta]\_2\%2\ A\&_\_2\)\/\(4\ 
                      \[Omega]\_1\%3\) - 
                  \(6\ I\ A\_1\ A\_2\ \[Delta]\_1\ \[Delta]\_3\ 
                      A\&_\_2\)\/\[Omega]\_1\%3 - 
                  \(4\ I\ A\_1\ A\_2\ \[Delta]\_3\%2\ A\&_\_2\)\/\(15\ 
                      \[Omega]\_1\%3\) - 
                  \(3\ I\ A\_1\ A\_2\ \[Delta]\_2\ \[Delta]\_4\ A\&_\_2\)\/\(2
                      \ \[Omega]\_1\%3\) - 
                  \(5\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ 
                      \[Delta]\_2\ \[CapitalLambda]\_1\ \[Mu]\_1\ 
                      A\&_\_2\)\/\(4\ \[Omega]\_1\%2\) - 
                  \(E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ \[Delta]\_3\ 
                      \[CapitalLambda]\_2\ \[Mu]\_1\ A\&_\_2\)\/\(2\ 
                      \[Omega]\_1\%2\) - 
                  \(E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ \[Delta]\_2\ 
                      \[CapitalLambda]\_1\ \[Mu]\_2\ A\&_\_2\)\/\(4\ 
                      \[Omega]\_1\%2\) - 
                  \(29\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ 
                      \[Delta]\_3\ \[CapitalLambda]\_2\ \[Mu]\_2\ 
                      A\&_\_2\)\/\(20\ \[Omega]\_1\%2\) + 
                  \(2\ I\ A\_1\ A\_2\ \[Alpha]\_3\ A\&_\_2\)\/\[Omega]\_1)
                \) + 2\ I\ \[Epsilon]\ \[Omega]\_1\ 
              \((\(-A\_1\)\ \[Mu]\_1 + 
                  \(I\ E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_2\ \[Delta]\_2\ 
                      A\&_\_1\)\/\[Omega]\_1 + 
                  \(I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ 
                      \[Delta]\_2\ \[CapitalLambda]\_1\ 
                      A\&_\_2\)\/\[Omega]\_1 + 
                  \(I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ 
                      \[Delta]\_3\ \[CapitalLambda]\_2\ 
                      A\&_\_2\)\/\[Omega]\_1)\)\)}], ",", 
        RowBox[{
          RowBox[{"2", " ", "I", " ", \(\[Omega]\_2\), " ", 
            SubsuperscriptBox["A", "2", "\[Prime]",
              MultilineFunction->None]}], "==", 
          \(2\ I\ \[Epsilon]\ \[Omega]\_2\ 
              \((\(-A\_2\)\ \[Mu]\_2 + 
                  \(I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\%2\ 
                      \[Delta]\_2\)\/\(2\ \[Omega]\_2\) + 
                  \(I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ 
                      \[Delta]\_2\ \[CapitalLambda]\_1\ 
                      A\&_\_1\)\/\[Omega]\_2 + 
                  \(I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ 
                      \[Delta]\_3\ \[CapitalLambda]\_2\ 
                      A\&_\_1\)\/\[Omega]\_2)\) + 
            2\ I\ \[Epsilon]\^2\ \[Omega]\_2\ 
              \((\(-\(\(E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\%2\ 
                          \[Delta]\_2\ \[Mu]\_2\)\/\(16\ 
                          \[Omega]\_1\%2\)\)\) - 
                  \(I\ A\_2\ \[Mu]\_2\%2\)\/\(4\ \[Omega]\_1\) + 
                  \(2\ I\ A\_2\ \[Alpha]\_3\ 
                      \[CapitalLambda]\_1\%2\)\/\[Omega]\_2 + 
                  \(3\ I\ E\^\(I\ \[Tau]\_1 - I\ \[Tau]\_2\)\ A\_2\ 
                      \[Alpha]\_4\ \[CapitalLambda]\_1\ 
                      \[CapitalLambda]\_2\)\/\[Omega]\_2 + 
                  \(3\ I\ E\^\(\(-I\)\ \[Tau]\_1 + I\ \[Tau]\_2\)\ A\_2\ 
                      \[Alpha]\_4\ \[CapitalLambda]\_1\ 
                      \[CapitalLambda]\_2\)\/\[Omega]\_2 + 
                  \(12\ I\ A\_2\ \[Alpha]\_5\ 
                      \[CapitalLambda]\_2\%2\)\/\[Omega]\_2 - 
                  \(5\ I\ A\_2\ \[Delta]\_2\%2\ \[CapitalLambda]\_1\%2\)\/\(12
                      \ \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(6\ I\ A\_2\ \[Delta]\_1\ \[Delta]\_3\ 
                      \[CapitalLambda]\_1\%2\)\/\(\[Omega]\_1\%2\ 
                      \[Omega]\_2\) - 
                  \(4\ I\ A\_2\ \[Delta]\_3\%2\ \[CapitalLambda]\_1\%2\)\/\(7
                      \ \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(3\ I\ A\_2\ \[Delta]\_2\ \[Delta]\_4\ 
                      \[CapitalLambda]\_1\%2\)\/\(2\ \[Omega]\_1\%2\ 
                      \[Omega]\_2\) - 
                  \(29\ I\ E\^\(I\ \[Tau]\_1 - I\ \[Tau]\_2\)\ A\_2\ 
                      \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
                      \[CapitalLambda]\_2\)\/\(12\ \[Omega]\_1\%2\ 
                      \[Omega]\_2\) - 
                  \(29\ I\ E\^\(\(-I\)\ \[Tau]\_1 + I\ \[Tau]\_2\)\ A\_2\ 
                      \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
                      \[CapitalLambda]\_2\)\/\(12\ \[Omega]\_1\%2\ 
                      \[Omega]\_2\) - 
                  \(45\ I\ E\^\(I\ \[Tau]\_1 - I\ \[Tau]\_2\)\ A\_2\ 
                      \[Delta]\_3\ \[Delta]\_4\ \[CapitalLambda]\_1\ 
                      \[CapitalLambda]\_2\)\/\(14\ \[Omega]\_1\%2\ 
                      \[Omega]\_2\) - 
                  \(45\ I\ E\^\(\(-I\)\ \[Tau]\_1 + I\ \[Tau]\_2\)\ A\_2\ 
                      \[Delta]\_3\ \[Delta]\_4\ \[CapitalLambda]\_1\ 
                      \[CapitalLambda]\_2\)\/\(14\ \[Omega]\_1\%2\ 
                      \[Omega]\_2\) - 
                  \(29\ I\ A\_2\ \[Delta]\_3\%2\ 
                      \[CapitalLambda]\_2\%2\)\/\(12\ \[Omega]\_1\%2\ 
                      \[Omega]\_2\) - 
                  \(135\ I\ A\_2\ \[Delta]\_4\%2\ 
                      \[CapitalLambda]\_2\%2\)\/\(14\ \[Omega]\_1\%2\ 
                      \[Omega]\_2\) + 
                  \(E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\%2\ \[Delta]\_2\ 
                      \[Mu]\_1\)\/\(2\ \[Omega]\_1\ \[Omega]\_2\) - 
                  \(E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ \[Delta]\_2\ 
                      \[CapitalLambda]\_1\ \[Mu]\_2\ A\&_\_1\)\/\(8\ 
                      \[Omega]\_1\%2\) - 
                  \(E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ \[Delta]\_3\ 
                      \[CapitalLambda]\_2\ \[Mu]\_2\ A\&_\_1\)\/\(8\ 
                      \[Omega]\_1\%2\) + 
                  \(2\ I\ A\_1\ A\_2\ \[Alpha]\_3\ A\&_\_1\)\/\[Omega]\_2 - 
                  \(I\ A\_1\ A\_2\ \[Delta]\_2\%2\ A\&_\_1\)\/\(4\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(6\ I\ A\_1\ A\_2\ \[Delta]\_1\ \[Delta]\_3\ 
                      A\&_\_1\)\/\(\[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(4\ I\ A\_1\ A\_2\ \[Delta]\_3\%2\ A\&_\_1\)\/\(15\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(3\ I\ A\_1\ A\_2\ \[Delta]\_2\ \[Delta]\_4\ A\&_\_1\)\/\(2
                      \ \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(5\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ 
                      \[Delta]\_2\ \[CapitalLambda]\_1\ \[Mu]\_1\ 
                      A\&_\_1\)\/\(4\ \[Omega]\_1\ \[Omega]\_2\) - 
                  \(E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ \[Delta]\_3\ 
                      \[CapitalLambda]\_2\ \[Mu]\_1\ A\&_\_1\)\/\(2\ 
                      \[Omega]\_1\ \[Omega]\_2\) - 
                  \(6\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ 
                      \[Delta]\_3\ \[CapitalLambda]\_2\ \[Mu]\_2\ 
                      A\&_\_1\)\/\(5\ \[Omega]\_1\ \[Omega]\_2\) + 
                  \(6\ I\ A\_2\%2\ \[Alpha]\_5\ A\&_\_2\)\/\[Omega]\_2 + 
                  \(2\ I\ E
                        \^\(\(-I\)\ T\_1\ \[Sigma]\_1 + 
                          I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                      \[Alpha]\_3\ \[CapitalLambda]\_1\ 
                      A\&_\_2\)\/\[Omega]\_2 + 
                  \(3\ I\ E
                        \^\(\(-I\)\ T\_1\ \[Sigma]\_1 + 
                          I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ A\_1\ 
                      \[Alpha]\_4\ \[CapitalLambda]\_2\ 
                      A\&_\_2\)\/\[Omega]\_2 - 
                  \(29\ I\ A\_2\%2\ \[Delta]\_3\%2\ A\&_\_2\)\/\(15\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(15\ I\ A\_2\%2\ \[Delta]\_4\%2\ A\&_\_2\)\/\(4\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1 + 
                          I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                      \[Delta]\_2\%2\ \[CapitalLambda]\_1\ 
                      A\&_\_2\)\/\(\[Omega]\_1\%2\ \[Omega]\_2\) + 
                  \(2\ I\ E
                        \^\(\(-I\)\ T\_1\ \[Sigma]\_1 + 
                          I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                      \[Delta]\_1\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
                      A\&_\_2\)\/\(5\ \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(4\ I\ E
                        \^\(\(-I\)\ T\_1\ \[Sigma]\_1 + 
                          I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                      \[Delta]\_3\%2\ \[CapitalLambda]\_1\ A\&_\_2\)\/\(3\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) + 
                  \(I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1 + 
                          I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                      \[Delta]\_2\ \[Delta]\_4\ \[CapitalLambda]\_1\ 
                      A\&_\_2\)\/\(2\ \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(13\ I\ 
                      E\^\(\(-I\)\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2 + 
                          I\ \[Tau]\_2\)\ A\_1\ \[Delta]\_2\ \[Delta]\_3\ 
                      \[CapitalLambda]\_2\ A\&_\_2\)\/\(15\ \[Omega]\_1\%2\ 
                      \[Omega]\_2\) - 
                  \(7\ I\ E
                        \^\(\(-I\)\ T\_1\ \[Sigma]\_1 + 
                          I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ A\_1\ 
                      \[Delta]\_3\ \[Delta]\_4\ \[CapitalLambda]\_2\ 
                      A\&_\_2\)\/\(2\ \[Omega]\_1\%2\ \[Omega]\_2\))\)\)}]}], 
      "}"}]], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({192.266000000000047`\ Second, Null}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "6.1.5 ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega] \[TildeTilde] \[Omega]\_2\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\_2 \[TildeTilde] 3  \[Omega]\_1\)]]
}], "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
In this case, we have a primary resonance of the second mode, a subharmonic \
resonance of the first mode, and a three-to-one internal resonance. We let\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(scaling5 = {\[Mu]\&^\_n_ -> \[Epsilon]\^2\ \[Mu]\_n, 
        F\_1 -> \[Epsilon]\ f\_1, F\_2 -> \[Epsilon]\^3\ f\_2}; \)\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(ResonanceCond5 = {
        \[Omega]\_2 == 3  \[Omega]\_1 + \[Epsilon]\^2\ \[Sigma]\_1, 
        \[CapitalOmega] == \[Omega]\_2 + \[Epsilon]\^2\ \[Sigma]\_2}; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Using ",
  StyleBox["MMS",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain the second-order approximate solution and the two equations \
governing the modulation of the complex-valued functions ",
  Cell[BoxData[
      \(TraditionalForm\`A\_k\)]],
  ":"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(MMS[scaling5, ResonanceCond5] // Timing\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\!\\(\\* StyleBox[\\(The\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(second\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* \
StyleBox[\\(-\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* StyleBox[\\(order\
\\), FontColor->RGBColor[0, 0, 1]]\\) \\!\\(\\* StyleBox[\\(approximate\\), \
FontColor->RGBColor[0, 0, 1]]\\) \\!\\(\\* StyleBox[\\(solution\\), \
FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* StyleBox[\\(:\\), \
FontColor->RGBColor[0, 0, 1]]\\)\"\>"], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u\_1[t] == 
        \[Epsilon]\ 
            \((E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1 + 
                E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1\)\ 
                  \[CapitalLambda]\_1 + 
                E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1\)\ 
                  \[CapitalLambda]\_1 + 
                E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ A\&_\_1)\) + 
          \[Epsilon]\^2\ 
            \((\(E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ A\_1\%2\ 
                    \[Delta]\_1\)\/\[Omega]\_1\%2 + 
                \(2\ E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                    A\_1\ A\_2\ \[Delta]\_2\)\/\(15\ \[Omega]\_1\%2\) + 
                \(E\^\(2\ I\ T\_0\ \[Omega]\_2\)\ A\_2\%2\ \[Delta]\_3\)\/\(35
                    \ \[Omega]\_1\%2\) + 
                \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
                        I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Delta]\_1\ 
                    \[CapitalLambda]\_1\)\/\[Omega]\_1\%2 + 
                \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                        I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Delta]\_1\ 
                    \[CapitalLambda]\_1\)\/\(5\ \[Omega]\_1\%2\) - 
                \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
                        I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\)\/\[Omega]\_1\%2 + 
                \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                        I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\)\/\(35\ \[Omega]\_1\%2\) - 
                \(6\ \[Delta]\_1\ \[CapitalLambda]\_1\%2\)\/\[Omega]\_1\%2 + 
                \(3\ E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega] - 
                        2\ I\ \[Tau]\_1\)\ \[Delta]\_1\ 
                    \[CapitalLambda]\_1\%2\)\/\(35\ \[Omega]\_1\%2\) + 
                \(3\ E\^\(2\ I\ T\_0\ \[CapitalOmega] + 2\ I\ \[Tau]\_1\)\ 
                    \[Delta]\_1\ \[CapitalLambda]\_1\%2\)\/\(35\ 
                    \[Omega]\_1\%2\) - 
                \(6\ A\_1\ \[Delta]\_1\ A\&_\_1\)\/\[Omega]\_1\%2 + 
                \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                    A\_2\ \[Delta]\_2\ A\&_\_1\)\/\(3\ \[Omega]\_1\%2\) + 
                \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                        I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ 
                    \[CapitalLambda]\_1\ A\&_\_1\)\/\(5\ \[Omega]\_1\%2\) + 
                \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
                        I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ 
                    \[CapitalLambda]\_1\ A\&_\_1\)\/\[Omega]\_1\%2 + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ 
                    A\&_\_1\%2\)\/\[Omega]\_1\%2 + 
                \(2\ E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                    A\_1\ \[Delta]\_2\ A\&_\_2\)\/\(3\ \[Omega]\_1\%2\) - 
                \(2\ A\_2\ \[Delta]\_3\ A\&_\_2\)\/\[Omega]\_1\%2 + 
                \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                        I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\ A\&_\_2\)\/\(35\ \[Omega]\_1\%2\) - 
                \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
                        I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\ A\&_\_2\)\/\[Omega]\_1\%2 + 
                \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                    \[Delta]\_2\ A\&_\_1\ A\&_\_2\)\/\(15\ \[Omega]\_1\%2\) + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ 
                    A\&_\_2\%2\)\/\(35\ \[Omega]\_1\%2\))\), 
      u\_2[t] == 
        \[Epsilon]\ 
            \((E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2 + 
                E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ A\&_\_2)\) + 
          \[Epsilon]\^2\ 
            \((\(-\(\(E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ A\_1\%2\ 
                        \[Delta]\_2\)\/\(5\ \[Omega]\_1\%2\)\)\) + 
                \(2\ E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                    A\_1\ A\_2\ \[Delta]\_3\)\/\(7\ \[Omega]\_1\%2\) + 
                \(E\^\(2\ I\ T\_0\ \[Omega]\_2\)\ A\_2\%2\ \[Delta]\_4\)\/\(9
                    \ \[Omega]\_1\%2\) - 
                \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
                        I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\)\/\(5\ \[Omega]\_1\%2\) + 
                \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                        I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\)\/\(7\ \[Omega]\_1\%2\) - 
                \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
                        I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Delta]\_3\ 
                    \[CapitalLambda]\_1\)\/\(9\ \[Omega]\_1\%2\) + 
                \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                        I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Delta]\_3\ 
                    \[CapitalLambda]\_1\)\/\(27\ \[Omega]\_1\%2\) - 
                \(2\ \[Delta]\_2\ \[CapitalLambda]\_1\%2\)\/\(9\ 
                    \[Omega]\_1\%2\) + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega] - 2\ I\ \[Tau]\_1\)\ 
                    \[Delta]\_2\ \[CapitalLambda]\_1\%2\)\/\(27\ 
                    \[Omega]\_1\%2\) + 
                \(E\^\(2\ I\ T\_0\ \[CapitalOmega] + 2\ I\ \[Tau]\_1\)\ 
                    \[Delta]\_2\ \[CapitalLambda]\_1\%2\)\/\(27\ 
                    \[Omega]\_1\%2\) - 
                \(2\ A\_1\ \[Delta]\_2\ A\&_\_1\)\/\(9\ \[Omega]\_1\%2\) - 
                \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                    A\_2\ \[Delta]\_3\ A\&_\_1\)\/\(5\ \[Omega]\_1\%2\) + 
                \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                        I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\ A\&_\_1\)\/\(7\ \[Omega]\_1\%2\) - 
                \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
                        I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\ A\&_\_1\)\/\(5\ \[Omega]\_1\%2\) - 
                \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ 
                    A\&_\_1\%2\)\/\(5\ \[Omega]\_1\%2\) - 
                \(2\ E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                    A\_1\ \[Delta]\_3\ A\&_\_2\)\/\(5\ \[Omega]\_1\%2\) - 
                \(2\ A\_2\ \[Delta]\_4\ A\&_\_2\)\/\(3\ \[Omega]\_1\%2\) + 
                \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                        I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ 
                    \[CapitalLambda]\_1\ A\&_\_2\)\/\(27\ \[Omega]\_1\%2\) - 
                \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
                        I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ 
                    \[CapitalLambda]\_1\ A\&_\_2\)\/\(9\ \[Omega]\_1\%2\) + 
                \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                    \[Delta]\_3\ A\&_\_1\ A\&_\_2\)\/\(7\ \[Omega]\_1\%2\) + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_4\ 
                    A\&_\_2\%2\)\/\(9\ \[Omega]\_1\%2\))\)}\)], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\!\\(\\* StyleBox[\\(where\\), FontColor->RGBColor[0, 0, 1]]\\)\"\>"],
   "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \("\!\(\[CapitalLambda]\_i\)==\!\(f\_i\/\(2 \((\[Omega]\_i\%2 - \
\[CapitalOmega]\^2)\)\)\)"\)], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\n\\!\\(\\* StyleBox[\\(The\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(modulation\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(equations\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* \
StyleBox[\\(:\\), FontColor->RGBColor[0, 0, 1]]\\)\"\>"], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{"2", " ", "I", " ", \(\[Omega]\_1\), " ", 
            SubsuperscriptBox["A", "1", "\[Prime]",
              MultilineFunction->None]}], "==", 
          \(2\ I\ \[Epsilon]\^2\ \[Omega]\_1\ 
            \((\(-A\_1\)\ \[Mu]\_1 - 
                \(18\ I\ E\^\(\(-I\)\ T\_2\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ 
                    A\_1\ A\_2\ \[Delta]\_1\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\)\/\(5\ \[Omega]\_1\%3\) - 
                \(106\ I\ E\^\(\(-I\)\ T\_2\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ 
                    A\_1\ A\_2\ \[Delta]\_2\ \[Delta]\_3\ 
                    \[CapitalLambda]\_1\)\/\(315\ \[Omega]\_1\%3\) - 
                \(54\ I\ A\_1\ \[Delta]\_1\%2\ \[CapitalLambda]\_1\%2\)\/\(5\ 
                    \[Omega]\_1\%3\) - 
                \(106\ I\ A\_1\ \[Delta]\_2\%2\ 
                    \[CapitalLambda]\_1\%2\)\/\(315\ \[Omega]\_1\%3\) + 
                \(3\ I\ E\^\(\(-I\)\ T\_2\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ 
                    A\_1\ A\_2\ \[Alpha]\_2\ 
                    \[CapitalLambda]\_1\)\/\[Omega]\_1 + 
                \(12\ I\ A\_1\ \[Alpha]\_1\ 
                    \[CapitalLambda]\_1\%2\)\/\[Omega]\_1 - 
                \(15\ I\ A\_1\%2\ \[Delta]\_1\%2\ A\&_\_1\)\/\[Omega]\_1\%3 - 
                \(19\ I\ A\_1\%2\ \[Delta]\_2\%2\ A\&_\_1\)\/\(45\ 
                    \[Omega]\_1\%3\) + 
                \(6\ I\ A\_1\%2\ \[Alpha]\_1\ A\&_\_1\)\/\[Omega]\_1 + 
                \(3\ I\ E\^\(I\ T\_2\ \[Sigma]\_1\)\ A\_2\ \[Delta]\_1\ 
                    \[Delta]\_2\ A\&_\_1\%2\)\/\[Omega]\_1\%3 - 
                \(3\ I\ E\^\(I\ T\_2\ \[Sigma]\_1\)\ A\_2\ \[Delta]\_2\ 
                    \[Delta]\_3\ A\&_\_1\%2\)\/\(5\ \[Omega]\_1\%3\) + 
                \(9\ I\ E
                      \^\(I\ T\_2\ \[Sigma]\_1 + I\ T\_2\ \[Sigma]\_2 + 
                        I\ \[Tau]\_1\)\ \[Delta]\_1\%2\ \[CapitalLambda]\_1\ 
                    A\&_\_1\%2\)\/\[Omega]\_1\%3 - 
                \(3\ I\ E
                      \^\(I\ T\_2\ \[Sigma]\_1 + I\ T\_2\ \[Sigma]\_2 + 
                        I\ \[Tau]\_1\)\ \[Delta]\_2\%2\ \[CapitalLambda]\_1\ 
                    A\&_\_1\%2\)\/\(5\ \[Omega]\_1\%3\) + 
                \(3\ I\ E\^\(I\ T\_2\ \[Sigma]\_1\)\ A\_2\ \[Alpha]\_2\ 
                    A\&_\_1\%2\)\/\(2\ \[Omega]\_1\) + 
                \(6\ I\ E
                      \^\(I\ T\_2\ \[Sigma]\_1 + I\ T\_2\ \[Sigma]\_2 + 
                        I\ \[Tau]\_1\)\ \[Alpha]\_1\ \[CapitalLambda]\_1\ 
                    A\&_\_1\%2\)\/\[Omega]\_1 + 
                \(4\ I\ A\_1\ A\_2\ \[Delta]\_2\%2\ A\&_\_2\)\/\(5\ 
                    \[Omega]\_1\%3\) - 
                \(6\ I\ A\_1\ A\_2\ \[Delta]\_1\ \[Delta]\_3\ 
                    A\&_\_2\)\/\[Omega]\_1\%3 - 
                \(4\ I\ A\_1\ A\_2\ \[Delta]\_3\%2\ A\&_\_2\)\/\(35\ 
                    \[Omega]\_1\%3\) - 
                \(2\ I\ A\_1\ A\_2\ \[Delta]\_2\ \[Delta]\_4\ A\&_\_2\)\/\(3\ 
                    \[Omega]\_1\%3\) - 
                \(18\ I\ E\^\(I\ T\_2\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                    \[Delta]\_1\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
                    A\&_\_2\)\/\(5\ \[Omega]\_1\%3\) - 
                \(106\ I\ E\^\(I\ T\_2\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                    \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
                    A\&_\_2\)\/\(315\ \[Omega]\_1\%3\) + 
                \(2\ I\ A\_1\ A\_2\ \[Alpha]\_3\ A\&_\_2\)\/\[Omega]\_1 + 
                \(3\ I\ E\^\(I\ T\_2\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                    \[Alpha]\_2\ \[CapitalLambda]\_1\ A\&_\_2\)\/\[Omega]\_1)
              \)\)}], ",", 
        RowBox[{
          RowBox[{"2", " ", "I", " ", \(\[Omega]\_2\), " ", 
            SubsuperscriptBox["A", "2", "\[Prime]",
              MultilineFunction->None]}], "==", 
          \(2\ I\ \[Epsilon]\^2\ \[Omega]\_2\ 
            \((\(-A\_2\)\ \[Mu]\_2 - 
                \(I\ E\^\(I\ T\_2\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ f\_2\)\/\(4\ 
                    \[Omega]\_2\) + 
                \(I\ E\^\(\(-I\)\ T\_2\ \[Sigma]\_1\)\ A\_1\%3\ 
                    \[Alpha]\_2\)\/\(2\ \[Omega]\_2\) + 
                \(3\ I\ E\^\(\(-I\)\ T\_2\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ 
                    A\_2\%2\ \[Alpha]\_4\ \[CapitalLambda]\_1\)\/\(2\ 
                    \[Omega]\_2\) + 
                \(2\ I\ A\_2\ \[Alpha]\_3\ 
                    \[CapitalLambda]\_1\%2\)\/\[Omega]\_2 + 
                \(3\ I\ E\^\(I\ T\_2\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ 
                    \[Alpha]\_2\ \[CapitalLambda]\_1\%3\)\/\(2\ 
                    \[Omega]\_2\) + 
                \(I\ E\^\(\(-I\)\ T\_2\ \[Sigma]\_1\)\ A\_1\%3\ \[Delta]\_1\ 
                    \[Delta]\_2\)\/\(\[Omega]\_1\%2\ \[Omega]\_2\) - 
                \(I\ E\^\(\(-I\)\ T\_2\ \[Sigma]\_1\)\ A\_1\%3\ \[Delta]\_2\ 
                    \[Delta]\_3\)\/\(5\ \[Omega]\_1\%2\ \[Omega]\_2\) - 
                \(69\ I\ E\^\(\(-I\)\ T\_2\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ 
                    A\_2\%2\ \[Delta]\_2\ \[Delta]\_3\ 
                    \[CapitalLambda]\_1\)\/\(35\ \[Omega]\_1\%2\ 
                    \[Omega]\_2\) - 
                \(5\ I\ E\^\(\(-I\)\ T\_2\ \[Sigma]\_2 - I\ \[Tau]\_1\)\ 
                    A\_2\%2\ \[Delta]\_3\ \[Delta]\_4\ 
                    \[CapitalLambda]\_1\)\/\(9\ \[Omega]\_1\%2\ 
                    \[Omega]\_2\) - 
                \(68\ I\ A\_2\ \[Delta]\_2\%2\ \[CapitalLambda]\_1\%2\)\/\(35
                    \ \[Omega]\_1\%2\ \[Omega]\_2\) - 
                \(6\ I\ A\_2\ \[Delta]\_1\ \[Delta]\_3\ 
                    \[CapitalLambda]\_1\%2\)\/\(\[Omega]\_1\%2\ 
                    \[Omega]\_2\) - 
                \(4\ I\ A\_2\ \[Delta]\_3\%2\ \[CapitalLambda]\_1\%2\)\/\(27\ 
                    \[Omega]\_1\%2\ \[Omega]\_2\) - 
                \(2\ I\ A\_2\ \[Delta]\_2\ \[Delta]\_4\ 
                    \[CapitalLambda]\_1\%2\)\/\(3\ \[Omega]\_1\%2\ 
                    \[Omega]\_2\) - 
                \(207\ I\ E\^\(I\ T\_2\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ 
                    \[Delta]\_1\ \[Delta]\_2\ \[CapitalLambda]\_1\%3\)\/\(35\ 
                    \[Omega]\_1\%2\ \[Omega]\_2\) - 
                \(5\ I\ E\^\(I\ T\_2\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ 
                    \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\%3\)\/\(27\ 
                    \[Omega]\_1\%2\ \[Omega]\_2\) + 
                \(2\ I\ A\_1\ A\_2\ \[Alpha]\_3\ A\&_\_1\)\/\[Omega]\_2 + 
                \(3\ I\ E\^\(I\ T\_2\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                    \[Alpha]\_2\ \[CapitalLambda]\_1\ 
                    A\&_\_1\)\/\[Omega]\_2 + 
                \(4\ I\ A\_1\ A\_2\ \[Delta]\_2\%2\ A\&_\_1\)\/\(5\ 
                    \[Omega]\_1\%2\ \[Omega]\_2\) - 
                \(6\ I\ A\_1\ A\_2\ \[Delta]\_1\ \[Delta]\_3\ 
                    A\&_\_1\)\/\(\[Omega]\_1\%2\ \[Omega]\_2\) - 
                \(4\ I\ A\_1\ A\_2\ \[Delta]\_3\%2\ A\&_\_1\)\/\(35\ 
                    \[Omega]\_1\%2\ \[Omega]\_2\) - 
                \(2\ I\ A\_1\ A\_2\ \[Delta]\_2\ \[Delta]\_4\ A\&_\_1\)\/\(3\ 
                    \[Omega]\_1\%2\ \[Omega]\_2\) - 
                \(18\ I\ E\^\(I\ T\_2\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                    \[Delta]\_1\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
                    A\&_\_1\)\/\(5\ \[Omega]\_1\%2\ \[Omega]\_2\) - 
                \(106\ I\ E\^\(I\ T\_2\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_1\ 
                    \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
                    A\&_\_1\)\/\(315\ \[Omega]\_1\%2\ \[Omega]\_2\) + 
                \(6\ I\ A\_2\%2\ \[Alpha]\_5\ A\&_\_2\)\/\[Omega]\_2 + 
                \(3\ I\ E\^\(I\ T\_2\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_2\ 
                    \[Alpha]\_4\ \[CapitalLambda]\_1\ 
                    A\&_\_2\)\/\[Omega]\_2 + 
                \(I\ E\^\(2\ I\ T\_2\ \[Sigma]\_2 + 2\ I\ \[Tau]\_1\)\ 
                    \[Alpha]\_3\ \[CapitalLambda]\_1\%2\ 
                    A\&_\_2\)\/\[Omega]\_2 - 
                \(69\ I\ A\_2\%2\ \[Delta]\_3\%2\ A\&_\_2\)\/\(35\ 
                    \[Omega]\_1\%2\ \[Omega]\_2\) - 
                \(5\ I\ A\_2\%2\ \[Delta]\_4\%2\ A\&_\_2\)\/\(3\ 
                    \[Omega]\_1\%2\ \[Omega]\_2\) - 
                \(138\ I\ E\^\(I\ T\_2\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_2\ 
                    \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
                    A\&_\_2\)\/\(35\ \[Omega]\_1\%2\ \[Omega]\_2\) - 
                \(10\ I\ E\^\(I\ T\_2\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ A\_2\ 
                    \[Delta]\_3\ \[Delta]\_4\ \[CapitalLambda]\_1\ 
                    A\&_\_2\)\/\(9\ \[Omega]\_1\%2\ \[Omega]\_2\) - 
                \(2\ I\ E\^\(2\ I\ T\_2\ \[Sigma]\_2 + 2\ I\ \[Tau]\_1\)\ 
                    \[Delta]\_2\%2\ \[CapitalLambda]\_1\%2\ 
                    A\&_\_2\)\/\(\[Omega]\_1\%2\ \[Omega]\_2\) + 
                \(3\ I\ E\^\(2\ I\ T\_2\ \[Sigma]\_2 + 2\ I\ \[Tau]\_1\)\ 
                    \[Delta]\_1\ \[Delta]\_3\ \[CapitalLambda]\_1\%2\ 
                    A\&_\_2\)\/\(35\ \[Omega]\_1\%2\ \[Omega]\_2\) - 
                \(2\ I\ E\^\(2\ I\ T\_2\ \[Sigma]\_2 + 2\ I\ \[Tau]\_1\)\ 
                    \[Delta]\_3\%2\ \[CapitalLambda]\_1\%2\ A\&_\_2\)\/\(9\ 
                    \[Omega]\_1\%2\ \[Omega]\_2\) + 
                \(I\ E\^\(2\ I\ T\_2\ \[Sigma]\_2 + 2\ I\ \[Tau]\_1\)\ 
                    \[Delta]\_2\ \[Delta]\_4\ \[CapitalLambda]\_1\%2\ 
                    A\&_\_2\)\/\(9\ \[Omega]\_1\%2\ \[Omega]\_2\))\)\)}]}], 
      "}"}]], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({66.9059999999999543`\ Second, Null}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "6.1.6 ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[CapitalOmega] \[TildeTilde] \[Omega]\_2 - 2  \[Omega]\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\_2 \[TildeTilde] 3  \[Omega]\_1\)]]
}], "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
In this case, we have a primary resonance of the first mode, a superharmonic \
resonance of the second mode, and a three-to-one internal resonance. We let\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(scaling6 = {\[Mu]\&^\_n_ -> \[Epsilon]\^2\ \[Mu]\_n, 
        F\_1 -> \[Epsilon]\^3\ f\_1, F\_2 -> \[Epsilon]\ f\_2}; \)\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(ResonanceCond6 = {
        \[Omega]\_2 == 3  \[Omega]\_1 + \[Epsilon]\^2\ \[Sigma]\_1, 
        \[CapitalOmega] == 
          \[Omega]\_2 - 2  \[Omega]\_1 + \[Epsilon]\^2\ \[Sigma]\_2}; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Using ",
  StyleBox["MMS",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain the second-order approximate solution and the two equations \
governing the modulation of the complex-valued functions ",
  Cell[BoxData[
      \(TraditionalForm\`A\_k\)]],
  ":"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(MMS[scaling6, ResonanceCond6] // Timing\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\!\\(\\* StyleBox[\\(The\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(second\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* \
StyleBox[\\(-\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* StyleBox[\\(order\
\\), FontColor->RGBColor[0, 0, 1]]\\) \\!\\(\\* StyleBox[\\(approximate\\), \
FontColor->RGBColor[0, 0, 1]]\\) \\!\\(\\* StyleBox[\\(solution\\), \
FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* StyleBox[\\(:\\), \
FontColor->RGBColor[0, 0, 1]]\\)\"\>"], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u\_1[t] == 
        \[Epsilon]\ 
            \((E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1 + 
                E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ A\&_\_1)\) + 
          \[Epsilon]\^2\ 
            \((\(E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ A\_1\%2\ 
                    \[Delta]\_1\)\/\[Omega]\_1\%2 + 
                \(2\ E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                    A\_1\%2\ \[Delta]\_2\)\/\(15\ \[Omega]\_1\%2\) + 
                \(E\^\(2\ I\ T\_0\ \[Omega]\_2\)\ A\_1\%2\ \[Delta]\_3\)\/\(35
                    \ \[Omega]\_1\%2\) - 
                \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2 + 
                        I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Delta]\_2\ 
                    \[CapitalLambda]\_2\)\/\[Omega]\_1\%2 + 
                \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2 + 
                        I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Delta]\_2\ 
                    \[CapitalLambda]\_2\)\/\(3\ \[Omega]\_1\%2\) + 
                \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2 + 
                        I\ T\_0\ \[Omega]\_2\)\ A\_1\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\)\/\(3\ \[Omega]\_1\%2\) + 
                \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2 + 
                        I\ T\_0\ \[Omega]\_2\)\ A\_1\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\)\/\(15\ \[Omega]\_1\%2\) - 
                \(2\ \[Delta]\_3\ \[CapitalLambda]\_2\%2\)\/\[Omega]\_1\%2 + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega] - 2\ I\ \[Tau]\_2\)\ 
                    \[Delta]\_3\ \[CapitalLambda]\_2\%2\)\/\(3\ 
                    \[Omega]\_1\%2\) + 
                \(E\^\(2\ I\ T\_0\ \[CapitalOmega] + 2\ I\ \[Tau]\_2\)\ 
                    \[Delta]\_3\ \[CapitalLambda]\_2\%2\)\/\(3\ 
                    \[Omega]\_1\%2\) - 
                \(6\ A\_1\ \[Delta]\_1\ A\&_\_1\)\/\[Omega]\_1\%2 + 
                \(2\ E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                    A\_1\ \[Delta]\_2\ A\&_\_1\)\/\(3\ \[Omega]\_1\%2\) + 
                \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                    A\_1\ \[Delta]\_2\ A\&_\_1\)\/\(3\ \[Omega]\_1\%2\) - 
                \(2\ A\_1\ \[Delta]\_3\ A\&_\_1\)\/\[Omega]\_1\%2 + 
                \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2 - 
                        I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ 
                    \[CapitalLambda]\_2\ A\&_\_1\)\/\(3\ \[Omega]\_1\%2\) - 
                \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2 - 
                        I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ 
                    \[CapitalLambda]\_2\ A\&_\_1\)\/\[Omega]\_1\%2 + 
                \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2 - 
                        I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\ A\&_\_1\)\/\(15\ \[Omega]\_1\%2\) + 
                \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2 - 
                        I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\ A\&_\_1\)\/\(3\ \[Omega]\_1\%2\) + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ 
                    A\&_\_1\%2\)\/\[Omega]\_1\%2 + 
                \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                    \[Delta]\_2\ A\&_\_1\%2\)\/\(15\ \[Omega]\_1\%2\) + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ 
                    A\&_\_1\%2\)\/\(35\ \[Omega]\_1\%2\))\), 
      u\_2[t] == 
        \[Epsilon]\ 
            \((E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2 + 
                E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2\)\ 
                  \[CapitalLambda]\_2 + 
                E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2\)\ 
                  \[CapitalLambda]\_2 + 
                E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ A\&_\_2)\) + 
          \[Epsilon]\^2\ 
            \((\(-\(\(E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ A\_2\%2\ 
                        \[Delta]\_2\)\/\(5\ \[Omega]\_1\%2\)\)\) + 
                \(2\ E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                    A\_2\%2\ \[Delta]\_3\)\/\(7\ \[Omega]\_1\%2\) + 
                \(E\^\(2\ I\ T\_0\ \[Omega]\_2\)\ A\_2\%2\ \[Delta]\_4\)\/\(9
                    \ \[Omega]\_1\%2\) - 
                \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2 + 
                        I\ T\_0\ \[Omega]\_1\)\ A\_2\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\)\/\(9\ \[Omega]\_1\%2\) - 
                \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2 + 
                        I\ T\_0\ \[Omega]\_1\)\ A\_2\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\)\/\(5\ \[Omega]\_1\%2\) - 
                \(6\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2 + 
                        I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Delta]\_4\ 
                    \[CapitalLambda]\_2\)\/\(5\ \[Omega]\_1\%2\) + 
                \(6\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2 + 
                        I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Delta]\_4\ 
                    \[CapitalLambda]\_2\)\/\(7\ \[Omega]\_1\%2\) - 
                \(2\ \[Delta]\_4\ \[CapitalLambda]\_2\%2\)\/\(3\ 
                    \[Omega]\_1\%2\) - 
                \(3\ E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega] - 
                        2\ I\ \[Tau]\_2\)\ \[Delta]\_4\ 
                    \[CapitalLambda]\_2\%2\)\/\(5\ \[Omega]\_1\%2\) - 
                \(3\ E\^\(2\ I\ T\_0\ \[CapitalOmega] + 2\ I\ \[Tau]\_2\)\ 
                    \[Delta]\_4\ \[CapitalLambda]\_2\%2\)\/\(5\ 
                    \[Omega]\_1\%2\) - 
                \(2\ A\_2\ \[Delta]\_2\ A\&_\_2\)\/\(9\ \[Omega]\_1\%2\) - 
                \(2\ E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                    A\_2\ \[Delta]\_3\ A\&_\_2\)\/\(5\ \[Omega]\_1\%2\) - 
                \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                    A\_2\ \[Delta]\_3\ A\&_\_2\)\/\(5\ \[Omega]\_1\%2\) - 
                \(2\ A\_2\ \[Delta]\_4\ A\&_\_2\)\/\(3\ \[Omega]\_1\%2\) - 
                \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2 - 
                        I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\ A\&_\_2\)\/\(5\ \[Omega]\_1\%2\) - 
                \(2\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2 - 
                        I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\ A\&_\_2\)\/\(9\ \[Omega]\_1\%2\) + 
                \(6\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2 - 
                        I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_4\ 
                    \[CapitalLambda]\_2\ A\&_\_2\)\/\(7\ \[Omega]\_1\%2\) - 
                \(6\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2 - 
                        I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_4\ 
                    \[CapitalLambda]\_2\ A\&_\_2\)\/\(5\ \[Omega]\_1\%2\) - 
                \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ 
                    A\&_\_2\%2\)\/\(5\ \[Omega]\_1\%2\) + 
                \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                    \[Delta]\_3\ A\&_\_2\%2\)\/\(7\ \[Omega]\_1\%2\) + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_4\ 
                    A\&_\_2\%2\)\/\(9\ \[Omega]\_1\%2\))\)}\)], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\!\\(\\* StyleBox[\\(where\\), FontColor->RGBColor[0, 0, 1]]\\)\"\>"],
   "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \("\!\(\[CapitalLambda]\_i\)==\!\(f\_i\/\(2 \((\[Omega]\_i\%2 - \
\[CapitalOmega]\^2)\)\)\)"\)], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\n\\!\\(\\* StyleBox[\\(The\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(modulation\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(equations\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* \
StyleBox[\\(:\\), FontColor->RGBColor[0, 0, 1]]\\)\"\>"], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{"2", " ", "I", " ", \(\[Omega]\_1\), " ", 
            SubsuperscriptBox["A", "1", "\[Prime]",
              MultilineFunction->None]}], "==", 
          \(2\ I\ \[Epsilon]\^2\ \[Omega]\_1\ 
            \((\(-A\_1\)\ \[Mu]\_1 - 
                \(5\ I\ E
                      \^\(\(-I\)\ T\_2\ \[Sigma]\_1 - I\ T\_2\ \[Sigma]\_2 - 
                        I\ \[Tau]\_2\)\ A\_1\%2\ \[Delta]\_1\ \[Delta]\_2\ 
                    \[CapitalLambda]\_2\)\/\[Omega]\_1\%3 - 
                \(19\ I\ 
                    E\^\(\(-I\)\ T\_2\ \[Sigma]\_1 - I\ T\_2\ \[Sigma]\_2 - 
                        I\ \[Tau]\_2\)\ A\_1\%2\ \[Delta]\_2\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\)\/\(45\ \[Omega]\_1\%3\) - 
                \(4\ I\ A\_1\ \[Delta]\_2\%2\ \[CapitalLambda]\_2\%2\)\/\(3\ 
                    \[Omega]\_1\%3\) - 
                \(6\ I\ A\_1\ \[Delta]\_1\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\%2\)\/\[Omega]\_1\%3 + 
                \(I\ E\^\(\(-I\)\ T\_2\ \[Sigma]\_1 - 
                        2\ I\ T\_2\ \[Sigma]\_2 - 2\ I\ \[Tau]\_2\)\ A\_2\ 
                    \[Delta]\_2\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\%2\)\/\[Omega]\_1\%3 - 
                \(28\ I\ A\_1\ \[Delta]\_3\%2\ \[CapitalLambda]\_2\%2\)\/\(45
                    \ \[Omega]\_1\%3\) - 
                \(2\ I\ A\_1\ \[Delta]\_2\ \[Delta]\_4\ 
                    \[CapitalLambda]\_2\%2\)\/\(3\ \[Omega]\_1\%3\) - 
                \(9\ I\ E
                      \^\(\(-I\)\ T\_2\ \[Sigma]\_1 - 
                        2\ I\ T\_2\ \[Sigma]\_2 - 2\ I\ \[Tau]\_2\)\ A\_2\ 
                    \[Delta]\_3\ \[Delta]\_4\ \[CapitalLambda]\_2\%2\)\/\(5\ 
                    \[Omega]\_1\%3\) - 
                \(5\ I\ E
                      \^\(I\ T\_2\ \[Sigma]\_1 + I\ T\_2\ \[Sigma]\_2 + 
                        I\ \[Tau]\_2\)\ \[Delta]\_2\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\%3\)\/\(3\ \[Omega]\_1\%3\) - 
                \(19\ I\ 
                    E\^\(I\ T\_2\ \[Sigma]\_1 + I\ T\_2\ \[Sigma]\_2 + 
                        I\ \[Tau]\_2\)\ \[Delta]\_3\ \[Delta]\_4\ 
                    \[CapitalLambda]\_2\%3\)\/\(15\ \[Omega]\_1\%3\) - 
                \(I\ E\^\(I\ T\_2\ \[Sigma]\_1 + I\ T\_2\ \[Sigma]\_2 + 
                        I\ \[Tau]\_1\)\ f\_1\)\/\(4\ \[Omega]\_1\) + 
                \(3\ I\ E
                      \^\(\(-I\)\ T\_2\ \[Sigma]\_1 - I\ T\_2\ \[Sigma]\_2 - 
                        I\ \[Tau]\_2\)\ A\_1\%2\ \[Alpha]\_2\ 
                    \[CapitalLambda]\_2\)\/\(2\ \[Omega]\_1\) + 
                \(2\ I\ A\_1\ \[Alpha]\_3\ 
                    \[CapitalLambda]\_2\%2\)\/\[Omega]\_1 + 
                \(3\ I\ 
                    E\^\(\(-I\)\ T\_2\ \[Sigma]\_1 - 
                        2\ I\ T\_2\ \[Sigma]\_2 - 2\ I\ \[Tau]\_2\)\ A\_2\ 
                    \[Alpha]\_4\ \[CapitalLambda]\_2\%2\)\/\(2\ 
                    \[Omega]\_1\) + 
                \(3\ I\ E
                      \^\(I\ T\_2\ \[Sigma]\_1 + I\ T\_2\ \[Sigma]\_2 + 
                        I\ \[Tau]\_2\)\ \[Alpha]\_4\ 
                    \[CapitalLambda]\_2\%3\)\/\(2\ \[Omega]\_1\) - 
                \(15\ I\ A\_1\%2\ \[Delta]\_1\%2\ A\&_\_1\)\/\[Omega]\_1\%3 - 
                \(19\ I\ A\_1\%2\ \[Delta]\_2\%2\ A\&_\_1\)\/\(45\ 
                    \[Omega]\_1\%3\) - 
                \(10\ I\ 
                    E\^\(I\ T\_2\ \[Sigma]\_1 + I\ T\_2\ \[Sigma]\_2 + 
                        I\ \[Tau]\_2\)\ A\_1\ \[Delta]\_1\ \[Delta]\_2\ 
                    \[CapitalLambda]\_2\ A\&_\_1\)\/\[Omega]\_1\%3 + 
                \(4\ I\ E\^\(\(-I\)\ T\_2\ \[Sigma]\_2 - I\ \[Tau]\_2\)\ 
                    A\_2\ \[Delta]\_2\%2\ \[CapitalLambda]\_2\ A\&_\_1\)\/\(3
                    \ \[Omega]\_1\%3\) + 
                \(2\ I\ E\^\(\(-I\)\ T\_2\ \[Sigma]\_2 - I\ \[Tau]\_2\)\ 
                    A\_2\ \[Delta]\_1\ \[Delta]\_3\ \[CapitalLambda]\_2\ 
                    A\&_\_1\)\/\[Omega]\_1\%3 - 
                \(38\ I\ 
                    E\^\(I\ T\_2\ \[Sigma]\_1 + I\ T\_2\ \[Sigma]\_2 + 
                        I\ \[Tau]\_2\)\ A\_1\ \[Delta]\_2\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\ A\&_\_1\)\/\(45\ \[Omega]\_1\%3\) - 
                \(4\ I\ E\^\(\(-I\)\ T\_2\ \[Sigma]\_2 - I\ \[Tau]\_2\)\ 
                    A\_2\ \[Delta]\_3\%2\ \[CapitalLambda]\_2\ A\&_\_1\)\/\(5
                    \ \[Omega]\_1\%3\) - 
                \(6\ I\ E\^\(\(-I\)\ T\_2\ \[Sigma]\_2 - I\ \[Tau]\_2\)\ 
                    A\_2\ \[Delta]\_2\ \[Delta]\_4\ \[CapitalLambda]\_2\ 
                    A\&_\_1\)\/\(5\ \[Omega]\_1\%3\) - 
                \(2\ I\ E
                      \^\(2\ I\ T\_2\ \[Sigma]\_1 + 2\ I\ T\_2\ \[Sigma]\_2 + 
                        2\ I\ \[Tau]\_2\)\ \[Delta]\_2\%2\ 
                    \[CapitalLambda]\_2\%2\ A\&_\_1\)\/\[Omega]\_1\%3 + 
                \(I\ E\^\(2\ I\ T\_2\ \[Sigma]\_1 + 2\ I\ T\_2\ \[Sigma]\_2 + 
                        2\ I\ \[Tau]\_2\)\ \[Delta]\_1\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\%2\ A\&_\_1\)\/\[Omega]\_1\%3 - 
                \(2\ I\ E
                      \^\(2\ I\ T\_2\ \[Sigma]\_1 + 2\ I\ T\_2\ \[Sigma]\_2 + 
                        2\ I\ \[Tau]\_2\)\ \[Delta]\_3\%2\ 
                    \[CapitalLambda]\_2\%2\ A\&_\_1\)\/\(9\ 
                    \[Omega]\_1\%3\) - 
                \(3\ I\ E
                      \^\(2\ I\ T\_2\ \[Sigma]\_1 + 2\ I\ T\_2\ \[Sigma]\_2 + 
                        2\ I\ \[Tau]\_2\)\ \[Delta]\_2\ \[Delta]\_4\ 
                    \[CapitalLambda]\_2\%2\ A\&_\_1\)\/\(5\ 
                    \[Omega]\_1\%3\) + 
                \(6\ I\ A\_1\%2\ \[Alpha]\_1\ A\&_\_1\)\/\[Omega]\_1 + 
                \(3\ I\ E
                      \^\(I\ T\_2\ \[Sigma]\_1 + I\ T\_2\ \[Sigma]\_2 + 
                        I\ \[Tau]\_2\)\ A\_1\ \[Alpha]\_2\ 
                    \[CapitalLambda]\_2\ A\&_\_1\)\/\[Omega]\_1 + 
                \(2\ I\ E\^\(\(-I\)\ T\_2\ \[Sigma]\_2 - I\ \[Tau]\_2\)\ 
                    A\_2\ \[Alpha]\_3\ \[CapitalLambda]\_2\ 
                    A\&_\_1\)\/\[Omega]\_1 + 
                \(I\ E\^\(2\ I\ T\_2\ \[Sigma]\_1 + 2\ I\ T\_2\ \[Sigma]\_2 + 
                        2\ I\ \[Tau]\_2\)\ \[Alpha]\_3\ 
                    \[CapitalLambda]\_2\%2\ A\&_\_1\)\/\[Omega]\_1 + 
                \(3\ I\ E\^\(I\ T\_2\ \[Sigma]\_1\)\ A\_2\ \[Delta]\_1\ 
                    \[Delta]\_2\ A\&_\_1\%2\)\/\[Omega]\_1\%3 - 
                \(3\ I\ E\^\(I\ T\_2\ \[Sigma]\_1\)\ A\_2\ \[Delta]\_2\ 
                    \[Delta]\_3\ A\&_\_1\%2\)\/\(5\ \[Omega]\_1\%3\) + 
                \(3\ I\ E\^\(I\ T\_2\ \[Sigma]\_1\)\ A\_2\ \[Alpha]\_2\ 
                    A\&_\_1\%2\)\/\(2\ \[Omega]\_1\) + 
                \(4\ I\ A\_1\ A\_2\ \[Delta]\_2\%2\ A\&_\_2\)\/\(5\ 
                    \[Omega]\_1\%3\) - 
                \(6\ I\ A\_1\ A\_2\ \[Delta]\_1\ \[Delta]\_3\ 
                    A\&_\_2\)\/\[Omega]\_1\%3 - 
                \(4\ I\ A\_1\ A\_2\ \[Delta]\_3\%2\ A\&_\_2\)\/\(35\ 
                    \[Omega]\_1\%3\) - 
                \(2\ I\ A\_1\ A\_2\ \[Delta]\_2\ \[Delta]\_4\ A\&_\_2\)\/\(3\ 
                    \[Omega]\_1\%3\) - 
                \(6\ I\ E
                      \^\(I\ T\_2\ \[Sigma]\_1 + I\ T\_2\ \[Sigma]\_2 + 
                        I\ \[Tau]\_2\)\ A\_2\ \[Delta]\_2\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\ A\&_\_2\)\/\(5\ \[Omega]\_1\%3\) - 
                \(106\ I\ 
                    E\^\(I\ T\_2\ \[Sigma]\_1 + I\ T\_2\ \[Sigma]\_2 + 
                        I\ \[Tau]\_2\)\ A\_2\ \[Delta]\_3\ \[Delta]\_4\ 
                    \[CapitalLambda]\_2\ A\&_\_2\)\/\(105\ \[Omega]\_1\%3\) + 
                \(2\ I\ A\_1\ A\_2\ \[Alpha]\_3\ A\&_\_2\)\/\[Omega]\_1 + 
                \(3\ I\ E
                      \^\(I\ T\_2\ \[Sigma]\_1 + I\ T\_2\ \[Sigma]\_2 + 
                        I\ \[Tau]\_2\)\ A\_2\ \[Alpha]\_4\ 
                    \[CapitalLambda]\_2\ A\&_\_2\)\/\[Omega]\_1)\)\)}], ",", 
        RowBox[{
          RowBox[{"2", " ", "I", " ", \(\[Omega]\_2\), " ", 
            SubsuperscriptBox["A", "2", "\[Prime]",
              MultilineFunction->None]}], "==", 
          \(2\ I\ \[Epsilon]\^2\ \[Omega]\_2\ 
            \((\(-A\_2\)\ \[Mu]\_2 + 
                \(I\ E\^\(\(-I\)\ T\_2\ \[Sigma]\_1\)\ A\_1\%3\ 
                    \[Alpha]\_2\)\/\(2\ \[Omega]\_2\) + 
                \(I\ E\^\(I\ T\_2\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ A\_1\%2\ 
                    \[Alpha]\_3\ \[CapitalLambda]\_2\)\/\[Omega]\_2 + 
                \(3\ I\ E
                      \^\(\(-I\)\ T\_2\ \[Sigma]\_1 - I\ T\_2\ \[Sigma]\_2 - 
                        I\ \[Tau]\_2\)\ A\_1\ A\_2\ \[Alpha]\_4\ 
                    \[CapitalLambda]\_2\)\/\[Omega]\_2 + 
                \(3\ I\ E
                      \^\(I\ T\_2\ \[Sigma]\_1 + 2\ I\ T\_2\ \[Sigma]\_2 + 
                        2\ I\ \[Tau]\_2\)\ A\_1\ \[Alpha]\_4\ 
                    \[CapitalLambda]\_2\%2\)\/\(2\ \[Omega]\_2\) + 
                \(12\ I\ A\_2\ \[Alpha]\_5\ 
                    \[CapitalLambda]\_2\%2\)\/\[Omega]\_2 + 
                \(2\ I\ E
                      \^\(2\ I\ T\_2\ \[Sigma]\_1 + 3\ I\ T\_2\ \[Sigma]\_2 + 
                        3\ I\ \[Tau]\_2\)\ \[Alpha]\_5\ 
                    \[CapitalLambda]\_2\%3\)\/\[Omega]\_2 + 
                \(I\ E\^\(\(-I\)\ T\_2\ \[Sigma]\_1\)\ A\_1\%3\ \[Delta]\_1\ 
                    \[Delta]\_2\)\/\(\[Omega]\_1\%2\ \[Omega]\_2\) - 
                \(I\ E\^\(\(-I\)\ T\_2\ \[Sigma]\_1\)\ A\_1\%3\ \[Delta]\_2\ 
                    \[Delta]\_3\)\/\(5\ \[Omega]\_1\%2\ \[Omega]\_2\) + 
                \(2\ I\ E\^\(I\ T\_2\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ A\_1\%2\ 
                    \[Delta]\_2\%2\ \[CapitalLambda]\_2\)\/\(3\ 
                    \[Omega]\_1\%2\ \[Omega]\_2\) + 
                \(I\ E\^\(I\ T\_2\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ A\_1\%2\ 
                    \[Delta]\_1\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\)\/\(\[Omega]\_1\%2\ \[Omega]\_2\) - 
                \(6\ I\ E
                      \^\(\(-I\)\ T\_2\ \[Sigma]\_1 - I\ T\_2\ \[Sigma]\_2 - 
                        I\ \[Tau]\_2\)\ A\_1\ A\_2\ \[Delta]\_2\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\)\/\(5\ \[Omega]\_1\%2\ 
                    \[Omega]\_2\) - 
                \(2\ I\ E\^\(I\ T\_2\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ A\_1\%2\ 
                    \[Delta]\_3\%2\ \[CapitalLambda]\_2\)\/\(5\ 
                    \[Omega]\_1\%2\ \[Omega]\_2\) - 
                \(3\ I\ E\^\(I\ T\_2\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ A\_1\%2\ 
                    \[Delta]\_2\ \[Delta]\_4\ \[CapitalLambda]\_2\)\/\(5\ 
                    \[Omega]\_1\%2\ \[Omega]\_2\) - 
                \(106\ I\ 
                    E\^\(\(-I\)\ T\_2\ \[Sigma]\_1 - I\ T\_2\ \[Sigma]\_2 - 
                        I\ \[Tau]\_2\)\ A\_1\ A\_2\ \[Delta]\_3\ \[Delta]\_4\ 
                    \[CapitalLambda]\_2\)\/\(105\ \[Omega]\_1\%2\ 
                    \[Omega]\_2\) + 
                \(I\ E\^\(I\ T\_2\ \[Sigma]\_1 + 2\ I\ T\_2\ \[Sigma]\_2 + 
                        2\ I\ \[Tau]\_2\)\ A\_1\ \[Delta]\_2\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\%2\)\/\(\[Omega]\_1\%2\ 
                    \[Omega]\_2\) - 
                \(6\ I\ A\_2\ \[Delta]\_3\%2\ \[CapitalLambda]\_2\%2\)\/\(5\ 
                    \[Omega]\_1\%2\ \[Omega]\_2\) - 
                \(9\ I\ E
                      \^\(I\ T\_2\ \[Sigma]\_1 + 2\ I\ T\_2\ \[Sigma]\_2 + 
                        2\ I\ \[Tau]\_2\)\ A\_1\ \[Delta]\_3\ \[Delta]\_4\ 
                    \[CapitalLambda]\_2\%2\)\/\(5\ \[Omega]\_1\%2\ 
                    \[Omega]\_2\) - 
                \(106\ I\ A\_2\ \[Delta]\_4\%2\ \[CapitalLambda]\_2\%2\)\/\(35
                    \ \[Omega]\_1\%2\ \[Omega]\_2\) + 
                \(I\ E\^\(2\ I\ T\_2\ \[Sigma]\_1 + 3\ I\ T\_2\ \[Sigma]\_2 + 
                        3\ I\ \[Tau]\_2\)\ \[Delta]\_3\%2\ 
                    \[CapitalLambda]\_2\%3\)\/\(3\ \[Omega]\_1\%2\ 
                    \[Omega]\_2\) - 
                \(9\ I\ E
                      \^\(2\ I\ T\_2\ \[Sigma]\_1 + 3\ I\ T\_2\ \[Sigma]\_2 + 
                        3\ I\ \[Tau]\_2\)\ \[Delta]\_4\%2\ 
                    \[CapitalLambda]\_2\%3\)\/\(5\ \[Omega]\_1\%2\ 
                    \[Omega]\_2\) + 
                \(2\ I\ A\_1\ A\_2\ \[Alpha]\_3\ A\&_\_1\)\/\[Omega]\_2 + 
                \(3\ I\ E
                      \^\(I\ T\_2\ \[Sigma]\_1 + I\ T\_2\ \[Sigma]\_2 + 
                        I\ \[Tau]\_2\)\ A\_2\ \[Alpha]\_4\ 
                    \[CapitalLambda]\_2\ A\&_\_1\)\/\[Omega]\_2 + 
                \(4\ I\ A\_1\ A\_2\ \[Delta]\_2\%2\ A\&_\_1\)\/\(5\ 
                    \[Omega]\_1\%2\ \[Omega]\_2\) - 
                \(6\ I\ A\_1\ A\_2\ \[Delta]\_1\ \[Delta]\_3\ 
                    A\&_\_1\)\/\(\[Omega]\_1\%2\ \[Omega]\_2\) - 
                \(4\ I\ A\_1\ A\_2\ \[Delta]\_3\%2\ A\&_\_1\)\/\(35\ 
                    \[Omega]\_1\%2\ \[Omega]\_2\) - 
                \(2\ I\ A\_1\ A\_2\ \[Delta]\_2\ \[Delta]\_4\ A\&_\_1\)\/\(3\ 
                    \[Omega]\_1\%2\ \[Omega]\_2\) - 
                \(6\ I\ E
                      \^\(I\ T\_2\ \[Sigma]\_1 + I\ T\_2\ \[Sigma]\_2 + 
                        I\ \[Tau]\_2\)\ A\_2\ \[Delta]\_2\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\ A\&_\_1\)\/\(5\ \[Omega]\_1\%2\ 
                    \[Omega]\_2\) - 
                \(106\ I\ 
                    E\^\(I\ T\_2\ \[Sigma]\_1 + I\ T\_2\ \[Sigma]\_2 + 
                        I\ \[Tau]\_2\)\ A\_2\ \[Delta]\_3\ \[Delta]\_4\ 
                    \[CapitalLambda]\_2\ A\&_\_1\)\/\(105\ \[Omega]\_1\%2\ 
                    \[Omega]\_2\) + 
                \(6\ I\ A\_2\%2\ \[Alpha]\_5\ A\&_\_2\)\/\[Omega]\_2 - 
                \(69\ I\ A\_2\%2\ \[Delta]\_3\%2\ A\&_\_2\)\/\(35\ 
                    \[Omega]\_1\%2\ \[Omega]\_2\) - 
                \(5\ I\ A\_2\%2\ \[Delta]\_4\%2\ A\&_\_2\)\/\(3\ 
                    \[Omega]\_1\%2\ \[Omega]\_2\))\)\)}]}], "}"}]], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({72.1539999999999981`\ Second, Null}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "6.1.7 ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[CapitalOmega] \[TildeTilde] \[Omega]\_1 + \[Omega]\_2\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\_2 \[TildeTilde] \[Omega]\_1\)]]
}], "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
In this case, we have a subharmonic resonance of either mode and a one-to-one \
internal resonance. We let\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(scaling7 = {\[Mu]\&^\_n_ -> \[Epsilon]\ \[Mu]\_n, 
        F\_1 -> \[Epsilon]\ f\_1, F\_2 -> \[Epsilon]\ f\_2}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(ResonanceCond7 = {
        \[Omega]\_2 == \[Omega]\_1 + \[Epsilon]\ \[Sigma]\_1, 
        \[CapitalOmega] == 
          \[Omega]\_1 + \[Omega]\_2 + \[Epsilon]\ \[Sigma]\_2}; \)\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Using ",
  StyleBox["MMS",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain the second-order approximate solution and the two equations \
governing the modulation of the complex-valued functions ",
  Cell[BoxData[
      \(TraditionalForm\`A\_k\)]],
  ":"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(MMS[scaling7, ResonanceCond7] // Timing\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\!\\(\\* StyleBox[\\(The\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(second\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* \
StyleBox[\\(-\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* StyleBox[\\(order\
\\), FontColor->RGBColor[0, 0, 1]]\\) \\!\\(\\* StyleBox[\\(approximate\\), \
FontColor->RGBColor[0, 0, 1]]\\) \\!\\(\\* StyleBox[\\(solution\\), \
FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* StyleBox[\\(:\\), \
FontColor->RGBColor[0, 0, 1]]\\)\"\>"], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u\_1[t] == 
        \[Epsilon]\ 
            \((E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1 + 
                E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1\)\ 
                  \[CapitalLambda]\_1 + 
                E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1\)\ 
                  \[CapitalLambda]\_1 + 
                E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ A\&_\_1)\) + 
          \[Epsilon]\^2\ 
            \((\(E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ A\_1\%2\ 
                    \[Delta]\_1\)\/\[Omega]\_1\%2 + 
                \(2\ E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                    A\_1\%2\ \[Delta]\_2\)\/\(3\ \[Omega]\_1\%2\) + 
                \(E\^\(2\ I\ T\_0\ \[Omega]\_2\)\ A\_1\%2\ \[Delta]\_3\)\/\(3
                    \ \[Omega]\_1\%2\) - 
                \(3\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
                        I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Delta]\_1\ 
                    \[CapitalLambda]\_1\)\/\(2\ \[Omega]\_1\%2\) + 
                \(3\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                        I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Delta]\_1\ 
                    \[CapitalLambda]\_1\)\/\(4\ \[Omega]\_1\%2\) - 
                \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
                        I\ T\_0\ \[Omega]\_2\)\ A\_1\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\)\/\(2\ \[Omega]\_1\%2\) + 
                \(E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                        I\ T\_0\ \[Omega]\_2\)\ A\_1\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\)\/\(4\ \[Omega]\_1\%2\) - 
                \(6\ \[Delta]\_1\ \[CapitalLambda]\_1\%2\)\/\[Omega]\_1\%2 + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega] - 2\ I\ \[Tau]\_1\)\ 
                    \[Delta]\_1\ \[CapitalLambda]\_1\%2\)\/\(5\ 
                    \[Omega]\_1\%2\) + 
                \(E\^\(2\ I\ T\_0\ \[CapitalOmega] + 2\ I\ \[Tau]\_1\)\ 
                    \[Delta]\_1\ \[CapitalLambda]\_1\%2\)\/\(5\ 
                    \[Omega]\_1\%2\) - 
                \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2 + 
                        I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Delta]\_2\ 
                    \[CapitalLambda]\_2\)\/\(2\ \[Omega]\_1\%2\) + 
                \(E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2 + 
                        I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Delta]\_2\ 
                    \[CapitalLambda]\_2\)\/\(4\ \[Omega]\_1\%2\) - 
                \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2 + 
                        I\ T\_0\ \[Omega]\_2\)\ A\_1\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\)\/\(2\ \[Omega]\_1\%2\) + 
                \(E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2 + 
                        I\ T\_0\ \[Omega]\_2\)\ A\_1\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\)\/\(4\ \[Omega]\_1\%2\) + 
                \(2\ E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                        I\ \[Tau]\_2\)\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
                    \[CapitalLambda]\_2\)\/\(15\ \[Omega]\_1\%2\) - 
                \(2\ E\^\(I\ \[Tau]\_1 - I\ \[Tau]\_2\)\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\ \[CapitalLambda]\_2\)\/\[Omega]\_1
                    \%2 - \(2\ E\^\(\(-I\)\ \[Tau]\_1 + I\ \[Tau]\_2\)\ 
                    \[Delta]\_2\ \[CapitalLambda]\_1\ 
                    \[CapitalLambda]\_2\)\/\[Omega]\_1\%2 + 
                \(2\ E\^\(2\ I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                        I\ \[Tau]\_2\)\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
                    \[CapitalLambda]\_2\)\/\(15\ \[Omega]\_1\%2\) - 
                \(2\ \[Delta]\_3\ \[CapitalLambda]\_2\%2\)\/\[Omega]\_1\%2 + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega] - 2\ I\ \[Tau]\_2\)\ 
                    \[Delta]\_3\ \[CapitalLambda]\_2\%2\)\/\(15\ 
                    \[Omega]\_1\%2\) + 
                \(E\^\(2\ I\ T\_0\ \[CapitalOmega] + 2\ I\ \[Tau]\_2\)\ 
                    \[Delta]\_3\ \[CapitalLambda]\_2\%2\)\/\(15\ 
                    \[Omega]\_1\%2\) - 
                \(I\ E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1\ \[Mu]\_1\)\/\(2\ 
                    \[Omega]\_1\) - 
                \(4\ I\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1\)\ 
                    \[CapitalLambda]\_1\ \[Mu]\_1\)\/\(3\ \[Omega]\_1\) + 
                \(4\ I\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1\)\ 
                    \[CapitalLambda]\_1\ \[Mu]\_1\)\/\(3\ \[Omega]\_1\) - 
                \(6\ A\_1\ \[Delta]\_1\ A\&_\_1\)\/\[Omega]\_1\%2 - 
                \(2\ E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                    A\_1\ \[Delta]\_2\ A\&_\_1\)\/\[Omega]\_1\%2 - 
                \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                    A\_1\ \[Delta]\_2\ A\&_\_1\)\/\[Omega]\_1\%2 - 
                \(2\ A\_1\ \[Delta]\_3\ A\&_\_1\)\/\[Omega]\_1\%2 + 
                \(3\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                        I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ 
                    \[CapitalLambda]\_1\ A\&_\_1\)\/\(4\ \[Omega]\_1\%2\) - 
                \(3\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
                        I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ 
                    \[CapitalLambda]\_1\ A\&_\_1\)\/\(2\ \[Omega]\_1\%2\) + 
                \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                        I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\ A\&_\_1\)\/\(4\ \[Omega]\_1\%2\) - 
                \(E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
                        I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\ A\&_\_1\)\/\(2\ \[Omega]\_1\%2\) + 
                \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2 - 
                        I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ 
                    \[CapitalLambda]\_2\ A\&_\_1\)\/\(4\ \[Omega]\_1\%2\) - 
                \(E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2 - 
                        I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ 
                    \[CapitalLambda]\_2\ A\&_\_1\)\/\(2\ \[Omega]\_1\%2\) + 
                \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2 - 
                        I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\ A\&_\_1\)\/\(4\ \[Omega]\_1\%2\) - 
                \(E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2 - 
                        I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\ A\&_\_1\)\/\(2\ \[Omega]\_1\%2\) + 
                \(I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ \[Mu]\_1\ 
                    A\&_\_1\)\/\(2\ \[Omega]\_1\) + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ 
                    A\&_\_1\%2\)\/\[Omega]\_1\%2 + 
                \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                    \[Delta]\_2\ A\&_\_1\%2\)\/\(3\ \[Omega]\_1\%2\) + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ 
                    A\&_\_1\%2\)\/\(3\ \[Omega]\_1\%2\))\), 
      u\_2[t] == 
        \[Epsilon]\ 
            \((E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2 + 
                E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2\)\ 
                  \[CapitalLambda]\_2 + 
                E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2\)\ 
                  \[CapitalLambda]\_2 + 
                E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ A\&_\_2)\) + 
          \[Epsilon]\^2\ 
            \((\(E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ A\_2\%2\ \[Delta]\_2\)\/\(3\ 
                    \[Omega]\_1\%2\) + 
                \(2\ E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                    A\_2\%2\ \[Delta]\_3\)\/\(3\ \[Omega]\_1\%2\) + 
                \(E\^\(2\ I\ T\_0\ \[Omega]\_2\)\ A\_2\%2\ 
                    \[Delta]\_4\)\/\[Omega]\_1\%2 - 
                \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
                        I\ T\_0\ \[Omega]\_1\)\ A\_2\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\)\/\(2\ \[Omega]\_1\%2\) + 
                \(E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                        I\ T\_0\ \[Omega]\_1\)\ A\_2\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\)\/\(4\ \[Omega]\_1\%2\) - 
                \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 + 
                        I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Delta]\_3\ 
                    \[CapitalLambda]\_1\)\/\(2\ \[Omega]\_1\%2\) + 
                \(E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                        I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Delta]\_3\ 
                    \[CapitalLambda]\_1\)\/\(4\ \[Omega]\_1\%2\) - 
                \(2\ \[Delta]\_2\ \[CapitalLambda]\_1\%2\)\/\[Omega]\_1\%2 + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega] - 2\ I\ \[Tau]\_1\)\ 
                    \[Delta]\_2\ \[CapitalLambda]\_1\%2\)\/\(15\ 
                    \[Omega]\_1\%2\) + 
                \(E\^\(2\ I\ T\_0\ \[CapitalOmega] + 2\ I\ \[Tau]\_1\)\ 
                    \[Delta]\_2\ \[CapitalLambda]\_1\%2\)\/\(15\ 
                    \[Omega]\_1\%2\) - 
                \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2 + 
                        I\ T\_0\ \[Omega]\_1\)\ A\_2\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\)\/\(2\ \[Omega]\_1\%2\) + 
                \(E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2 + 
                        I\ T\_0\ \[Omega]\_1\)\ A\_2\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\)\/\(4\ \[Omega]\_1\%2\) - 
                \(3\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2 + 
                        I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Delta]\_4\ 
                    \[CapitalLambda]\_2\)\/\(2\ \[Omega]\_1\%2\) + 
                \(3\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2 + 
                        I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Delta]\_4\ 
                    \[CapitalLambda]\_2\)\/\(4\ \[Omega]\_1\%2\) + 
                \(2\ E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                        I\ \[Tau]\_2\)\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
                    \[CapitalLambda]\_2\)\/\(15\ \[Omega]\_1\%2\) - 
                \(2\ E\^\(I\ \[Tau]\_1 - I\ \[Tau]\_2\)\ \[Delta]\_3\ 
                    \[CapitalLambda]\_1\ \[CapitalLambda]\_2\)\/\[Omega]\_1
                    \%2 - \(2\ E\^\(\(-I\)\ \[Tau]\_1 + I\ \[Tau]\_2\)\ 
                    \[Delta]\_3\ \[CapitalLambda]\_1\ 
                    \[CapitalLambda]\_2\)\/\[Omega]\_1\%2 + 
                \(2\ E\^\(2\ I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 + 
                        I\ \[Tau]\_2\)\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
                    \[CapitalLambda]\_2\)\/\(15\ \[Omega]\_1\%2\) - 
                \(6\ \[Delta]\_4\ \[CapitalLambda]\_2\%2\)\/\[Omega]\_1\%2 + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega] - 2\ I\ \[Tau]\_2\)\ 
                    \[Delta]\_4\ \[CapitalLambda]\_2\%2\)\/\(5\ 
                    \[Omega]\_1\%2\) + 
                \(E\^\(2\ I\ T\_0\ \[CapitalOmega] + 2\ I\ \[Tau]\_2\)\ 
                    \[Delta]\_4\ \[CapitalLambda]\_2\%2\)\/\(5\ 
                    \[Omega]\_1\%2\) - 
                \(I\ E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2\ \[Mu]\_2\)\/\(2\ 
                    \[Omega]\_1\) - 
                \(4\ I\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2\)\ 
                    \[CapitalLambda]\_2\ \[Mu]\_2\)\/\(3\ \[Omega]\_1\) + 
                \(4\ I\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2\)\ 
                    \[CapitalLambda]\_2\ \[Mu]\_2\)\/\(3\ \[Omega]\_1\) - 
                \(2\ A\_2\ \[Delta]\_2\ A\&_\_2\)\/\[Omega]\_1\%2 - 
                \(2\ E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                    A\_2\ \[Delta]\_3\ A\&_\_2\)\/\[Omega]\_1\%2 - 
                \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                    A\_2\ \[Delta]\_3\ A\&_\_2\)\/\[Omega]\_1\%2 - 
                \(6\ A\_2\ \[Delta]\_4\ A\&_\_2\)\/\[Omega]\_1\%2 + 
                \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                        I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\ A\&_\_2\)\/\(4\ \[Omega]\_1\%2\) - 
                \(E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
                        I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ 
                    \[CapitalLambda]\_1\ A\&_\_2\)\/\(2\ \[Omega]\_1\%2\) + 
                \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_1 - 
                        I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ 
                    \[CapitalLambda]\_1\ A\&_\_2\)\/\(4\ \[Omega]\_1\%2\) - 
                \(E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_1 - 
                        I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ 
                    \[CapitalLambda]\_1\ A\&_\_2\)\/\(2\ \[Omega]\_1\%2\) + 
                \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2 - 
                        I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\ A\&_\_2\)\/\(4\ \[Omega]\_1\%2\) - 
                \(E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2 - 
                        I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_3\ 
                    \[CapitalLambda]\_2\ A\&_\_2\)\/\(2\ \[Omega]\_1\%2\) + 
                \(3\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ \[Tau]\_2 - 
                        I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_4\ 
                    \[CapitalLambda]\_2\ A\&_\_2\)\/\(4\ \[Omega]\_1\%2\) - 
                \(3\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ \[Tau]\_2 - 
                        I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_4\ 
                    \[CapitalLambda]\_2\ A\&_\_2\)\/\(2\ \[Omega]\_1\%2\) + 
                \(I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ \[Mu]\_2\ 
                    A\&_\_2\)\/\(2\ \[Omega]\_1\) + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ 
                    A\&_\_2\%2\)\/\(3\ \[Omega]\_1\%2\) + 
                \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                    \[Delta]\_3\ A\&_\_2\%2\)\/\(3\ \[Omega]\_1\%2\) + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_4\ 
                    A\&_\_2\%2\)\/\[Omega]\_1\%2)\)}\)], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\!\\(\\* StyleBox[\\(where\\), FontColor->RGBColor[0, 0, 1]]\\)\"\>"],
   "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \("\!\(\[CapitalLambda]\_i\)==\!\(f\_i\/\(2 \((\[Omega]\_i\%2 - \
\[CapitalOmega]\^2)\)\)\)"\)], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\n\\!\\(\\* StyleBox[\\(The\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(modulation\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(equations\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* \
StyleBox[\\(:\\), FontColor->RGBColor[0, 0, 1]]\\)\"\>"], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{"2", " ", "I", " ", \(\[Omega]\_1\), " ", 
            SubsuperscriptBox["A", "1", "\[Prime]",
              MultilineFunction->None]}], "==", 
          \(2\ I\ \[Epsilon]\^2\ \[Omega]\_1\ 
              \((\(-\(\(81\ I\ A\_1\ \[Delta]\_1\%2\ 
                          \[CapitalLambda]\_1\%2\)\/\(4\ 
                          \[Omega]\_1\%3\)\)\) - 
                  \(27\ I\ E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_2\ \[Delta]\_1\ 
                      \[Delta]\_2\ \[CapitalLambda]\_1\%2\)\/\(4\ 
                      \[Omega]\_1\%3\) - 
                  \(9\ I\ A\_1\ \[Delta]\_2\%2\ \[CapitalLambda]\_1\%2\)\/\(4
                      \ \[Omega]\_1\%3\) - 
                  \(9\ I\ E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_2\ \[Delta]\_2\ 
                      \[Delta]\_3\ \[CapitalLambda]\_1\%2\)\/\(4\ 
                      \[Omega]\_1\%3\) - 
                  \(27\ I\ E\^\(I\ \[Tau]\_1 - I\ \[Tau]\_2\)\ A\_1\ 
                      \[Delta]\_1\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
                      \[CapitalLambda]\_2\)\/\(4\ \[Omega]\_1\%3\) - 
                  \(27\ I\ E\^\(\(-I\)\ \[Tau]\_1 + I\ \[Tau]\_2\)\ A\_1\ 
                      \[Delta]\_1\ \[Delta]\_2\ \[CapitalLambda]\_1\ 
                      \[CapitalLambda]\_2\)\/\(4\ \[Omega]\_1\%3\) - 
                  \(7\ I\ E
                        \^\(I\ T\_1\ \[Sigma]\_1 + I\ \[Tau]\_1 - 
                          I\ \[Tau]\_2\)\ A\_2\ \[Delta]\_2\%2\ 
                      \[CapitalLambda]\_1\ \[CapitalLambda]\_2\)\/\(4\ 
                      \[Omega]\_1\%3\) - 
                  \(5\ I\ E
                        \^\(I\ T\_1\ \[Sigma]\_1 - I\ \[Tau]\_1 + 
                          I\ \[Tau]\_2\)\ A\_2\ \[Delta]\_2\%2\ 
                      \[CapitalLambda]\_1\ \[CapitalLambda]\_2\)\/\(2\ 
                      \[Omega]\_1\%3\) - 
                  \(3\ I\ E
                        \^\(I\ T\_1\ \[Sigma]\_1 + I\ \[Tau]\_1 - 
                          I\ \[Tau]\_2\)\ A\_2\ \[Delta]\_1\ \[Delta]\_3\ 
                      \[CapitalLambda]\_1\ \[CapitalLambda]\_2\)\/\(2\ 
                      \[Omega]\_1\%3\) + 
                  \(3\ I\ E
                        \^\(I\ T\_1\ \[Sigma]\_1 - I\ \[Tau]\_1 + 
                          I\ \[Tau]\_2\)\ A\_2\ \[Delta]\_1\ \[Delta]\_3\ 
                      \[CapitalLambda]\_1\ \[CapitalLambda]\_2\)\/\(4\ 
                      \[Omega]\_1\%3\) - 
                  \(9\ I\ E\^\(I\ \[Tau]\_1 - I\ \[Tau]\_2\)\ A\_1\ 
                      \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
                      \[CapitalLambda]\_2\)\/\(4\ \[Omega]\_1\%3\) - 
                  \(9\ I\ E\^\(\(-I\)\ \[Tau]\_1 + I\ \[Tau]\_2\)\ A\_1\ 
                      \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
                      \[CapitalLambda]\_2\)\/\(4\ \[Omega]\_1\%3\) - 
                  \(7\ I\ 
                      E\^\(I\ T\_1\ \[Sigma]\_1 + I\ \[Tau]\_1 - 
                          I\ \[Tau]\_2\)\ A\_2\ \[Delta]\_3\%2\ 
                      \[CapitalLambda]\_1\ \[CapitalLambda]\_2\)\/\(4\ 
                      \[Omega]\_1\%3\) - 
                  \(5\ I\ E
                        \^\(I\ T\_1\ \[Sigma]\_1 - I\ \[Tau]\_1 + 
                          I\ \[Tau]\_2\)\ A\_2\ \[Delta]\_3\%2\ 
                      \[CapitalLambda]\_1\ \[CapitalLambda]\_2\)\/\(2\ 
                      \[Omega]\_1\%3\) - 
                  \(3\ I\ E
                        \^\(I\ T\_1\ \[Sigma]\_1 + I\ \[Tau]\_1 - 
                          I\ \[Tau]\_2\)\ A\_2\ \[Delta]\_2\ \[Delta]\_4\ 
                      \[CapitalLambda]\_1\ \[CapitalLambda]\_2\)\/\(2\ 
                      \[Omega]\_1\%3\) + 
                  \(3\ I\ E
                        \^\(I\ T\_1\ \[Sigma]\_1 - I\ \[Tau]\_1 + 
                          I\ \[Tau]\_2\)\ A\_2\ \[Delta]\_2\ \[Delta]\_4\ 
                      \[CapitalLambda]\_1\ \[CapitalLambda]\_2\)\/\(4\ 
                      \[Omega]\_1\%3\) - 
                  \(I\ A\_1\ \[Delta]\_2\%2\ \[CapitalLambda]\_2\%2\)\/\(4\ 
                      \[Omega]\_1\%3\) - 
                  \(6\ I\ A\_1\ \[Delta]\_1\ \[Delta]\_3\ 
                      \[CapitalLambda]\_2\%2\)\/\[Omega]\_1\%3 - 
                  \(9\ I\ E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_2\ \[Delta]\_2\ 
                      \[Delta]\_3\ \[CapitalLambda]\_2\%2\)\/\(4\ 
                      \[Omega]\_1\%3\) - 
                  \(I\ A\_1\ \[Delta]\_3\%2\ \[CapitalLambda]\_2\%2\)\/\(4\ 
                      \[Omega]\_1\%3\) - 
                  \(6\ I\ A\_1\ \[Delta]\_2\ \[Delta]\_4\ 
                      \[CapitalLambda]\_2\%2\)\/\[Omega]\_1\%3 - 
                  \(27\ I\ E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_2\ \[Delta]\_3\ 
                      \[Delta]\_4\ \[CapitalLambda]\_2\%2\)\/\(4\ 
                      \[Omega]\_1\%3\) + 
                  \(12\ I\ A\_1\ \[Alpha]\_1\ 
                      \[CapitalLambda]\_1\%2\)\/\[Omega]\_1 + 
                  \(3\ I\ E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_2\ \[Alpha]\_2\ 
                      \[CapitalLambda]\_1\%2\)\/\[Omega]\_1 + 
                  \(3\ I\ E\^\(I\ \[Tau]\_1 - I\ \[Tau]\_2\)\ A\_1\ 
                      \[Alpha]\_2\ \[CapitalLambda]\_1\ 
                      \[CapitalLambda]\_2\)\/\[Omega]\_1 + 
                  \(3\ I\ E\^\(\(-I\)\ \[Tau]\_1 + I\ \[Tau]\_2\)\ A\_1\ 
                      \[Alpha]\_2\ \[CapitalLambda]\_1\ 
                      \[CapitalLambda]\_2\)\/\[Omega]\_1 + 
                  \(2\ I\ E
                        \^\(I\ T\_1\ \[Sigma]\_1 + I\ \[Tau]\_1 - 
                          I\ \[Tau]\_2\)\ A\_2\ \[Alpha]\_3\ 
                      \[CapitalLambda]\_1\ 
                      \[CapitalLambda]\_2\)\/\[Omega]\_1 + 
                  \(2\ I\ E
                        \^\(I\ T\_1\ \[Sigma]\_1 - I\ \[Tau]\_1 + 
                          I\ \[Tau]\_2\)\ A\_2\ \[Alpha]\_3\ 
                      \[CapitalLambda]\_1\ 
                      \[CapitalLambda]\_2\)\/\[Omega]\_1 + 
                  \(2\ I\ A\_1\ \[Alpha]\_3\ 
                      \[CapitalLambda]\_2\%2\)\/\[Omega]\_1 + 
                  \(3\ I\ E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_2\ \[Alpha]\_4\ 
                      \[CapitalLambda]\_2\%2\)\/\[Omega]\_1 - 
                  \(I\ A\_1\ \[Mu]\_1\%2\)\/\(2\ \[Omega]\_1\) - 
                  \(15\ I\ A\_1\%2\ \[Delta]\_1\%2\ A\&_\_1\)\/\[Omega]\_1
                      \%3 - \(10\ I\ E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_1\ A\_2\ 
                      \[Delta]\_1\ \[Delta]\_2\ A\&_\_1\)\/\[Omega]\_1\%3 - 
                  \(5\ I\ A\_1\%2\ \[Delta]\_2\%2\ A\&_\_1\)\/\(3\ 
                      \[Omega]\_1\%3\) - 
                  \(2\ I\ E\^\(2\ I\ T\_1\ \[Sigma]\_1\)\ A\_2\%2\ 
                      \[Delta]\_2\%2\ A\&_\_1\)\/\[Omega]\_1\%3 + 
                  \(I\ E\^\(2\ I\ T\_1\ \[Sigma]\_1\)\ A\_2\%2\ \[Delta]\_1\ 
                      \[Delta]\_3\ A\&_\_1\)\/\[Omega]\_1\%3 - 
                  \(10\ I\ E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_1\ A\_2\ 
                      \[Delta]\_2\ \[Delta]\_3\ A\&_\_1\)\/\(3\ 
                      \[Omega]\_1\%3\) - 
                  \(2\ I\ E\^\(2\ I\ T\_1\ \[Sigma]\_1\)\ A\_2\%2\ 
                      \[Delta]\_3\%2\ A\&_\_1\)\/\[Omega]\_1\%3 + 
                  \(I\ E\^\(2\ I\ T\_1\ \[Sigma]\_1\)\ A\_2\%2\ \[Delta]\_2\ 
                      \[Delta]\_4\ A\&_\_1\)\/\[Omega]\_1\%3 - 
                  \(7\ E\^\(I\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2 + 
                          I\ \[Tau]\_1\)\ \[Delta]\_1\ \[CapitalLambda]\_1\ 
                      \[Mu]\_1\ A\&_\_1\)\/\[Omega]\_1\%2 - 
                  \(E\^\(I\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2 + 
                          I\ \[Tau]\_2\)\ \[Delta]\_2\ \[CapitalLambda]\_2\ 
                      \[Mu]\_1\ A\&_\_1\)\/\[Omega]\_1\%2 - 
                  \(4\ E\^\(I\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2 + 
                          I\ \[Tau]\_2\)\ \[Delta]\_2\ \[CapitalLambda]\_2\ 
                      \[Mu]\_2\ A\&_\_1\)\/\(3\ \[Omega]\_1\%2\) + 
                  \(6\ I\ A\_1\%2\ \[Alpha]\_1\ A\&_\_1\)\/\[Omega]\_1 + 
                  \(3\ I\ E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_1\ A\_2\ 
                      \[Alpha]\_2\ A\&_\_1\)\/\[Omega]\_1 + 
                  \(I\ E\^\(2\ I\ T\_1\ \[Sigma]\_1\)\ A\_2\%2\ \[Alpha]\_3\ 
                      A\&_\_1\)\/\[Omega]\_1 - 
                  \(5\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\%2\ 
                      \[Delta]\_1\ \[Delta]\_2\ A\&_\_2\)\/\[Omega]\_1\%3 - 
                  \(4\ I\ A\_1\ A\_2\ \[Delta]\_2\%2\ A\&_\_2\)\/\(3\ 
                      \[Omega]\_1\%3\) - 
                  \(6\ I\ A\_1\ A\_2\ \[Delta]\_1\ \[Delta]\_3\ 
                      A\&_\_2\)\/\[Omega]\_1\%3 - 
                  \(5\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\%2\ 
                      \[Delta]\_2\ \[Delta]\_3\ A\&_\_2\)\/\(3\ 
                      \[Omega]\_1\%3\) - 
                  \(5\ I\ E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_2\%2\ \[Delta]\_2\ 
                      \[Delta]\_3\ A\&_\_2\)\/\(3\ \[Omega]\_1\%3\) - 
                  \(4\ I\ A\_1\ A\_2\ \[Delta]\_3\%2\ A\&_\_2\)\/\(3\ 
                      \[Omega]\_1\%3\) - 
                  \(6\ I\ A\_1\ A\_2\ \[Delta]\_2\ \[Delta]\_4\ 
                      A\&_\_2\)\/\[Omega]\_1\%3 - 
                  \(5\ I\ E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_2\%2\ \[Delta]\_3\ 
                      \[Delta]\_4\ A\&_\_2\)\/\[Omega]\_1\%3 - 
                  \(11\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ 
                      \[Delta]\_2\ \[CapitalLambda]\_1\ \[Mu]\_1\ 
                      A\&_\_2\)\/\(6\ \[Omega]\_1\%2\) - 
                  \(E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ \[Delta]\_3\ 
                      \[CapitalLambda]\_2\ \[Mu]\_1\ A\&_\_2\)\/\(2\ 
                      \[Omega]\_1\%2\) - 
                  \(E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ \[Delta]\_2\ 
                      \[CapitalLambda]\_1\ \[Mu]\_2\ A\&_\_2\)\/\(2\ 
                      \[Omega]\_1\%2\) - 
                  \(11\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ 
                      \[Delta]\_3\ \[CapitalLambda]\_2\ \[Mu]\_2\ 
                      A\&_\_2\)\/\(6\ \[Omega]\_1\%2\) + 
                  \(3\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\%2\ 
                      \[Alpha]\_2\ A\&_\_2\)\/\(2\ \[Omega]\_1\) + 
                  \(2\ I\ A\_1\ A\_2\ \[Alpha]\_3\ A\&_\_2\)\/\[Omega]\_1 + 
                  \(3\ I\ E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_2\%2\ \[Alpha]\_4\ 
                      A\&_\_2\)\/\(2\ \[Omega]\_1\))\) + 
            2\ I\ \[Epsilon]\ \[Omega]\_1\ 
              \((\(-A\_1\)\ \[Mu]\_1 + 
                  \(3\ I\ E
                        \^\(I\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2 + 
                          I\ \[Tau]\_1\)\ \[Delta]\_1\ \[CapitalLambda]\_1\ 
                      A\&_\_1\)\/\[Omega]\_1 + 
                  \(I\ E\^\(I\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2 + 
                          I\ \[Tau]\_2\)\ \[Delta]\_2\ \[CapitalLambda]\_2\ 
                      A\&_\_1\)\/\[Omega]\_1 + 
                  \(I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ 
                      \[Delta]\_2\ \[CapitalLambda]\_1\ 
                      A\&_\_2\)\/\[Omega]\_1 + 
                  \(I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ 
                      \[Delta]\_3\ \[CapitalLambda]\_2\ 
                      A\&_\_2\)\/\[Omega]\_1)\)\)}], ",", 
        RowBox[{
          RowBox[{"2", " ", "I", " ", \(\[Omega]\_2\), " ", 
            SubsuperscriptBox["A", "2", "\[Prime]",
              MultilineFunction->None]}], "==", 
          \(2\ I\ \[Epsilon]\ \[Omega]\_2\ 
              \((\(-A\_2\)\ \[Mu]\_2 + 
                  \(I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ 
                      \[Delta]\_2\ \[CapitalLambda]\_1\ 
                      A\&_\_1\)\/\[Omega]\_2 + 
                  \(I\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ 
                      \[Delta]\_3\ \[CapitalLambda]\_2\ 
                      A\&_\_1\)\/\[Omega]\_2 + 
                  \(I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1 + 
                          I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ \[Delta]\_3\ 
                      \[CapitalLambda]\_1\ A\&_\_2\)\/\[Omega]\_2 + 
                  \(3\ I\ E
                        \^\(\(-I\)\ T\_1\ \[Sigma]\_1 + 
                          I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ \[Delta]\_4\ 
                      \[CapitalLambda]\_2\ A\&_\_2\)\/\[Omega]\_2)\) + 
            2\ I\ \[Epsilon]\^2\ \[Omega]\_2\ 
              \((\(-\(\(I\ A\_2\ \[Mu]\_2\%2\)\/\(2\ \[Omega]\_1\)\)\) + 
                  \(3\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\ 
                      \[Alpha]\_2\ \[CapitalLambda]\_1\%2\)\/\[Omega]\_2 + 
                  \(2\ I\ A\_2\ \[Alpha]\_3\ 
                      \[CapitalLambda]\_1\%2\)\/\[Omega]\_2 + 
                  \(2\ I\ E
                        \^\(\(-I\)\ T\_1\ \[Sigma]\_1 + I\ \[Tau]\_1 - 
                          I\ \[Tau]\_2\)\ A\_1\ \[Alpha]\_3\ 
                      \[CapitalLambda]\_1\ 
                      \[CapitalLambda]\_2\)\/\[Omega]\_2 + 
                  \(2\ I\ E
                        \^\(\(-I\)\ T\_1\ \[Sigma]\_1 - I\ \[Tau]\_1 + 
                          I\ \[Tau]\_2\)\ A\_1\ \[Alpha]\_3\ 
                      \[CapitalLambda]\_1\ 
                      \[CapitalLambda]\_2\)\/\[Omega]\_2 + 
                  \(3\ I\ E\^\(I\ \[Tau]\_1 - I\ \[Tau]\_2\)\ A\_2\ 
                      \[Alpha]\_4\ \[CapitalLambda]\_1\ 
                      \[CapitalLambda]\_2\)\/\[Omega]\_2 + 
                  \(3\ I\ E\^\(\(-I\)\ \[Tau]\_1 + I\ \[Tau]\_2\)\ A\_2\ 
                      \[Alpha]\_4\ \[CapitalLambda]\_1\ 
                      \[CapitalLambda]\_2\)\/\[Omega]\_2 + 
                  \(3\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\ 
                      \[Alpha]\_4\ \[CapitalLambda]\_2\%2\)\/\[Omega]\_2 + 
                  \(12\ I\ A\_2\ \[Alpha]\_5\ 
                      \[CapitalLambda]\_2\%2\)\/\[Omega]\_2 - 
                  \(27\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\ 
                      \[Delta]\_1\ \[Delta]\_2\ \[CapitalLambda]\_1\%2\)\/\(4
                      \ \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(I\ A\_2\ \[Delta]\_2\%2\ \[CapitalLambda]\_1\%2\)\/\(4\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(6\ I\ A\_2\ \[Delta]\_1\ \[Delta]\_3\ 
                      \[CapitalLambda]\_1\%2\)\/\(\[Omega]\_1\%2\ 
                      \[Omega]\_2\) - 
                  \(9\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\ 
                      \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\%2\)\/\(4
                      \ \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(I\ A\_2\ \[Delta]\_3\%2\ \[CapitalLambda]\_1\%2\)\/\(4\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(6\ I\ A\_2\ \[Delta]\_2\ \[Delta]\_4\ 
                      \[CapitalLambda]\_1\%2\)\/\(\[Omega]\_1\%2\ 
                      \[Omega]\_2\) - 
                  \(5\ I\ E
                        \^\(\(-I\)\ T\_1\ \[Sigma]\_1 + I\ \[Tau]\_1 - 
                          I\ \[Tau]\_2\)\ A\_1\ \[Delta]\_2\%2\ 
                      \[CapitalLambda]\_1\ \[CapitalLambda]\_2\)\/\(2\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(7\ I\ E
                        \^\(\(-I\)\ T\_1\ \[Sigma]\_1 - I\ \[Tau]\_1 + 
                          I\ \[Tau]\_2\)\ A\_1\ \[Delta]\_2\%2\ 
                      \[CapitalLambda]\_1\ \[CapitalLambda]\_2\)\/\(4\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) + 
                  \(3\ I\ E
                        \^\(\(-I\)\ T\_1\ \[Sigma]\_1 + I\ \[Tau]\_1 - 
                          I\ \[Tau]\_2\)\ A\_1\ \[Delta]\_1\ \[Delta]\_3\ 
                      \[CapitalLambda]\_1\ \[CapitalLambda]\_2\)\/\(4\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(3\ I\ E
                        \^\(\(-I\)\ T\_1\ \[Sigma]\_1 - I\ \[Tau]\_1 + 
                          I\ \[Tau]\_2\)\ A\_1\ \[Delta]\_1\ \[Delta]\_3\ 
                      \[CapitalLambda]\_1\ \[CapitalLambda]\_2\)\/\(2\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(9\ I\ E\^\(I\ \[Tau]\_1 - I\ \[Tau]\_2\)\ A\_2\ 
                      \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
                      \[CapitalLambda]\_2\)\/\(4\ \[Omega]\_1\%2\ 
                      \[Omega]\_2\) - 
                  \(9\ I\ E\^\(\(-I\)\ \[Tau]\_1 + I\ \[Tau]\_2\)\ A\_2\ 
                      \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
                      \[CapitalLambda]\_2\)\/\(4\ \[Omega]\_1\%2\ 
                      \[Omega]\_2\) - 
                  \(5\ I\ E
                        \^\(\(-I\)\ T\_1\ \[Sigma]\_1 + I\ \[Tau]\_1 - 
                          I\ \[Tau]\_2\)\ A\_1\ \[Delta]\_3\%2\ 
                      \[CapitalLambda]\_1\ \[CapitalLambda]\_2\)\/\(2\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(7\ I\ E
                        \^\(\(-I\)\ T\_1\ \[Sigma]\_1 - I\ \[Tau]\_1 + 
                          I\ \[Tau]\_2\)\ A\_1\ \[Delta]\_3\%2\ 
                      \[CapitalLambda]\_1\ \[CapitalLambda]\_2\)\/\(4\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) + 
                  \(3\ I\ E
                        \^\(\(-I\)\ T\_1\ \[Sigma]\_1 + I\ \[Tau]\_1 - 
                          I\ \[Tau]\_2\)\ A\_1\ \[Delta]\_2\ \[Delta]\_4\ 
                      \[CapitalLambda]\_1\ \[CapitalLambda]\_2\)\/\(4\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(3\ I\ E
                        \^\(\(-I\)\ T\_1\ \[Sigma]\_1 - I\ \[Tau]\_1 + 
                          I\ \[Tau]\_2\)\ A\_1\ \[Delta]\_2\ \[Delta]\_4\ 
                      \[CapitalLambda]\_1\ \[CapitalLambda]\_2\)\/\(2\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(27\ I\ E\^\(I\ \[Tau]\_1 - I\ \[Tau]\_2\)\ A\_2\ 
                      \[Delta]\_3\ \[Delta]\_4\ \[CapitalLambda]\_1\ 
                      \[CapitalLambda]\_2\)\/\(4\ \[Omega]\_1\%2\ 
                      \[Omega]\_2\) - 
                  \(27\ I\ E\^\(\(-I\)\ \[Tau]\_1 + I\ \[Tau]\_2\)\ A\_2\ 
                      \[Delta]\_3\ \[Delta]\_4\ \[CapitalLambda]\_1\ 
                      \[CapitalLambda]\_2\)\/\(4\ \[Omega]\_1\%2\ 
                      \[Omega]\_2\) - 
                  \(9\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\ 
                      \[Delta]\_2\ \[Delta]\_3\ \[CapitalLambda]\_2\%2\)\/\(4
                      \ \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(9\ I\ A\_2\ \[Delta]\_3\%2\ \[CapitalLambda]\_2\%2\)\/\(4
                      \ \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(27\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\ 
                      \[Delta]\_3\ \[Delta]\_4\ \[CapitalLambda]\_2\%2\)\/\(4
                      \ \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(81\ I\ A\_2\ \[Delta]\_4\%2\ \[CapitalLambda]\_2\%2\)\/\(4
                      \ \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ \[Delta]\_2\ 
                      \[CapitalLambda]\_1\ \[Mu]\_2\ A\&_\_1\)\/\(2\ 
                      \[Omega]\_1\%2\) - 
                  \(E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ \[Delta]\_3\ 
                      \[CapitalLambda]\_2\ \[Mu]\_2\ A\&_\_1\)\/\(2\ 
                      \[Omega]\_1\%2\) + 
                  \(3\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\%2\ 
                      \[Alpha]\_2\ A\&_\_1\)\/\(2\ \[Omega]\_2\) + 
                  \(2\ I\ A\_1\ A\_2\ \[Alpha]\_3\ A\&_\_1\)\/\[Omega]\_2 + 
                  \(3\ I\ E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_2\%2\ \[Alpha]\_4\ 
                      A\&_\_1\)\/\(2\ \[Omega]\_2\) - 
                  \(5\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\%2\ 
                      \[Delta]\_1\ \[Delta]\_2\ A\&_\_1\)\/\(\[Omega]\_1\%2\ 
                      \[Omega]\_2\) - 
                  \(4\ I\ A\_1\ A\_2\ \[Delta]\_2\%2\ A\&_\_1\)\/\(3\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(6\ I\ A\_1\ A\_2\ \[Delta]\_1\ \[Delta]\_3\ 
                      A\&_\_1\)\/\(\[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(5\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\%2\ 
                      \[Delta]\_2\ \[Delta]\_3\ A\&_\_1\)\/\(3\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(5\ I\ E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_2\%2\ \[Delta]\_2\ 
                      \[Delta]\_3\ A\&_\_1\)\/\(3\ \[Omega]\_1\%2\ 
                      \[Omega]\_2\) - 
                  \(4\ I\ A\_1\ A\_2\ \[Delta]\_3\%2\ A\&_\_1\)\/\(3\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(6\ I\ A\_1\ A\_2\ \[Delta]\_2\ \[Delta]\_4\ 
                      A\&_\_1\)\/\(\[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(5\ I\ E\^\(I\ T\_1\ \[Sigma]\_1\)\ A\_2\%2\ \[Delta]\_3\ 
                      \[Delta]\_4\ A\&_\_1\)\/\(\[Omega]\_1\%2\ 
                      \[Omega]\_2\) - 
                  \(11\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ 
                      \[Delta]\_2\ \[CapitalLambda]\_1\ \[Mu]\_1\ 
                      A\&_\_1\)\/\(6\ \[Omega]\_1\ \[Omega]\_2\) - 
                  \(E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ \[Delta]\_3\ 
                      \[CapitalLambda]\_2\ \[Mu]\_1\ A\&_\_1\)\/\(2\ 
                      \[Omega]\_1\ \[Omega]\_2\) - 
                  \(4\ E\^\(I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ 
                      \[Delta]\_3\ \[CapitalLambda]\_2\ \[Mu]\_2\ 
                      A\&_\_1\)\/\(3\ \[Omega]\_1\ \[Omega]\_2\) - 
                  \(E\^\(\(-I\)\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2 + 
                          I\ \[Tau]\_1\)\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
                      \[Mu]\_2\ A\&_\_2\)\/\(2\ \[Omega]\_1\%2\) - 
                  \(3\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1 + 
                          I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ \[Delta]\_4\ 
                      \[CapitalLambda]\_2\ \[Mu]\_2\ A\&_\_2\)\/\(2\ 
                      \[Omega]\_1\%2\) + 
                  \(I\ E\^\(\(-2\)\ I\ T\_1\ \[Sigma]\_1\)\ A\_1\%2\ 
                      \[Alpha]\_3\ A\&_\_2\)\/\[Omega]\_2 + 
                  \(3\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\ A\_2\ 
                      \[Alpha]\_4\ A\&_\_2\)\/\[Omega]\_2 + 
                  \(6\ I\ A\_2\%2\ \[Alpha]\_5\ A\&_\_2\)\/\[Omega]\_2 - 
                  \(2\ I\ E\^\(\(-2\)\ I\ T\_1\ \[Sigma]\_1\)\ A\_1\%2\ 
                      \[Delta]\_2\%2\ A\&_\_2\)\/\(\[Omega]\_1\%2\ 
                      \[Omega]\_2\) + 
                  \(I\ E\^\(\(-2\)\ I\ T\_1\ \[Sigma]\_1\)\ A\_1\%2\ 
                      \[Delta]\_1\ \[Delta]\_3\ A\&_\_2\)\/\(\[Omega]\_1\%2\ 
                      \[Omega]\_2\) - 
                  \(10\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\ A\_2\ 
                      \[Delta]\_2\ \[Delta]\_3\ A\&_\_2\)\/\(3\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(2\ I\ E\^\(\(-2\)\ I\ T\_1\ \[Sigma]\_1\)\ A\_1\%2\ 
                      \[Delta]\_3\%2\ A\&_\_2\)\/\(\[Omega]\_1\%2\ 
                      \[Omega]\_2\) - 
                  \(5\ I\ A\_2\%2\ \[Delta]\_3\%2\ A\&_\_2\)\/\(3\ 
                      \[Omega]\_1\%2\ \[Omega]\_2\) + 
                  \(I\ E\^\(\(-2\)\ I\ T\_1\ \[Sigma]\_1\)\ A\_1\%2\ 
                      \[Delta]\_2\ \[Delta]\_4\ A\&_\_2\)\/\(\[Omega]\_1\%2\ 
                      \[Omega]\_2\) - 
                  \(10\ I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ A\_1\ A\_2\ 
                      \[Delta]\_3\ \[Delta]\_4\ A\&_\_2\)\/\(\[Omega]\_1\%2\ 
                      \[Omega]\_2\) - 
                  \(15\ I\ A\_2\%2\ \[Delta]\_4\%2\ 
                      A\&_\_2\)\/\(\[Omega]\_1\%2\ \[Omega]\_2\) - 
                  \(4\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1 + 
                          I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_1\)\ \[Delta]\_3\ 
                      \[CapitalLambda]\_1\ \[Mu]\_1\ A\&_\_2\)\/\(3\ 
                      \[Omega]\_1\ \[Omega]\_2\) - 
                  \(E\^\(\(-I\)\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2 + 
                          I\ \[Tau]\_1\)\ \[Delta]\_3\ \[CapitalLambda]\_1\ 
                      \[Mu]\_2\ A\&_\_2\)\/\(2\ \[Omega]\_1\ \[Omega]\_2\) - 
                  \(11\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1 + 
                          I\ T\_1\ \[Sigma]\_2 + I\ \[Tau]\_2\)\ \[Delta]\_4\ 
                      \[CapitalLambda]\_2\ \[Mu]\_2\ A\&_\_2\)\/\(2\ 
                      \[Omega]\_1\ \[Omega]\_2\))\)\)}]}], "}"}]], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({194.159000000000006`\ Second, Null}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "6.1.8 ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[CapitalOmega] \[TildeTilde] 2  \[Omega]\_2 - \[Omega]\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\_2 \[TildeTilde] \[Omega]\_1\)]]
}], "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
In this case, we have a primary resonance of either mode and a one-to-one \
internal resonance. We let\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(scaling8 = {\[Mu]\&^\_n_ -> \[Epsilon]\^2\ \[Mu]\_n, 
        F\_1 -> \[Epsilon]\^3\ f\_1, F\_2 -> \[Epsilon]\^3\ f\_2}; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(ResonanceCond8 = {
        \[Omega]\_2 == \[Omega]\_1 + \[Epsilon]\^2\ \[Sigma]\_1, 
        \[CapitalOmega] == 
          2  \[Omega]\_2 - \[Omega]\_1 + \[Epsilon]\^2\ \[Sigma]\_2}; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Using ",
  StyleBox["MMS",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain the second-order approximate solution and the two equations \
governing the modulation of the complex-valued functions ",
  Cell[BoxData[
      \(TraditionalForm\`A\_k\)]],
  ":"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(MMS[scaling8, ResonanceCond8] // Timing\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\!\\(\\* StyleBox[\\(The\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(second\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* \
StyleBox[\\(-\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* StyleBox[\\(order\
\\), FontColor->RGBColor[0, 0, 1]]\\) \\!\\(\\* StyleBox[\\(approximate\\), \
FontColor->RGBColor[0, 0, 1]]\\) \\!\\(\\* StyleBox[\\(solution\\), \
FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* StyleBox[\\(:\\), \
FontColor->RGBColor[0, 0, 1]]\\)\"\>"], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u\_1[t] == 
        \[Epsilon]\ 
            \((E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1 + 
                E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ A\&_\_1)\) + 
          \[Epsilon]\^2\ 
            \((\(E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ A\_1\%2\ 
                    \[Delta]\_1\)\/\[Omega]\_1\%2 + 
                \(2\ E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                    A\_1\ A\_2\ \[Delta]\_2\)\/\(3\ \[Omega]\_1\%2\) + 
                \(E\^\(2\ I\ T\_0\ \[Omega]\_2\)\ A\_2\%2\ \[Delta]\_3\)\/\(3
                    \ \[Omega]\_1\%2\) - 
                \(6\ A\_1\ \[Delta]\_1\ A\&_\_1\)\/\[Omega]\_1\%2 - 
                \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                    A\_2\ \[Delta]\_2\ A\&_\_1\)\/\[Omega]\_1\%2 + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_1\ 
                    A\&_\_1\%2\)\/\[Omega]\_1\%2 - 
                \(2\ E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                    A\_1\ \[Delta]\_2\ A\&_\_2\)\/\[Omega]\_1\%2 - 
                \(2\ A\_2\ \[Delta]\_3\ A\&_\_2\)\/\[Omega]\_1\%2 + 
                \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                    \[Delta]\_2\ A\&_\_1\ A\&_\_2\)\/\(3\ \[Omega]\_1\%2\) + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_3\ 
                    A\&_\_2\%2\)\/\(3\ \[Omega]\_1\%2\))\), 
      u\_2[t] == 
        \[Epsilon]\ 
            \((E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2 + 
                E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ A\&_\_2)\) + 
          \[Epsilon]\^2\ 
            \((\(E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ A\_1\%2\ \[Delta]\_2\)\/\(3\ 
                    \[Omega]\_1\%2\) + 
                \(2\ E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                    A\_1\ A\_2\ \[Delta]\_3\)\/\(3\ \[Omega]\_1\%2\) + 
                \(E\^\(2\ I\ T\_0\ \[Omega]\_2\)\ A\_2\%2\ 
                    \[Delta]\_4\)\/\[Omega]\_1\%2 - 
                \(2\ A\_1\ \[Delta]\_2\ A\&_\_1\)\/\[Omega]\_1\%2 - 
                \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                    A\_2\ \[Delta]\_3\ A\&_\_1\)\/\[Omega]\_1\%2 + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\_2\ 
                    A\&_\_1\%2\)\/\(3\ \[Omega]\_1\%2\) - 
                \(2\ E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                    A\_1\ \[Delta]\_3\ A\&_\_2\)\/\[Omega]\_1\%2 - 
                \(6\ A\_2\ \[Delta]\_4\ A\&_\_2\)\/\[Omega]\_1\%2 + 
                \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                    \[Delta]\_3\ A\&_\_1\ A\&_\_2\)\/\(3\ \[Omega]\_1\%2\) + 
                \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_2\)\ \[Delta]\_4\ 
                    A\&_\_2\%2\)\/\[Omega]\_1\%2)\)}\)], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\n\\!\\(\\* StyleBox[\\(The\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(modulation\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(equations\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* \
StyleBox[\\(:\\), FontColor->RGBColor[0, 0, 1]]\\)\"\>"], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{"2", " ", "I", " ", \(\[Omega]\_1\), " ", 
            SubsuperscriptBox["A", "1", "\[Prime]",
              MultilineFunction->None]}], "==", 
          \(2\ I\ \[Epsilon]\^2\ \[Omega]\_1\ 
            \((\(-A\_1\)\ \[Mu]\_1 - 
                \(I\ E\^\(2\ I\ T\_2\ \[Sigma]\_1 + I\ T\_2\ \[Sigma]\_2 + 
                        I\ \[Tau]\_1\)\ f\_1\)\/\(4\ \[Omega]\_1\) - 
                \(15\ I\ A\_1\%2\ \[Delta]\_1\%2\ A\&_\_1\)\/\[Omega]\_1\%3 - 
                \(10\ I\ E\^\(I\ T\_2\ \[Sigma]\_1\)\ A\_1\ A\_2\ 
                    \[Delta]\_1\ \[Delta]\_2\ A\&_\_1\)\/\[Omega]\_1\%3 - 
                \(5\ I\ A\_1\%2\ \[Delta]\_2\%2\ A\&_\_1\)\/\(3\ 
                    \[Omega]\_1\%3\) - 
                \(2\ I\ E\^\(2\ I\ T\_2\ \[Sigma]\_1\)\ A\_2\%2\ 
                    \[Delta]\_2\%2\ A\&_\_1\)\/\[Omega]\_1\%3 + 
                \(I\ E\^\(2\ I\ T\_2\ \[Sigma]\_1\)\ A\_2\%2\ \[Delta]\_1\ 
                    \[Delta]\_3\ A\&_\_1\)\/\[Omega]\_1\%3 - 
                \(10\ I\ E\^\(I\ T\_2\ \[Sigma]\_1\)\ A\_1\ A\_2\ 
                    \[Delta]\_2\ \[Delta]\_3\ A\&_\_1\)\/\(3\ 
                    \[Omega]\_1\%3\) - 
                \(2\ I\ E\^\(2\ I\ T\_2\ \[Sigma]\_1\)\ A\_2\%2\ 
                    \[Delta]\_3\%2\ A\&_\_1\)\/\[Omega]\_1\%3 + 
                \(I\ E\^\(2\ I\ T\_2\ \[Sigma]\_1\)\ A\_2\%2\ \[Delta]\_2\ 
                    \[Delta]\_4\ A\&_\_1\)\/\[Omega]\_1\%3 + 
                \(6\ I\ A\_1\%2\ \[Alpha]\_1\ A\&_\_1\)\/\[Omega]\_1 + 
                \(3\ I\ E\^\(I\ T\_2\ \[Sigma]\_1\)\ A\_1\ A\_2\ \[Alpha]\_2\ 
                    A\&_\_1\)\/\[Omega]\_1 + 
                \(I\ E\^\(2\ I\ T\_2\ \[Sigma]\_1\)\ A\_2\%2\ \[Alpha]\_3\ 
                    A\&_\_1\)\/\[Omega]\_1 - 
                \(5\ I\ E\^\(\(-I\)\ T\_2\ \[Sigma]\_1\)\ A\_1\%2\ 
                    \[Delta]\_1\ \[Delta]\_2\ A\&_\_2\)\/\[Omega]\_1\%3 - 
                \(4\ I\ A\_1\ A\_2\ \[Delta]\_2\%2\ A\&_\_2\)\/\(3\ 
                    \[Omega]\_1\%3\) - 
                \(6\ I\ A\_1\ A\_2\ \[Delta]\_1\ \[Delta]\_3\ 
                    A\&_\_2\)\/\[Omega]\_1\%3 - 
                \(5\ I\ E\^\(\(-I\)\ T\_2\ \[Sigma]\_1\)\ A\_1\%2\ 
                    \[Delta]\_2\ \[Delta]\_3\ A\&_\_2\)\/\(3\ 
                    \[Omega]\_1\%3\) - 
                \(5\ I\ E\^\(I\ T\_2\ \[Sigma]\_1\)\ A\_2\%2\ \[Delta]\_2\ 
                    \[Delta]\_3\ A\&_\_2\)\/\(3\ \[Omega]\_1\%3\) - 
                \(4\ I\ A\_1\ A\_2\ \[Delta]\_3\%2\ A\&_\_2\)\/\(3\ 
                    \[Omega]\_1\%3\) - 
                \(6\ I\ A\_1\ A\_2\ \[Delta]\_2\ \[Delta]\_4\ 
                    A\&_\_2\)\/\[Omega]\_1\%3 - 
                \(5\ I\ E\^\(I\ T\_2\ \[Sigma]\_1\)\ A\_2\%2\ \[Delta]\_3\ 
                    \[Delta]\_4\ A\&_\_2\)\/\[Omega]\_1\%3 + 
                \(3\ I\ E\^\(\(-I\)\ T\_2\ \[Sigma]\_1\)\ A\_1\%2\ 
                    \[Alpha]\_2\ A\&_\_2\)\/\(2\ \[Omega]\_1\) + 
                \(2\ I\ A\_1\ A\_2\ \[Alpha]\_3\ A\&_\_2\)\/\[Omega]\_1 + 
                \(3\ I\ E\^\(I\ T\_2\ \[Sigma]\_1\)\ A\_2\%2\ \[Alpha]\_4\ 
                    A\&_\_2\)\/\(2\ \[Omega]\_1\))\)\)}], ",", 
        RowBox[{
          RowBox[{"2", " ", "I", " ", \(\[Omega]\_2\), " ", 
            SubsuperscriptBox["A", "2", "\[Prime]",
              MultilineFunction->None]}], "==", 
          \(2\ I\ \[Epsilon]\^2\ \[Omega]\_2\ 
            \((\(-A\_2\)\ \[Mu]\_2 - 
                \(I\ E\^\(I\ T\_2\ \[Sigma]\_1 + I\ T\_2\ \[Sigma]\_2 + 
                        I\ \[Tau]\_2\)\ f\_2\)\/\(4\ \[Omega]\_2\) + 
                \(3\ I\ E\^\(\(-I\)\ T\_2\ \[Sigma]\_1\)\ A\_1\%2\ 
                    \[Alpha]\_2\ A\&_\_1\)\/\(2\ \[Omega]\_2\) + 
                \(2\ I\ A\_1\ A\_2\ \[Alpha]\_3\ A\&_\_1\)\/\[Omega]\_2 + 
                \(3\ I\ E\^\(I\ T\_2\ \[Sigma]\_1\)\ A\_2\%2\ \[Alpha]\_4\ 
                    A\&_\_1\)\/\(2\ \[Omega]\_2\) - 
                \(5\ I\ E\^\(\(-I\)\ T\_2\ \[Sigma]\_1\)\ A\_1\%2\ 
                    \[Delta]\_1\ \[Delta]\_2\ A\&_\_1\)\/\(\[Omega]\_1\%2\ 
                    \[Omega]\_2\) - 
                \(4\ I\ A\_1\ A\_2\ \[Delta]\_2\%2\ A\&_\_1\)\/\(3\ 
                    \[Omega]\_1\%2\ \[Omega]\_2\) - 
                \(6\ I\ A\_1\ A\_2\ \[Delta]\_1\ \[Delta]\_3\ 
                    A\&_\_1\)\/\(\[Omega]\_1\%2\ \[Omega]\_2\) - 
                \(5\ I\ E\^\(\(-I\)\ T\_2\ \[Sigma]\_1\)\ A\_1\%2\ 
                    \[Delta]\_2\ \[Delta]\_3\ A\&_\_1\)\/\(3\ \[Omega]\_1\%2\ 
                    \[Omega]\_2\) - 
                \(5\ I\ E\^\(I\ T\_2\ \[Sigma]\_1\)\ A\_2\%2\ \[Delta]\_2\ 
                    \[Delta]\_3\ A\&_\_1\)\/\(3\ \[Omega]\_1\%2\ 
                    \[Omega]\_2\) - 
                \(4\ I\ A\_1\ A\_2\ \[Delta]\_3\%2\ A\&_\_1\)\/\(3\ 
                    \[Omega]\_1\%2\ \[Omega]\_2\) - 
                \(6\ I\ A\_1\ A\_2\ \[Delta]\_2\ \[Delta]\_4\ 
                    A\&_\_1\)\/\(\[Omega]\_1\%2\ \[Omega]\_2\) - 
                \(5\ I\ E\^\(I\ T\_2\ \[Sigma]\_1\)\ A\_2\%2\ \[Delta]\_3\ 
                    \[Delta]\_4\ A\&_\_1\)\/\(\[Omega]\_1\%2\ \[Omega]\_2\) + 
                \(I\ E\^\(\(-2\)\ I\ T\_2\ \[Sigma]\_1\)\ A\_1\%2\ 
                    \[Alpha]\_3\ A\&_\_2\)\/\[Omega]\_2 + 
                \(3\ I\ E\^\(\(-I\)\ T\_2\ \[Sigma]\_1\)\ A\_1\ A\_2\ 
                    \[Alpha]\_4\ A\&_\_2\)\/\[Omega]\_2 + 
                \(6\ I\ A\_2\%2\ \[Alpha]\_5\ A\&_\_2\)\/\[Omega]\_2 - 
                \(2\ I\ E\^\(\(-2\)\ I\ T\_2\ \[Sigma]\_1\)\ A\_1\%2\ 
                    \[Delta]\_2\%2\ A\&_\_2\)\/\(\[Omega]\_1\%2\ 
                    \[Omega]\_2\) + 
                \(I\ E\^\(\(-2\)\ I\ T\_2\ \[Sigma]\_1\)\ A\_1\%2\ 
                    \[Delta]\_1\ \[Delta]\_3\ A\&_\_2\)\/\(\[Omega]\_1\%2\ 
                    \[Omega]\_2\) - 
                \(10\ I\ E\^\(\(-I\)\ T\_2\ \[Sigma]\_1\)\ A\_1\ A\_2\ 
                    \[Delta]\_2\ \[Delta]\_3\ A\&_\_2\)\/\(3\ \[Omega]\_1\%2\ 
                    \[Omega]\_2\) - 
                \(2\ I\ E\^\(\(-2\)\ I\ T\_2\ \[Sigma]\_1\)\ A\_1\%2\ 
                    \[Delta]\_3\%2\ A\&_\_2\)\/\(\[Omega]\_1\%2\ 
                    \[Omega]\_2\) - 
                \(5\ I\ A\_2\%2\ \[Delta]\_3\%2\ A\&_\_2\)\/\(3\ 
                    \[Omega]\_1\%2\ \[Omega]\_2\) + 
                \(I\ E\^\(\(-2\)\ I\ T\_2\ \[Sigma]\_1\)\ A\_1\%2\ 
                    \[Delta]\_2\ \[Delta]\_4\ A\&_\_2\)\/\(\[Omega]\_1\%2\ 
                    \[Omega]\_2\) - 
                \(10\ I\ E\^\(\(-I\)\ T\_2\ \[Sigma]\_1\)\ A\_1\ A\_2\ 
                    \[Delta]\_3\ \[Delta]\_4\ A\&_\_2\)\/\(\[Omega]\_1\%2\ 
                    \[Omega]\_2\) - 
                \(15\ I\ A\_2\%2\ \[Delta]\_4\%2\ 
                    A\&_\_2\)\/\(\[Omega]\_1\%2\ \[Omega]\_2\))\)\)}]}], 
      "}"}]], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({16.6640000000001009`\ Second, Null}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["6.2 Parametrically Excited Linearly Coupled Systems", "Section",
  CellMargins->{{Inherited, 17.4375}, {Inherited, Inherited}},
  Evaluatable->False,
  TextAlignment->Left,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],

Cell[CellGroupData[{

Cell["6.2.1 Two-Pendulum Oscillator", "Subsection",
  CellMargins->{{Inherited, 17.4375}, {Inherited, Inherited}},
  Evaluatable->False,
  TextAlignment->Left,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],

Cell["\<\
As an example, we consider a parametrically excited two-pendulum oscillator \
with a three-to-one internal resonance:\
\>", "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(eq621a = {
        \(\[Theta]\_1\^\[DoublePrime]\)[t] + 
            \[Alpha]\ \(\[Theta]\_2\^\[DoublePrime]\)[t] + \[Theta]\_1[t] == 
          \(1\/2\) \[Alpha]\ \((\[Theta]\_2[t] - \[Theta]\_1[t])\)\^2\ 
              \(\[Theta]\_2\^\[DoublePrime]\)[t] + 
            \(1\/6\) \[Theta]\_1[t]\^3 + 
            \[Alpha]\ \((\[Theta]\_2[t] - \[Theta]\_1[t])\)\ 
              \(\[Theta]\_2\^\[Prime]\)[t]\^2 - 
            2  F\_1\ \[CapitalOmega]\^2\ \[Theta]\_1[t]\ 
              Cos[\[CapitalOmega]\ t], 
        \(\[Theta]\_2\^\[DoublePrime]\)[t] + 
            \(\[Theta]\_1\^\[DoublePrime]\)[t] + \[Theta]\_2[t] == 
          \(1\/2\) \((\[Theta]\_2[t] - \[Theta]\_1[t])\)\^2\ 
              \(\[Theta]\_1\^\[DoublePrime]\)[t] + 
            \(1\/6\) \[Theta]\_2[t]\^3 - 
            \((\[Theta]\_2[t] - \[Theta]\_1[t])\)\ 
              \(\[Theta]\_1\^\[Prime]\)[t]\^2 - 
            2  F\_1\ \[CapitalOmega]\^2\ \[Theta]\_2[t]\ 
              Cos[\[CapitalOmega]\ t]}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["where", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(params = {\[Alpha] -> 16\/25 + \[Epsilon]\^2\ \[Sigma]\_1}; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "for small \[Epsilon]. Here, the excitation frequency, \[CapitalOmega], is \
assumed to be close to twice the natural frequency of the second mode, ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\_2\)]],
  ", which is three times the natural frequency of the first mode, ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\_1\)]],
  ". Hence, we define the following lists:"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(omgList = {\[Omega]\_1, \[Omega]\_2}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(ResonanceCond = {
        \[CapitalOmega] == 2\ \[Omega]\_2 + \[Epsilon]\^2\ \[Sigma]\_2, 
        \[Omega]\_2 == 3\ \[Omega]\_1}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(omgRule = 
      \(\(Solve[ResonanceCond, {\[CapitalOmega], #} // Flatten]\)[\([1]\)]\ &
            \)\ /@\ omgList // Reverse\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{\[CapitalOmega] \[Rule] \[Epsilon]\^2\ \[Sigma]\_2 + 6\ \[Omega]\_1, 
        \[Omega]\_2 \[Rule] 3\ \[Omega]\_1}, {
        \[CapitalOmega] \[Rule] \[Epsilon]\^2\ \[Sigma]\_2 + 2\ \[Omega]\_2, 
        \[Omega]\_1 \[Rule] \[Omega]\_2\/3}}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
In order to bring the effects of forcing and nonlinearity at the same order, \
we let\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(scaling = {F\_1 -> \[Epsilon]\^2\ f\_1}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "For a consistent expansion, we first transform ",
  StyleBox["eq621a",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into a system of four first-order equations. To this end, we introduce \
the two states ",
  Cell[BoxData[
      \(TraditionalForm\`v\_1[t]\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`v\_2[t]\)]],
  " defined by"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(vel = {\(\[Theta]\_1\^\[Prime]\)[t] -> v\_1[t], 
        \(\[Theta]\_2\^\[Prime]\)[t] -> v\_2[t]}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting the velocity and acceleration terms, using ",
  StyleBox["vel",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", into ",
  StyleBox["eq621a",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and combining the result with ",
  StyleBox["vel",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we transform ",
  StyleBox["eq621a ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "into the following set of four first-order equations:"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(eq621b = 
      \({vel /. Rule -> Equal, \(eq621a /. D[vel, t]\) /. vel} // Transpose
          \) // Flatten\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SubsuperscriptBox["\[Theta]", "1", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "==", \(v\_1[t]\)}], 
        ",", 
        RowBox[{
          RowBox[{\(\[Theta]\_1[t]\), "+", 
            RowBox[{
              SubsuperscriptBox["v", "1", "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}], "+", 
            RowBox[{"\[Alpha]", " ", 
              RowBox[{
                SubsuperscriptBox["v", "2", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}]}], "==", 
          RowBox[{
          \(\(-2\)\ \[CapitalOmega]\^2\ Cos[t\ \[CapitalOmega]]\ F\_1\ 
              \[Theta]\_1[t]\), "+", \(1\/6\ \[Theta]\_1[t]\^3\), "+", 
            \(\[Alpha]\ v\_2[t]\^2\ 
              \((\(-\[Theta]\_1[t]\) + \[Theta]\_2[t])\)\), "+", 
            RowBox[{
            \(1\/2\), " ", "\[Alpha]", " ", 
              \(\((\(-\[Theta]\_1[t]\) + \[Theta]\_2[t])\)\^2\), " ", 
              RowBox[{
                SubsuperscriptBox["v", "2", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}]}]}], ",", 
        RowBox[{
          RowBox[{
            SubsuperscriptBox["\[Theta]", "2", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "==", \(v\_2[t]\)}], 
        ",", 
        RowBox[{
          RowBox[{\(\[Theta]\_2[t]\), "+", 
            RowBox[{
              SubsuperscriptBox["v", "1", "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}], "+", 
            RowBox[{
              SubsuperscriptBox["v", "2", "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}]}], "==", 
          RowBox[{
          \(\(-2\)\ \[CapitalOmega]\^2\ Cos[t\ \[CapitalOmega]]\ F\_1\ 
              \[Theta]\_2[t]\), "+", \(1\/6\ \[Theta]\_2[t]\^3\), "-", 
            \(v\_1[t]\^2\ \((\(-\[Theta]\_1[t]\) + \[Theta]\_2[t])\)\), "+", 
            RowBox[{
            \(1\/2\), " ", \(\((\(-\[Theta]\_1[t]\) + \[Theta]\_2[t])\)\^2\), 
              " ", 
              RowBox[{
                SubsuperscriptBox["v", "1", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}]}]}]}], "}"}]], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "We seek a uniform second-order expansion of the solution of ",
  StyleBox["eq621b",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in the form"
}], "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(solRule = {
        \[Theta]\_i_ -> 
          \((Sum[\[Epsilon]\^j\ \[Theta]\_\(i, j\)[#1, #2, #3], {j, 3}]\ &)
            \), v\_i_ -> 
          \((Sum[\[Epsilon]\^j\ v\_\(i, j\)[#1, #2, #3], {j, 3}]\ &)\)}; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(maxOrder = 2; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Using the time scales ",
  Cell[BoxData[
      \(TraditionalForm\`T\_0\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`T\_1\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`T\_2\)]],
  ", we express the dependent variables and their time derivatives as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(multiScales = {\[Theta]\_i_[t] -> \[Theta]\_i\ @@\ timeScales, 
        v\_i_[t] -> v\_i\ @@\ timeScales, 
        \(\(Derivative[1]\)[u_]\)[t] -> \(dt[1]\)[u\ @@\ timeScales], 
        t -> T\_0}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting the ",
  StyleBox["params",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", ",
  StyleBox["scaling",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", ",
  StyleBox["multiScales",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", and ",
  StyleBox["solRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["eq621b",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", expanding the result for small \[Epsilon], and discarding terms of order \
higher than ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon]\^3\)]],
  ", we obtain"
}], "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(eq621c = 
      \((\(\(\(\(eq621b /. params\) /. scaling\) /. multiScales\) /. 
                solRule // TrigToExp\) // ExpandAll)\) /. 
        \[Epsilon]\^\(n_ /; n > 3\) -> 0; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[
"Equating coefficients of like powers of \[Epsilon], we obtain"], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(eqEps = 
      \(Rest[Thread[CoefficientList[Subtract\ @@\ #, \[Epsilon]] == 0]]\ &
            \)\ /@\ eq621c // Transpose; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
To place the linear operator on one side and the nonhomogeneous terms on the \
other side, we define\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(eqOrder[i_] := 
      \((\(\(#[\([1]\)]\ &\)\ /@\ eqEps[\([1]\)] /. f\_s_ -> 0\) /. 
              u_\_\(k_, 1\) -> u\_\(k, i\))\) == 
          \((\(\(#[\([1]\)]\ &\)\ /@\ eqEps[\([1]\)] /. f\_s_ -> 0\) /. 
                u_\_\(k_, 1\) -> u\_\(k, i\))\) - 
            \((\(#[\([1]\)]\ &\)\ /@\ eqEps[\([i]\)])\) // Thread\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Using the ",
  StyleBox["eqOrder[i]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["displayRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we rewrite ",
  StyleBox["eqEps",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in a concise way as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[{
    \(eqOrder[1] /. displayRule\), 
    \(eqOrder[2] /. displayRule\), 
    \(eqOrder[3] /. displayRule\)}], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]\[Theta]\_\(1, 1\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ \[Theta], 1, 1]],
              Editable->False], "-", \(v\_\(1, 1\)\)}], "==", "0"}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(1, 1\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ v, 1, 1]],
              Editable->False], "+", 
            RowBox[{\(16\/25\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(2, 1\)\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ v, 2, 1]],
                  Editable->False], ")"}]}], "+", \(\[Theta]\_\(1, 1\)\)}], 
          "==", "0"}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]\[Theta]\_\(2, 1\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ \[Theta], 2, 1]],
              Editable->False], "-", \(v\_\(2, 1\)\)}], "==", "0"}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(1, 1\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ v, 1, 1]],
              Editable->False], "+", 
            InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(2, 1\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ v, 2, 1]],
              Editable->False], "+", \(\[Theta]\_\(2, 1\)\)}], "==", "0"}]}], 
      "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]\[Theta]\_\(1, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ \[Theta], 1, 2]],
              Editable->False], "-", \(v\_\(1, 2\)\)}], "==", 
          RowBox[{"-", 
            RowBox[{"(", 
              InterpretationBox[\(D\_1\[InvisibleSpace]\[Theta]\_\(1, 1\)\),
                SequenceForm[ 
                  Subscript[ D, 1], 
                  Subscript[ \[Theta], 1, 1]],
                Editable->False], ")"}]}]}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(1, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ v, 1, 2]],
              Editable->False], "+", 
            RowBox[{\(16\/25\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(2, 2\)\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ v, 2, 2]],
                  Editable->False], ")"}]}], "+", \(\[Theta]\_\(1, 2\)\)}], 
          "==", 
          RowBox[{
            RowBox[{"-", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]v\_\(1, 1\)\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ v, 1, 1]],
                  Editable->False], ")"}]}], "-", 
            RowBox[{\(16\/25\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]v\_\(2, 1\)\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ v, 2, 1]],
                  Editable->False], ")"}]}]}]}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]\[Theta]\_\(2, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ \[Theta], 2, 2]],
              Editable->False], "-", \(v\_\(2, 2\)\)}], "==", 
          RowBox[{"-", 
            RowBox[{"(", 
              InterpretationBox[\(D\_1\[InvisibleSpace]\[Theta]\_\(2, 1\)\),
                SequenceForm[ 
                  Subscript[ D, 1], 
                  Subscript[ \[Theta], 2, 1]],
                Editable->False], ")"}]}]}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(1, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ v, 1, 2]],
              Editable->False], "+", 
            InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(2, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ v, 2, 2]],
              Editable->False], "+", \(\[Theta]\_\(2, 2\)\)}], "==", 
          RowBox[{
            RowBox[{"-", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]v\_\(1, 1\)\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ v, 1, 1]],
                  Editable->False], ")"}]}], "-", 
            InterpretationBox[\(D\_1\[InvisibleSpace]v\_\(2, 1\)\),
              SequenceForm[ 
                Subscript[ D, 1], 
                Subscript[ v, 2, 1]],
              Editable->False]}]}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]\[Theta]\_\(1, 3\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ \[Theta], 1, 3]],
              Editable->False], "-", \(v\_\(1, 3\)\)}], "==", 
          RowBox[{
            RowBox[{"-", 
              RowBox[{"(", 
                
                InterpretationBox[
                  \(D\_1\[InvisibleSpace]\[Theta]\_\(1, 2\)\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ \[Theta], 1, 2]],
                  Editable->False], ")"}]}], "-", 
            InterpretationBox[\(D\_2\[InvisibleSpace]\[Theta]\_\(1, 1\)\),
              SequenceForm[ 
                Subscript[ D, 2], 
                Subscript[ \[Theta], 1, 1]],
              Editable->False]}]}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(1, 3\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ v, 1, 3]],
              Editable->False], "+", 
            RowBox[{\(16\/25\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(2, 3\)\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ v, 2, 3]],
                  Editable->False], ")"}]}], "+", \(\[Theta]\_\(1, 3\)\)}], 
          "==", 
          RowBox[{
            RowBox[{"-", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]v\_\(1, 2\)\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ v, 1, 2]],
                  Editable->False], ")"}]}], "-", 
            RowBox[{\(16\/25\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]v\_\(2, 2\)\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ v, 2, 2]],
                  Editable->False], ")"}]}], "-", 
            InterpretationBox[\(D\_2\[InvisibleSpace]v\_\(1, 1\)\),
              SequenceForm[ 
                Subscript[ D, 2], 
                Subscript[ v, 1, 1]],
              Editable->False], "-", 
            RowBox[{\(16\/25\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_2\[InvisibleSpace]v\_\(2, 1\)\),
                  SequenceForm[ 
                    Subscript[ D, 2], 
                    Subscript[ v, 2, 1]],
                  Editable->False], ")"}]}], "-", 
            RowBox[{
              RowBox[{"(", 
                InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(2, 1\)\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ v, 2, 1]],
                  Editable->False], ")"}], " ", \(\[Sigma]\_1\)}], "-", 
            \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ \[CapitalOmega]\^2\ f\_1\ 
              \[Theta]\_\(1, 1\)\), "-", 
            \(E\^\(I\ T\_0\ \[CapitalOmega]\)\ \[CapitalOmega]\^2\ f\_1\ 
              \[Theta]\_\(1, 1\)\), "-", 
            \(16\/25\ v\_\(2, 1\)\%2\ \[Theta]\_\(1, 1\)\), "+", 
            RowBox[{\(8\/25\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(2, 1\)\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ v, 2, 1]],
                  Editable->False], ")"}], " ", \(\[Theta]\_\(1, 1\)\%2\)}], 
            "+", \(\[Theta]\_\(1, 1\)\%3\/6\), "+", 
            \(16\/25\ v\_\(2, 1\)\%2\ \[Theta]\_\(2, 1\)\), "-", 
            RowBox[{\(16\/25\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(2, 1\)\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ v, 2, 1]],
                  Editable->False], ")"}], " ", \(\[Theta]\_\(1, 1\)\), " ", 
              \(\[Theta]\_\(2, 1\)\)}], "+", 
            RowBox[{\(8\/25\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(2, 1\)\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ v, 2, 1]],
                  Editable->False], ")"}], " ", 
              \(\[Theta]\_\(2, 1\)\%2\)}]}]}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]\[Theta]\_\(2, 3\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ \[Theta], 2, 3]],
              Editable->False], "-", \(v\_\(2, 3\)\)}], "==", 
          RowBox[{
            RowBox[{"-", 
              RowBox[{"(", 
                
                InterpretationBox[
                  \(D\_1\[InvisibleSpace]\[Theta]\_\(2, 2\)\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ \[Theta], 2, 2]],
                  Editable->False], ")"}]}], "-", 
            InterpretationBox[\(D\_2\[InvisibleSpace]\[Theta]\_\(2, 1\)\),
              SequenceForm[ 
                Subscript[ D, 2], 
                Subscript[ \[Theta], 2, 1]],
              Editable->False]}]}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(1, 3\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ v, 1, 3]],
              Editable->False], "+", 
            InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(2, 3\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ v, 2, 3]],
              Editable->False], "+", \(\[Theta]\_\(2, 3\)\)}], "==", 
          RowBox[{
            RowBox[{"-", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]v\_\(1, 2\)\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ v, 1, 2]],
                  Editable->False], ")"}]}], "-", 
            InterpretationBox[\(D\_1\[InvisibleSpace]v\_\(2, 2\)\),
              SequenceForm[ 
                Subscript[ D, 1], 
                Subscript[ v, 2, 2]],
              Editable->False], "-", 
            InterpretationBox[\(D\_2\[InvisibleSpace]v\_\(1, 1\)\),
              SequenceForm[ 
                Subscript[ D, 2], 
                Subscript[ v, 1, 1]],
              Editable->False], "-", 
            InterpretationBox[\(D\_2\[InvisibleSpace]v\_\(2, 1\)\),
              SequenceForm[ 
                Subscript[ D, 2], 
                Subscript[ v, 2, 1]],
              Editable->False], "+", \(v\_\(1, 1\)\%2\ \[Theta]\_\(1, 1\)\), 
            "+", 
            RowBox[{\(1\/2\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(1, 1\)\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ v, 1, 1]],
                  Editable->False], ")"}], " ", \(\[Theta]\_\(1, 1\)\%2\)}], 
            "-", \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ \[CapitalOmega]\^2\ 
              f\_1\ \[Theta]\_\(2, 1\)\), "-", 
            \(E\^\(I\ T\_0\ \[CapitalOmega]\)\ \[CapitalOmega]\^2\ f\_1\ 
              \[Theta]\_\(2, 1\)\), "-", 
            \(v\_\(1, 1\)\%2\ \[Theta]\_\(2, 1\)\), "-", 
            RowBox[{
              RowBox[{"(", 
                InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(1, 1\)\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ v, 1, 1]],
                  Editable->False], ")"}], " ", \(\[Theta]\_\(1, 1\)\), " ", 
              \(\[Theta]\_\(2, 1\)\)}], "+", 
            RowBox[{\(1\/2\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(1, 1\)\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ v, 1, 1]],
                  Editable->False], ")"}], " ", \(\[Theta]\_\(2, 1\)\%2\)}], 
            "+", \(\[Theta]\_\(2, 1\)\%3\/6\)}]}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell["First-Order Problem: Linear System", "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "The first-order problem, ",
  StyleBox["eqOrder[1]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", consists of a set of coupled linear homogeneous differential equations. \
Hence, the general solution is the solution of the homogeneous equations. To \
determine the general solution of the homogeneous set, we rewrite ",
  StyleBox["eqOrder[1]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(linearSys = \(#[\([1]\)]\ &\)\ /@\ eqOrder[1]; \n
    linearSys /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          InterpretationBox[\(D\_0\[InvisibleSpace]\[Theta]\_\(1, 1\)\),
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ \[Theta], 1, 1]],
            Editable->False], "-", \(v\_\(1, 1\)\)}], ",", 
        RowBox[{
          InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(1, 1\)\),
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ v, 1, 1]],
            Editable->False], "+", 
          RowBox[{\(16\/25\), " ", 
            RowBox[{"(", 
              InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(2, 1\)\),
                SequenceForm[ 
                  Subscript[ D, 0], 
                  Subscript[ v, 2, 1]],
                Editable->False], ")"}]}], "+", \(\[Theta]\_\(1, 1\)\)}], 
        ",", 
        RowBox[{
          InterpretationBox[\(D\_0\[InvisibleSpace]\[Theta]\_\(2, 1\)\),
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ \[Theta], 2, 1]],
            Editable->False], "-", \(v\_\(2, 1\)\)}], ",", 
        RowBox[{
          InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(1, 1\)\),
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ v, 1, 1]],
            Editable->False], "+", 
          InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(2, 1\)\),
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ v, 2, 1]],
            Editable->False], "+", \(\[Theta]\_\(2, 1\)\)}]}], "}"}]], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Next, we seek a solution of the ",
  StyleBox["linearSys",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in the form"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(assumedForm = {
        \[Theta]\_\(i_, 1\) -> \((c\_i\ E\^\(I\ \[Omega]\ #\)\ &)\), 
        v\_\(i_, 1\) -> \((d\_i\ E\^\(I\ \[Omega]\ #\)\ &)\)}; \)\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting ",
  StyleBox["assumedForm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["linearSys",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and collecting coefficients of ",
  Cell[BoxData[
      \(TraditionalForm\`c\_i\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`d\_i\)]],
  ", we obtain the coefficient matrix as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(coefMat = 
      Outer[D, E\^\(\(-I\)\ \[Omega]\ T\_0\)\ linearSys /. assumedForm // 
          Expand, {c\_1, d\_1, c\_2, d\_2}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{I\ \[Omega], \(-1\), 0, 0}, {1, I\ \[Omega], 0, 
        \(16\ I\ \[Omega]\)\/25}, {0, 0, I\ \[Omega], \(-1\)}, {0, 
        I\ \[Omega], 1, I\ \[Omega]}}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["whose adjoint is defined by", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(hermitian[mat_?MatrixQ] := mat /. conjugateRule // Transpose\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell["The natural frequencies of the two modes involved are", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(evals = 
      Cases[\[Omega] /. Solve[Det[coefMat] == 0, \[Omega]], n_ /; n > 0]\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\@5\/3, \@5}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Hence, the right and left eigenvectors of ",
  StyleBox["coefMat",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " corresponding to ",
  StyleBox["evals",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " are"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(rightVec = 
      \(#/#[\([1]\)]\ &\)\ /@\ 
        \((\(\(NullSpace[coefMat /. \[Omega] -> #]\)[\([1]\)]\ &\)\ /@\ evals)
          \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{1, \(I\ \@5\)\/3, 5\/4, \(5\ I\ \@5\)\/12}, {1, I\ \@5, 
        \(-\(5\/4\)\), \(-\(\(5\ I\ \@5\)\/4\)\)}}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(leftVec = 
      \(\(NullSpace[hermitian[coefMat] /. \[Omega] -> #]\)[\([1]\)]\ &\)\ /@\ 
        evals\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{\(-\(\(3\ I\ \@5\)\/4\)\), 5\/4, \(-\(\(3\ I\)\/\@5\)\), 1}, {
        \(I\ \@5\)\/4, \(-\(5\/4\)\), \(-\(I\/\@5\)\), 1}}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["whose complex conjugates are", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(ccleftVec = leftVec /. conjugateRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{\(3\ I\ \@5\)\/4, 5\/4, \(3\ I\)\/\@5, 1}, {\(-\(\(I\ \@5\)\/4\)\), 
        \(-\(5\/4\)\), I\/\@5, 1}}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Based on the ",
  StyleBox["rightVec",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we can assume the general solution form as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1Form = 
      Transpose[rightVec] . {A\_1[T\_1, T\_2]\ E\^\(I\ \[Omega]\_1\ T\_0\), 
          A\_2[T\_1, T\_2]\ E\^\(I\ \[Omega]\_2\ T\_0\)}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1[T\_1, T\_2] + 
        E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2[T\_1, T\_2], 
      1\/3\ I\ \@5\ E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1[T\_1, T\_2] + 
        I\ \@5\ E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2[T\_1, T\_2], 
      5\/4\ E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1[T\_1, T\_2] - 
        5\/4\ E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2[T\_1, T\_2], 
      5\/12\ I\ \@5\ E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1[T\_1, T\_2] - 
        5\/4\ I\ \@5\ E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2[T\_1, T\_2]}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\_1 = \@5/3\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\_2 = \@5\)]],
  ". Therefore, the general solution of ",
  StyleBox["eqOrder[1]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " can be expressed in pure function form as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1 = {\[Theta]\_\(1, 1\), v\_\(1, 1\), \[Theta]\_\(2, 1\), 
            v\_\(2, 1\)} -> 
          \((\(Function[{T\_0, T\_1, T\_2}, # + \((# /. conjugateRule)\) // 
                    Evaluate]\ &\)\ /@\ sol1Form)\) // Thread; \n
    sol1 /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[Theta]\_\(1, 1\) \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1 + 
            E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2 + 
            E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ A\&_\_1 + 
            E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ A\&_\_2], 
      v\_\(1, 1\) \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          1\/3\ I\ \@5\ E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1 + 
            I\ \@5\ E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2 - 
            1\/3\ I\ \@5\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ A\&_\_1 - 
            I\ \@5\ E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ A\&_\_2], 
      \[Theta]\_\(2, 1\) \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          5\/4\ E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1 - 
            5\/4\ E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2 + 
            5\/4\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ A\&_\_1 - 
            5\/4\ E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ A\&_\_2], 
      v\_\(2, 1\) \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          5\/12\ I\ \@5\ E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1 - 
            5\/4\ I\ \@5\ E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2 - 
            5\/12\ I\ \@5\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ A\&_\_1 + 
            5\/4\ I\ \@5\ E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ A\&_\_2]}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`A\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`A\_2\)]],
  " are to be determined from the solvability conditions at the next levels \
of approximation."
}], "Text",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell["Second-Order Problem", "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting the first-order solution ",
  StyleBox["sol1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into the second-order problem, ",
  StyleBox["eqOrder[2]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(order2Eq = eqOrder[2] /. sol1 // ExpandAll; \n
    order2Eq /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]\[Theta]\_\(1, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ \[Theta], 1, 2]],
              Editable->False], "-", \(v\_\(1, 2\)\)}], "==", 
          RowBox[{
            RowBox[{\(-E\^\(I\ T\_0\ \[Omega]\_1\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 1]],
                  Editable->False], ")"}]}], "-", 
            RowBox[{\(E\^\(I\ T\_0\ \[Omega]\_2\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 2]],
                  Editable->False], ")"}]}], "-", 
            RowBox[{\(E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 1]],
                  Editable->False], ")"}]}], "-", 
            RowBox[{\(E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 2]],
                  Editable->False], ")"}]}]}]}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(1, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ v, 1, 2]],
              Editable->False], "+", 
            RowBox[{\(16\/25\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(2, 2\)\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ v, 2, 2]],
                  Editable->False], ")"}]}], "+", \(\[Theta]\_\(1, 2\)\)}], 
          "==", 
          RowBox[{
            RowBox[{"-", 
              FractionBox[
                RowBox[{
                "4", " ", "I", " ", \(E\^\(I\ T\_0\ \[Omega]\_1\)\), " ", 
                  RowBox[{"(", 
                    InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                      SequenceForm[ 
                        Subscript[ D, 1], 
                        Subscript[ A, 1]],
                      Editable->False], ")"}]}], \(3\ \@5\)]}], "-", 
            RowBox[{
            \(1\/3\), " ", "I", " ", \(\@5\), " ", 
              \(E\^\(I\ T\_0\ \[Omega]\_1\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 1]],
                  Editable->False], ")"}]}], "+", 
            FractionBox[
              RowBox[{
              "4", " ", "I", " ", \(E\^\(I\ T\_0\ \[Omega]\_2\)\), " ", 
                RowBox[{"(", 
                  InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
                    SequenceForm[ 
                      Subscript[ D, 1], 
                      Subscript[ A, 2]],
                    Editable->False], ")"}]}], \(\@5\)], "-", 
            RowBox[{
            "I", " ", \(\@5\), " ", \(E\^\(I\ T\_0\ \[Omega]\_2\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 2]],
                  Editable->False], ")"}]}], "+", 
            FractionBox[
              RowBox[{
              "4", " ", "I", " ", \(E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\), " ", 
                RowBox[{"(", 
                  InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_1\),
                    SequenceForm[ 
                      Subscript[ D, 1], 
                      Subscript[ 
                        OverBar[ A], 1]],
                    Editable->False], ")"}]}], \(3\ \@5\)], "+", 
            RowBox[{
            \(1\/3\), " ", "I", " ", \(\@5\), " ", 
              \(E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 1]],
                  Editable->False], ")"}]}], "-", 
            FractionBox[
              RowBox[{
              "4", " ", "I", " ", \(E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\), " ", 
                RowBox[{"(", 
                  InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_2\),
                    SequenceForm[ 
                      Subscript[ D, 1], 
                      Subscript[ 
                        OverBar[ A], 2]],
                    Editable->False], ")"}]}], \(\@5\)], "+", 
            RowBox[{
            "I", " ", \(\@5\), " ", \(E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\), 
              " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 2]],
                  Editable->False], ")"}]}]}]}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]\[Theta]\_\(2, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ \[Theta], 2, 2]],
              Editable->False], "-", \(v\_\(2, 2\)\)}], "==", 
          RowBox[{
            RowBox[{
            \(-\(5\/4\)\), " ", \(E\^\(I\ T\_0\ \[Omega]\_1\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 1]],
                  Editable->False], ")"}]}], "+", 
            RowBox[{\(5\/4\), " ", \(E\^\(I\ T\_0\ \[Omega]\_2\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 2]],
                  Editable->False], ")"}]}], "-", 
            RowBox[{
            \(5\/4\), " ", \(E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 1]],
                  Editable->False], ")"}]}], "+", 
            RowBox[{
            \(5\/4\), " ", \(E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 2]],
                  Editable->False], ")"}]}]}]}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(1, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ v, 1, 2]],
              Editable->False], "+", 
            InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(2, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ v, 2, 2]],
              Editable->False], "+", \(\[Theta]\_\(2, 2\)\)}], "==", 
          RowBox[{
            RowBox[{
            \(-\(3\/4\)\), " ", "I", " ", \(\@5\), " ", 
              \(E\^\(I\ T\_0\ \[Omega]\_1\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 1]],
                  Editable->False], ")"}]}], "+", 
            RowBox[{
            \(1\/4\), " ", "I", " ", \(\@5\), " ", 
              \(E\^\(I\ T\_0\ \[Omega]\_2\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 2]],
                  Editable->False], ")"}]}], "+", 
            RowBox[{
            \(3\/4\), " ", "I", " ", \(\@5\), " ", 
              \(E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 1]],
                  Editable->False], ")"}]}], "-", 
            RowBox[{
            \(1\/4\), " ", "I", " ", \(\@5\), " ", 
              \(E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 2]],
                  Editable->False], ")"}]}]}]}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "For a uniform expansion, we choose ",
  Cell[BoxData[
      \(TraditionalForm\`\(D\_1\) A\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\(D\_1\) A\_2\)]],
  " to eliminate the secular or small-divisor terms. To accomplish this, we \
first convert the small-divisor terms into secular terms using the rule"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(expRule1[i_] := 
      Exp[a_] :> 
        Exp[Expand[a /. omgRule[\([i]\)]] /. \[Epsilon]\^2\ T\_0 -> T\_2]\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "To eliminate the terms that produce secular terms (i.e., determine the \
solvability conditions) from ",
  StyleBox["order2Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we collect the terms proportional to ",
  Cell[BoxData[
      \(TraditionalForm\`E\^\(I\ \[Omega]\_1\ T\_0\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`E\^\(I\ \[Omega]\_2\ T\_0\)\)]],
  " and obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(ST11 = 
      \(Coefficient[order2Eq[\([#, 2]\)] /. expRule1[1], 
            E\^\(I\ \[Omega]\_1\ T\_0\)]\ &\)\ /@\ Range[4]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"-", 
          RowBox[{
            SubsuperscriptBox["A", "1", 
              TagBox[\((1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], ",", 
        RowBox[{"-", 
          FractionBox[
            RowBox[{"3", " ", "I", " ", 
              RowBox[{
                SubsuperscriptBox["A", "1", 
                  TagBox[\((1, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], 
            \(\@5\)]}], ",", 
        RowBox[{\(-\(5\/4\)\), " ", 
          RowBox[{
            SubsuperscriptBox["A", "1", 
              TagBox[\((1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], ",", 
        RowBox[{\(-\(3\/4\)\), " ", "I", " ", \(\@5\), " ", 
          RowBox[{
            SubsuperscriptBox["A", "1", 
              TagBox[\((1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}]}], 
      "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ST12 = 
      \(Coefficient[order2Eq[\([#, 2]\)] /. expRule1[2], 
            E\^\(I\ \[Omega]\_2\ T\_0\)]\ &\)\ /@\ Range[4]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"-", 
          RowBox[{
            SubsuperscriptBox["A", "2", 
              TagBox[\((1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], ",", 
        RowBox[{"-", 
          FractionBox[
            RowBox[{"I", " ", 
              RowBox[{
                SubsuperscriptBox["A", "2", 
                  TagBox[\((1, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], 
            \(\@5\)]}], ",", 
        RowBox[{\(5\/4\), " ", 
          RowBox[{
            SubsuperscriptBox["A", "2", 
              TagBox[\((1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], ",", 
        RowBox[{\(1\/4\), " ", "I", " ", \(\@5\), " ", 
          RowBox[{
            SubsuperscriptBox["A", "2", 
              TagBox[\((1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}]}], 
      "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Then, the solvability conditions demand that ",
  StyleBox["ST11",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["ST12",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " be orthogonal to every solution of the corresponding adjoint problem, \
namely, the components of ",
  StyleBox["ccleftVec",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ". The result is"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(SCond11 = ccleftVec[\([1]\)] . ST11 == 0\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{\(-3\), " ", "I", " ", \(\@5\), " ", 
        RowBox[{
          SubsuperscriptBox["A", "1", 
            TagBox[\((1, 0)\),
              Derivative],
            MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], "==", 
      "0"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SCond12 = ccleftVec[\([2]\)] . ST12 == 0\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{"I", " ", \(\@5\), " ", 
        RowBox[{
          SubsuperscriptBox["A", "2", 
            TagBox[\((1, 0)\),
              Derivative],
            MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], "==", 
      "0"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Solving ",
  StyleBox["SCond11",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["SCond12",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " for ",
  Cell[BoxData[
      \(TraditionalForm\`\(D\_1\) A\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\(D\_1\) A\_2\)]],
  ", respectively, yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"SCond11Rule", "=", 
      RowBox[{
        RowBox[{"Solve", "[", 
          RowBox[{"SCond11", ",", 
            RowBox[{
              SubsuperscriptBox["A", "1", 
                TagBox[\((1, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], 
          "]"}], "[", \([1]\), "]"}]}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          SubsuperscriptBox["A", "1", 
            TagBox[\((1, 0)\),
              Derivative],
            MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}], "\[Rule]", 
        "0"}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"SCond12Rule", "=", 
      RowBox[{
        RowBox[{"Solve", "[", 
          RowBox[{"SCond12", ",", 
            RowBox[{
              SubsuperscriptBox["A", "2", 
                TagBox[\((1, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], 
          "]"}], "[", \([1]\), "]"}]}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          SubsuperscriptBox["A", "2", 
            TagBox[\((1, 0)\),
              Derivative],
            MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}], "\[Rule]", 
        "0"}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[BoxData[
    \(\(SCond1Rule = Join[SCond11Rule, SCond12Rule]; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["whose complex conjugate is", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(ccSCond1Rule = SCond1Rule /. conjugateRule; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting ",
  StyleBox["SCond1Rule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["ccSCond1Rule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["order2Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(order2Eqm = \(order2Eq /. SCond1Rule\) /. ccSCond1Rule // ExpandAll; \n
    order2Eqm /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]\[Theta]\_\(1, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ \[Theta], 1, 2]],
              Editable->False], "-", \(v\_\(1, 2\)\)}], "==", "0"}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(1, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ v, 1, 2]],
              Editable->False], "+", 
            RowBox[{\(16\/25\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(2, 2\)\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ v, 2, 2]],
                  Editable->False], ")"}]}], "+", \(\[Theta]\_\(1, 2\)\)}], 
          "==", "0"}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]\[Theta]\_\(2, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ \[Theta], 2, 2]],
              Editable->False], "-", \(v\_\(2, 2\)\)}], "==", "0"}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(1, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ v, 1, 2]],
              Editable->False], "+", 
            InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(2, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ v, 2, 2]],
              Editable->False], "+", \(\[Theta]\_\(2, 2\)\)}], "==", "0"}]}], 
      "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
which is a set of homogeneous equations. Then, we express the solution of the \
second-order equations in pure function form as\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(sol2 = {\[Theta]\_\(1, 2\) -> \((0\ &)\), v\_\(1, 2\) -> \((0\ &)\), 
        \[Theta]\_\(2, 2\) -> \((0\ &)\), v\_\(2, 2\) -> \((0\ &)\)}; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell["Third-Order Problem", "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting the first- and second-order solutions into the third-order \
problem, ",
  StyleBox["eqOrder[3]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(order3Eq = \(eqOrder[3] /. sol1\) /. sol2 // ExpandAll; \)\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting the ",
  StyleBox["expRule1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into the right-hand sides of ",
  StyleBox["order3Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and collecting the terms that could produce secular terms, the terms \
proportional to ",
  Cell[BoxData[
      \(TraditionalForm\`E\^\(I\ \(\[Omega]\_1\) T\_0\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`E\^\(I\ \(\[Omega]\_2\) T\_0\)\)]],
  ", we have"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(ST21 = 
      \(Coefficient[#[\([2]\)] /. expRule1[1], E\^\(I\ \[Omega]\_1\ T\_0\)]\ &
          \)\ /@\ order3Eq; \nST21 /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"-", 
          RowBox[{"(", 
            InterpretationBox[\(D\_2\[InvisibleSpace]A\_1\),
              SequenceForm[ 
                Subscript[ D, 2], 
                Subscript[ A, 1]],
              Editable->False], ")"}]}], ",", 
        RowBox[{
          RowBox[{"-", 
            FractionBox[
              RowBox[{"3", " ", "I", " ", 
                RowBox[{"(", 
                  InterpretationBox[\(D\_2\[InvisibleSpace]A\_1\),
                    SequenceForm[ 
                      Subscript[ D, 2], 
                      Subscript[ A, 1]],
                    Editable->False], ")"}]}], \(\@5\)]}], "+", 
          \(5\/12\ \@5\ A\_1\ \[Sigma]\_1\ \[Omega]\_1\), "+", 
          \(23\/36\ A\_1\%2\ A\&_\_1\), "-", 
          \(\(A\_1\%2\ \[Omega]\_1\ A\&_\_1\)\/\(8\ \@5\)\), "+", 
          \(11\/12\ A\_2\ A\&_\_1\%2\), "+", 
          \(\(3\ A\_2\ \[Omega]\_1\ A\&_\_1\%2\)\/\(4\ \@5\)\), "+", 
          \(\(A\_2\ \[Omega]\_2\ A\&_\_1\%2\)\/\(8\ \@5\)\), "+", 
          \(7\/2\ A\_1\ A\_2\ A\&_\_2\), "-", 
          \(\(27\ A\_1\ A\_2\ \[Omega]\_1\ A\&_\_2\)\/\(4\ \@5\)\), "-", 
          \(\(9\ A\_1\ A\_2\ \[Omega]\_2\ A\&_\_2\)\/\(2\ \@5\)\)}], ",", 
        RowBox[{\(-\(5\/4\)\), " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_2\[InvisibleSpace]A\_1\),
              SequenceForm[ 
                Subscript[ D, 2], 
                Subscript[ A, 1]],
              Editable->False], ")"}]}], ",", 
        RowBox[{
          RowBox[{\(-\(3\/4\)\), " ", "I", " ", \(\@5\), " ", 
            RowBox[{"(", 
              InterpretationBox[\(D\_2\[InvisibleSpace]A\_1\),
                SequenceForm[ 
                  Subscript[ D, 2], 
                  Subscript[ A, 1]],
                Editable->False], ")"}]}], "+", 
          \(\(965\ A\_1\%2\ A\&_\_1\)\/1152\), "-", 
          \(1\/32\ \@5\ A\_1\%2\ \[Omega]\_1\ A\&_\_1\), "-", 
          \(1175\/384\ A\_2\ A\&_\_1\%2\), "+", 
          \(3\/16\ \@5\ A\_2\ \[Omega]\_1\ A\&_\_1\%2\), "-", 
          \(1\/32\ \@5\ A\_2\ \[Omega]\_2\ A\&_\_1\%2\), "-", 
          \(35\/64\ A\_1\ A\_2\ A\&_\_2\), "-", 
          \(27\/16\ \@5\ A\_1\ A\_2\ \[Omega]\_1\ A\&_\_2\), "+", 
          \(9\/8\ \@5\ A\_1\ A\_2\ \[Omega]\_2\ A\&_\_2\)}]}], "}"}]], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ST22 = 
      \(Coefficient[#[\([2]\)] /. expRule1[2], E\^\(I\ \[Omega]\_2\ T\_0\)]\ &
          \)\ /@\ order3Eq; \nST22 /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"-", 
          RowBox[{"(", 
            InterpretationBox[\(D\_2\[InvisibleSpace]A\_2\),
              SequenceForm[ 
                Subscript[ D, 2], 
                Subscript[ A, 2]],
              Editable->False], ")"}]}], ",", 
        RowBox[{
          RowBox[{"-", 
            FractionBox[
              RowBox[{"I", " ", 
                RowBox[{"(", 
                  InterpretationBox[\(D\_2\[InvisibleSpace]A\_2\),
                    SequenceForm[ 
                      Subscript[ D, 2], 
                      Subscript[ A, 2]],
                    Editable->False], ")"}]}], \(\@5\)]}], "+", 
          \(A\_1\%3\/36\), "-", \(\(A\_1\%3\ \[Omega]\_1\)\/\(24\ \@5\)\), 
          "-", \(5\/4\ \@5\ A\_2\ \[Sigma]\_1\ \[Omega]\_2\), "-", 
          \(3\/2\ A\_1\ A\_2\ A\&_\_1\), "+", 
          \(\(3\ A\_1\ A\_2\ \[Omega]\_1\ A\&_\_1\)\/\(2\ \@5\)\), "+", 
          \(\(A\_1\ A\_2\ \[Omega]\_2\ A\&_\_1\)\/\(4\ \@5\)\), "-", 
          \(43\/4\ A\_2\%2\ A\&_\_2\), "-", 
          \(E\^\(I\ T\_2\ \[Sigma]\_2\)\ \[CapitalOmega]\^2\ f\_1\ A\&_\_2\), 
          "+", \(\(243\ A\_2\%2\ \[Omega]\_2\ A\&_\_2\)\/\(8\ \@5\)\)}], 
        ",", 
        RowBox[{\(5\/4\), " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_2\[InvisibleSpace]A\_2\),
              SequenceForm[ 
                Subscript[ D, 2], 
                Subscript[ A, 2]],
              Editable->False], ")"}]}], ",", 
        RowBox[{
          RowBox[{\(1\/4\), " ", "I", " ", \(\@5\), " ", 
            RowBox[{"(", 
              InterpretationBox[\(D\_2\[InvisibleSpace]A\_2\),
                SequenceForm[ 
                  Subscript[ D, 2], 
                  Subscript[ A, 2]],
                Editable->False], ")"}]}], "+", \(\(535\ A\_1\%3\)\/1152\), 
          "-", \(1\/96\ \@5\ A\_1\%3\ \[Omega]\_1\), "+", 
          \(35\/64\ A\_1\ A\_2\ A\&_\_1\), "+", 
          \(3\/8\ \@5\ A\_1\ A\_2\ \[Omega]\_1\ A\&_\_1\), "-", 
          \(1\/16\ \@5\ A\_1\ A\_2\ \[Omega]\_2\ A\&_\_1\), "+", 
          \(1315\/128\ A\_2\%2\ A\&_\_2\), "+", 
          \(5\/4\ E\^\(I\ T\_2\ \[Sigma]\_2\)\ \[CapitalOmega]\^2\ f\_1\ 
            A\&_\_2\), "-", 
          \(243\/32\ \@5\ A\_2\%2\ \[Omega]\_2\ A\&_\_2\)}]}], "}"}]], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Then, solvability conditions demand that ",
  StyleBox["ST21",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["ST22",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " be orthogonal to their corresponding adjoints. The result is"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"SCond21", "=", 
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{"Solve", "[", 
                RowBox[{\(ccleftVec[\([1]\)] . ST21 == 0\), ",", 
                  RowBox[{
                    SubsuperscriptBox["A", "1", 
                      TagBox[\((0, 1)\),
                        Derivative],
                      MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], 
                "]"}], "[", \([1]\), "]"}], "/.", 
            \({\[Omega]\_1 -> \@5/3, \[Omega]\_2 -> \@5}\)}], "//", 
          "ExpandAll"}]}], ";", "\n", \(SCond21 /. displayRule\)}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        InterpretationBox[\(D\_2\[InvisibleSpace]A\_1\),
          SequenceForm[ 
            Subscript[ D, 2], 
            Subscript[ A, 1]],
          Editable->False], "\[Rule]", 
        \(\(-\(25\/432\)\)\ I\ \@5\ A\_1\ \[Sigma]\_1 - 
          \(353\ I\ \@5\ A\_1\%2\ A\&_\_1\)\/3456 + 
          11\/128\ I\ \@5\ A\_2\ A\&_\_1\%2 + 
          23\/192\ I\ \@5\ A\_1\ A\_2\ A\&_\_2\)}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"SCond22", "=", 
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{"Solve", "[", 
                RowBox[{\(ccleftVec[\([2]\)] . ST22 == 0\), ",", 
                  RowBox[{
                    SubsuperscriptBox["A", "2", 
                      TagBox[\((0, 1)\),
                        Derivative],
                      MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], 
                "]"}], "[", \([1]\), "]"}], "/.", 
            \({\[CapitalOmega] -> 2 \@ 5, \[Omega]\_1 -> \@5/3, 
              \[Omega]\_2 -> \@5}\)}], "//", "ExpandAll"}]}], ";", "\n", 
      \(SCond22 /. displayRule\)}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        InterpretationBox[\(D\_2\[InvisibleSpace]A\_2\),
          SequenceForm[ 
            Subscript[ D, 2], 
            Subscript[ A, 2]],
          Editable->False], "\[Rule]", 
        \(11\/128\ I\ \@5\ A\_1\%3 + 25\/16\ I\ \@5\ A\_2\ \[Sigma]\_1 + 
          23\/64\ I\ \@5\ A\_1\ A\_2\ A\&_\_1 - 
          1337\/128\ I\ \@5\ A\_2\%2\ A\&_\_2 + 
          10\ I\ \@5\ E\^\(I\ T\_2\ \[Sigma]\_2\)\ f\_1\ A\&_\_2\)}], "}"}]], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[BoxData[
    \(\(SCond2Rule = Join[SCond21, SCond22]; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell["Reconstitution", "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Using the method of reconstitution, ",
  Cell[BoxData[
      \(TraditionalForm
      \`A\_k\^\[Prime] = 
        \[Epsilon]\ \(D\_1\) A\_k + \[Epsilon]\^2\ \(D\_2\) A\_k + \ 
          \[CenterEllipsis]\)]],
  ", we combine the partial-differential equations ",
  StyleBox["SCond1Rule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["SCond2Rule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into the following two ordinary-differential equations governing the \
modulation of the complex-valued functions ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(A\_k\) : \)\)]]
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(moduEq = 
      Table[2\ I\ \[Omega]\_k\ A\_k\^\[Prime], {k, 2}] == 
          \((\(Table[
                  2\ I\ \[Omega]\_k\ \(dt[1]\)[\ A\_k[T\_1, T\_2]], {k, 
                    2}] /. SCond1Rule\) /. SCond2Rule)\) // Thread; \n
    moduEq /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{"2", " ", "I", " ", \(\[Omega]\_1\), " ", 
            SubsuperscriptBox["A", "1", "\[Prime]",
              MultilineFunction->None]}], "==", 
          \(2\ I\ \[Epsilon]\^2\ \[Omega]\_1\ 
            \((\(-\(25\/432\)\)\ I\ \@5\ A\_1\ \[Sigma]\_1 - 
                \(353\ I\ \@5\ A\_1\%2\ A\&_\_1\)\/3456 + 
                11\/128\ I\ \@5\ A\_2\ A\&_\_1\%2 + 
                23\/192\ I\ \@5\ A\_1\ A\_2\ A\&_\_2)\)\)}], ",", 
        RowBox[{
          RowBox[{"2", " ", "I", " ", \(\[Omega]\_2\), " ", 
            SubsuperscriptBox["A", "2", "\[Prime]",
              MultilineFunction->None]}], "==", 
          \(2\ I\ \[Epsilon]\^2\ \[Omega]\_2\ 
            \((11\/128\ I\ \@5\ A\_1\%3 + 25\/16\ I\ \@5\ A\_2\ \[Sigma]\_1 + 
                23\/64\ I\ \@5\ A\_1\ A\_2\ A\&_\_1 - 
                1337\/128\ I\ \@5\ A\_2\%2\ A\&_\_2 + 
                10\ I\ \@5\ E\^\(I\ T\_2\ \[Sigma]\_2\)\ f\_1\ A\&_\_2)
              \)\)}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "6.2.2 The function ",
  StyleBox["MMSC",
    FontColor->RGBColor[1, 0, 1]]
}], "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "According to the procedures described in the previous section, we build a \
function named ",
  StyleBox["MMSC",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " (",
  StyleBox["M",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  "ethod of ",
  StyleBox["M",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  "ultiple ",
  StyleBox["S",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  "cales for Linearly ",
  StyleBox["C",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  "oupled Systems) to automate the process."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
    \(MMSC[eqs_List, depVar_List, scaling_List, ResonanceCond : {__Equal}]\), 
      ":=", "\n", "   ", 
      RowBox[{"Module", "[", 
        RowBox[{\({}\), ",", "\n", "\t\t", 
          RowBox[{
          \(omgList = {\[Omega]\_1, \[Omega]\_2}\), ";", "\n", "     ", 
            \(omgRule = 
              \(\(Solve[ResonanceCond, {\[CapitalOmega], #} // Flatten]\)[
                      \([1]\)]\ &\)\ /@\ omgList // Reverse\), ";", "\n", 
            "\t\t", \(mydepVar = {u\_1, v\_1, u\_2, v\_2}\), ";", "\n", 
            "\t\t", \(solRule = {
                u\_i_ -> 
                  \((Sum[\[Epsilon]^j\ u\_\(i, j\)[#1, #2, #3], {j, 3}]\ &)
                    \), v\_i_ -> 
                  \((Sum[\[Epsilon]^j\ v\_\(i, j\)[#1, #2, #3], {j, 3}]\ &)\)}
                \), ";", "\n", "\t\t", \(maxOrder = 2\), ";", "\n", "     ", 
            \(multiScales = {u\_i_[t] -> u\_i\ @@\ timeScales, 
                v\_i_[t] -> v\_i\ @@\ timeScales, 
                \(\(Derivative[1]\)[u_]\)[t] -> \(dt[1]\)[u\ @@\ timeScales], 
                t -> T\_0}\), ";", "\n", "\t\t", 
            \(eqa = \((
                  \(\(\(\(eqs /. Thread[depVar -> mydepVar]\) /. scaling\) /. 
                          multiScales\) /. solRule // TrigToExp\) // 
                    ExpandAll)\) /. \[Epsilon]^\((n_ /; n > 3)\) -> 0\), ";", 
            "\n", "\t\t", 
            \(eqEps = 
              \(Rest[Thread[
                        CoefficientList[Subtract\ @@\ #, \[Epsilon]] == 0]]\ &
                    \)\ /@\ eqa // Transpose\), ";", "\n", "\t  ", 
            \(eqOrder[i_] := 
              \((\(\(#[\([1]\)]\ &\)\ /@\ eqEps[\([1]\)] /. f\_s_ -> 0\) /. 
                      u_\_\(k_, 1\) -> u\_\(k, i\))\) == 
                  \((\(\(#[\([1]\)]\ &\)\ /@\ eqEps[\([1]\)] /. 
                          f\_s_ -> 0\) /. u_\_\(k_, 1\) -> u\_\(k, i\))\) - 
                    \((\(#[\([1]\)]\ &\)\ /@\ eqEps[\([i]\)])\) // Thread\), 
            ";", "\n", "\t", "\n", "\t\t", 
            StyleBox[\( (*\ First - Order\ Problem\ *) \),
              FontColor->RGBColor[0, 0, 1]], "\t\t", "\n", "\t\t", 
            \(linearSys = \(#[\([1]\)]\ &\)\ /@\ eqOrder[1]\), ";", "\n", 
            "\t\t", \(assumedForm = {
                u\_\(i_, 1\) -> \((c\_i\ E^\((I\ \[Omega]\ #)\)\ &)\), 
                v\_\(i_, 1\) -> \((d\_i\ E^\((I\ \[Omega]\ #)\)\ &)\)}\), 
            ";", "\n", "\t\t", 
            \(coefMat = 
              Outer[D, 
                E^\((\(-I\)\ \[Omega]\ T\_0)\)\ linearSys /. assumedForm // 
                  Expand, {c\_1, d\_1, c\_2, d\_2}]\), ";", "\n", "\t\t", 
            \(hermitian[mat_?MatrixQ] := mat /. conjugateRule // Transpose\), 
            ";", "\n", "\t\t", 
            \(evals = 
              Cases[\[Omega] /. Solve[Det[coefMat] == 0, \[Omega]], 
                n_ /; n > 0]\), ";", "\n", "\t\t", 
            \(values = 
              Append[\(omgRule[\([1]\)] /. \[Epsilon] -> 0\) /. 
                  \[Omega]\_1 -> evals[\([1]\)], 
                \[Omega]\_1 -> evals[\([1]\)]]\), ";", "\n", "\t\t", 
            \(rightVec = 
              \(#/#[\([1]\)]\ &\)\ /@\ 
                \((\(\(NullSpace[coefMat /. \[Omega] -> #]\)[\([1]\)]\ &\)\ /@
                    \ evals)\)\), ";", "\n", "     ", 
            \(leftVec = 
              \(\(NullSpace[hermitian[coefMat] /. \[Omega] -> #]\)[\([1]\)]\ &
                  \)\ /@\ evals\), ";", "\n", "\t\t", 
            \(ccleftVec = leftVec /. conjugateRule\), ";", "\n", "\t\t", 
            \(order1Eq = 
              eqOrder[1] /. u_\_\(i_, 1\) -> \((u\_\(i, 1\)[#1]\ &)\)\), ";", 
            "\n", "\t\t", 
            \(sol1p = 
              \(DSolve[
                      order1Eq, {u\_\(1, 1\)[T\_0], v\_\(1, 1\)[T\_0], 
                        u\_\(2, 1\)[T\_0], v\_\(2, 1\)[T\_0]}, T\_0]\)[
                    \([1]\)] /. C[_] -> 0 // Simplify\), ";", "\n", "\t\t", 
            \(fRule = {
                f\_i_ -> 
                  2\ \[CapitalLambda]\_i\ 
                    \((\[Omega]\_i\%2 - \[CapitalOmega]^2)\)}\), ";", "\n", 
            "\t\t", \(sol1Form = 
              \((\(#[\([2]\)]\ &\)\ /@\ sol1p)\) + 
                \((\(\((# + \((# /. conjugateRule)\))\)\ &\)\ /@\ 
                    \((Transpose[rightVec] . {
                          A\_1[T\_1, T\_2]\ E^\((I\ \[Omega]\_1\ T\_0)\), 
                          A\_2[T\_1, T\_2]\ E^\((I\ \[Omega]\_2\ T\_0)\)})\))
                  \)\), ";", "\n", "\t\t", 
            \(sol1 = {u\_\(1, 1\), v\_\(1, 1\), u\_\(2, 1\), v\_\(2, 1\)} -> 
                  \((\(Function[{T\_0, T\_1, T\_2}, # // Evaluate]\ &\)\ /@\ 
                      sol1Form)\) // Thread\), ";", "\n", "\t\t\t\t", "\n", 
            "\t\t", 
            StyleBox[\( (*\ Second - Order\ Problem\ *) \),
              FontColor->RGBColor[0, 0, 1]], "\n", "\t\t", 
            \(order2Eq = eqOrder[2] /. sol1 // ExpandAll\), ";", "\n", 
            "\t\t", \(expRule1[i_] := 
              Exp[a_] :> 
                Exp[Expand[a /. omgRule[\([i]\)]] /. 
                    \[Epsilon]^n_. \ T\_0 :> timeScales[\([n + 1]\)]]\), ";", 
            "\n", "\t\t", 
            \(ST11 = 
              \(Coefficient[#[\([2]\)] /. expRule1[1], 
                    E^\((I\ \[Omega]\_1\ T\_0)\)]\ &\)\ /@\ order2Eq\), ";", 
            "\n", "\t\t", 
            \(ST12 = 
              \(Coefficient[#[\([2]\)] /. expRule1[2], 
                    E^\((I\ \[Omega]\_2\ T\_0)\)]\ &\)\ /@\ order2Eq\), ";", 
            "\n", "\t\t", 
            \(SCond1 = {ccleftVec[\([1]\)] . ST11 == 0, 
                ccleftVec[\([2]\)] . ST12 == 0}\), ";", "\n", "\t\t", 
            RowBox[{"SCond1Rule1", "=", 
              RowBox[{
                RowBox[{
                  RowBox[{"Solve", "[", 
                    RowBox[{"SCond1", ",", 
                      RowBox[{"{", 
                        RowBox[{
                          RowBox[{
                            SubsuperscriptBox["A", "1", 
                              TagBox[\((1, 0)\),
                                Derivative],
                              MultilineFunction->None], "[", \(T\_1, T\_2\), 
                            "]"}], ",", 
                          RowBox[{
                            SubsuperscriptBox["A", "2", 
                              TagBox[\((1, 0)\),
                                Derivative],
                              MultilineFunction->None], "[", \(T\_1, T\_2\), 
                            "]"}]}], "}"}]}], "]"}], "[", \([1]\), "]"}], 
                "//", "ExpandAll"}]}], ";", "\n", "\t\t", 
            \( (*\ sigRule = 
                \(Solve[ResonanceCond, {\[Sigma]\_1, \[Sigma]\_2}]\)[
                  \([1]\)]; \ *) \), "\n", "\t\t", 
            \(sigRule = \(Solve[ResonanceCond, \[Sigma]\_2]\)[\([1]\)]\), 
            ";", "\n", "\t\t", 
            \(expRule2 = 
              Exp[a_] :> 
                Exp[\(a /. {T\_1 -> \[Epsilon]\ T\_0, 
                          T\_2 -> \[Epsilon]^2\ T\_0}\) /. sigRule // Expand]
                  \), ";", "\n", "\t\t", 
            \(SCond1Rule2 = SCond1Rule1 /. expRule2\), ";", "\n", "\t\t", 
            \(ccSCond1Rule2 = SCond1Rule2 /. conjugateRule\), ";", "\n", 
            "\t\t", \(order2Eqm = 
              \(order2Eq /. SCond1Rule2\) /. ccSCond1Rule2 // ExpandAll\), 
            ";", "\n", "\t\t", 
            \(If[Union[\(#[\([2]\)]\ &\)\ /@\ order2Eqm] === {0}, \n\t\ \ \ \t
              sol2 = {u\_\(1, 2\) -> \((0\ &)\), v\_\(1, 2\) -> \((0\ &)\), 
                  u\_\(2, 2\) -> \((0\ &)\), v\_\(2, 2\) -> \((0\ &)\)}, \n
              \t\t\ \ \ 
              Return["\<The particular solution of the second order equations \
needs to be solved, which is not included in this function.\>"]\n
              \t\t (*\n\ \ \ \t\t
                basicH = 
                  Table[{A\_i[T\_1, T\_2]\ E^\((I\ \[Omega]\_i\ T\_0)\), 
                        A\&_\_i[T\_1, T\_2]\ 
                          E^\((\(-I\)\ \[Omega]\_i\ T\_0)\)}, {i, 2}] // 
                    Flatten; \n\ \ \ \t\t
                collectForm = 
                  Join[basicH, 
                    If[list1 = 
                        List\ @@\ 
                            \(Plus\ @@\ 
                              \((\(#[\([2]\)]\ &\)\ /@\ eqOrder[1])\)\) /. 
                          c_\ f\_i_\ E^a_ -> \[CapitalLambda]\_i\ E^a; 
                      Head[list1] === List, list1, {}]]; \n\ \ \ \t\t
                possibleTerms = 
                  Join[collectForm, 
                    If[list1 = 
                        List\ @@\ 
                            \(Plus\ @@\ 
                              \((\(#[\([2]\)]\ &\)\ /@\ eqOrder[2] /. 
                                  u_\_\(i_, j_\) -> \((0\ &)\))\)\) /. 
                          c_\ f\_i_\ E^a_ -> E^a; Head[list1] === List, 
                      list1, {}], 
                    \(Outer[Times, collectForm, collectForm] // Flatten\) // 
                      Union]; \n\t\ \ \ \t
                ResonantTerms[i_] := 
                  \(\((\(# /. {a_ /; a =!= 0 -> 1}\ &\)\ /@\ 
                            \((\(E^\((\(-I\)\ \[Omega]\_i\ T\_0)\)\ 
                                    possibleTerms /. expRule1[i]\) /. 
                                Exp[_\ T\_0 + _. ] -> 0)\))\)\ 
                        possibleTerms // Union\) // Rest; \n\ \ \ \t\ \ \ 
                RT = {Array[ResonantTerms, 2], 
                      Array[ResonantTerms, 2] /. conjugateRule} // Flatten; \n
                \ \ \ \t\tNRT = Complement[possibleTerms, RT]; \n\ \ \ \t\t
                rRule = 
                  Table[MapIndexed[
                        r\_\(i, #2[\([1]\)]\) -> 
                            Coefficient[order2Eqm[\([i, 2]\)], #1]\ &, RT], {
                        i, 4}] // Flatten; \n\ \ \ \t\t
                list1 = Join[ccleftVec, Conjugate[ccleftVec]]; \n\ \ \ \ \ \t
                r4Rule = 
                  Table[\(Solve[
                          list1[\([j]\)] . Table[r\_\(i, j\), {i, 4}] == 0, 
                          r\_\(4, j\)]\)[\([1]\)], {j, 4}] // Flatten; \n
                \ \ \ \t\t
                RTsymbolList[i_] = 
                  Table[\[CapitalGamma]\_\(i, j\), {j, Length[RT]}]; \n
                \ \ \ \t\t
                NRTsymbolList[i_] = 
                  Table[\[CapitalLambda]\_\(i, j\), {j, Length[NRT]}]; \n
                \t\t\ \ \ 
                sol2Form = {u\_\(1, 2\), v\_\(1, 2\), u\_\(2, 2\), 
                        v\_\(2, 2\)} -> 
                      \((\(Function[{T\_0, T\_1, T\_2}, 
                              RTsymbolList[#] . RT + 
                                  NRTsymbolList[#] . NRT // Evaluate]\ &\)\ /@
                          \ Range[4])\) // Thread; \n\ \ \ \t\t
                coef1 = 
                  \(Solve[
                          \(Coefficient[Subtract\ @@\ # /. sol2Form, NRT] == 
                                  0 /. Exp[_\ T\_0 + _. ] -> 0\ &\)\ /@\ 
                            order2Eqm, Array[NRTsymbolList, 4] // Flatten]\)[
                        \([1]\)] /. values // ExpandAll; \n\ \ \ \t\t
                eq1 = Table[
                        MapIndexed[
                            Coefficient[
                                  order2Eqm[\([k, 1]\)] /. sol2Form, #1] == 
                                r\_\(k, #2[\([1]\)]\)\ &, RT] /. 
                          Exp[_\ T\_0 + _. ] -> 0, {k, 4}] /. r4Rule // 
                    Flatten; \n\ \ \ \ \ \ \ \ 
                coef2 = 
                  \(\((\(Solve[eq1, Join\ @@\ Array[RTsymbolList, 4]]\)[
                              \([1]\)] // Simplify)\) /. values\) /. rRule // 
                    ExpandAll; \n\t\ \ \ \t
                sol2 = sol2Form /. 
                    Function[{T\_0, T\_1, T\_2}, a_] :> 
                      Function[{T\_0, T\_1, T\_2} // Evaluate, 
                        \(\(a /. coef1\) /. coef2 // Expand\) // Evaluate]
                        \ \ \ *) \n\t\ \ ]\), ";", "\n", "\t\t", "\n", 
            "\t\t", 
            StyleBox[\( (*\ Third - Order\ Problem\ *) \),
              FontColor->RGBColor[0, 0, 1]], "\n", "\t\t", 
            \(order3Eq = \(eqOrder[3] /. sol1\) /. sol2 // ExpandAll\), ";", 
            "\n", "\t\t", 
            \(ST21 = 
              \(Coefficient[#[\([2]\)] /. expRule1[1], 
                    Exp[I\ \[Omega]\_1\ T\_0]]\ &\)\ /@\ order3Eq\), ";", 
            "\n", "\t\t", 
            \(ST22 = 
              \(Coefficient[#[\([2]\)] /. expRule1[2], 
                    Exp[I\ \[Omega]\_2\ T\_0]]\ &\)\ /@\ order3Eq\), ";", 
            "\n", "\t\t", 
            \(SCond2 = {ccleftVec[\([1]\)] . ST21 == 0, 
                  ccleftVec[\([2]\)] . ST22 == 0} // ExpandAll\), ";", "\n", 
            "\t\t", 
            RowBox[{"SCond2Rule1", "=", 
              RowBox[{
                RowBox[{
                  RowBox[{
                    RowBox[{"Solve", "[", 
                      RowBox[{"SCond2", ",", 
                        RowBox[{"{", 
                          RowBox[{
                            RowBox[{
                              SubsuperscriptBox["A", "1", 
                                TagBox[\((0, 1)\),
                                  Derivative],
                                MultilineFunction->None], "[", \(T\_1, 
                              T\_2\), "]"}], ",", 
                            RowBox[{
                              SubsuperscriptBox["A", "2", 
                                TagBox[\((0, 1)\),
                                  Derivative],
                                MultilineFunction->None], "[", \(T\_1, 
                              T\_2\), "]"}]}], "}"}]}], "]"}], "[", \([1]\), 
                    "]"}], "/.", "values"}], "//", "ExpandAll"}]}], ";", 
            "\n", "\t\t", "\n", "\t\t", 
            StyleBox[\( (*\ Reconstitution\ *) \),
              FontColor->RGBColor[0, 0, 1]], "\n", "\t\t", 
            \(moduEq = 
              Table[2\ I\ \[Omega]\_k\ A\_k\^\[Prime], {k, 2}] == 
                  \((\(Table[
                            2\ I\ \[Omega]\_k\ 
                              \(dt[1]\)[\ A\_k[T\_1, T\_2]], {k, 2}] /. 
                          \((SCond1Rule1 /. values)\)\) /. SCond2Rule1 // 
                      Collect[#, \[Epsilon]]\ &)\) // Thread\), ";", "\n", 
            "\t\t", 
            RowBox[{"Print", "[", "\"\<\!\(\*
StyleBox[\\(The\\),\nFontColor->RGBColor[0, 0, 1]]\) \!\(\*
StyleBox[\\(second\\),\nFontColor->RGBColor[0, 0, 1]]\)\!\(\*
StyleBox[\\(-\\),\nFontColor->RGBColor[0, 0, 1]]\)\!\(\*
StyleBox[\\(order\\),\nFontColor->RGBColor[0, 0, 1]]\) \!\(\*
StyleBox[\\(approximate\\),\nFontColor->RGBColor[0, 0, 1]]\) \!\(\*
StyleBox[\\(solution\\),\nFontColor->RGBColor[0, 0, 1]]\)\!\(\*
StyleBox[\\(:\\),\nFontColor->RGBColor[0, 0, 1]]\)\>\"", "]"}], ";", "\n", 
            "\t\t", \(Print[
              Table[u\_i[t] == 
                    \((\(\(\(\(u\_i\ @@\ timeScales /. solRule\) /. 
                              \[Epsilon]^3 -> 0\) /. sol1\) /. sol2\) /. 
                        displayRule)\), {i, 2}] /. Thread[mydepVar -> depVar]]
              \), ";", "\n", "\t\t", 
            RowBox[{"If", "[", 
              RowBox[{
              \(Or\ @@\ 
                  Table[\((F\_i/f\_i /. scaling)\) === \[Epsilon], {i, 2}]\), 
                ",", "\n", "\t\t\t", 
                RowBox[{
                  RowBox[{"Print", "[", "\"\<\!\(\*
StyleBox[\\(where\\),\nFontColor->RGBColor[0, 0, 1]]\)\>\"", "]"}], ";", 
                  "\n", "\t\t\t", 
                  \(Print[
                    \*"\"\<\!\(\[CapitalLambda]\_i\)==\!\(f\_i\)/(2(\!\(\
\[Omega]\_i\%2\)-\[CapitalOmega]^2))\>\""]\)}]}], "\n", "\t\t", "]"}], ";", 
            " ", "\n", "\t\t", 
            RowBox[{"Print", "[", "\"\<\\n\!\(\*
StyleBox[\\(The\\),\nFontColor->RGBColor[0, 0, 1]]\) \!\(\*
StyleBox[\\(modulation\\),\nFontColor->RGBColor[0, 0, 1]]\) \!\(\*
StyleBox[\\(equations\\),\nFontColor->RGBColor[0, 0, 1]]\)\!\(\*
StyleBox[\\(:\\),\nFontColor->RGBColor[0, 0, 1]]\)\>\"", "]"}], ";", "\n", 
            "\t\t", \(Print[moduEq /. displayRule]\)}]}], "\n", "]"}]}]], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["As an example, we check the case in Section 6.2.1:", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{"eqtest", "=", 
        RowBox[{
          RowBox[{"{", "\n", "\t\t", 
            RowBox[{
              RowBox[{
                RowBox[{
                  SubsuperscriptBox["\[Theta]", "1", "\[Prime]",
                    MultilineFunction->None], "[", "t", "]"}], "==", 
                \(v\_1[t]\)}], ",", "\n", "\t\t", 
              RowBox[{
                RowBox[{
                  RowBox[{
                    SubsuperscriptBox["v", "1", "\[Prime]",
                      MultilineFunction->None], "[", "t", "]"}], "+", 
                  RowBox[{"\[Alpha]", " ", 
                    RowBox[{
                      SubsuperscriptBox["v", "2", "\[Prime]",
                        MultilineFunction->None], "[", "t", "]"}]}], "+", 
                  \(\[Theta]\_1[t]\)}], "==", 
                RowBox[{
                \(\(-2\)\ \[CapitalOmega]\^2\ Cos[t\ \[CapitalOmega]]\ F\_1\ 
                    \[Theta]\_1[t]\), "+", \(1\/6\ \[Theta]\_1[t]\^3\), "+", 
                  \(\[Alpha]\ v\_2[t]\^2\ 
                    \((\(-\[Theta]\_1[t]\) + \[Theta]\_2[t])\)\), "+", 
                  RowBox[{
                  \(1\/2\), " ", "\[Alpha]", " ", 
                    \(\((\(-\[Theta]\_1[t]\) + \[Theta]\_2[t])\)\^2\), " ", 
                    RowBox[{
                      SubsuperscriptBox["v", "2", "\[Prime]",
                        MultilineFunction->None], "[", "t", "]"}]}]}]}], ",", 
              "\n", "\t\t", 
              RowBox[{
                RowBox[{
                  SubsuperscriptBox["\[Theta]", "2", "\[Prime]",
                    MultilineFunction->None], "[", "t", "]"}], "==", 
                \(v\_2[t]\)}], ",", "\n", "\t\t", 
              RowBox[{
                RowBox[{
                  RowBox[{
                    SubsuperscriptBox["v", "2", "\[Prime]",
                      MultilineFunction->None], "[", "t", "]"}], "+", 
                  RowBox[{
                    SubsuperscriptBox["v", "1", "\[Prime]",
                      MultilineFunction->None], "[", "t", "]"}], "+", 
                  \(\[Theta]\_2[t]\)}], "==", 
                RowBox[{
                \(\(-2\)\ \[CapitalOmega]\^2\ Cos[t\ \[CapitalOmega]]\ F\_1\ 
                    \[Theta]\_2[t]\), "+", \(1\/6\ \[Theta]\_2[t]\^3\), "-", 
                  \(v\_1[t]\^2\ \((\(-\[Theta]\_1[t]\) + \[Theta]\_2[t])\)\), 
                  "+", 
                  RowBox[{
                  \(1\/2\), " ", 
                    \(\((\(-\[Theta]\_1[t]\) + \[Theta]\_2[t])\)\^2\), " ", 
                    RowBox[{
                      SubsuperscriptBox["v", "1", "\[Prime]",
                        MultilineFunction->None], "[", "t", "]"}]}]}]}]}], 
            "\n", "\t", "}"}], "/.", 
          \({\[Alpha] \[Rule] 16\/25 + \[Epsilon]\^2\ \[Sigma]\_1}\)}]}], 
      ";"}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(scaling1 = {F\_1 -> \[Epsilon]\^2\ f\_1}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(ResonanceCond1 = {\[Omega]\_2 == 3  \[Omega]\_1, 
        \[CapitalOmega] == 2  \[Omega]\_2 + \[Epsilon]\^2\ \[Sigma]\_2}; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(MMSC[eqtest, {\[Theta]\_1, v\_1, \[Theta]\_2, v\_2}, scaling1, 
        ResonanceCond1] // Timing\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\!\\(\\* StyleBox[\\(The\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(second\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* \
StyleBox[\\(-\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* StyleBox[\\(order\
\\), FontColor->RGBColor[0, 0, 1]]\\) \\!\\(\\* StyleBox[\\(approximate\\), \
FontColor->RGBColor[0, 0, 1]]\\) \\!\\(\\* StyleBox[\\(solution\\), \
FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* StyleBox[\\(:\\), \
FontColor->RGBColor[0, 0, 1]]\\)\"\>"], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[Theta]\_1[t] == 
        \[Epsilon]\ 
          \((E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1 + 
              E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2 + 
              E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ A\&_\_1 + 
              E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ A\&_\_2)\), 
      \[Theta]\_2[t] == 
        \[Epsilon]\ 
          \((5\/4\ E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1 - 
              5\/4\ E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2 + 
              5\/4\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ A\&_\_1 - 
              5\/4\ E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ A\&_\_2)\)}\)], "Print",\

  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\n\\!\\(\\* StyleBox[\\(The\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(modulation\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(equations\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* \
StyleBox[\\(:\\), FontColor->RGBColor[0, 0, 1]]\\)\"\>"], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{"2", " ", "I", " ", \(\[Omega]\_1\), " ", 
            SubsuperscriptBox["A", "1", "\[Prime]",
              MultilineFunction->None]}], "==", 
          \(2\ I\ \[Epsilon]\^2\ \[Omega]\_1\ 
            \((\(-\(25\/432\)\)\ I\ \@5\ A\_1\ \[Sigma]\_1 - 
                \(353\ I\ \@5\ A\_1\%2\ A\&_\_1\)\/3456 + 
                11\/128\ I\ \@5\ A\_2\ A\&_\_1\%2 + 
                23\/192\ I\ \@5\ A\_1\ A\_2\ A\&_\_2)\)\)}], ",", 
        RowBox[{
          RowBox[{"2", " ", "I", " ", \(\[Omega]\_2\), " ", 
            SubsuperscriptBox["A", "2", "\[Prime]",
              MultilineFunction->None]}], "==", 
          \(2\ I\ \[Epsilon]\^2\ \[Omega]\_2\ 
            \((11\/128\ I\ \@5\ A\_1\%3 + 25\/16\ I\ \@5\ A\_2\ \[Sigma]\_1 + 
                23\/64\ I\ \@5\ A\_1\ A\_2\ A\&_\_1 - 
                1337\/128\ I\ \@5\ A\_2\%2\ A\&_\_2 + 
                10\ I\ \@5\ E\^\(I\ T\_2\ \[Sigma]\_2\)\ f\_1\ A\&_\_2)
              \)\)}]}], "}"}]], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({7.69100000000003092`\ Second, Null}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 1024}, {0, 712}},
WindowToolbars->{"RulerBar", "EditBar"},
WindowSize->{666, 568},
WindowMargins->{{2, Automatic}, {Automatic, 5}},
PrintingCopies->1,
PrintingStartingPageNumber->147,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Inherited, Cell[ 
        TextData[ {
          ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
        TextData[ {
          ValueBox[ "FileName"]}], "Header"], Inherited, Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"]}},
PrintingOptions->{"FirstPageHeader"->False,
"FacingPages"->True},
Magnification->1
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "ChapterTwo"->{
    Cell[12178, 362, 288, 6, 46, "Section",
      Evaluatable->False,
      CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],
    Cell[390000, 8422, 290, 6, 46, "Section",
      Evaluatable->False,
      CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],
    Cell[390315, 8432, 271, 6, 43, "Subsection",
      Evaluatable->False,
      CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}]},
  "ChapterTwo.2"->{
    Cell[12178, 362, 288, 6, 46, "Section",
      Evaluatable->False,
      CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],
    Cell[390000, 8422, 290, 6, 46, "Section",
      Evaluatable->False,
      CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],
    Cell[390315, 8432, 271, 6, 43, "Subsection",
      Evaluatable->False,
      CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}]},
  "ChapterTwo.2.1"->{
    Cell[12178, 362, 288, 6, 46, "Section",
      Evaluatable->False,
      CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],
    Cell[390000, 8422, 290, 6, 46, "Section",
      Evaluatable->False,
      CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],
    Cell[390315, 8432, 271, 6, 43, "Subsection",
      Evaluatable->False,
      CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"ChapterTwo", 481571, 10954},
  {"ChapterTwo.2", 482010, 10964},
  {"ChapterTwo.2.1", 482451, 10974}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 142, 5, 195, "Title"],
Cell[1876, 58, 620, 11, 109, "Text"],
Cell[2499, 71, 810, 20, 90, "Text"],
Cell[3312, 93, 456, 9, 30, "Text"],
Cell[3771, 104, 1696, 42, 147, "Text"],
Cell[5470, 148, 342, 7, 54, "Text"],
Cell[5815, 157, 651, 19, 54, "Text"],
Cell[6469, 178, 219, 5, 24, "Text"],
Cell[6691, 185, 249, 10, 26, "Text"],
Cell[6943, 197, 156, 4, 24, "Text"],
Cell[7102, 203, 1586, 38, 126, "Text"],
Cell[8691, 243, 451, 8, 24, "Text"],

Cell[CellGroupData[{
Cell[9167, 255, 79, 2, 46, "Section"],
Cell[9249, 259, 100, 3, 22, "Input"],
Cell[9352, 264, 112, 3, 22, "Input"],
Cell[9467, 269, 164, 5, 26, "Text"],
Cell[9634, 276, 456, 15, 22, "Input"],
Cell[10093, 293, 98, 2, 26, "Text"],
Cell[10194, 297, 117, 3, 22, "Input"],
Cell[10314, 302, 251, 8, 26, "Text"],
Cell[10568, 312, 317, 7, 34, "Input"],
Cell[10888, 321, 318, 8, 26, "Text"],
Cell[11209, 331, 267, 6, 22, "Input"],
Cell[11479, 339, 173, 5, 26, "Text"],
Cell[11655, 346, 486, 11, 69, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12178, 362, 288, 6, 46, "Section",
  Evaluatable->False,
  CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],

Cell[CellGroupData[{
Cell[12491, 372, 88, 2, 43, "Subsection"],
Cell[12582, 376, 291, 7, 40, "Text"],

Cell[CellGroupData[{
Cell[12898, 387, 532, 11, 47, "Input"],
Cell[13433, 400, 1488, 35, 33, "Output"]
}, Open  ]],
Cell[14936, 438, 278, 8, 40, "Text"],
Cell[15217, 448, 117, 3, 22, "Input"],

Cell[CellGroupData[{
Cell[15359, 455, 182, 5, 22, "Input"],
Cell[15544, 462, 150, 4, 22, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15731, 471, 164, 5, 22, "Input"],
Cell[15898, 478, 178, 4, 22, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16113, 487, 385, 9, 47, "Input"],
Cell[16501, 498, 359, 7, 22, "Output"]
}, Open  ]],
Cell[16875, 508, 781, 13, 97, "Text"],
Cell[17659, 523, 409, 8, 54, "Text"],
Cell[18071, 533, 436, 15, 40, "Text"],
Cell[18510, 550, 169, 4, 22, "Input"],
Cell[18682, 556, 672, 24, 40, "Text"],

Cell[CellGroupData[{
Cell[19379, 584, 215, 6, 22, "Input"],
Cell[19597, 592, 1853, 43, 71, "Output"]
}, Open  ]],
Cell[21465, 638, 294, 9, 26, "Text"],
Cell[21762, 649, 283, 8, 35, "Input"],
Cell[22048, 659, 128, 3, 26, "Text"],
Cell[22179, 664, 98, 3, 22, "Input"],
Cell[22280, 669, 404, 10, 40, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22721, 684, 277, 9, 43, "Subsection"],
Cell[23001, 695, 347, 7, 54, "Text"],
Cell[23351, 704, 200, 5, 23, "Input"],
Cell[23554, 711, 315, 11, 26, "Text"],
Cell[23872, 724, 238, 6, 22, "Input"],
Cell[24113, 732, 99, 2, 26, "Text"],
Cell[24215, 736, 122, 3, 22, "Input"],

Cell[CellGroupData[{
Cell[24362, 743, 207, 5, 22, "Input"],
Cell[24572, 750, 430, 9, 28, "Output"]
}, Open  ]],
Cell[25017, 762, 315, 13, 26, "Text"],
Cell[25335, 777, 268, 6, 35, "Input"],
Cell[25606, 785, 684, 25, 40, "Text"],
Cell[26293, 812, 242, 6, 34, "Input"],
Cell[26538, 820, 135, 3, 26, "Text"],
Cell[26676, 825, 209, 5, 22, "Input"],
Cell[26888, 832, 171, 5, 26, "Text"],
Cell[27062, 839, 406, 9, 53, "Input"],
Cell[27471, 850, 393, 16, 26, "Text"],

Cell[CellGroupData[{
Cell[27889, 870, 179, 5, 47, "Input"],
Cell[28071, 877, 1432, 36, 43, "Output"],
Cell[29506, 915, 3041, 75, 55, "Output"],
Cell[32550, 992, 4385, 102, 58, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[36972, 1099, 106, 2, 34, "Subsubsection"],
Cell[37081, 1103, 652, 16, 69, "Text"],

Cell[CellGroupData[{
Cell[37758, 1123, 158, 4, 34, "Input"],
Cell[37919, 1129, 1102, 29, 22, "Output"]
}, Open  ]],
Cell[39036, 1161, 481, 15, 26, "Text"],

Cell[CellGroupData[{
Cell[39542, 1180, 286, 6, 35, "Input"],
Cell[39831, 1188, 235, 5, 22, "Output"]
}, Open  ]],
Cell[40081, 1196, 254, 9, 26, "Text"],

Cell[CellGroupData[{
Cell[40360, 1209, 127, 3, 22, "Input"],
Cell[40490, 1214, 219, 5, 22, "Output"]
}, Open  ]],
Cell[40724, 1222, 154, 3, 26, "Text"],
Cell[40881, 1227, 142, 4, 22, "Input"],
Cell[41026, 1233, 270, 9, 26, "Text"],

Cell[CellGroupData[{
Cell[41321, 1246, 183, 5, 22, "Input"],
Cell[41507, 1253, 123, 3, 22, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[41667, 1261, 149, 4, 22, "Input"],
Cell[41819, 1267, 133, 3, 22, "Output"]
}, Open  ]],
Cell[41967, 1273, 91, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[42083, 1279, 116, 3, 22, "Input"],
Cell[42202, 1284, 123, 3, 22, "Output"]
}, Open  ]],
Cell[42340, 1290, 448, 15, 40, "Text"],

Cell[CellGroupData[{
Cell[42813, 1309, 149, 4, 24, "Input"],
Cell[42965, 1315, 1248, 30, 43, "Output"]
}, Open  ]],
Cell[44228, 1348, 205, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[44458, 1360, 261, 6, 34, "Input"],
Cell[44722, 1368, 751, 14, 47, "Output"]
}, Open  ]],
Cell[45488, 1385, 106, 2, 26, "Text"],
Cell[45597, 1389, 195, 6, 22, "Input"],
Cell[45795, 1397, 307, 11, 26, "Text"],

Cell[CellGroupData[{
Cell[46127, 1412, 417, 9, 47, "Input"],
Cell[46547, 1423, 664, 15, 33, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[47248, 1443, 247, 7, 34, "Input"],
Cell[47498, 1452, 800, 16, 45, "Output"]
}, Open  ]],
Cell[48313, 1471, 290, 11, 26, "Text"],
Cell[48606, 1484, 111, 3, 22, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[48754, 1492, 92, 2, 34, "Subsubsection"],
Cell[48849, 1496, 331, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[49205, 1512, 154, 4, 34, "Input"],
Cell[49362, 1518, 10324, 200, 208, "Output"]
}, Open  ]],
Cell[59701, 1721, 573, 16, 54, "Text"],
Cell[60277, 1739, 188, 6, 22, "Input"],
Cell[60468, 1747, 484, 15, 40, "Text"],

Cell[CellGroupData[{
Cell[60977, 1766, 229, 6, 34, "Input"],
Cell[61209, 1774, 987, 25, 22, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[62233, 1804, 229, 6, 34, "Input"],
Cell[62465, 1812, 878, 22, 28, "Output"]
}, Open  ]],
Cell[63358, 1837, 575, 18, 55, "Text"],

Cell[CellGroupData[{
Cell[63958, 1859, 187, 4, 34, "Input"],
Cell[64148, 1865, 1385, 32, 43, "Output"]
}, Open  ]],
Cell[65548, 1900, 322, 14, 26, "Text"],

Cell[CellGroupData[{
Cell[65895, 1918, 935, 24, 35, "Input"],
Cell[66833, 1944, 1149, 28, 54, "Output"]
}, Open  ]],
Cell[67997, 1975, 775, 24, 55, "Text"],
Cell[68775, 2001, 980, 36, 55, "Text"],

Cell[CellGroupData[{
Cell[69780, 2041, 161, 5, 22, "Input"],
Cell[69944, 2048, 265, 7, 28, "Output"]
}, Open  ]],
Cell[70224, 2058, 238, 10, 26, "Text"],
Cell[70465, 2070, 179, 5, 22, "Input"],
Cell[70647, 2077, 284, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[70956, 2093, 150, 4, 34, "Input"],
Cell[71109, 2099, 1242, 29, 54, "Output"]
}, Open  ]],
Cell[72366, 2131, 89, 2, 26, "Text"],
Cell[72458, 2135, 130, 3, 22, "Input"],
Cell[72591, 2140, 233, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[72849, 2152, 182, 4, 34, "Input"],
Cell[73034, 2158, 8353, 153, 260, "Output"]
}, Open  ]],
Cell[81402, 2314, 363, 10, 40, "Text"],

Cell[CellGroupData[{
Cell[81790, 2328, 250, 6, 22, "Input"],
Cell[82043, 2336, 306, 6, 22, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[82386, 2347, 308, 9, 22, "Input"],
Cell[82697, 2358, 472, 9, 33, "Output"]
}, Open  ]],
Cell[83184, 2370, 226, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[83435, 2382, 310, 7, 34, "Input"],
Cell[83748, 2391, 2642, 45, 113, "Output"]
}, Open  ]],
Cell[86405, 2439, 1326, 31, 112, "Text"],
Cell[87734, 2472, 340, 7, 60, "Input"],

Cell[CellGroupData[{
Cell[88099, 2483, 108, 3, 22, "Input"],
Cell[88210, 2488, 649, 12, 33, "Output"]
}, Open  ]],
Cell[88874, 2503, 318, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[89217, 2519, 236, 6, 34, "Input"],
Cell[89456, 2527, 255, 6, 29, "Output"]
}, Open  ]],
Cell[89726, 2536, 315, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[90066, 2552, 236, 6, 34, "Input"],
Cell[90305, 2560, 225, 5, 22, "Output"]
}, Open  ]],
Cell[90545, 2568, 78, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[90648, 2574, 175, 4, 22, "Input"],
Cell[90826, 2580, 90, 3, 22, "Output"]
}, Open  ]],
Cell[90931, 2586, 498, 18, 40, "Text"],
Cell[91432, 2606, 322, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[91779, 2622, 205, 6, 22, "Input"],
Cell[91987, 2630, 277, 6, 29, "Output"]
}, Open  ]],
Cell[92279, 2639, 315, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[92619, 2655, 236, 6, 34, "Input"],
Cell[92858, 2663, 243, 5, 28, "Output"]
}, Open  ]],
Cell[93116, 2671, 85, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[93226, 2677, 175, 4, 22, "Input"],
Cell[93404, 2683, 93, 3, 22, "Output"]
}, Open  ]],
Cell[93512, 2689, 355, 11, 26, "Text"],
Cell[93870, 2702, 336, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[94231, 2718, 171, 5, 22, "Input"],
Cell[94405, 2725, 4320, 75, 164, "Output"]
}, Open  ]],
Cell[98740, 2803, 212, 5, 40, "Text"],

Cell[CellGroupData[{
Cell[98977, 2812, 161, 4, 22, "Input"],
Cell[99141, 2818, 169, 4, 22, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[99347, 2827, 161, 4, 22, "Input"],
Cell[99511, 2833, 196, 4, 22, "Output"]
}, Open  ]],
Cell[99722, 2840, 168, 5, 26, "Text"],

Cell[CellGroupData[{
Cell[99915, 2849, 170, 5, 22, "Input"],
Cell[100088, 2856, 816, 14, 33, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[100941, 2875, 175, 5, 22, "Input"],
Cell[101119, 2882, 835, 13, 33, "Output"]
}, Open  ]],
Cell[101969, 2898, 862, 30, 40, "Text"],

Cell[CellGroupData[{
Cell[102856, 2932, 142, 4, 22, "Input"],
Cell[103001, 2938, 123, 3, 22, "Output"]
}, Open  ]],
Cell[103139, 2944, 1091, 24, 161, "Input"],
Cell[104233, 2970, 445, 16, 40, "Text"],

Cell[CellGroupData[{
Cell[104703, 2990, 286, 7, 47, "Input"],
Cell[104992, 2999, 6059, 106, 188, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[111088, 3110, 286, 7, 47, "Input"],
Cell[111377, 3119, 5989, 104, 176, "Output"]
}, Open  ]],
Cell[117381, 3226, 287, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[117693, 3242, 162, 5, 22, "Input"],
Cell[117858, 3249, 6028, 116, 241, "Output"]
}, Open  ]],
Cell[123901, 3368, 287, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[124213, 3384, 162, 5, 22, "Input"],
Cell[124378, 3391, 6050, 122, 237, "Output"]
}, Open  ]],
Cell[130443, 3516, 444, 16, 40, "Text"],

Cell[CellGroupData[{
Cell[130912, 3536, 258, 7, 34, "Input"],
Cell[131173, 3545, 276, 5, 22, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[131486, 3555, 258, 7, 34, "Input"],
Cell[131747, 3564, 516, 10, 22, "Output"]
}, Open  ]],
Cell[132278, 3577, 519, 22, 26, "Text"],

Cell[CellGroupData[{
Cell[132822, 3603, 137, 3, 22, "Input"],
Cell[132962, 3608, 385, 8, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[133384, 3621, 137, 3, 22, "Input"],
Cell[133524, 3626, 472, 10, 29, "Output"]
}, Open  ]],
Cell[134011, 3639, 184, 7, 26, "Text"],
Cell[134198, 3648, 253, 6, 47, "Input"],
Cell[134454, 3656, 157, 5, 26, "Text"],

Cell[CellGroupData[{
Cell[134636, 3665, 280, 8, 47, "Input"],
Cell[134919, 3675, 13817, 229, 624, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[148785, 3910, 91, 2, 34, "Subsubsection"],
Cell[148879, 3914, 260, 9, 26, "Text"],
Cell[149142, 3925, 142, 4, 22, "Input"],
Cell[149287, 3931, 570, 19, 40, "Text"],

Cell[CellGroupData[{
Cell[149882, 3954, 229, 6, 34, "Input"],
Cell[150114, 3962, 6963, 146, 180, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[157114, 4113, 229, 6, 34, "Input"],
Cell[157346, 4121, 6925, 132, 229, "Output"]
}, Open  ]],
Cell[164286, 4256, 482, 17, 40, "Text"],

Cell[CellGroupData[{
Cell[164793, 4277, 207, 5, 34, "Input"],
Cell[165003, 4284, 8472, 146, 356, "Output"]
}, Open  ]],
Cell[173490, 4433, 324, 14, 26, "Text"],

Cell[CellGroupData[{
Cell[173839, 4451, 935, 24, 35, "Input"],
Cell[174777, 4477, 8347, 142, 354, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[183173, 4625, 86, 2, 34, "Subsubsection"],
Cell[183262, 4629, 702, 21, 55, "Text"],

Cell[CellGroupData[{
Cell[183989, 4654, 390, 9, 60, "Input"],
Cell[184382, 4665, 10195, 166, 428, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[194638, 4838, 157, 6, 43, "Subsection"],
Cell[194798, 4846, 1093, 33, 83, "Text"],
Cell[195894, 4881, 17539, 340, 1601, "Input"],
Cell[213436, 5223, 113, 2, 26, "Text"],
Cell[213552, 5227, 201, 5, 23, "Input"],
Cell[213756, 5234, 239, 6, 22, "Input"],

Cell[CellGroupData[{
Cell[214020, 5244, 119, 3, 22, "Input"],
Cell[214142, 5249, 547, 9, 20, "Print"],
Cell[214692, 5260, 8356, 131, 322, "Print"],
Cell[223051, 5393, 151, 4, 20, "Print"],
Cell[223205, 5399, 170, 4, 26, "Print"],
Cell[223378, 5405, 354, 6, 29, "Print"],
Cell[223735, 5413, 10194, 166, 370, "Print"],
Cell[233932, 5581, 117, 3, 22, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[234098, 5590, 277, 9, 43, "Subsection"],
Cell[234378, 5601, 331, 7, 54, "Text"],
Cell[234712, 5610, 201, 5, 23, "Input"],
Cell[234916, 5617, 331, 11, 40, "Text"],
Cell[235250, 5630, 239, 6, 22, "Input"],
Cell[235492, 5638, 357, 12, 40, "Text"],

Cell[CellGroupData[{
Cell[235874, 5654, 119, 3, 22, "Input"],
Cell[235996, 5659, 547, 9, 20, "Print"],
Cell[236546, 5670, 8352, 131, 308, "Print"],
Cell[244901, 5803, 151, 4, 20, "Print"],
Cell[245055, 5809, 170, 4, 26, "Print"],
Cell[245228, 5815, 354, 6, 29, "Print"],
Cell[245585, 5823, 12406, 203, 460, "Print"],
Cell[257994, 6028, 117, 3, 22, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[258160, 6037, 298, 10, 43, "Subsection"],
Cell[258461, 6049, 162, 5, 26, "Text"],
Cell[258626, 6056, 196, 4, 23, "Input"],
Cell[258825, 6062, 263, 7, 22, "Input"],
Cell[259091, 6071, 357, 12, 40, "Text"],

Cell[CellGroupData[{
Cell[259473, 6087, 119, 3, 22, "Input"],
Cell[259595, 6092, 547, 9, 20, "Print"],
Cell[260145, 6103, 14419, 221, 511, "Print"],
Cell[274567, 6326, 151, 4, 20, "Print"],
Cell[274721, 6332, 170, 4, 26, "Print"],
Cell[274894, 6338, 354, 6, 29, "Print"],
Cell[275251, 6346, 16230, 269, 543, "Print"],
Cell[291484, 6617, 117, 3, 22, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[291650, 6626, 277, 9, 43, "Subsection"],
Cell[291930, 6637, 223, 5, 40, "Text"],
Cell[292156, 6644, 204, 5, 23, "Input"],
Cell[292363, 6651, 245, 6, 22, "Input"],
Cell[292611, 6659, 357, 12, 40, "Text"],

Cell[CellGroupData[{
Cell[292993, 6675, 119, 3, 22, "Input"],
Cell[293115, 6680, 547, 9, 20, "Print"],
Cell[293665, 6691, 7391, 115, 286, "Print"],
Cell[301059, 6808, 151, 4, 20, "Print"],
Cell[301213, 6814, 170, 4, 26, "Print"],
Cell[301386, 6820, 354, 6, 29, "Print"],
Cell[301743, 6828, 9616, 159, 351, "Print"],
Cell[311362, 6989, 117, 3, 22, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[311528, 6998, 301, 10, 43, "Subsection"],
Cell[311832, 7010, 225, 5, 40, "Text"],
Cell[312060, 7017, 204, 5, 23, "Input"],
Cell[312267, 7024, 273, 7, 22, "Input"],
Cell[312543, 7033, 357, 12, 40, "Text"],

Cell[CellGroupData[{
Cell[312925, 7049, 119, 3, 22, "Input"],
Cell[313047, 7054, 547, 9, 20, "Print"],
Cell[313597, 7065, 7381, 115, 283, "Print"],
Cell[320981, 7182, 151, 4, 20, "Print"],
Cell[321135, 7188, 170, 4, 26, "Print"],
Cell[321308, 7194, 354, 6, 29, "Print"],
Cell[321665, 7202, 14127, 238, 506, "Print"],
Cell[335795, 7442, 117, 3, 22, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[335961, 7451, 295, 10, 43, "Subsection"],
Cell[336259, 7463, 177, 5, 26, "Text"],
Cell[336439, 7470, 196, 4, 23, "Input"],
Cell[336638, 7476, 260, 7, 22, "Input"],
Cell[336901, 7485, 357, 12, 40, "Text"],

Cell[CellGroupData[{
Cell[337283, 7501, 119, 3, 22, "Input"],
Cell[337405, 7506, 547, 9, 20, "Print"],
Cell[337955, 7517, 14261, 218, 511, "Print"],
Cell[352219, 7737, 151, 4, 20, "Print"],
Cell[352373, 7743, 170, 4, 26, "Print"],
Cell[352546, 7749, 354, 6, 29, "Print"],
Cell[352903, 7757, 24641, 402, 841, "Print"],
Cell[377547, 8161, 117, 3, 22, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[377713, 8170, 298, 10, 43, "Subsection"],
Cell[378014, 8182, 173, 5, 26, "Text"],
Cell[378190, 8189, 208, 5, 23, "Input"],
Cell[378401, 8196, 270, 7, 22, "Input"],
Cell[378674, 8205, 357, 12, 40, "Text"],

Cell[CellGroupData[{
Cell[379056, 8221, 119, 3, 22, "Input"],
Cell[379178, 8226, 547, 9, 20, "Print"],
Cell[379728, 8237, 2861, 48, 124, "Print"],
Cell[382592, 8287, 354, 6, 29, "Print"],
Cell[382949, 8295, 6870, 115, 279, "Print"],
Cell[389822, 8412, 117, 3, 22, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[390000, 8422, 290, 6, 46, "Section",
  Evaluatable->False,
  CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],

Cell[CellGroupData[{
Cell[390315, 8432, 271, 6, 43, "Subsection",
  Evaluatable->False,
  CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],
Cell[390589, 8440, 246, 6, 26, "Text"],
Cell[390838, 8448, 1063, 21, 68, "Input"],
Cell[391904, 8471, 68, 2, 26, "Text"],
Cell[391975, 8475, 147, 4, 31, "Input"],
Cell[392125, 8481, 457, 11, 40, "Text"],
Cell[392585, 8494, 122, 3, 22, "Input"],
Cell[392710, 8499, 215, 5, 22, "Input"],

Cell[CellGroupData[{
Cell[392950, 8508, 207, 5, 22, "Input"],
Cell[393160, 8515, 322, 6, 26, "Output"]
}, Open  ]],
Cell[393497, 8524, 156, 5, 26, "Text"],
Cell[393656, 8531, 125, 3, 22, "Input"],
Cell[393784, 8536, 437, 15, 40, "Text"],
Cell[394224, 8553, 183, 4, 22, "Input"],
Cell[394410, 8559, 580, 20, 40, "Text"],

Cell[CellGroupData[{
Cell[395015, 8583, 189, 5, 22, "Input"],
Cell[395207, 8590, 2288, 53, 75, "Output"]
}, Open  ]],
Cell[397510, 8646, 295, 9, 26, "Text"],
Cell[397808, 8657, 301, 8, 35, "Input"],
Cell[398112, 8667, 98, 3, 22, "Input"],
Cell[398213, 8672, 346, 13, 26, "Text"],
Cell[398562, 8687, 282, 6, 35, "Input"],
Cell[398847, 8695, 773, 29, 40, "Text"],
Cell[399623, 8726, 265, 6, 34, "Input"],
Cell[399891, 8734, 135, 3, 26, "Text"],
Cell[400029, 8739, 209, 5, 22, "Input"],
Cell[400241, 8746, 171, 5, 26, "Text"],
Cell[400415, 8753, 406, 9, 53, "Input"],
Cell[400824, 8764, 393, 16, 26, "Text"],

Cell[CellGroupData[{
Cell[401242, 8784, 179, 5, 47, "Input"],
Cell[401424, 8791, 1802, 46, 28, "Output"],
Cell[403229, 8839, 3472, 87, 43, "Output"],
Cell[406704, 8928, 8195, 191, 125, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[414936, 9124, 106, 2, 34, "Subsubsection"],
Cell[415045, 9128, 508, 14, 55, "Text"],

Cell[CellGroupData[{
Cell[415578, 9146, 158, 4, 34, "Input"],
Cell[415739, 9152, 1604, 42, 28, "Output"]
}, Open  ]],
Cell[417358, 9197, 212, 8, 26, "Text"],
Cell[417573, 9207, 235, 6, 22, "Input"],
Cell[417811, 9215, 466, 18, 26, "Text"],

Cell[CellGroupData[{
Cell[418302, 9237, 209, 5, 22, "Input"],
Cell[418514, 9244, 237, 5, 28, "Output"]
}, Open  ]],
Cell[418766, 9252, 90, 2, 26, "Text"],
Cell[418859, 9256, 142, 4, 22, "Input"],
Cell[419004, 9262, 116, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[419145, 9268, 164, 5, 22, "Input"],
Cell[419312, 9275, 94, 3, 31, "Output"]
}, Open  ]],
Cell[419421, 9281, 315, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[419761, 9297, 215, 6, 22, "Input"],
Cell[419979, 9305, 190, 4, 31, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[420206, 9314, 183, 5, 22, "Input"],
Cell[420392, 9321, 204, 4, 35, "Output"]
}, Open  ]],
Cell[420611, 9328, 91, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[420727, 9334, 116, 3, 22, "Input"],
Cell[420846, 9339, 186, 4, 35, "Output"]
}, Open  ]],
Cell[421047, 9346, 224, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[421296, 9358, 225, 5, 22, "Input"],
Cell[421524, 9365, 584, 11, 48, "Output"]
}, Open  ]],
Cell[422123, 9379, 401, 14, 26, "Text"],

Cell[CellGroupData[{
Cell[422549, 9397, 337, 7, 47, "Input"],
Cell[422889, 9406, 1317, 27, 84, "Output"]
}, Open  ]],
Cell[424221, 9436, 296, 11, 26, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[424554, 9452, 92, 2, 34, "Subsubsection"],
Cell[424649, 9456, 331, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[425005, 9472, 154, 4, 34, "Input"],
Cell[425162, 9478, 9522, 226, 144, "Output"]
}, Open  ]],
Cell[434699, 9707, 397, 11, 40, "Text"],
Cell[435099, 9720, 191, 6, 22, "Input"],
Cell[435293, 9728, 484, 15, 40, "Text"],

Cell[CellGroupData[{
Cell[435802, 9747, 205, 5, 22, "Input"],
Cell[436010, 9754, 1157, 32, 34, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[437204, 9791, 205, 5, 22, "Input"],
Cell[437412, 9798, 1137, 32, 34, "Output"]
}, Open  ]],
Cell[438564, 9833, 500, 17, 40, "Text"],

Cell[CellGroupData[{
Cell[439089, 9854, 120, 3, 22, "Input"],
Cell[439212, 9859, 338, 10, 22, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[439587, 9874, 120, 3, 22, "Input"],
Cell[439710, 9879, 325, 10, 22, "Output"]
}, Open  ]],
Cell[440050, 9892, 430, 18, 26, "Text"],

Cell[CellGroupData[{
Cell[440505, 9914, 427, 12, 22, "Input"],
Cell[440935, 9928, 318, 10, 22, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[441290, 9943, 427, 12, 22, "Input"],
Cell[441720, 9957, 318, 10, 22, "Output"]
}, Open  ]],
Cell[442053, 9970, 129, 3, 22, "Input"],
Cell[442185, 9975, 89, 2, 26, "Text"],
Cell[442277, 9979, 128, 3, 22, "Input"],
Cell[442408, 9984, 384, 16, 26, "Text"],

Cell[CellGroupData[{
Cell[442817, 10004, 180, 4, 34, "Input"],
Cell[443000, 10010, 1802, 46, 28, "Output"]
}, Open  ]],
Cell[444817, 10059, 198, 5, 26, "Text"],
Cell[445018, 10066, 227, 5, 22, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[445282, 10076, 91, 2, 34, "Subsubsection"],
Cell[445376, 10080, 260, 9, 26, "Text"],
Cell[445639, 10091, 142, 4, 22, "Input"],
Cell[445784, 10097, 570, 19, 40, "Text"],

Cell[CellGroupData[{
Cell[446379, 10120, 216, 5, 34, "Input"],
Cell[446598, 10127, 2372, 54, 106, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[449007, 10186, 216, 5, 34, "Input"],
Cell[449226, 10193, 2354, 54, 103, "Output"]
}, Open  ]],
Cell[451595, 10250, 354, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[451974, 10266, 695, 17, 51, "Input"],
Cell[452672, 10285, 504, 13, 31, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[453213, 10303, 733, 18, 51, "Input"],
Cell[453949, 10323, 540, 14, 28, "Output"]
}, Open  ]],
Cell[454504, 10340, 121, 3, 22, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[454662, 10348, 86, 2, 34, "Subsubsection"],
Cell[454751, 10352, 700, 21, 55, "Text"],

Cell[CellGroupData[{
Cell[455476, 10377, 340, 8, 47, "Input"],
Cell[455819, 10387, 1089, 23, 66, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[456969, 10417, 158, 6, 43, "Subsection"],
Cell[457130, 10425, 656, 25, 40, "Text"],
Cell[457789, 10452, 16258, 310, 1470, "Input"],
Cell[474050, 10764, 113, 2, 26, "Text"],
Cell[474166, 10768, 2896, 62, 146, "Input"],
Cell[477065, 10832, 126, 3, 22, "Input"],
Cell[477194, 10837, 212, 5, 22, "Input"],

Cell[CellGroupData[{
Cell[477431, 10846, 177, 4, 22, "Input"],
Cell[477611, 10852, 547, 9, 20, "Print"],
Cell[478161, 10863, 633, 15, 37, "Print"],
Cell[478797, 10880, 354, 6, 29, "Print"],
Cell[479154, 10888, 1088, 23, 47, "Print"],
Cell[480245, 10913, 117, 3, 22, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

